/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.attributes;

import com.axlradius.misc.b;
import com.axlradius.radclient4.RADIUSException;
import com.axlradius.radclient4.attributes.Attribute;
import com.axlradius.radclient4.attributes.VendorSpecific;
import com.axlradius.radclient4.attributes.a;
import com.axlradius.radclient4.auth.eap.EAPException;
import com.axlradius.radclient4.auth.eap.EAPPacket;
import com.axlradius.radclient4.radutil.RADIUSEncode;
import com.axlradius.radclient4.radutil.Util;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;

public class AttributeList {
    protected Attribute[] a;
    protected int active = 0;

    public AttributeList(Attribute[] attributeArray) {
        this.init();
        this.add(attributeArray);
    }

    public AttributeList(AttributeList attributeList) {
        this.init();
        this.add(attributeList);
    }

    public AttributeList() {
        this.init();
    }

    private void init() {
        this.a = new Attribute[10];
        this.active = 0;
    }

    public void add(Attribute attribute) {
        if (attribute == null) {
            return;
        }
        if (this.active >= this.a.length) {
            Attribute[] attributeArray = new Attribute[this.a.length + 10];
            System.arraycopy(this.a, 0, attributeArray, 0, this.active);
            this.a = attributeArray;
        }
        this.a[this.active++] = attribute;
    }

    public void add(int n2, byte[] byArray) {
        this.add(new Attribute(n2, byArray));
    }

    public void add(int n2, int n3, InetAddress inetAddress) {
        this.add(n2, n3, inetAddress.getAddress());
    }

    public void add(int n2, int n3, int n4) {
        this.add(n2, n3, b.a(n4));
    }

    public void add(int n2) {
        this.add(new Attribute(n2));
    }

    public void add(int n2, int n3, String string) {
        this.add(n2, n3, Util.toUTF8(string));
    }

    public void add(int n2, int n3, byte[] byArray) {
        this.add(new Attribute(n2, n3, byArray));
    }

    public void add(int n2, int n3) {
        byte[] byArray = b.a(n3);
        this.add(n2, byArray);
    }

    public void add(int n2, String string) {
        this.add(n2, Util.toUTF8(string));
    }

    public void add(int n2, Date date) {
        Attribute attribute = new Attribute(n2, date);
        this.add(attribute);
    }

    public void add(int n2, InetAddress inetAddress) {
        Attribute attribute = new Attribute(n2, inetAddress);
        this.add(attribute);
    }

    public void add(VendorSpecific vendorSpecific) {
        if (vendorSpecific == null) {
            return;
        }
        this.add(vendorSpecific.getAttribute());
    }

    public boolean set(int n2, byte[] byArray) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.active; ++i2) {
            if (this.a[i2].tag != n2) continue;
            bl = true;
            this.a[i2] = new Attribute(n2, byArray);
            break;
        }
        return bl;
    }

    public void clean() {
        for (int i2 = 0; i2 < this.active; ++i2) {
            this.a[i2].clean();
            this.a[i2] = null;
        }
        this.init();
    }

    public void clear() {
        this.clean();
    }

    public String getString(int n2) {
        int n3 = this.active;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.a[i2].tag != n2) continue;
            return Util.toUTF8(this.a[i2].value);
        }
        return null;
    }

    public byte[][] getValues(int n2) {
        int n3;
        int n4 = this.active;
        int n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            if (this.a[n3].tag != n2) continue;
            ++n5;
        }
        if (n5 == 0) {
            return null;
        }
        byte[][] byArrayArray = new byte[n5][];
        n5 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            Attribute attribute = this.a[n3];
            if (attribute.tag != n2) continue;
            byte[] byArray = new byte[attribute.value.length];
            System.arraycopy(attribute.value, 0, byArray, 0, attribute.value.length);
            byArrayArray[n5++] = byArray;
        }
        return byArrayArray;
    }

    public byte[] getValue(int n2) {
        for (int i2 = 0; i2 < this.active; ++i2) {
            Attribute attribute = this.a[i2];
            if (attribute.tag != n2) continue;
            return attribute.value;
        }
        return null;
    }

    public final boolean loadRadiusAttributes(byte[] object, int n2, int n3) throws RADIUSException {
        int n4;
        if (this.active > 0) {
            this.clear();
        }
        if (n3 == 0) {
            return true;
        }
        int n5 = n2 + n3;
        for (int i2 = n2; i2 < n5; i2 += n4) {
            int n6 = object[i2++] & 0xFF;
            if ((n4 = (object[i2++] & 0xFF) - 2) < 0) {
                if (this.a((byte[])object, n2, n3)) {
                    return true;
                }
                object = "Attribute at position " + this.active + " of type " + Attribute.getName(n6) + " (" + n6 + ") has an incorrect length of " + (n4 + 2) + " - " + (n5 - i2) + " octets not processed after error.";
                throw new RADIUSException((String)object);
            }
            try {
                byte[] byArray = new byte[n4];
                System.arraycopy(object, i2, byArray, 0, n4);
                this.add(n6, byArray);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                if (this.a((byte[])object, n2, n3)) {
                    return true;
                }
                object = "Attribute at position " + this.active + " of type " + Attribute.getName(n6) + " (" + n6 + ") has an incorrect length of " + (n4 + 2) + " - " + (n5 - i2) + " octets not processed after error.";
                throw new RADIUSException((String)object);
            }
        }
        return false;
    }

    private boolean a(byte[] byArray, int n2, int n3) {
        int n4 = n2;
        int n5 = n2 + n3;
        if (this.active > 0) {
            this.clear();
        }
        try {
            while (n4 < n5) {
                n2 = (byArray[n4] & 0xFF) << 8 | byArray[n4 + 1] & 0xFF;
                n4 += 2;
                if ((n3 = (byArray[n4++] & 0xFF) - 3) < 0) {
                    return false;
                }
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n4, byArray2, 0, n3);
                n4 += n3;
                this.add(n2, byArray2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        return true;
    }

    public byte[] createRadiusAttributeBlock() throws IllegalArgumentException {
        byte[] byArray = new byte[this.dataSize()];
        try {
            int n2 = 0;
            for (int i2 = 0; i2 < this.active; ++i2) {
                byte[] byArray2 = this.a[i2].getAttribute();
                int n3 = this.a[i2].length;
                System.arraycopy(byArray2, 0, byArray, n2, n3);
                n2 += n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException(arrayIndexOutOfBoundsException.getMessage());
        }
        return byArray;
    }

    public int dataSize() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.active; ++i2) {
            n2 += this.a[i2].length;
        }
        return n2;
    }

    public static AttributeList merge(AttributeList attributeList, AttributeList attributeList2) {
        int n2;
        if (attributeList == null) {
            return attributeList2;
        }
        if (attributeList2 == null) {
            return attributeList;
        }
        new AttributeList();
        int n3 = attributeList.size();
        int n4 = attributeList2.size();
        AttributeList attributeList3 = new AttributeList();
        for (n2 = 0; n2 < n3; ++n2) {
            attributeList3.add(attributeList.a[n2]);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            attributeList3.add(attributeList2.a[n2]);
        }
        return attributeList3;
    }

    public void add(AttributeList attributeArray) {
        if (attributeArray == null) {
            return;
        }
        if (attributeArray.size() > 0) {
            attributeArray = attributeArray.toArray();
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                this.add(attributeArray[i2]);
            }
        }
    }

    public void add(Attribute[] attributeArray) {
        if (attributeArray == null) {
            return;
        }
        int n2 = attributeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add(attributeArray[i2]);
        }
    }

    public static AttributeList merge(AttributeList attributeList, Attribute[] attributeArray) {
        int n2;
        AttributeList attributeList2 = new AttributeList();
        if (attributeList == null && attributeArray == null) {
            return attributeList2;
        }
        if (attributeList == null) {
            return new AttributeList(attributeArray);
        }
        if (attributeArray == null) {
            return new AttributeList(attributeList);
        }
        int n3 = attributeList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            attributeList2.add(attributeList.a[n2]);
        }
        n3 = attributeArray.length;
        for (n2 = 0; n2 < n3; ++n2) {
            attributeList2.add(attributeArray[n2]);
        }
        return attributeList2;
    }

    public InetAddress getIP(int n2) {
        Attribute[] attributeArray = this.toArray(n2);
        if (attributeArray.length == 0) {
            return null;
        }
        return attributeArray[0].getIP();
    }

    public static InetAddress parseIPV6(byte[] byArray) {
        if (byArray.length != 16) {
            return null;
        }
        return AttributeList.parseIP(byArray);
    }

    public static InetAddress parseIP(byte[] byArray) {
        InetAddress inetAddress = null;
        if (byArray.length != 4 && byArray.length != 16) {
            return null;
        }
        try {
            inetAddress = InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {}
        return inetAddress;
    }

    public int getShort(int n2) {
        Object object = this.getAttribute(n2);
        if (object == null) {
            return -1;
        }
        byte[] byArray = ((Attribute)object).getData();
        object = byArray;
        if (byArray.length != 2) {
            return -1;
        }
        return (object[0] & 0xFF) << 8 | object[1] & 0xFF;
    }

    public VendorSpecific[] getVendorSpecific(int n2) {
        VendorSpecific[] vendorSpecificArray = new VendorSpecific[this.active];
        Attribute[] attributeArray = this.toArray(26);
        int n3 = 0;
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            if (attributeArray[i2].getVendorID() != n2) continue;
            vendorSpecificArray[n3++] = new VendorSpecific(attributeArray[i2]);
        }
        if (this.active != n3) {
            VendorSpecific[] vendorSpecificArray2 = new VendorSpecific[n3];
            System.arraycopy(vendorSpecificArray, 0, vendorSpecificArray2, 0, n3);
            vendorSpecificArray = vendorSpecificArray2;
        }
        return vendorSpecificArray;
    }

    public Attribute[] getVendorArray(int n2) {
        Attribute[] attributeArray = new Attribute[this.active];
        int n3 = 0;
        for (int i2 = 0; i2 < this.active; ++i2) {
            Attribute attribute = this.a[i2];
            if (attribute.getTag() != 26 || b.a(attribute.value, 2) != n2) continue;
            attributeArray[n3++] = attribute;
        }
        if (n3 > 0) {
            Attribute[] attributeArray2 = new Attribute[n3];
            System.arraycopy(attributeArray, 0, attributeArray2, 0, n3);
            return attributeArray2;
        }
        return new Attribute[0];
    }

    public Attribute[] getVendorSpecific(int n2, int n3) {
        VendorSpecific[] vendorSpecificArray = this.getVendorSpecific(n2);
        int n4 = vendorSpecificArray.length;
        if (n4 == 0) {
            return new Attribute[0];
        }
        AttributeList attributeList = new AttributeList();
        for (int i2 = 0; i2 < n4; ++i2) {
            Attribute[] attributeArray = vendorSpecificArray[i2].toArray(n3);
            attributeList.add(attributeArray);
        }
        return attributeList.toArray();
    }

    public int getInt(int n2) throws IllegalArgumentException {
        Object object = this.getAttribute(n2);
        if (object == null) {
            throw new IllegalArgumentException("No attributes of this type in list.");
        }
        byte[] byArray = ((Attribute)object).getData();
        object = byArray;
        return byArray[0] << 24 | (object[1] & 0xFF) << 16 | (object[2] & 0xFF) << 8 | object[3] & 0xFF;
    }

    public void delete(int n2) {
        this.a(n2, false);
    }

    public void deleteAll(int n2) {
        this.a(n2, true);
    }

    private void a(int n2, boolean bl) {
        int n3 = 0;
        boolean bl2 = true;
        int n4 = 0;
        for (int i2 = 0; i2 < this.active; ++i2) {
            if (bl2 && this.a[i2].tag == n2) {
                this.a[n4] = this.a[i2];
                ++n3;
                bl2 = bl;
                continue;
            }
            this.a[n4++] = this.a[i2];
        }
        this.active -= n3;
    }

    public Attribute getAttribute(int n2) {
        for (int i2 = 0; i2 < this.active; ++i2) {
            if (this.a[i2].tag != n2) continue;
            return this.a[i2];
        }
        return null;
    }

    public Attribute[] toArray() {
        Attribute[] attributeArray = new Attribute[this.active];
        System.arraycopy(this.a, 0, attributeArray, 0, this.active);
        return attributeArray;
    }

    public Attribute[] toArray(int n2) {
        Attribute[] attributeArray = new Attribute[this.size(n2)];
        int n3 = 0;
        for (int i2 = 0; i2 < this.active && n3 < attributeArray.length; ++i2) {
            Attribute attribute = this.a[i2];
            int n4 = attribute.getTag();
            if (n4 != n2) continue;
            attributeArray[n3++] = new Attribute(n4, attribute.getData());
        }
        return attributeArray;
    }

    public boolean contains(int n2) {
        return this.size(n2) > 0;
    }

    public int size(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.active; ++i2) {
            if (this.a[i2].tag != n2) continue;
            ++n3;
        }
        return n3;
    }

    public int size() {
        return this.active;
    }

    public int findPosition(int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.active; ++i2) {
            if (this.a[i2].tag == n2) {
                return n3;
            }
            n3 += this.a[i2].length;
        }
        return -1;
    }

    public Enumeration elements() {
        return new a(this);
    }

    public Attribute getAttributeAt(int n2) {
        if (n2 < 0 || n2 >= this.active) {
            return null;
        }
        return this.a[n2];
    }

    public void setAttributeAt(int n2, Attribute attribute) {
        if (n2 < 0 || n2 >= this.active) {
            return;
        }
        this.a[n2] = attribute;
    }

    public AttributeList getAttributeList(int n2) {
        AttributeList attributeList = new AttributeList();
        for (int i2 = 0; i2 < this.active; ++i2) {
            if (this.a[i2].tag != n2) continue;
            attributeList.add(this.a[i2]);
        }
        return attributeList;
    }

    public AttributeList copy() {
        AttributeList attributeList = new AttributeList();
        for (int i2 = 0; i2 < this.active; ++i2) {
            Attribute attribute = this.a[i2].copy();
            attributeList.add(attribute);
        }
        return attributeList;
    }

    public void encodeAll(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i2 = 0; i2 < this.active; ++i2) {
            Attribute attribute = this.a[i2];
            byte[] byArray4 = RADIUSEncode.saltEncode(byArray, attribute.getData(), byArray2, byArray3);
            this.a[i2] = attribute = new Attribute(attribute.getTag(), byArray4);
        }
    }

    public void decodeAll(byte[] byArray, byte[] byArray2) {
        for (int i2 = 0; i2 < this.active; ++i2) {
            Attribute attribute = this.a[i2];
            byte[] byArray3 = RADIUSEncode.saltDecode(attribute.getData(), byArray, byArray2);
            this.a[i2] = attribute = new Attribute(attribute.getTag(), byArray3);
        }
    }

    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            stringBuffer.append(attribute.toString(n2)).append('\n');
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        Enumeration enumeration = this.elements();
        block6: while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            switch (attribute.getTag()) {
                case 26: {
                    VendorSpecific vendorSpecific = new VendorSpecific(attribute);
                    if (vendorSpecific.hasVendorAttributes()) {
                        stringBuilder.append(vendorSpecific);
                        continue block6;
                    }
                    stringBuilder.append(attribute).append("\n");
                    continue block6;
                }
                case 79: {
                    stringBuilder.append(attribute).append("\n");
                    if (bl) continue block6;
                    bl = true;
                    continue block6;
                }
            }
            stringBuilder.append(attribute).append("\n");
        }
        if (bl) {
            try {
                stringBuilder.append("EAP-Message Information:\n\t").append(new EAPPacket(this));
            }
            catch (EAPException eAPException) {
                stringBuilder.append("Error displaying EAP-Message: " + eAPException.getMessage());
            }
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

