/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.jaas.jetty;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.eclipse.jetty.jaas.spi.AbstractLoginModule;
import org.eclipse.jetty.jaas.spi.UserInfo;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.security.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReloadablePropertyFileLoginModule
extends AbstractLoginModule {
    public static final String DEFAULT_FILENAME = "realm.properties";
    private static final Logger LOG = LoggerFactory.getLogger(ReloadablePropertyFileLoginModule.class);
    private static ConcurrentHashMap<String, PropertyUserStore> _propertyUserStores = new ConcurrentHashMap();
    private int _refreshInterval = 0;
    private String _filename = "realm.properties";
    private boolean _reloadEnabled = true;
    private boolean _debug = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.setupPropertyUserStore(options);
    }

    private void setupPropertyUserStore(Map<String, ?> options) {
        this.parseConfig(options);
        if (_propertyUserStores.get(this._filename) == null) {
            PropertyUserStore propertyUserStore = new PropertyUserStore();
            propertyUserStore.setHotReload(this._reloadEnabled);
            propertyUserStore.setConfig(this._filename);
            PropertyUserStore prev = _propertyUserStores.putIfAbsent(this._filename, propertyUserStore);
            if (prev == null) {
                this.debug("ReloadablePropertyFileLoginModule: setupPropertyUserStore: Starting new PropertyUserStore. PropertiesFile: " + this._filename + " refreshInterval: " + this._refreshInterval);
                try {
                    propertyUserStore.start();
                }
                catch (Exception e) {
                    LOG.warn("Exception while starting propertyUserStore: ", (Throwable)e);
                }
            }
        }
    }

    private void parseConfig(Map<String, ?> options) {
        String tmp = (String)options.get("file");
        this._filename = tmp == null ? DEFAULT_FILENAME : tmp;
        tmp = (String)options.get("refreshInterval");
        this._refreshInterval = tmp == null ? this._refreshInterval : Integer.parseInt(tmp);
        this._debug = options.containsKey("debug") && options.get("debug").equals("true");
    }

    public UserInfo getUserInfo(String userName) throws Exception {
        PropertyUserStore propertyUserStore = (PropertyUserStore)_propertyUserStores.get(this._filename);
        if (propertyUserStore == null) {
            throw new IllegalStateException("PropertyUserStore should never be null here!");
        }
        this.debug("ReloadablePropertyFileLoginModule: Checking PropertyUserStore " + this._filename + " for " + userName);
        UserIdentity userIdentity = propertyUserStore.getUserIdentity(userName);
        if (userIdentity == null) {
            return null;
        }
        Set<Principal> principals = userIdentity.getSubject().getPrincipals();
        ArrayList<String> roles = new ArrayList<String>();
        for (Principal principal : principals) {
            if (!(principal instanceof AbstractLoginService.RolePrincipal)) continue;
            roles.add(principal.getName());
        }
        Credential credential = (Credential)userIdentity.getSubject().getPrivateCredentials().iterator().next();
        this.debug("ReloadablePropertyFileLoginModule: Found: " + userName + " in PropertyUserStore " + this._filename);
        return new UserInfo(userName, credential, roles);
    }

    public boolean isReloadEnabled() {
        return this._reloadEnabled;
    }

    public void setReloadEnabled(boolean enabled) {
        this._reloadEnabled = enabled;
    }

    public boolean isDebug() {
        return this._debug;
    }

    protected void debug(String message) {
        if (this._debug) {
            System.err.println(message);
        }
    }
}

