/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.jaas;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class AbstractBaseLoginModule
implements LoginModule {
    private boolean debug;
    private boolean authenticated;
    private boolean committed;
    private Principal userPrincipal;
    private List<Principal> rolePrincipals;
    private Subject subject;
    private CallbackHandler callbackHandler;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> stringMap, Map<String, ?> options) {
        Object debug1 = options.get("debug");
        if (null != debug1) {
            this.debug = Boolean.parseBoolean(debug1.toString());
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    protected void debug(String message) {
        if (this.isDebug()) {
            System.err.println(message);
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    protected boolean isAuthenticated() {
        return this.authenticated;
    }

    protected void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    protected boolean isCommitted() {
        return this.committed;
    }

    protected void setCommitted(boolean committed) {
        this.committed = committed;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    protected void wasAuthenticated() {
        this.userPrincipal = this.createUserPrincipal();
        this.rolePrincipals = this.createRolePrincipals();
    }

    protected abstract List<Principal> createRolePrincipals();

    protected abstract Principal createUserPrincipal();

    private void setSubjectPrincipals() {
        if (null != this.userPrincipal) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (null != this.rolePrincipals) {
            for (Principal rolePrincipal : this.rolePrincipals) {
                this.subject.getPrincipals().add(rolePrincipal);
            }
        }
    }

    private void clearSubjectPrincipals() {
        if (null != this.userPrincipal) {
            this.subject.getPrincipals().remove(this.userPrincipal);
            this.userPrincipal = null;
        }
        if (null != this.rolePrincipals) {
            this.subject.getPrincipals().removeAll(this.rolePrincipals);
            this.rolePrincipals = null;
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isAuthenticated()) {
            this.setCommitted(false);
        } else {
            this.setSubjectPrincipals();
            this.setCommitted(true);
        }
        return this.isCommitted();
    }

    @Override
    public boolean logout() throws LoginException {
        this.setAuthenticated(false);
        this.clearSubjectPrincipals();
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return this.isAuthenticated() && this.isCommitted();
    }
}

