// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/billing/v1/customer_service.proto

package billing

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	CustomerService_List_FullMethodName                 = "/yandex.cloud.billing.v1.CustomerService/List"
	CustomerService_Invite_FullMethodName               = "/yandex.cloud.billing.v1.CustomerService/Invite"
	CustomerService_CreateResellerServed_FullMethodName = "/yandex.cloud.billing.v1.CustomerService/CreateResellerServed"
	CustomerService_Activate_FullMethodName             = "/yandex.cloud.billing.v1.CustomerService/Activate"
	CustomerService_Suspend_FullMethodName              = "/yandex.cloud.billing.v1.CustomerService/Suspend"
)

// CustomerServiceClient is the client API for CustomerService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// A set of methods for managing Customer resources.
type CustomerServiceClient interface {
	// Retrieves the list of customers associated with the specified reseller.
	List(ctx context.Context, in *ListCustomersRequest, opts ...grpc.CallOption) (*ListCustomersResponse, error)
	// Invites customer to the specified reseller.
	Invite(ctx context.Context, in *InviteCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Creates new reseller-served customer.
	CreateResellerServed(ctx context.Context, in *CreateResellerServedCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Activates specified customer. After customer is activated, he can use resources associated with his billing account.
	Activate(ctx context.Context, in *ActivateCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Suspend specified customer. After customer is suspended, he can't use resources associated with his billing account.
	Suspend(ctx context.Context, in *SuspendCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error)
}

type customerServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCustomerServiceClient(cc grpc.ClientConnInterface) CustomerServiceClient {
	return &customerServiceClient{cc}
}

func (c *customerServiceClient) List(ctx context.Context, in *ListCustomersRequest, opts ...grpc.CallOption) (*ListCustomersResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListCustomersResponse)
	err := c.cc.Invoke(ctx, CustomerService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerServiceClient) Invite(ctx context.Context, in *InviteCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, CustomerService_Invite_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerServiceClient) CreateResellerServed(ctx context.Context, in *CreateResellerServedCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, CustomerService_CreateResellerServed_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerServiceClient) Activate(ctx context.Context, in *ActivateCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, CustomerService_Activate_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *customerServiceClient) Suspend(ctx context.Context, in *SuspendCustomerRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, CustomerService_Suspend_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CustomerServiceServer is the server API for CustomerService service.
// All implementations should embed UnimplementedCustomerServiceServer
// for forward compatibility.
//
// A set of methods for managing Customer resources.
type CustomerServiceServer interface {
	// Retrieves the list of customers associated with the specified reseller.
	List(context.Context, *ListCustomersRequest) (*ListCustomersResponse, error)
	// Invites customer to the specified reseller.
	Invite(context.Context, *InviteCustomerRequest) (*operation.Operation, error)
	// Creates new reseller-served customer.
	CreateResellerServed(context.Context, *CreateResellerServedCustomerRequest) (*operation.Operation, error)
	// Activates specified customer. After customer is activated, he can use resources associated with his billing account.
	Activate(context.Context, *ActivateCustomerRequest) (*operation.Operation, error)
	// Suspend specified customer. After customer is suspended, he can't use resources associated with his billing account.
	Suspend(context.Context, *SuspendCustomerRequest) (*operation.Operation, error)
}

// UnimplementedCustomerServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedCustomerServiceServer struct{}

func (UnimplementedCustomerServiceServer) List(context.Context, *ListCustomersRequest) (*ListCustomersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedCustomerServiceServer) Invite(context.Context, *InviteCustomerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Invite not implemented")
}
func (UnimplementedCustomerServiceServer) CreateResellerServed(context.Context, *CreateResellerServedCustomerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateResellerServed not implemented")
}
func (UnimplementedCustomerServiceServer) Activate(context.Context, *ActivateCustomerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Activate not implemented")
}
func (UnimplementedCustomerServiceServer) Suspend(context.Context, *SuspendCustomerRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Suspend not implemented")
}
func (UnimplementedCustomerServiceServer) testEmbeddedByValue() {}

// UnsafeCustomerServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CustomerServiceServer will
// result in compilation errors.
type UnsafeCustomerServiceServer interface {
	mustEmbedUnimplementedCustomerServiceServer()
}

func RegisterCustomerServiceServer(s grpc.ServiceRegistrar, srv CustomerServiceServer) {
	// If the following call pancis, it indicates UnimplementedCustomerServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&CustomerService_ServiceDesc, srv)
}

func _CustomerService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CustomerService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerServiceServer).List(ctx, req.(*ListCustomersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerService_Invite_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InviteCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerServiceServer).Invite(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CustomerService_Invite_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerServiceServer).Invite(ctx, req.(*InviteCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerService_CreateResellerServed_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateResellerServedCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerServiceServer).CreateResellerServed(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CustomerService_CreateResellerServed_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerServiceServer).CreateResellerServed(ctx, req.(*CreateResellerServedCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerService_Activate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ActivateCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerServiceServer).Activate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CustomerService_Activate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerServiceServer).Activate(ctx, req.(*ActivateCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CustomerService_Suspend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuspendCustomerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CustomerServiceServer).Suspend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CustomerService_Suspend_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CustomerServiceServer).Suspend(ctx, req.(*SuspendCustomerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CustomerService_ServiceDesc is the grpc.ServiceDesc for CustomerService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CustomerService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.billing.v1.CustomerService",
	HandlerType: (*CustomerServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "List",
			Handler:    _CustomerService_List_Handler,
		},
		{
			MethodName: "Invite",
			Handler:    _CustomerService_Invite_Handler,
		},
		{
			MethodName: "CreateResellerServed",
			Handler:    _CustomerService_CreateResellerServed_Handler,
		},
		{
			MethodName: "Activate",
			Handler:    _CustomerService_Activate_Handler,
		},
		{
			MethodName: "Suspend",
			Handler:    _CustomerService_Suspend_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/billing/v1/customer_service.proto",
}
