// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/memcache/v1beta2/cloud_memcache.proto

package memcachepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CloudMemcache_ListInstances_FullMethodName         = "/google.cloud.memcache.v1beta2.CloudMemcache/ListInstances"
	CloudMemcache_GetInstance_FullMethodName           = "/google.cloud.memcache.v1beta2.CloudMemcache/GetInstance"
	CloudMemcache_CreateInstance_FullMethodName        = "/google.cloud.memcache.v1beta2.CloudMemcache/CreateInstance"
	CloudMemcache_UpdateInstance_FullMethodName        = "/google.cloud.memcache.v1beta2.CloudMemcache/UpdateInstance"
	CloudMemcache_UpdateParameters_FullMethodName      = "/google.cloud.memcache.v1beta2.CloudMemcache/UpdateParameters"
	CloudMemcache_DeleteInstance_FullMethodName        = "/google.cloud.memcache.v1beta2.CloudMemcache/DeleteInstance"
	CloudMemcache_ApplyParameters_FullMethodName       = "/google.cloud.memcache.v1beta2.CloudMemcache/ApplyParameters"
	CloudMemcache_ApplySoftwareUpdate_FullMethodName   = "/google.cloud.memcache.v1beta2.CloudMemcache/ApplySoftwareUpdate"
	CloudMemcache_RescheduleMaintenance_FullMethodName = "/google.cloud.memcache.v1beta2.CloudMemcache/RescheduleMaintenance"
)

// CloudMemcacheClient is the client API for CloudMemcache service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CloudMemcacheClient interface {
	// Lists Instances in a given location.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates a new Instance in a given location.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates an existing Instance in a given project and location.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the defined Memcached parameters for an existing instance.
	// This method only stages the parameters, it must be followed by
	// `ApplyParameters` to apply the parameters to nodes of the Memcached
	// instance.
	UpdateParameters(ctx context.Context, in *UpdateParametersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Instance.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// `ApplyParameters` restarts the set of specified nodes in order to update
	// them to the current set of parameters for the Memcached Instance.
	ApplyParameters(ctx context.Context, in *ApplyParametersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates software on the selected nodes of the Instance.
	ApplySoftwareUpdate(ctx context.Context, in *ApplySoftwareUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Performs the apply phase of the RescheduleMaintenance verb.
	RescheduleMaintenance(ctx context.Context, in *RescheduleMaintenanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type cloudMemcacheClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudMemcacheClient(cc grpc.ClientConnInterface) CloudMemcacheClient {
	return &cloudMemcacheClient{cc}
}

func (c *cloudMemcacheClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, CloudMemcache_ListInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, CloudMemcache_GetInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudMemcache_CreateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudMemcache_UpdateInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) UpdateParameters(ctx context.Context, in *UpdateParametersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudMemcache_UpdateParameters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudMemcache_DeleteInstance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) ApplyParameters(ctx context.Context, in *ApplyParametersRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudMemcache_ApplyParameters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) ApplySoftwareUpdate(ctx context.Context, in *ApplySoftwareUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudMemcache_ApplySoftwareUpdate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudMemcacheClient) RescheduleMaintenance(ctx context.Context, in *RescheduleMaintenanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CloudMemcache_RescheduleMaintenance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudMemcacheServer is the server API for CloudMemcache service.
// All implementations should embed UnimplementedCloudMemcacheServer
// for forward compatibility
type CloudMemcacheServer interface {
	// Lists Instances in a given location.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets details of a single Instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates a new Instance in a given location.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error)
	// Updates an existing Instance in a given project and location.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error)
	// Updates the defined Memcached parameters for an existing instance.
	// This method only stages the parameters, it must be followed by
	// `ApplyParameters` to apply the parameters to nodes of the Memcached
	// instance.
	UpdateParameters(context.Context, *UpdateParametersRequest) (*longrunningpb.Operation, error)
	// Deletes a single Instance.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error)
	// `ApplyParameters` restarts the set of specified nodes in order to update
	// them to the current set of parameters for the Memcached Instance.
	ApplyParameters(context.Context, *ApplyParametersRequest) (*longrunningpb.Operation, error)
	// Updates software on the selected nodes of the Instance.
	ApplySoftwareUpdate(context.Context, *ApplySoftwareUpdateRequest) (*longrunningpb.Operation, error)
	// Performs the apply phase of the RescheduleMaintenance verb.
	RescheduleMaintenance(context.Context, *RescheduleMaintenanceRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCloudMemcacheServer should be embedded to have forward compatible implementations.
type UnimplementedCloudMemcacheServer struct {
}

func (UnimplementedCloudMemcacheServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedCloudMemcacheServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (UnimplementedCloudMemcacheServer) CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (UnimplementedCloudMemcacheServer) UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (UnimplementedCloudMemcacheServer) UpdateParameters(context.Context, *UpdateParametersRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateParameters not implemented")
}
func (UnimplementedCloudMemcacheServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (UnimplementedCloudMemcacheServer) ApplyParameters(context.Context, *ApplyParametersRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyParameters not implemented")
}
func (UnimplementedCloudMemcacheServer) ApplySoftwareUpdate(context.Context, *ApplySoftwareUpdateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplySoftwareUpdate not implemented")
}
func (UnimplementedCloudMemcacheServer) RescheduleMaintenance(context.Context, *RescheduleMaintenanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RescheduleMaintenance not implemented")
}

// UnsafeCloudMemcacheServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CloudMemcacheServer will
// result in compilation errors.
type UnsafeCloudMemcacheServer interface {
	mustEmbedUnimplementedCloudMemcacheServer()
}

func RegisterCloudMemcacheServer(s grpc.ServiceRegistrar, srv CloudMemcacheServer) {
	s.RegisterService(&CloudMemcache_ServiceDesc, srv)
}

func _CloudMemcache_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudMemcache_ListInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudMemcache_GetInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudMemcache_CreateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudMemcache_UpdateInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_UpdateParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).UpdateParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudMemcache_UpdateParameters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).UpdateParameters(ctx, req.(*UpdateParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudMemcache_DeleteInstance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_ApplyParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).ApplyParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudMemcache_ApplyParameters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).ApplyParameters(ctx, req.(*ApplyParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_ApplySoftwareUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplySoftwareUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).ApplySoftwareUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudMemcache_ApplySoftwareUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).ApplySoftwareUpdate(ctx, req.(*ApplySoftwareUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudMemcache_RescheduleMaintenance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RescheduleMaintenanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudMemcacheServer).RescheduleMaintenance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CloudMemcache_RescheduleMaintenance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudMemcacheServer).RescheduleMaintenance(ctx, req.(*RescheduleMaintenanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CloudMemcache_ServiceDesc is the grpc.ServiceDesc for CloudMemcache service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CloudMemcache_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.memcache.v1beta2.CloudMemcache",
	HandlerType: (*CloudMemcacheServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudMemcache_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudMemcache_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudMemcache_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudMemcache_UpdateInstance_Handler,
		},
		{
			MethodName: "UpdateParameters",
			Handler:    _CloudMemcache_UpdateParameters_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudMemcache_DeleteInstance_Handler,
		},
		{
			MethodName: "ApplyParameters",
			Handler:    _CloudMemcache_ApplyParameters_Handler,
		},
		{
			MethodName: "ApplySoftwareUpdate",
			Handler:    _CloudMemcache_ApplySoftwareUpdate_Handler,
		},
		{
			MethodName: "RescheduleMaintenance",
			Handler:    _CloudMemcache_RescheduleMaintenance_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/memcache/v1beta2/cloud_memcache.proto",
}
