// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Initiates an AMI copy operation. You must specify the source AMI ID and both
// the source and destination locations. The copy operation must be initiated in
// the destination Region.
//
// CopyImage supports the following source to destination copies:
//
//   - Region to Region
//
//   - Region to Outpost
//
//   - Parent Region to Local Zone
//
//   - Local Zone to parent Region
//
//   - Between Local Zones with the same parent Region (only supported for certain
//     Local Zones)
//
// CopyImage does not support the following source to destination copies:
//
//   - Local Zone to non-parent Regions
//
//   - Between Local Zones with different parent Regions
//
//   - Local Zone to Outpost
//
//   - Outpost to Local Zone
//
//   - Outpost to Region
//
//   - Between Outposts
//
//   - Within same Outpost
//
//   - Cross-partition copies (use [CreateStoreImageTask]instead)
//
// Destination specification
//
//   - Region to Region: The destination Region is the Region in which you
//     initiate the copy operation.
//
//   - Region to Outpost: Specify the destination using the DestinationOutpostArn
//     parameter (the ARN of the Outpost)
//
//   - Region to Local Zone, and Local Zone to Local Zone copies: Specify the
//     destination using the DestinationAvailabilityZone parameter (the name of the
//     destination Local Zone) or DestinationAvailabilityZoneId parameter (the ID of
//     the destination Local Zone).
//
// Snapshot encryption
//
//   - Region to Outpost: Backing snapshots copied to an Outpost are encrypted by
//     default using the default encryption key for the Region or the key that you
//     specify. Outposts do not support unencrypted snapshots.
//
//   - Region to Local Zone, and Local Zone to Local Zone: Not all Local Zones
//     require encrypted snapshots. In Local Zones that require encrypted snapshots,
//     backing snapshots are automatically encrypted during copy. In Local Zones where
//     encryption is not required, snapshots retain their original encryption state
//     (encrypted or unencrypted) by default.
//
// For more information, including the required permissions for copying an AMI,
// see [Copy an Amazon EC2 AMI]in the Amazon EC2 User Guide.
//
// [CreateStoreImageTask]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateStoreImageTask.html
// [Copy an Amazon EC2 AMI]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html
func (c *Client) CopyImage(ctx context.Context, params *CopyImageInput, optFns ...func(*Options)) (*CopyImageOutput, error) {
	if params == nil {
		params = &CopyImageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CopyImage", params, optFns, c.addOperationCopyImageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CopyImageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Contains the parameters for CopyImage.
type CopyImageInput struct {

	// The name of the new AMI.
	//
	// This member is required.
	Name *string

	// The ID of the AMI to copy.
	//
	// This member is required.
	SourceImageId *string

	// The name of the Region that contains the AMI to copy.
	//
	// This member is required.
	SourceRegion *string

	// Unique, case-sensitive identifier you provide to ensure idempotency of the
	// request. For more information, see [Ensuring idempotency in Amazon EC2 API requests]in the Amazon EC2 API Reference.
	//
	// [Ensuring idempotency in Amazon EC2 API requests]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	// Specifies whether to copy your user-defined AMI tags to the new AMI.
	//
	// The following tags are not be copied:
	//
	//   - System tags (prefixed with aws: )
	//
	//   - For public and shared AMIs, user-defined tags that are attached by other
	//   Amazon Web Services accounts
	//
	// Default: Your user-defined AMI tags are not copied.
	CopyImageTags *bool

	// A description for the new AMI.
	Description *string

	// The Local Zone for the new AMI (for example, cn-north-1-pkx-1a ).
	//
	// Only one of DestinationAvailabilityZone , DestinationAvailabilityZoneId , or
	// DestinationOutpostArn can be specified.
	DestinationAvailabilityZone *string

	// The ID of the Local Zone for the new AMI (for example, cnn1-pkx1-az1 ).
	//
	// Only one of DestinationAvailabilityZone , DestinationAvailabilityZoneId , or
	// DestinationOutpostArn can be specified.
	DestinationAvailabilityZoneId *string

	// The Amazon Resource Name (ARN) of the Outpost for the new AMI.
	//
	// Only specify this parameter when copying an AMI from an Amazon Web Services
	// Region to an Outpost. The AMI must be in the Region of the destination Outpost.
	// You can't copy an AMI from an Outpost to a Region, from one Outpost to another,
	// or within the same Outpost.
	//
	// For more information, see [Copy AMIs from an Amazon Web Services Region to an Outpost] in the Amazon EBS User Guide.
	//
	// Only one of DestinationAvailabilityZone , DestinationAvailabilityZoneId , or
	// DestinationOutpostArn can be specified.
	//
	// [Copy AMIs from an Amazon Web Services Region to an Outpost]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#copy-amis
	DestinationOutpostArn *string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Specifies whether to encrypt the snapshots of the copied image.
	//
	// You can encrypt a copy of an unencrypted snapshot, but you cannot create an
	// unencrypted copy of an encrypted snapshot. The default KMS key for Amazon EBS is
	// used unless you specify a non-default Key Management Service (KMS) KMS key using
	// KmsKeyId . For more information, see [Use encryption with EBS-backed AMIs] in the Amazon EC2 User Guide.
	//
	// [Use encryption with EBS-backed AMIs]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html
	Encrypted *bool

	// The identifier of the symmetric Key Management Service (KMS) KMS key to use
	// when creating encrypted volumes. If this parameter is not specified, your Amazon
	// Web Services managed KMS key for Amazon EBS is used. If you specify a KMS key,
	// you must also set the encrypted state to true .
	//
	// You can specify a KMS key using any of the following:
	//
	//   - Key ID. For example, 1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	//   - Key alias. For example, alias/ExampleAlias.
	//
	//   - Key ARN. For example,
	//   arn:aws:kms:us-east-1:012345678910:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	//
	//   - Alias ARN. For example,
	//   arn:aws:kms:us-east-1:012345678910:alias/ExampleAlias.
	//
	// Amazon Web Services authenticates the KMS key asynchronously. Therefore, if you
	// specify an identifier that is not valid, the action can appear to complete, but
	// eventually fails.
	//
	// The specified KMS key must exist in the destination Region.
	//
	// Amazon EBS does not support asymmetric KMS keys.
	KmsKeyId *string

	// Specify a completion duration, in 15 minute increments, to initiate a
	// time-based AMI copy. The specified completion duration applies to each of the
	// snapshots associated with the AMI. Each snapshot associated with the AMI will be
	// completed within the specified completion duration, with copy throughput
	// automatically adjusted for each snapshot based on its size to meet the timing
	// target.
	//
	// If you do not specify a value, the AMI copy operation is completed on a
	// best-effort basis.
	//
	// This parameter is not supported when copying an AMI to or from a Local Zone, or
	// to an Outpost.
	//
	// For more information, see [Time-based copies for Amazon EBS snapshots and EBS-backed AMIs].
	//
	// [Time-based copies for Amazon EBS snapshots and EBS-backed AMIs]: https://docs.aws.amazon.com/ebs/latest/userguide/time-based-copies.html
	SnapshotCopyCompletionDurationMinutes *int64

	// The tags to apply to the new AMI and new snapshots. You can tag the AMI, the
	// snapshots, or both.
	//
	//   - To tag the new AMI, the value for ResourceType must be image .
	//
	//   - To tag the new snapshots, the value for ResourceType must be snapshot . The
	//   same tag is applied to all the new snapshots.
	//
	// If you specify other values for ResourceType , the request fails.
	//
	// To tag an AMI or snapshot after it has been created, see [CreateTags].
	//
	// [CreateTags]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTags.html
	TagSpecifications []types.TagSpecification

	noSmithyDocumentSerde
}

// Contains the output of CopyImage.
type CopyImageOutput struct {

	// The ID of the new AMI.
	ImageId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCopyImageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpCopyImage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCopyImage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CopyImage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCopyImageMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCopyImageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCopyImage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCopyImage struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCopyImage) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCopyImage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CopyImageInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CopyImageInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCopyImageMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCopyImage{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCopyImage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CopyImage",
	}
}
