package main

import (
	"context"
	"log"

	"github.com/owenthereal/tmux"
)

func main() {
	ctx := context.Background()

	t, err := tmux.Default()
	if err != nil {
		log.Fatal(err)
	}

	session, err := t.New(ctx)
	if err != nil {
		log.Fatal(err)
	}

	window, err := session.New(ctx)
	if err != nil {
		log.Fatal(err)
	}

	pane, err := window.FirstPane(ctx)
	if err != nil {
		log.Fatal(err)
	}

	_, err = pane.Split(ctx)
	if err != nil {
		log.Fatal(err)
	}
}
