// Code generated by go generate. DO NOT EDIT.

package opt

import (
	"encoding/json"
	"testing"

	"github.com/algolia/algoliasearch-client-go/v3/algolia/opt"
	"github.com/stretchr/testify/require"
)

func TestCustomRanking(t *testing.T) {
	for _, c := range []struct {
		opts     []interface{}
		expected *opt.CustomRankingOption
	}{
		{
			opts:     []interface{}{nil},
			expected: opt.CustomRanking([]string{}...),
		},
		{
			opts:     []interface{}{opt.CustomRanking("value1")},
			expected: opt.CustomRanking("value1"),
		},
		{
			opts:     []interface{}{opt.CustomRanking("value1", "value2", "value3")},
			expected: opt.CustomRanking("value1", "value2", "value3"),
		},
	} {
		var (
			in  = ExtractCustomRanking(c.opts...)
			out opt.CustomRankingOption
		)
		data, err := json.Marshal(&in)
		require.NoError(t, err)
		err = json.Unmarshal(data, &out)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), out.Get())
	}
}

func TestCustomRanking_CommaSeparatedString(t *testing.T) {
	for _, c := range []struct {
		payload  string
		expected *opt.CustomRankingOption
	}{
		{
			payload:  `""`,
			expected: opt.CustomRanking([]string{}...),
		},
		{
			payload:  `"value1"`,
			expected: opt.CustomRanking("value1"),
		},
		{
			payload:  `"value1,value2,value3"`,
			expected: opt.CustomRanking("value1", "value2", "value3"),
		},
	} {
		var got opt.CustomRankingOption
		err := json.Unmarshal([]byte(c.payload), &got)
		require.NoError(t, err)
		require.ElementsMatch(t, c.expected.Get(), got.Get())
	}
}
