/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Instruction;
import org.openstreetmap.josm.tools.Utils;

public class Declaration {
    public final List<Instruction> instructions;
    public final int idx;

    public Declaration(List<Instruction> instructions, int idx) {
        this.instructions = Utils.toUnmodifiableList(instructions);
        this.idx = idx;
    }

    public void execute(Environment env) {
        for (Instruction i : this.instructions) {
            i.execute(env);
        }
    }

    public int hashCode() {
        return Objects.hash(this.instructions, this.idx);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Declaration that = (Declaration)obj;
        return this.idx == that.idx && Objects.equals(this.instructions, that.instructions);
    }

    public String toString() {
        return "Declaration [instructions=" + String.valueOf(this.instructions) + ", idx=" + this.idx + "]";
    }
}

