// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/prediction_service.proto

package aiplatformpb

import (
	context "context"

	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PredictionService_Predict_FullMethodName                = "/google.cloud.aiplatform.v1.PredictionService/Predict"
	PredictionService_RawPredict_FullMethodName             = "/google.cloud.aiplatform.v1.PredictionService/RawPredict"
	PredictionService_StreamRawPredict_FullMethodName       = "/google.cloud.aiplatform.v1.PredictionService/StreamRawPredict"
	PredictionService_DirectPredict_FullMethodName          = "/google.cloud.aiplatform.v1.PredictionService/DirectPredict"
	PredictionService_DirectRawPredict_FullMethodName       = "/google.cloud.aiplatform.v1.PredictionService/DirectRawPredict"
	PredictionService_StreamDirectPredict_FullMethodName    = "/google.cloud.aiplatform.v1.PredictionService/StreamDirectPredict"
	PredictionService_StreamDirectRawPredict_FullMethodName = "/google.cloud.aiplatform.v1.PredictionService/StreamDirectRawPredict"
	PredictionService_StreamingPredict_FullMethodName       = "/google.cloud.aiplatform.v1.PredictionService/StreamingPredict"
	PredictionService_ServerStreamingPredict_FullMethodName = "/google.cloud.aiplatform.v1.PredictionService/ServerStreamingPredict"
	PredictionService_StreamingRawPredict_FullMethodName    = "/google.cloud.aiplatform.v1.PredictionService/StreamingRawPredict"
	PredictionService_Explain_FullMethodName                = "/google.cloud.aiplatform.v1.PredictionService/Explain"
	PredictionService_GenerateContent_FullMethodName        = "/google.cloud.aiplatform.v1.PredictionService/GenerateContent"
	PredictionService_StreamGenerateContent_FullMethodName  = "/google.cloud.aiplatform.v1.PredictionService/StreamGenerateContent"
	PredictionService_EmbedContent_FullMethodName           = "/google.cloud.aiplatform.v1.PredictionService/EmbedContent"
)

// PredictionServiceClient is the client API for PredictionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PredictionServiceClient interface {
	// Perform an online prediction.
	Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error)
	// Perform an online prediction with an arbitrary HTTP payload.
	//
	// The response includes the following HTTP headers:
	//
	// * `X-Vertex-AI-Endpoint-Id`: ID of the
	// [Endpoint][google.cloud.aiplatform.v1.Endpoint] that served this
	// prediction.
	//
	// * `X-Vertex-AI-Deployed-Model-Id`: ID of the Endpoint's
	// [DeployedModel][google.cloud.aiplatform.v1.DeployedModel] that served this
	// prediction.
	RawPredict(ctx context.Context, in *RawPredictRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error)
	// Perform a streaming online prediction with an arbitrary HTTP payload.
	StreamRawPredict(ctx context.Context, in *StreamRawPredictRequest, opts ...grpc.CallOption) (PredictionService_StreamRawPredictClient, error)
	// Perform an unary online prediction request to a gRPC model server for
	// Vertex first-party products and frameworks.
	DirectPredict(ctx context.Context, in *DirectPredictRequest, opts ...grpc.CallOption) (*DirectPredictResponse, error)
	// Perform an unary online prediction request to a gRPC model server for
	// custom containers.
	DirectRawPredict(ctx context.Context, in *DirectRawPredictRequest, opts ...grpc.CallOption) (*DirectRawPredictResponse, error)
	// Perform a streaming online prediction request to a gRPC model server for
	// Vertex first-party products and frameworks.
	StreamDirectPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamDirectPredictClient, error)
	// Perform a streaming online prediction request to a gRPC model server for
	// custom containers.
	StreamDirectRawPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamDirectRawPredictClient, error)
	// Perform a streaming online prediction request for Vertex first-party
	// products and frameworks.
	StreamingPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamingPredictClient, error)
	// Perform a server-side streaming online prediction request for Vertex
	// LLM streaming.
	ServerStreamingPredict(ctx context.Context, in *StreamingPredictRequest, opts ...grpc.CallOption) (PredictionService_ServerStreamingPredictClient, error)
	// Perform a streaming online prediction request through gRPC.
	StreamingRawPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamingRawPredictClient, error)
	// Perform an online explanation.
	//
	// If
	// [deployed_model_id][google.cloud.aiplatform.v1.ExplainRequest.deployed_model_id]
	// is specified, the corresponding DeployModel must have
	// [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
	// populated. If
	// [deployed_model_id][google.cloud.aiplatform.v1.ExplainRequest.deployed_model_id]
	// is not specified, all DeployedModels must have
	// [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
	// populated.
	Explain(ctx context.Context, in *ExplainRequest, opts ...grpc.CallOption) (*ExplainResponse, error)
	// Generate content with multimodal inputs.
	GenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (*GenerateContentResponse, error)
	// Generate content with multimodal inputs with streaming support.
	StreamGenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (PredictionService_StreamGenerateContentClient, error)
	// Embed content with multimodal inputs.
	EmbedContent(ctx context.Context, in *EmbedContentRequest, opts ...grpc.CallOption) (*EmbedContentResponse, error)
}

type predictionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPredictionServiceClient(cc grpc.ClientConnInterface) PredictionServiceClient {
	return &predictionServiceClient{cc}
}

func (c *predictionServiceClient) Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error) {
	out := new(PredictResponse)
	err := c.cc.Invoke(ctx, PredictionService_Predict_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) RawPredict(ctx context.Context, in *RawPredictRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error) {
	out := new(httpbody.HttpBody)
	err := c.cc.Invoke(ctx, PredictionService_RawPredict_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) StreamRawPredict(ctx context.Context, in *StreamRawPredictRequest, opts ...grpc.CallOption) (PredictionService_StreamRawPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &PredictionService_ServiceDesc.Streams[0], PredictionService_StreamRawPredict_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamRawPredictClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type PredictionService_StreamRawPredictClient interface {
	Recv() (*httpbody.HttpBody, error)
	grpc.ClientStream
}

type predictionServiceStreamRawPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamRawPredictClient) Recv() (*httpbody.HttpBody, error) {
	m := new(httpbody.HttpBody)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) DirectPredict(ctx context.Context, in *DirectPredictRequest, opts ...grpc.CallOption) (*DirectPredictResponse, error) {
	out := new(DirectPredictResponse)
	err := c.cc.Invoke(ctx, PredictionService_DirectPredict_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) DirectRawPredict(ctx context.Context, in *DirectRawPredictRequest, opts ...grpc.CallOption) (*DirectRawPredictResponse, error) {
	out := new(DirectRawPredictResponse)
	err := c.cc.Invoke(ctx, PredictionService_DirectRawPredict_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) StreamDirectPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamDirectPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &PredictionService_ServiceDesc.Streams[1], PredictionService_StreamDirectPredict_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamDirectPredictClient{stream}
	return x, nil
}

type PredictionService_StreamDirectPredictClient interface {
	Send(*StreamDirectPredictRequest) error
	Recv() (*StreamDirectPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamDirectPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamDirectPredictClient) Send(m *StreamDirectPredictRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *predictionServiceStreamDirectPredictClient) Recv() (*StreamDirectPredictResponse, error) {
	m := new(StreamDirectPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) StreamDirectRawPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamDirectRawPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &PredictionService_ServiceDesc.Streams[2], PredictionService_StreamDirectRawPredict_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamDirectRawPredictClient{stream}
	return x, nil
}

type PredictionService_StreamDirectRawPredictClient interface {
	Send(*StreamDirectRawPredictRequest) error
	Recv() (*StreamDirectRawPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamDirectRawPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamDirectRawPredictClient) Send(m *StreamDirectRawPredictRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *predictionServiceStreamDirectRawPredictClient) Recv() (*StreamDirectRawPredictResponse, error) {
	m := new(StreamDirectRawPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) StreamingPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamingPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &PredictionService_ServiceDesc.Streams[3], PredictionService_StreamingPredict_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamingPredictClient{stream}
	return x, nil
}

type PredictionService_StreamingPredictClient interface {
	Send(*StreamingPredictRequest) error
	Recv() (*StreamingPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamingPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamingPredictClient) Send(m *StreamingPredictRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *predictionServiceStreamingPredictClient) Recv() (*StreamingPredictResponse, error) {
	m := new(StreamingPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) ServerStreamingPredict(ctx context.Context, in *StreamingPredictRequest, opts ...grpc.CallOption) (PredictionService_ServerStreamingPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &PredictionService_ServiceDesc.Streams[4], PredictionService_ServerStreamingPredict_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceServerStreamingPredictClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type PredictionService_ServerStreamingPredictClient interface {
	Recv() (*StreamingPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceServerStreamingPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceServerStreamingPredictClient) Recv() (*StreamingPredictResponse, error) {
	m := new(StreamingPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) StreamingRawPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamingRawPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &PredictionService_ServiceDesc.Streams[5], PredictionService_StreamingRawPredict_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamingRawPredictClient{stream}
	return x, nil
}

type PredictionService_StreamingRawPredictClient interface {
	Send(*StreamingRawPredictRequest) error
	Recv() (*StreamingRawPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamingRawPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamingRawPredictClient) Send(m *StreamingRawPredictRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *predictionServiceStreamingRawPredictClient) Recv() (*StreamingRawPredictResponse, error) {
	m := new(StreamingRawPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) Explain(ctx context.Context, in *ExplainRequest, opts ...grpc.CallOption) (*ExplainResponse, error) {
	out := new(ExplainResponse)
	err := c.cc.Invoke(ctx, PredictionService_Explain_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) GenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (*GenerateContentResponse, error) {
	out := new(GenerateContentResponse)
	err := c.cc.Invoke(ctx, PredictionService_GenerateContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) StreamGenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (PredictionService_StreamGenerateContentClient, error) {
	stream, err := c.cc.NewStream(ctx, &PredictionService_ServiceDesc.Streams[6], PredictionService_StreamGenerateContent_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamGenerateContentClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type PredictionService_StreamGenerateContentClient interface {
	Recv() (*GenerateContentResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamGenerateContentClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamGenerateContentClient) Recv() (*GenerateContentResponse, error) {
	m := new(GenerateContentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) EmbedContent(ctx context.Context, in *EmbedContentRequest, opts ...grpc.CallOption) (*EmbedContentResponse, error) {
	out := new(EmbedContentResponse)
	err := c.cc.Invoke(ctx, PredictionService_EmbedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PredictionServiceServer is the server API for PredictionService service.
// All implementations should embed UnimplementedPredictionServiceServer
// for forward compatibility
type PredictionServiceServer interface {
	// Perform an online prediction.
	Predict(context.Context, *PredictRequest) (*PredictResponse, error)
	// Perform an online prediction with an arbitrary HTTP payload.
	//
	// The response includes the following HTTP headers:
	//
	// * `X-Vertex-AI-Endpoint-Id`: ID of the
	// [Endpoint][google.cloud.aiplatform.v1.Endpoint] that served this
	// prediction.
	//
	// * `X-Vertex-AI-Deployed-Model-Id`: ID of the Endpoint's
	// [DeployedModel][google.cloud.aiplatform.v1.DeployedModel] that served this
	// prediction.
	RawPredict(context.Context, *RawPredictRequest) (*httpbody.HttpBody, error)
	// Perform a streaming online prediction with an arbitrary HTTP payload.
	StreamRawPredict(*StreamRawPredictRequest, PredictionService_StreamRawPredictServer) error
	// Perform an unary online prediction request to a gRPC model server for
	// Vertex first-party products and frameworks.
	DirectPredict(context.Context, *DirectPredictRequest) (*DirectPredictResponse, error)
	// Perform an unary online prediction request to a gRPC model server for
	// custom containers.
	DirectRawPredict(context.Context, *DirectRawPredictRequest) (*DirectRawPredictResponse, error)
	// Perform a streaming online prediction request to a gRPC model server for
	// Vertex first-party products and frameworks.
	StreamDirectPredict(PredictionService_StreamDirectPredictServer) error
	// Perform a streaming online prediction request to a gRPC model server for
	// custom containers.
	StreamDirectRawPredict(PredictionService_StreamDirectRawPredictServer) error
	// Perform a streaming online prediction request for Vertex first-party
	// products and frameworks.
	StreamingPredict(PredictionService_StreamingPredictServer) error
	// Perform a server-side streaming online prediction request for Vertex
	// LLM streaming.
	ServerStreamingPredict(*StreamingPredictRequest, PredictionService_ServerStreamingPredictServer) error
	// Perform a streaming online prediction request through gRPC.
	StreamingRawPredict(PredictionService_StreamingRawPredictServer) error
	// Perform an online explanation.
	//
	// If
	// [deployed_model_id][google.cloud.aiplatform.v1.ExplainRequest.deployed_model_id]
	// is specified, the corresponding DeployModel must have
	// [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
	// populated. If
	// [deployed_model_id][google.cloud.aiplatform.v1.ExplainRequest.deployed_model_id]
	// is not specified, all DeployedModels must have
	// [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
	// populated.
	Explain(context.Context, *ExplainRequest) (*ExplainResponse, error)
	// Generate content with multimodal inputs.
	GenerateContent(context.Context, *GenerateContentRequest) (*GenerateContentResponse, error)
	// Generate content with multimodal inputs with streaming support.
	StreamGenerateContent(*GenerateContentRequest, PredictionService_StreamGenerateContentServer) error
	// Embed content with multimodal inputs.
	EmbedContent(context.Context, *EmbedContentRequest) (*EmbedContentResponse, error)
}

// UnimplementedPredictionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedPredictionServiceServer struct {
}

func (UnimplementedPredictionServiceServer) Predict(context.Context, *PredictRequest) (*PredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Predict not implemented")
}
func (UnimplementedPredictionServiceServer) RawPredict(context.Context, *RawPredictRequest) (*httpbody.HttpBody, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RawPredict not implemented")
}
func (UnimplementedPredictionServiceServer) StreamRawPredict(*StreamRawPredictRequest, PredictionService_StreamRawPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamRawPredict not implemented")
}
func (UnimplementedPredictionServiceServer) DirectPredict(context.Context, *DirectPredictRequest) (*DirectPredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DirectPredict not implemented")
}
func (UnimplementedPredictionServiceServer) DirectRawPredict(context.Context, *DirectRawPredictRequest) (*DirectRawPredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DirectRawPredict not implemented")
}
func (UnimplementedPredictionServiceServer) StreamDirectPredict(PredictionService_StreamDirectPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamDirectPredict not implemented")
}
func (UnimplementedPredictionServiceServer) StreamDirectRawPredict(PredictionService_StreamDirectRawPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamDirectRawPredict not implemented")
}
func (UnimplementedPredictionServiceServer) StreamingPredict(PredictionService_StreamingPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingPredict not implemented")
}
func (UnimplementedPredictionServiceServer) ServerStreamingPredict(*StreamingPredictRequest, PredictionService_ServerStreamingPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method ServerStreamingPredict not implemented")
}
func (UnimplementedPredictionServiceServer) StreamingRawPredict(PredictionService_StreamingRawPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingRawPredict not implemented")
}
func (UnimplementedPredictionServiceServer) Explain(context.Context, *ExplainRequest) (*ExplainResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Explain not implemented")
}
func (UnimplementedPredictionServiceServer) GenerateContent(context.Context, *GenerateContentRequest) (*GenerateContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateContent not implemented")
}
func (UnimplementedPredictionServiceServer) StreamGenerateContent(*GenerateContentRequest, PredictionService_StreamGenerateContentServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamGenerateContent not implemented")
}
func (UnimplementedPredictionServiceServer) EmbedContent(context.Context, *EmbedContentRequest) (*EmbedContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EmbedContent not implemented")
}

// UnsafePredictionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PredictionServiceServer will
// result in compilation errors.
type UnsafePredictionServiceServer interface {
	mustEmbedUnimplementedPredictionServiceServer()
}

func RegisterPredictionServiceServer(s grpc.ServiceRegistrar, srv PredictionServiceServer) {
	s.RegisterService(&PredictionService_ServiceDesc, srv)
}

func _PredictionService_Predict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Predict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionService_Predict_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Predict(ctx, req.(*PredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_RawPredict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawPredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).RawPredict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionService_RawPredict_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).RawPredict(ctx, req.(*RawPredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_StreamRawPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamRawPredictRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PredictionServiceServer).StreamRawPredict(m, &predictionServiceStreamRawPredictServer{stream})
}

type PredictionService_StreamRawPredictServer interface {
	Send(*httpbody.HttpBody) error
	grpc.ServerStream
}

type predictionServiceStreamRawPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamRawPredictServer) Send(m *httpbody.HttpBody) error {
	return x.ServerStream.SendMsg(m)
}

func _PredictionService_DirectPredict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DirectPredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).DirectPredict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionService_DirectPredict_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).DirectPredict(ctx, req.(*DirectPredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_DirectRawPredict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DirectRawPredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).DirectRawPredict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionService_DirectRawPredict_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).DirectRawPredict(ctx, req.(*DirectRawPredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_StreamDirectPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PredictionServiceServer).StreamDirectPredict(&predictionServiceStreamDirectPredictServer{stream})
}

type PredictionService_StreamDirectPredictServer interface {
	Send(*StreamDirectPredictResponse) error
	Recv() (*StreamDirectPredictRequest, error)
	grpc.ServerStream
}

type predictionServiceStreamDirectPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamDirectPredictServer) Send(m *StreamDirectPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *predictionServiceStreamDirectPredictServer) Recv() (*StreamDirectPredictRequest, error) {
	m := new(StreamDirectPredictRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _PredictionService_StreamDirectRawPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PredictionServiceServer).StreamDirectRawPredict(&predictionServiceStreamDirectRawPredictServer{stream})
}

type PredictionService_StreamDirectRawPredictServer interface {
	Send(*StreamDirectRawPredictResponse) error
	Recv() (*StreamDirectRawPredictRequest, error)
	grpc.ServerStream
}

type predictionServiceStreamDirectRawPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamDirectRawPredictServer) Send(m *StreamDirectRawPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *predictionServiceStreamDirectRawPredictServer) Recv() (*StreamDirectRawPredictRequest, error) {
	m := new(StreamDirectRawPredictRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _PredictionService_StreamingPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PredictionServiceServer).StreamingPredict(&predictionServiceStreamingPredictServer{stream})
}

type PredictionService_StreamingPredictServer interface {
	Send(*StreamingPredictResponse) error
	Recv() (*StreamingPredictRequest, error)
	grpc.ServerStream
}

type predictionServiceStreamingPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamingPredictServer) Send(m *StreamingPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *predictionServiceStreamingPredictServer) Recv() (*StreamingPredictRequest, error) {
	m := new(StreamingPredictRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _PredictionService_ServerStreamingPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamingPredictRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PredictionServiceServer).ServerStreamingPredict(m, &predictionServiceServerStreamingPredictServer{stream})
}

type PredictionService_ServerStreamingPredictServer interface {
	Send(*StreamingPredictResponse) error
	grpc.ServerStream
}

type predictionServiceServerStreamingPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceServerStreamingPredictServer) Send(m *StreamingPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _PredictionService_StreamingRawPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PredictionServiceServer).StreamingRawPredict(&predictionServiceStreamingRawPredictServer{stream})
}

type PredictionService_StreamingRawPredictServer interface {
	Send(*StreamingRawPredictResponse) error
	Recv() (*StreamingRawPredictRequest, error)
	grpc.ServerStream
}

type predictionServiceStreamingRawPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamingRawPredictServer) Send(m *StreamingRawPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *predictionServiceStreamingRawPredictServer) Recv() (*StreamingRawPredictRequest, error) {
	m := new(StreamingRawPredictRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _PredictionService_Explain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExplainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Explain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionService_Explain_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Explain(ctx, req.(*ExplainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_GenerateContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).GenerateContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionService_GenerateContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).GenerateContent(ctx, req.(*GenerateContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_StreamGenerateContent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GenerateContentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PredictionServiceServer).StreamGenerateContent(m, &predictionServiceStreamGenerateContentServer{stream})
}

type PredictionService_StreamGenerateContentServer interface {
	Send(*GenerateContentResponse) error
	grpc.ServerStream
}

type predictionServiceStreamGenerateContentServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamGenerateContentServer) Send(m *GenerateContentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _PredictionService_EmbedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EmbedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).EmbedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionService_EmbedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).EmbedContent(ctx, req.(*EmbedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PredictionService_ServiceDesc is the grpc.ServiceDesc for PredictionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PredictionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.PredictionService",
	HandlerType: (*PredictionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Predict",
			Handler:    _PredictionService_Predict_Handler,
		},
		{
			MethodName: "RawPredict",
			Handler:    _PredictionService_RawPredict_Handler,
		},
		{
			MethodName: "DirectPredict",
			Handler:    _PredictionService_DirectPredict_Handler,
		},
		{
			MethodName: "DirectRawPredict",
			Handler:    _PredictionService_DirectRawPredict_Handler,
		},
		{
			MethodName: "Explain",
			Handler:    _PredictionService_Explain_Handler,
		},
		{
			MethodName: "GenerateContent",
			Handler:    _PredictionService_GenerateContent_Handler,
		},
		{
			MethodName: "EmbedContent",
			Handler:    _PredictionService_EmbedContent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamRawPredict",
			Handler:       _PredictionService_StreamRawPredict_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamDirectPredict",
			Handler:       _PredictionService_StreamDirectPredict_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "StreamDirectRawPredict",
			Handler:       _PredictionService_StreamDirectRawPredict_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "StreamingPredict",
			Handler:       _PredictionService_StreamingPredict_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "ServerStreamingPredict",
			Handler:       _PredictionService_ServerStreamingPredict_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamingRawPredict",
			Handler:       _PredictionService_StreamingRawPredict_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "StreamGenerateContent",
			Handler:       _PredictionService_StreamGenerateContent_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/aiplatform/v1/prediction_service.proto",
}
