/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.http;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.net.PeerServiceResolver;
import io.opentelemetry.instrumentation.api.incubator.semconv.net.internal.UrlParser;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class HttpClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private final PeerServiceResolver peerServiceResolver;

    HttpClientPeerServiceAttributesExtractor(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, PeerServiceResolver peerServiceResolver) {
        this.attributesGetter = attributesGetter;
        this.peerServiceResolver = peerServiceResolver;
    }

    public static <REQUEST, RESPONSE> HttpClientPeerServiceAttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, PeerServiceResolver peerServiceResolver) {
        return new HttpClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>(attributesGetter, peerServiceResolver);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Supplier<String> pathSupplier;
        Integer serverPort;
        if (this.peerServiceResolver.isEmpty()) {
            return;
        }
        String serverAddress = this.attributesGetter.getServerAddress(request);
        String peerService = this.mapToPeerService(serverAddress, serverPort = this.attributesGetter.getServerPort(request), pathSupplier = () -> this.getUrlPath(this.attributesGetter, request));
        if (peerService != null) {
            attributes.put(SemanticAttributes.PEER_SERVICE, (Object)peerService);
        }
    }

    @Nullable
    private String mapToPeerService(@Nullable String host, @Nullable Integer port, @Nullable Supplier<String> pathSupplier) {
        if (host == null) {
            return null;
        }
        return this.peerServiceResolver.resolveService(host, port, pathSupplier);
    }

    @Nullable
    private String getUrlPath(HttpClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, REQUEST request) {
        String urlFull = attributesGetter.getUrlFull(request);
        if (urlFull == null) {
            return null;
        }
        return UrlParser.getPath(urlFull);
    }
}

