/*
 * Decompiled with CFR 0.152.
 */
package com.jgraph.layout.tree;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.tree.JGraphAbstractTreeLayout;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Iterator;

public class JGraphCompactTreeLayout
extends JGraphAbstractTreeLayout {
    public static final int LEFT_TO_RIGHT = 7;
    public static final int UP_TO_DOWN = 1;
    public static final int DEFAULT_ORIENTATION = 7;

    public JGraphCompactTreeLayout() {
        this.orientation = 7;
        this.levelDistance = 30.0;
        this.nodeDistance = 5.0;
    }

    public void run(JGraphFacade jGraphFacade) {
        super.run(jGraphFacade);
        for (int i = 0; i < jGraphFacade.getRootCount(); ++i) {
            this.nodes.clear();
            jGraphFacade.dfs(jGraphFacade.getRootAt(i), new JGraphFacade.CellVisitor(){

                public void visit(Object object, Object object2, Object object3, int n, int n2) {
                    CompactTreeNode compactTreeNode = JGraphCompactTreeLayout.this.getTreeLayoutNode(object);
                    CompactTreeNode compactTreeNode2 = JGraphCompactTreeLayout.this.getTreeLayoutNode(object2);
                    if (compactTreeNode != null) {
                        if (object3 == null) {
                            compactTreeNode.child = compactTreeNode2;
                        } else {
                            CompactTreeNode compactTreeNode3 = JGraphCompactTreeLayout.this.getTreeLayoutNode(object3);
                            compactTreeNode3.sibling = compactTreeNode2;
                        }
                    }
                }
            });
            this.layoutTree(this.getTreeLayoutNode(jGraphFacade.getRootAt(i)));
            this.dispatchResult(this.nodes.values());
        }
    }

    protected void layoutTree(CompactTreeNode compactTreeNode) {
        this.layout(compactTreeNode);
        Rectangle2D rectangle2D = this.graph.getBounds(compactTreeNode.getCell());
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        switch (this.orientation) {
            case 7: {
                this.leftRightNodeLayout(compactTreeNode, d, d2);
                break;
            }
            case 1: {
                this.upDownNodeLayout(compactTreeNode, null, d, d2);
                break;
            }
            default: {
                this.leftRightNodeLayout(compactTreeNode, d, d2);
            }
        }
    }

    protected CompactTreeNode getTreeLayoutNode(Object object) {
        if (object != null) {
            return this.getTreeLayoutNode(object, true);
        }
        return null;
    }

    protected CompactTreeNode getTreeLayoutNode(Object object, boolean bl) {
        CompactTreeNode compactTreeNode = (CompactTreeNode)this.nodes.get(object);
        if (compactTreeNode == null && bl) {
            compactTreeNode = new CompactTreeNode(object);
            this.nodes.put(object, compactTreeNode);
        }
        return compactTreeNode;
    }

    protected void dispatchResult(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            CompactTreeNode compactTreeNode = (CompactTreeNode)iterator.next();
            this.graph.setLocation(compactTreeNode.getCell(), compactTreeNode.x, compactTreeNode.y);
        }
    }

    protected void layout(CompactTreeNode compactTreeNode) {
        if (compactTreeNode == null) {
            return;
        }
        CompactTreeNode compactTreeNode2 = compactTreeNode.child;
        while (compactTreeNode2 != null) {
            this.layout(compactTreeNode2);
            compactTreeNode2 = compactTreeNode2.sibling;
        }
        if (compactTreeNode.child != null) {
            this.attachParent(compactTreeNode, this.join(compactTreeNode));
        } else {
            this.layoutLeaf(compactTreeNode);
        }
    }

    protected void attachParent(CompactTreeNode compactTreeNode, double d) {
        double d2 = this.nodeDistance + this.levelDistance;
        double d3 = (d - compactTreeNode.width) / 2.0 - this.nodeDistance;
        double d4 = d3 + compactTreeNode.width + 2.0 * this.nodeDistance - d;
        compactTreeNode.child.offsetX = d2 + compactTreeNode.height;
        compactTreeNode.child.offsetY = d4;
        compactTreeNode.contour.upperHead = new PolyLine(compactTreeNode.height, 0.0, new PolyLine(d2, d4, compactTreeNode.contour.upperHead));
        compactTreeNode.contour.lowerHead = new PolyLine(compactTreeNode.height, 0.0, new PolyLine(d2, d3, compactTreeNode.contour.lowerHead));
    }

    protected void layoutLeaf(CompactTreeNode compactTreeNode) {
        compactTreeNode.contour.upperHead = compactTreeNode.contour.upperTail = new PolyLine(compactTreeNode.height + 2.0 * this.nodeDistance, 0.0, null);
        compactTreeNode.contour.lowerTail = new PolyLine(0.0, -compactTreeNode.width - 2.0 * this.nodeDistance, null);
        compactTreeNode.contour.lowerHead = new PolyLine(compactTreeNode.height + 2.0 * this.nodeDistance, 0.0, compactTreeNode.contour.lowerTail);
    }

    protected double join(CompactTreeNode compactTreeNode) {
        double d;
        CompactTreeNode compactTreeNode2 = compactTreeNode.child;
        compactTreeNode.contour = compactTreeNode2.contour;
        double d2 = d = compactTreeNode2.width + 2.0 * this.nodeDistance;
        compactTreeNode2 = compactTreeNode2.sibling;
        while (compactTreeNode2 != null) {
            double d3 = this.merge(compactTreeNode.contour, compactTreeNode2.contour);
            compactTreeNode2.offsetY = d3 + d;
            compactTreeNode2.offsetX = 0.0;
            d = compactTreeNode2.width + 2.0 * this.nodeDistance;
            d2 += d3 + d;
            compactTreeNode2 = compactTreeNode2.sibling;
        }
        return d2;
    }

    protected double merge(Polygon polygon, Polygon polygon2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        PolyLine polyLine = polygon.lowerHead;
        PolyLine polyLine2 = polygon2.upperHead;
        while (polyLine2 != null && polyLine != null) {
            double d4 = this.offset(d3, d2, polyLine2.dx, polyLine2.dy, polyLine.dx, polyLine.dy);
            d2 += d4;
            d += d4;
            if (d3 + polyLine2.dx <= polyLine.dx) {
                d2 += polyLine2.dy;
                d3 += polyLine2.dx;
                polyLine2 = polyLine2.link;
                continue;
            }
            d2 -= polyLine.dy;
            d3 -= polyLine.dx;
            polyLine = polyLine.link;
        }
        if (polyLine2 != null) {
            PolyLine polyLine3 = this.bridge(polygon.upperTail, 0.0, 0.0, polyLine2, d3, d2);
            polygon.upperTail = polyLine3.link != null ? polygon2.upperTail : polyLine3;
            polygon.lowerTail = polygon2.lowerTail;
        } else {
            PolyLine polyLine4 = this.bridge(polygon2.lowerTail, d3, d2, polyLine, 0.0, 0.0);
            if (polyLine4.link == null) {
                polygon.lowerTail = polyLine4;
            }
        }
        polygon.lowerHead = polygon2.lowerHead;
        return d;
    }

    protected double offset(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        if (d5 <= d || d + d3 <= 0.0) {
            return 0.0;
        }
        double d8 = d5 * d4 - d3 * d6;
        if (d8 > 0.0) {
            if (d < 0.0) {
                double d9 = d * d4;
                d7 = d9 / d3 - d2;
            } else if (d > 0.0) {
                double d10 = d * d6;
                d7 = d10 / d5 - d2;
            } else {
                d7 = -d2;
            }
        } else if (d5 < d + d3) {
            double d11 = (d5 - d) * d4;
            d7 = d6 - (d2 + d11 / d3);
        } else if (d5 > d + d3) {
            double d12 = (d3 + d) * d6;
            d7 = d12 / d5 - (d2 + d4);
        } else {
            d7 = d6 - (d2 + d4);
        }
        if (d7 > 0.0) {
            return d7;
        }
        return 0.0;
    }

    protected PolyLine bridge(PolyLine polyLine, double d, double d2, PolyLine polyLine2, double d3, double d4) {
        double d5;
        double d6 = d3 + polyLine2.dx - d;
        if (polyLine2.dx == 0.0) {
            d5 = polyLine2.dy;
        } else {
            double d7 = d6 * polyLine2.dy;
            d5 = d7 / polyLine2.dx;
        }
        PolyLine polyLine3 = new PolyLine(d6, d5, polyLine2.link);
        polyLine.link = new PolyLine(0.0, d4 + polyLine2.dy - d5 - d2, polyLine3);
        return polyLine3;
    }

    protected void branch(CompactTreeNode compactTreeNode, CompactTreeNode compactTreeNode2, CompactTreeNode compactTreeNode3) {
        this.unzip(compactTreeNode);
        compactTreeNode2.parent = compactTreeNode;
        if (compactTreeNode3 != null) {
            compactTreeNode2.sibling = compactTreeNode3.sibling;
            compactTreeNode3.sibling = compactTreeNode2;
        } else {
            compactTreeNode2.sibling = compactTreeNode.child;
            compactTreeNode.child = compactTreeNode2;
        }
        this.zip(compactTreeNode);
    }

    protected void unzip(CompactTreeNode compactTreeNode) {
        if (compactTreeNode.parent != null) {
            this.unzip(compactTreeNode.parent);
        }
        if (compactTreeNode.child != null) {
            // empty if block
        }
    }

    protected void zip(CompactTreeNode compactTreeNode) {
        if (compactTreeNode.child != null) {
            this.attachParent(compactTreeNode, this.join(compactTreeNode));
        } else {
            this.layoutLeaf(compactTreeNode);
        }
        if (compactTreeNode.parent != null) {
            this.zip(compactTreeNode.parent);
        }
    }

    protected void leftRightNodeLayout(CompactTreeNode compactTreeNode, double d, double d2) {
        compactTreeNode.x += d + compactTreeNode.offsetX;
        compactTreeNode.y += d2 + compactTreeNode.offsetY;
        CompactTreeNode compactTreeNode2 = compactTreeNode.child;
        if (compactTreeNode2 != null) {
            this.leftRightNodeLayout(compactTreeNode2, compactTreeNode.x, compactTreeNode.y);
            CompactTreeNode compactTreeNode3 = compactTreeNode2.sibling;
            double d3 = compactTreeNode.y + compactTreeNode2.offsetY;
            while (compactTreeNode3 != null) {
                this.leftRightNodeLayout(compactTreeNode3, compactTreeNode.x + compactTreeNode2.offsetX, d3);
                d3 += compactTreeNode3.offsetY;
                compactTreeNode3 = compactTreeNode3.sibling;
            }
        }
    }

    protected void upDownNodeLayout(CompactTreeNode compactTreeNode, CompactTreeNode compactTreeNode2, double d, double d2) {
        compactTreeNode.x += d + compactTreeNode.offsetY;
        compactTreeNode.y += d2 + compactTreeNode.offsetX;
        CompactTreeNode compactTreeNode3 = compactTreeNode.child;
        if (compactTreeNode3 != null) {
            this.upDownNodeLayout(compactTreeNode3, compactTreeNode, compactTreeNode.x, compactTreeNode.y);
            CompactTreeNode compactTreeNode4 = compactTreeNode3.sibling;
            double d3 = compactTreeNode.x + compactTreeNode3.offsetY;
            while (compactTreeNode4 != null) {
                this.upDownNodeLayout(compactTreeNode4, compactTreeNode, d3, compactTreeNode.y + compactTreeNode3.offsetX);
                d3 += compactTreeNode4.offsetY;
                compactTreeNode4 = compactTreeNode4.sibling;
            }
        }
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 7) {
            throw new IllegalArgumentException("Orientation must be NORTH (1), or WEST (7)");
        }
        this.orientation = n;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setChildParentDistance(double d) {
        this.setLevelDistance(d);
    }

    public double getChildParentDistance() {
        return this.getLevelDistance();
    }

    public double getNodeBorder() {
        return this.nodeDistance;
    }

    public void setNodeBorder(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        this.nodeDistance = d;
    }

    public String toString() {
        return "Compact Tree";
    }

    private static class PolyLine {
        final double dx;
        final double dy;
        PolyLine link;

        PolyLine(double d, double d2, PolyLine polyLine) {
            this.dx = d;
            this.dy = d2;
            this.link = polyLine;
        }
    }

    private static class Polygon {
        PolyLine lowerHead;
        PolyLine lowerTail;
        PolyLine upperHead;
        PolyLine upperTail;

        private Polygon() {
        }
    }

    protected class CompactTreeNode
    extends JGraphAbstractTreeLayout.TreeNode {
        CompactTreeNode parent;
        CompactTreeNode child;
        CompactTreeNode sibling;
        protected double offsetX = 0.0;
        protected double offsetY = 0.0;
        Polygon contour = new Polygon();

        public CompactTreeNode(Object object) {
            super(object);
        }

        public Object getCell() {
            return this.cell;
        }
    }
}

