/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Arrays;
import java.util.Collections;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.Fields;

public class SelectionOperators {

    public static class Last
    extends AbstractAggregationExpression {
        protected Last(Object value) {
            super(value);
        }

        public static Last last() {
            return new Last(Collections.emptyMap());
        }

        public static Last last(int numberOfResults) {
            return Last.last().limit(numberOfResults);
        }

        public Last limit(int numberOfResults) {
            return this.limit((Object)numberOfResults);
        }

        public Last limit(AggregationExpression expression) {
            return this.limit((Object)expression);
        }

        private Last limit(Object value) {
            return new Last(this.append("n", value));
        }

        public Last of(String fieldName) {
            return this.input(fieldName);
        }

        public Last of(AggregationExpression expression) {
            return this.input(expression);
        }

        public Last input(String fieldName) {
            return new Last(this.append("input", Fields.field(fieldName)));
        }

        public Last input(AggregationExpression expression) {
            return new Last(this.append("input", expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$lastN";
        }
    }

    public static class First
    extends AbstractAggregationExpression {
        protected First(Object value) {
            super(value);
        }

        public static First first() {
            return new First(Collections.emptyMap());
        }

        public static First first(int numberOfResults) {
            return First.first().limit(numberOfResults);
        }

        public First limit(int numberOfResults) {
            return this.limit((Object)numberOfResults);
        }

        public First limit(AggregationExpression expression) {
            return this.limit((Object)expression);
        }

        private First limit(Object value) {
            return new First(this.append("n", value));
        }

        public First of(String fieldName) {
            return this.input(fieldName);
        }

        public First of(AggregationExpression expression) {
            return this.input(expression);
        }

        public First input(String fieldName) {
            return new First(this.append("input", Fields.field(fieldName)));
        }

        public First input(AggregationExpression expression) {
            return new First(this.append("input", expression));
        }

        @Override
        protected String getMongoMethod() {
            return "$firstN";
        }
    }

    public static class Top
    extends AbstractAggregationExpression {
        private Top(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return this.get("n") == null ? "$top" : "$topN";
        }

        public static Top top() {
            return new Top(Collections.emptyMap());
        }

        public static Top top(int numberOfResults) {
            return Top.top().limit(numberOfResults);
        }

        public Top limit(int numberOfResults) {
            return this.limit((Object)numberOfResults);
        }

        public Top limit(AggregationExpression expression) {
            return this.limit((Object)expression);
        }

        private Top limit(Object value) {
            return new Top(this.append("n", value));
        }

        public Top sortBy(Sort sort) {
            return new Top(this.append("sortBy", sort));
        }

        public Top output(Fields out) {
            return new Top(this.append("output", out));
        }

        public Top output(String ... fieldNames) {
            return this.output(Fields.fields(fieldNames));
        }

        public Top output(AggregationExpression ... out) {
            return new Top(this.append("output", Arrays.asList(out)));
        }
    }

    public static class Bottom
    extends AbstractAggregationExpression {
        private Bottom(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return this.get("n") == null ? "$bottom" : "$bottomN";
        }

        public static Bottom bottom() {
            return new Bottom(Collections.emptyMap());
        }

        public static Bottom bottom(int numberOfResults) {
            return Bottom.bottom().limit(numberOfResults);
        }

        public Bottom limit(int numberOfResults) {
            return this.limit((Object)numberOfResults);
        }

        public Bottom limit(AggregationExpression expression) {
            return this.limit((Object)expression);
        }

        private Bottom limit(Object value) {
            return new Bottom(this.append("n", value));
        }

        public Bottom sortBy(Sort sort) {
            return new Bottom(this.append("sortBy", sort));
        }

        public Bottom output(Fields out) {
            return new Bottom(this.append("output", out));
        }

        public Bottom output(String ... fieldNames) {
            return this.output(Fields.fields(fieldNames));
        }

        public Bottom output(AggregationExpression ... out) {
            return new Bottom(this.append("output", Arrays.asList(out)));
        }
    }
}

