// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ContainerScanRegistry Registry information for a container scan target
type ContainerScanRegistry interface {

	// URL of the registry.
	GetUrl() *string
}

type containerscanregistry struct {
	JsonData []byte
	Url      *string `mandatory:"true" json:"url"`
	Type     string  `json:"type"`
}

// UnmarshalJSON unmarshals json
func (m *containerscanregistry) UnmarshalJSON(data []byte) error {
	m.JsonData = data
	type Unmarshalercontainerscanregistry containerscanregistry
	s := struct {
		Model Unmarshalercontainerscanregistry
	}{}
	err := json.Unmarshal(data, &s.Model)
	if err != nil {
		return err
	}
	m.Url = s.Model.Url
	m.Type = s.Model.Type

	return err
}

// UnmarshalPolymorphicJSON unmarshals polymorphic json
func (m *containerscanregistry) UnmarshalPolymorphicJSON(data []byte) (interface{}, error) {

	if data == nil || string(data) == "null" {
		return nil, nil
	}

	var err error
	switch m.Type {
	case "OCIR":
		mm := OcirContainerScanRegistry{}
		err = json.Unmarshal(data, &mm)
		return mm, err
	default:
		common.Logf("Received unsupported enum value for ContainerScanRegistry: %s.", m.Type)
		return *m, nil
	}
}

// GetUrl returns Url
func (m containerscanregistry) GetUrl() *string {
	return m.Url
}

func (m containerscanregistry) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m containerscanregistry) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ContainerScanRegistryTypeEnum Enum with underlying type: string
type ContainerScanRegistryTypeEnum string

// Set of constants representing the allowable values for ContainerScanRegistryTypeEnum
const (
	ContainerScanRegistryTypeOcir ContainerScanRegistryTypeEnum = "OCIR"
)

var mappingContainerScanRegistryTypeEnum = map[string]ContainerScanRegistryTypeEnum{
	"OCIR": ContainerScanRegistryTypeOcir,
}

var mappingContainerScanRegistryTypeEnumLowerCase = map[string]ContainerScanRegistryTypeEnum{
	"ocir": ContainerScanRegistryTypeOcir,
}

// GetContainerScanRegistryTypeEnumValues Enumerates the set of values for ContainerScanRegistryTypeEnum
func GetContainerScanRegistryTypeEnumValues() []ContainerScanRegistryTypeEnum {
	values := make([]ContainerScanRegistryTypeEnum, 0)
	for _, v := range mappingContainerScanRegistryTypeEnum {
		values = append(values, v)
	}
	return values
}

// GetContainerScanRegistryTypeEnumStringValues Enumerates the set of values in String for ContainerScanRegistryTypeEnum
func GetContainerScanRegistryTypeEnumStringValues() []string {
	return []string{
		"OCIR",
	}
}

// GetMappingContainerScanRegistryTypeEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingContainerScanRegistryTypeEnum(val string) (ContainerScanRegistryTypeEnum, bool) {
	enum, ok := mappingContainerScanRegistryTypeEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
