// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package apiaccesscontrol

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListApiMetadataByEntityTypesRequest wrapper for the ListApiMetadataByEntityTypes operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/apiaccesscontrol/ListApiMetadataByEntityTypes.go.html to see an example of how to use ListApiMetadataByEntityTypesRequest.
type ListApiMetadataByEntityTypesRequest struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
	CompartmentId *string `mandatory:"false" contributesTo:"query" name:"compartmentId"`

	// A filter to return only resources that match the given lifecycle state. The
	// state value is case-insensitive.
	LifecycleState ApiMetadataLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter to return only lists of resources that match the entire given service type.
	ResourceType *string `mandatory:"false" contributesTo:"query" name:"resourceType"`

	// A filter to return only resources that match the given display name exactly.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// For list pagination. The maximum number of results per page, or items to return in a
	// paginated "List" call. For important details about how pagination works, see
	// List Pagination (https://docs.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// For list pagination. The value of the opc-next-page response header from the previous
	// "List" call. For important details about how pagination works, see
	// List Pagination (https://docs.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either ascending (`ASC`) or descending (`DESC`).
	SortOrder ListApiMetadataByEntityTypesSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. You can provide only one sort order. Default order for `timeCreated`
	// is descending. Default order for `displayName` is ascending.
	SortBy ListApiMetadataByEntityTypesSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	// The only valid characters for request IDs are letters, numbers,
	// underscore, and dash.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListApiMetadataByEntityTypesRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListApiMetadataByEntityTypesRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListApiMetadataByEntityTypesRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListApiMetadataByEntityTypesRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListApiMetadataByEntityTypesRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingApiMetadataLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetApiMetadataLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListApiMetadataByEntityTypesSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListApiMetadataByEntityTypesSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListApiMetadataByEntityTypesSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListApiMetadataByEntityTypesSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListApiMetadataByEntityTypesResponse wrapper for the ListApiMetadataByEntityTypes operation
type ListApiMetadataByEntityTypesResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of ApiMetadataByEntityTypeCollection instances
	ApiMetadataByEntityTypeCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For list pagination. When this header appears in the response, additional pages of results remain. For
	// important details about how pagination works, see List Pagination (https://docs.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine).
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListApiMetadataByEntityTypesResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListApiMetadataByEntityTypesResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListApiMetadataByEntityTypesSortOrderEnum Enum with underlying type: string
type ListApiMetadataByEntityTypesSortOrderEnum string

// Set of constants representing the allowable values for ListApiMetadataByEntityTypesSortOrderEnum
const (
	ListApiMetadataByEntityTypesSortOrderAsc  ListApiMetadataByEntityTypesSortOrderEnum = "ASC"
	ListApiMetadataByEntityTypesSortOrderDesc ListApiMetadataByEntityTypesSortOrderEnum = "DESC"
)

var mappingListApiMetadataByEntityTypesSortOrderEnum = map[string]ListApiMetadataByEntityTypesSortOrderEnum{
	"ASC":  ListApiMetadataByEntityTypesSortOrderAsc,
	"DESC": ListApiMetadataByEntityTypesSortOrderDesc,
}

var mappingListApiMetadataByEntityTypesSortOrderEnumLowerCase = map[string]ListApiMetadataByEntityTypesSortOrderEnum{
	"asc":  ListApiMetadataByEntityTypesSortOrderAsc,
	"desc": ListApiMetadataByEntityTypesSortOrderDesc,
}

// GetListApiMetadataByEntityTypesSortOrderEnumValues Enumerates the set of values for ListApiMetadataByEntityTypesSortOrderEnum
func GetListApiMetadataByEntityTypesSortOrderEnumValues() []ListApiMetadataByEntityTypesSortOrderEnum {
	values := make([]ListApiMetadataByEntityTypesSortOrderEnum, 0)
	for _, v := range mappingListApiMetadataByEntityTypesSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListApiMetadataByEntityTypesSortOrderEnumStringValues Enumerates the set of values in String for ListApiMetadataByEntityTypesSortOrderEnum
func GetListApiMetadataByEntityTypesSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListApiMetadataByEntityTypesSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListApiMetadataByEntityTypesSortOrderEnum(val string) (ListApiMetadataByEntityTypesSortOrderEnum, bool) {
	enum, ok := mappingListApiMetadataByEntityTypesSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListApiMetadataByEntityTypesSortByEnum Enum with underlying type: string
type ListApiMetadataByEntityTypesSortByEnum string

// Set of constants representing the allowable values for ListApiMetadataByEntityTypesSortByEnum
const (
	ListApiMetadataByEntityTypesSortByTimecreated ListApiMetadataByEntityTypesSortByEnum = "timeCreated"
	ListApiMetadataByEntityTypesSortByDisplayname ListApiMetadataByEntityTypesSortByEnum = "displayName"
)

var mappingListApiMetadataByEntityTypesSortByEnum = map[string]ListApiMetadataByEntityTypesSortByEnum{
	"timeCreated": ListApiMetadataByEntityTypesSortByTimecreated,
	"displayName": ListApiMetadataByEntityTypesSortByDisplayname,
}

var mappingListApiMetadataByEntityTypesSortByEnumLowerCase = map[string]ListApiMetadataByEntityTypesSortByEnum{
	"timecreated": ListApiMetadataByEntityTypesSortByTimecreated,
	"displayname": ListApiMetadataByEntityTypesSortByDisplayname,
}

// GetListApiMetadataByEntityTypesSortByEnumValues Enumerates the set of values for ListApiMetadataByEntityTypesSortByEnum
func GetListApiMetadataByEntityTypesSortByEnumValues() []ListApiMetadataByEntityTypesSortByEnum {
	values := make([]ListApiMetadataByEntityTypesSortByEnum, 0)
	for _, v := range mappingListApiMetadataByEntityTypesSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListApiMetadataByEntityTypesSortByEnumStringValues Enumerates the set of values in String for ListApiMetadataByEntityTypesSortByEnum
func GetListApiMetadataByEntityTypesSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
	}
}

// GetMappingListApiMetadataByEntityTypesSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListApiMetadataByEntityTypesSortByEnum(val string) (ListApiMetadataByEntityTypesSortByEnum, bool) {
	enum, ok := mappingListApiMetadataByEntityTypesSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
