// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/storage/v1beta1/storage.proto

package storagepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	BigQueryStorage_CreateReadSession_FullMethodName             = "/google.cloud.bigquery.storage.v1beta1.BigQueryStorage/CreateReadSession"
	BigQueryStorage_ReadRows_FullMethodName                      = "/google.cloud.bigquery.storage.v1beta1.BigQueryStorage/ReadRows"
	BigQueryStorage_BatchCreateReadSessionStreams_FullMethodName = "/google.cloud.bigquery.storage.v1beta1.BigQueryStorage/BatchCreateReadSessionStreams"
	BigQueryStorage_FinalizeStream_FullMethodName                = "/google.cloud.bigquery.storage.v1beta1.BigQueryStorage/FinalizeStream"
	BigQueryStorage_SplitReadStream_FullMethodName               = "/google.cloud.bigquery.storage.v1beta1.BigQueryStorage/SplitReadStream"
)

// BigQueryStorageClient is the client API for BigQueryStorage service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BigQueryStorageClient interface {
	// Creates a new read session. A read session divides the contents of a
	// BigQuery table into one or more streams, which can then be used to read
	// data from the table. The read session also specifies properties of the
	// data to be read, such as a list of columns or a push-down filter describing
	// the rows to be returned.
	//
	// A particular row can be read by at most one stream. When the caller has
	// reached the end of each stream in the session, then all the data in the
	// table has been read.
	//
	// Read sessions automatically expire 6 hours after they are created and do
	// not require manual clean-up by the caller.
	CreateReadSession(ctx context.Context, in *CreateReadSessionRequest, opts ...grpc.CallOption) (*ReadSession, error)
	// Reads rows from the table in the format prescribed by the read session.
	// Each response contains one or more table rows, up to a maximum of 10 MiB
	// per response; read requests which attempt to read individual rows larger
	// than this will fail.
	//
	// Each request also returns a set of stream statistics reflecting the
	// estimated total number of rows in the read stream. This number is computed
	// based on the total table size and the number of active streams in the read
	// session, and may change as other streams continue to read data.
	ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigQueryStorage_ReadRowsClient, error)
	// Creates additional streams for a ReadSession. This API can be used to
	// dynamically adjust the parallelism of a batch processing task upwards by
	// adding additional workers.
	BatchCreateReadSessionStreams(ctx context.Context, in *BatchCreateReadSessionStreamsRequest, opts ...grpc.CallOption) (*BatchCreateReadSessionStreamsResponse, error)
	// Causes a single stream in a ReadSession to gracefully stop. This
	// API can be used to dynamically adjust the parallelism of a batch processing
	// task downwards without losing data.
	//
	// This API does not delete the stream -- it remains visible in the
	// ReadSession, and any data processed by the stream is not released to other
	// streams. However, no additional data will be assigned to the stream once
	// this call completes. Callers must continue reading data on the stream until
	// the end of the stream is reached so that data which has already been
	// assigned to the stream will be processed.
	//
	// This method will return an error if there are no other live streams
	// in the Session, or if SplitReadStream() has been called on the given
	// Stream.
	FinalizeStream(ctx context.Context, in *FinalizeStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Splits a given read stream into two Streams. These streams are referred to
	// as the primary and the residual of the split. The original stream can still
	// be read from in the same manner as before. Both of the returned streams can
	// also be read from, and the total rows return by both child streams will be
	// the same as the rows read from the original stream.
	//
	// Moreover, the two child streams will be allocated back to back in the
	// original Stream. Concretely, it is guaranteed that for streams Original,
	// Primary, and Residual, that Original[0-j] = Primary[0-j] and
	// Original[j-n] = Residual[0-m] once the streams have been read to
	// completion.
	//
	// This method is guaranteed to be idempotent.
	SplitReadStream(ctx context.Context, in *SplitReadStreamRequest, opts ...grpc.CallOption) (*SplitReadStreamResponse, error)
}

type bigQueryStorageClient struct {
	cc grpc.ClientConnInterface
}

func NewBigQueryStorageClient(cc grpc.ClientConnInterface) BigQueryStorageClient {
	return &bigQueryStorageClient{cc}
}

func (c *bigQueryStorageClient) CreateReadSession(ctx context.Context, in *CreateReadSessionRequest, opts ...grpc.CallOption) (*ReadSession, error) {
	out := new(ReadSession)
	err := c.cc.Invoke(ctx, BigQueryStorage_CreateReadSession_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryStorageClient) ReadRows(ctx context.Context, in *ReadRowsRequest, opts ...grpc.CallOption) (BigQueryStorage_ReadRowsClient, error) {
	stream, err := c.cc.NewStream(ctx, &BigQueryStorage_ServiceDesc.Streams[0], BigQueryStorage_ReadRows_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &bigQueryStorageReadRowsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type BigQueryStorage_ReadRowsClient interface {
	Recv() (*ReadRowsResponse, error)
	grpc.ClientStream
}

type bigQueryStorageReadRowsClient struct {
	grpc.ClientStream
}

func (x *bigQueryStorageReadRowsClient) Recv() (*ReadRowsResponse, error) {
	m := new(ReadRowsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *bigQueryStorageClient) BatchCreateReadSessionStreams(ctx context.Context, in *BatchCreateReadSessionStreamsRequest, opts ...grpc.CallOption) (*BatchCreateReadSessionStreamsResponse, error) {
	out := new(BatchCreateReadSessionStreamsResponse)
	err := c.cc.Invoke(ctx, BigQueryStorage_BatchCreateReadSessionStreams_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryStorageClient) FinalizeStream(ctx context.Context, in *FinalizeStreamRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, BigQueryStorage_FinalizeStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigQueryStorageClient) SplitReadStream(ctx context.Context, in *SplitReadStreamRequest, opts ...grpc.CallOption) (*SplitReadStreamResponse, error) {
	out := new(SplitReadStreamResponse)
	err := c.cc.Invoke(ctx, BigQueryStorage_SplitReadStream_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigQueryStorageServer is the server API for BigQueryStorage service.
// All implementations should embed UnimplementedBigQueryStorageServer
// for forward compatibility
type BigQueryStorageServer interface {
	// Creates a new read session. A read session divides the contents of a
	// BigQuery table into one or more streams, which can then be used to read
	// data from the table. The read session also specifies properties of the
	// data to be read, such as a list of columns or a push-down filter describing
	// the rows to be returned.
	//
	// A particular row can be read by at most one stream. When the caller has
	// reached the end of each stream in the session, then all the data in the
	// table has been read.
	//
	// Read sessions automatically expire 6 hours after they are created and do
	// not require manual clean-up by the caller.
	CreateReadSession(context.Context, *CreateReadSessionRequest) (*ReadSession, error)
	// Reads rows from the table in the format prescribed by the read session.
	// Each response contains one or more table rows, up to a maximum of 10 MiB
	// per response; read requests which attempt to read individual rows larger
	// than this will fail.
	//
	// Each request also returns a set of stream statistics reflecting the
	// estimated total number of rows in the read stream. This number is computed
	// based on the total table size and the number of active streams in the read
	// session, and may change as other streams continue to read data.
	ReadRows(*ReadRowsRequest, BigQueryStorage_ReadRowsServer) error
	// Creates additional streams for a ReadSession. This API can be used to
	// dynamically adjust the parallelism of a batch processing task upwards by
	// adding additional workers.
	BatchCreateReadSessionStreams(context.Context, *BatchCreateReadSessionStreamsRequest) (*BatchCreateReadSessionStreamsResponse, error)
	// Causes a single stream in a ReadSession to gracefully stop. This
	// API can be used to dynamically adjust the parallelism of a batch processing
	// task downwards without losing data.
	//
	// This API does not delete the stream -- it remains visible in the
	// ReadSession, and any data processed by the stream is not released to other
	// streams. However, no additional data will be assigned to the stream once
	// this call completes. Callers must continue reading data on the stream until
	// the end of the stream is reached so that data which has already been
	// assigned to the stream will be processed.
	//
	// This method will return an error if there are no other live streams
	// in the Session, or if SplitReadStream() has been called on the given
	// Stream.
	FinalizeStream(context.Context, *FinalizeStreamRequest) (*emptypb.Empty, error)
	// Splits a given read stream into two Streams. These streams are referred to
	// as the primary and the residual of the split. The original stream can still
	// be read from in the same manner as before. Both of the returned streams can
	// also be read from, and the total rows return by both child streams will be
	// the same as the rows read from the original stream.
	//
	// Moreover, the two child streams will be allocated back to back in the
	// original Stream. Concretely, it is guaranteed that for streams Original,
	// Primary, and Residual, that Original[0-j] = Primary[0-j] and
	// Original[j-n] = Residual[0-m] once the streams have been read to
	// completion.
	//
	// This method is guaranteed to be idempotent.
	SplitReadStream(context.Context, *SplitReadStreamRequest) (*SplitReadStreamResponse, error)
}

// UnimplementedBigQueryStorageServer should be embedded to have forward compatible implementations.
type UnimplementedBigQueryStorageServer struct {
}

func (UnimplementedBigQueryStorageServer) CreateReadSession(context.Context, *CreateReadSessionRequest) (*ReadSession, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReadSession not implemented")
}
func (UnimplementedBigQueryStorageServer) ReadRows(*ReadRowsRequest, BigQueryStorage_ReadRowsServer) error {
	return status.Errorf(codes.Unimplemented, "method ReadRows not implemented")
}
func (UnimplementedBigQueryStorageServer) BatchCreateReadSessionStreams(context.Context, *BatchCreateReadSessionStreamsRequest) (*BatchCreateReadSessionStreamsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchCreateReadSessionStreams not implemented")
}
func (UnimplementedBigQueryStorageServer) FinalizeStream(context.Context, *FinalizeStreamRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeStream not implemented")
}
func (UnimplementedBigQueryStorageServer) SplitReadStream(context.Context, *SplitReadStreamRequest) (*SplitReadStreamResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SplitReadStream not implemented")
}

// UnsafeBigQueryStorageServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BigQueryStorageServer will
// result in compilation errors.
type UnsafeBigQueryStorageServer interface {
	mustEmbedUnimplementedBigQueryStorageServer()
}

func RegisterBigQueryStorageServer(s grpc.ServiceRegistrar, srv BigQueryStorageServer) {
	s.RegisterService(&BigQueryStorage_ServiceDesc, srv)
}

func _BigQueryStorage_CreateReadSession_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReadSessionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryStorageServer).CreateReadSession(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryStorage_CreateReadSession_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryStorageServer).CreateReadSession(ctx, req.(*CreateReadSessionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryStorage_ReadRows_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReadRowsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BigQueryStorageServer).ReadRows(m, &bigQueryStorageReadRowsServer{stream})
}

type BigQueryStorage_ReadRowsServer interface {
	Send(*ReadRowsResponse) error
	grpc.ServerStream
}

type bigQueryStorageReadRowsServer struct {
	grpc.ServerStream
}

func (x *bigQueryStorageReadRowsServer) Send(m *ReadRowsResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _BigQueryStorage_BatchCreateReadSessionStreams_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateReadSessionStreamsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryStorageServer).BatchCreateReadSessionStreams(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryStorage_BatchCreateReadSessionStreams_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryStorageServer).BatchCreateReadSessionStreams(ctx, req.(*BatchCreateReadSessionStreamsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryStorage_FinalizeStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryStorageServer).FinalizeStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryStorage_FinalizeStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryStorageServer).FinalizeStream(ctx, req.(*FinalizeStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigQueryStorage_SplitReadStream_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitReadStreamRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigQueryStorageServer).SplitReadStream(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BigQueryStorage_SplitReadStream_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigQueryStorageServer).SplitReadStream(ctx, req.(*SplitReadStreamRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BigQueryStorage_ServiceDesc is the grpc.ServiceDesc for BigQueryStorage service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BigQueryStorage_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.storage.v1beta1.BigQueryStorage",
	HandlerType: (*BigQueryStorageServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReadSession",
			Handler:    _BigQueryStorage_CreateReadSession_Handler,
		},
		{
			MethodName: "BatchCreateReadSessionStreams",
			Handler:    _BigQueryStorage_BatchCreateReadSessionStreams_Handler,
		},
		{
			MethodName: "FinalizeStream",
			Handler:    _BigQueryStorage_FinalizeStream_Handler,
		},
		{
			MethodName: "SplitReadStream",
			Handler:    _BigQueryStorage_SplitReadStream_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReadRows",
			Handler:       _BigQueryStorage_ReadRows_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/bigquery/storage/v1beta1/storage.proto",
}
