// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/migration/v2alpha/migration_service.proto

package migrationpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MigrationService_CreateMigrationWorkflow_FullMethodName = "/google.cloud.bigquery.migration.v2alpha.MigrationService/CreateMigrationWorkflow"
	MigrationService_GetMigrationWorkflow_FullMethodName    = "/google.cloud.bigquery.migration.v2alpha.MigrationService/GetMigrationWorkflow"
	MigrationService_ListMigrationWorkflows_FullMethodName  = "/google.cloud.bigquery.migration.v2alpha.MigrationService/ListMigrationWorkflows"
	MigrationService_DeleteMigrationWorkflow_FullMethodName = "/google.cloud.bigquery.migration.v2alpha.MigrationService/DeleteMigrationWorkflow"
	MigrationService_StartMigrationWorkflow_FullMethodName  = "/google.cloud.bigquery.migration.v2alpha.MigrationService/StartMigrationWorkflow"
	MigrationService_GetMigrationSubtask_FullMethodName     = "/google.cloud.bigquery.migration.v2alpha.MigrationService/GetMigrationSubtask"
	MigrationService_ListMigrationSubtasks_FullMethodName   = "/google.cloud.bigquery.migration.v2alpha.MigrationService/ListMigrationSubtasks"
)

// MigrationServiceClient is the client API for MigrationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MigrationServiceClient interface {
	// Creates a migration workflow.
	CreateMigrationWorkflow(ctx context.Context, in *CreateMigrationWorkflowRequest, opts ...grpc.CallOption) (*MigrationWorkflow, error)
	// Gets a previously created migration workflow.
	GetMigrationWorkflow(ctx context.Context, in *GetMigrationWorkflowRequest, opts ...grpc.CallOption) (*MigrationWorkflow, error)
	// Lists previously created migration workflow.
	ListMigrationWorkflows(ctx context.Context, in *ListMigrationWorkflowsRequest, opts ...grpc.CallOption) (*ListMigrationWorkflowsResponse, error)
	// Deletes a migration workflow by name.
	DeleteMigrationWorkflow(ctx context.Context, in *DeleteMigrationWorkflowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Starts a previously created migration workflow. I.e., the state transitions
	// from DRAFT to RUNNING. This is a no-op if the state is already RUNNING.
	// An error will be signaled if the state is anything other than DRAFT or
	// RUNNING.
	StartMigrationWorkflow(ctx context.Context, in *StartMigrationWorkflowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a previously created migration subtask.
	GetMigrationSubtask(ctx context.Context, in *GetMigrationSubtaskRequest, opts ...grpc.CallOption) (*MigrationSubtask, error)
	// Lists previously created migration subtasks.
	ListMigrationSubtasks(ctx context.Context, in *ListMigrationSubtasksRequest, opts ...grpc.CallOption) (*ListMigrationSubtasksResponse, error)
}

type migrationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewMigrationServiceClient(cc grpc.ClientConnInterface) MigrationServiceClient {
	return &migrationServiceClient{cc}
}

func (c *migrationServiceClient) CreateMigrationWorkflow(ctx context.Context, in *CreateMigrationWorkflowRequest, opts ...grpc.CallOption) (*MigrationWorkflow, error) {
	out := new(MigrationWorkflow)
	err := c.cc.Invoke(ctx, MigrationService_CreateMigrationWorkflow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationServiceClient) GetMigrationWorkflow(ctx context.Context, in *GetMigrationWorkflowRequest, opts ...grpc.CallOption) (*MigrationWorkflow, error) {
	out := new(MigrationWorkflow)
	err := c.cc.Invoke(ctx, MigrationService_GetMigrationWorkflow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationServiceClient) ListMigrationWorkflows(ctx context.Context, in *ListMigrationWorkflowsRequest, opts ...grpc.CallOption) (*ListMigrationWorkflowsResponse, error) {
	out := new(ListMigrationWorkflowsResponse)
	err := c.cc.Invoke(ctx, MigrationService_ListMigrationWorkflows_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationServiceClient) DeleteMigrationWorkflow(ctx context.Context, in *DeleteMigrationWorkflowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, MigrationService_DeleteMigrationWorkflow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationServiceClient) StartMigrationWorkflow(ctx context.Context, in *StartMigrationWorkflowRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, MigrationService_StartMigrationWorkflow_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationServiceClient) GetMigrationSubtask(ctx context.Context, in *GetMigrationSubtaskRequest, opts ...grpc.CallOption) (*MigrationSubtask, error) {
	out := new(MigrationSubtask)
	err := c.cc.Invoke(ctx, MigrationService_GetMigrationSubtask_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *migrationServiceClient) ListMigrationSubtasks(ctx context.Context, in *ListMigrationSubtasksRequest, opts ...grpc.CallOption) (*ListMigrationSubtasksResponse, error) {
	out := new(ListMigrationSubtasksResponse)
	err := c.cc.Invoke(ctx, MigrationService_ListMigrationSubtasks_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MigrationServiceServer is the server API for MigrationService service.
// All implementations should embed UnimplementedMigrationServiceServer
// for forward compatibility
type MigrationServiceServer interface {
	// Creates a migration workflow.
	CreateMigrationWorkflow(context.Context, *CreateMigrationWorkflowRequest) (*MigrationWorkflow, error)
	// Gets a previously created migration workflow.
	GetMigrationWorkflow(context.Context, *GetMigrationWorkflowRequest) (*MigrationWorkflow, error)
	// Lists previously created migration workflow.
	ListMigrationWorkflows(context.Context, *ListMigrationWorkflowsRequest) (*ListMigrationWorkflowsResponse, error)
	// Deletes a migration workflow by name.
	DeleteMigrationWorkflow(context.Context, *DeleteMigrationWorkflowRequest) (*emptypb.Empty, error)
	// Starts a previously created migration workflow. I.e., the state transitions
	// from DRAFT to RUNNING. This is a no-op if the state is already RUNNING.
	// An error will be signaled if the state is anything other than DRAFT or
	// RUNNING.
	StartMigrationWorkflow(context.Context, *StartMigrationWorkflowRequest) (*emptypb.Empty, error)
	// Gets a previously created migration subtask.
	GetMigrationSubtask(context.Context, *GetMigrationSubtaskRequest) (*MigrationSubtask, error)
	// Lists previously created migration subtasks.
	ListMigrationSubtasks(context.Context, *ListMigrationSubtasksRequest) (*ListMigrationSubtasksResponse, error)
}

// UnimplementedMigrationServiceServer should be embedded to have forward compatible implementations.
type UnimplementedMigrationServiceServer struct {
}

func (UnimplementedMigrationServiceServer) CreateMigrationWorkflow(context.Context, *CreateMigrationWorkflowRequest) (*MigrationWorkflow, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMigrationWorkflow not implemented")
}
func (UnimplementedMigrationServiceServer) GetMigrationWorkflow(context.Context, *GetMigrationWorkflowRequest) (*MigrationWorkflow, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMigrationWorkflow not implemented")
}
func (UnimplementedMigrationServiceServer) ListMigrationWorkflows(context.Context, *ListMigrationWorkflowsRequest) (*ListMigrationWorkflowsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMigrationWorkflows not implemented")
}
func (UnimplementedMigrationServiceServer) DeleteMigrationWorkflow(context.Context, *DeleteMigrationWorkflowRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMigrationWorkflow not implemented")
}
func (UnimplementedMigrationServiceServer) StartMigrationWorkflow(context.Context, *StartMigrationWorkflowRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartMigrationWorkflow not implemented")
}
func (UnimplementedMigrationServiceServer) GetMigrationSubtask(context.Context, *GetMigrationSubtaskRequest) (*MigrationSubtask, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMigrationSubtask not implemented")
}
func (UnimplementedMigrationServiceServer) ListMigrationSubtasks(context.Context, *ListMigrationSubtasksRequest) (*ListMigrationSubtasksResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMigrationSubtasks not implemented")
}

// UnsafeMigrationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MigrationServiceServer will
// result in compilation errors.
type UnsafeMigrationServiceServer interface {
	mustEmbedUnimplementedMigrationServiceServer()
}

func RegisterMigrationServiceServer(s grpc.ServiceRegistrar, srv MigrationServiceServer) {
	s.RegisterService(&MigrationService_ServiceDesc, srv)
}

func _MigrationService_CreateMigrationWorkflow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMigrationWorkflowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationServiceServer).CreateMigrationWorkflow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MigrationService_CreateMigrationWorkflow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationServiceServer).CreateMigrationWorkflow(ctx, req.(*CreateMigrationWorkflowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationService_GetMigrationWorkflow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMigrationWorkflowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationServiceServer).GetMigrationWorkflow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MigrationService_GetMigrationWorkflow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationServiceServer).GetMigrationWorkflow(ctx, req.(*GetMigrationWorkflowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationService_ListMigrationWorkflows_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMigrationWorkflowsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationServiceServer).ListMigrationWorkflows(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MigrationService_ListMigrationWorkflows_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationServiceServer).ListMigrationWorkflows(ctx, req.(*ListMigrationWorkflowsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationService_DeleteMigrationWorkflow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMigrationWorkflowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationServiceServer).DeleteMigrationWorkflow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MigrationService_DeleteMigrationWorkflow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationServiceServer).DeleteMigrationWorkflow(ctx, req.(*DeleteMigrationWorkflowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationService_StartMigrationWorkflow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartMigrationWorkflowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationServiceServer).StartMigrationWorkflow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MigrationService_StartMigrationWorkflow_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationServiceServer).StartMigrationWorkflow(ctx, req.(*StartMigrationWorkflowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationService_GetMigrationSubtask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMigrationSubtaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationServiceServer).GetMigrationSubtask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MigrationService_GetMigrationSubtask_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationServiceServer).GetMigrationSubtask(ctx, req.(*GetMigrationSubtaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MigrationService_ListMigrationSubtasks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMigrationSubtasksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MigrationServiceServer).ListMigrationSubtasks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MigrationService_ListMigrationSubtasks_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MigrationServiceServer).ListMigrationSubtasks(ctx, req.(*ListMigrationSubtasksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MigrationService_ServiceDesc is the grpc.ServiceDesc for MigrationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MigrationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.migration.v2alpha.MigrationService",
	HandlerType: (*MigrationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMigrationWorkflow",
			Handler:    _MigrationService_CreateMigrationWorkflow_Handler,
		},
		{
			MethodName: "GetMigrationWorkflow",
			Handler:    _MigrationService_GetMigrationWorkflow_Handler,
		},
		{
			MethodName: "ListMigrationWorkflows",
			Handler:    _MigrationService_ListMigrationWorkflows_Handler,
		},
		{
			MethodName: "DeleteMigrationWorkflow",
			Handler:    _MigrationService_DeleteMigrationWorkflow_Handler,
		},
		{
			MethodName: "StartMigrationWorkflow",
			Handler:    _MigrationService_StartMigrationWorkflow_Handler,
		},
		{
			MethodName: "GetMigrationSubtask",
			Handler:    _MigrationService_GetMigrationSubtask_Handler,
		},
		{
			MethodName: "ListMigrationSubtasks",
			Handler:    _MigrationService_ListMigrationSubtasks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/migration/v2alpha/migration_service.proto",
}
