/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.app.data.project;

import com.dtolabs.rundeck.core.authorization.AuthContext;
import com.dtolabs.rundeck.core.authorization.AuthContextProcessor;
import com.dtolabs.rundeck.core.authorization.AuthorizationUtil;
import com.dtolabs.rundeck.core.authorization.UserAndRolesAuthContext;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.rundeck.app.components.jobs.ComponentMeta;
import org.rundeck.app.components.project.ProjectMetadataComponent;
import org.rundeck.app.data.project.ProjectAuthorizationMetadataComponent;
import org.rundeck.core.auth.AuthConstants;
import org.springframework.beans.factory.annotation.Autowired;

public class ProjectAuthorizationMetadataComponent
implements ProjectMetadataComponent,
GroovyObject {
    public static final String NAME = "authz";
    public static final Map<String, List<String>> PROJ_TYPES_AUTH_CHECK_SET;
    public static final List<String> PROJ_AUTH_CHECK_ACTIONS;
    @Autowired
    private AuthContextProcessor rundeckAuthContextProcessor;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ProjectAuthorizationMetadataComponent() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Set<String> getAvailableMetadataNames() {
        return DefaultGroovyMethods.toSet((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{NAME}));
    }

    public Optional<List<ComponentMeta>> getMetadataForProject(String project, Set<String> names, UserAndRolesAuthContext authContext) {
        if (!names.contains(NAME) && !names.contains("*")) {
            return Optional.empty();
        }
        HashMap result = new HashMap();
        result.putAll(this.getTypeAuthzMeta(project, authContext));
        result.putAll(this.getProjAuthzMeta(project, authContext, PROJ_AUTH_CHECK_ACTIONS));
        return Optional.of(ScriptBytecodeAdapter.createList((Object[])new Object[]{ComponentMeta.with((String)NAME, result)}));
    }

    public Map<String, Object> getProjAuthzMeta(String project, UserAndRolesAuthContext authContext, List<String> actions) {
        Map results = this.getAuthSystemResults(actions, project, authContext);
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"project", results});
    }

    public Map<String, Object> getTypeAuthzMeta(String project, UserAndRolesAuthContext authContext) {
        LinkedHashMap typeAuthz = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        Set set = PROJ_TYPES_AUTH_CHECK_SET.keySet();
        Iterator iterator = set != null ? set.iterator() : null;
        String type = null;
        Iterator iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                type = ShortTypeHandling.castToString(iterator2.next());
                Map resource = AuthorizationUtil.resourceType((String)type);
                Map map = this.getAuthProjectResults(resource, (List)ScriptBytecodeAdapter.castToType(PROJ_TYPES_AUTH_CHECK_SET.get(type), List.class), project, authContext);
                ScriptBytecodeAdapter.invokeMethodN(ProjectAuthorizationMetadataComponent.class, (Object)typeAuthz, (String)"putAt", (Object[])new Object[]{type, map});
            }
        }
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"types", typeAuthz});
    }

    public Map<String, Object> getAuthProjectResults(Map<String, String> authResource, List<String> actions, String project, UserAndRolesAuthContext authContext) {
        Set authz = this.rundeckAuthContextProcessor.authorizeProjectResources((AuthContext)authContext, DefaultGroovyMethods.toSet((Collection)ScriptBytecodeAdapter.createList((Object[])new Object[]{authResource})), DefaultGroovyMethods.toSet(actions), project);
        return DefaultGroovyMethods.collectEntries((Iterable)authz, (Closure)new _getAuthProjectResults_closure1((Object)this, (Object)this));
    }

    public Map<String, Object> getAuthSystemResults(List<String> actions, String project, UserAndRolesAuthContext authContext) {
        LinkedHashMap result = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        Map authResource = this.rundeckAuthContextProcessor.authResourceForProject(project);
        List<String> list = actions;
        Iterator<String> iterator = list != null ? list.iterator() : null;
        String action = null;
        Iterator<String> iterator2 = iterator;
        if (iterator2 != null) {
            while (iterator2.hasNext()) {
                action = ShortTypeHandling.castToString((Object)iterator2.next());
                boolean bl = this.rundeckAuthContextProcessor.authorizeApplicationResource((AuthContext)authContext, authResource, action);
                ScriptBytecodeAdapter.invokeMethodN(ProjectAuthorizationMetadataComponent.class, (Object)result, (String)"putAt", (Object[])new Object[]{action, bl});
            }
        }
        return result;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProjectAuthorizationMetadataComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        List list;
        Map map;
        PROJ_TYPES_AUTH_CHECK_SET = map = Collections.unmodifiableMap(ScriptBytecodeAdapter.createMap((Object[])new Object[]{AuthConstants.TYPE_JOB, ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthConstants.ACTION_CREATE, AuthConstants.ACTION_DELETE}), AuthConstants.TYPE_EVENT, ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthConstants.ACTION_READ})}));
        PROJ_AUTH_CHECK_ACTIONS = list = Collections.unmodifiableList(ScriptBytecodeAdapter.createList((Object[])new Object[]{AuthConstants.ACTION_CONFIGURE, AuthConstants.ACTION_ADMIN, AuthConstants.ACTION_APP_ADMIN, AuthConstants.ACTION_EXPORT, AuthConstants.ACTION_SCM_EXPORT, AuthConstants.ACTION_IMPORT, AuthConstants.ACTION_SCM_IMPORT}));
    }

    @Generated
    public AuthContextProcessor getRundeckAuthContextProcessor() {
        return this.rundeckAuthContextProcessor;
    }

    @Generated
    public void setRundeckAuthContextProcessor(AuthContextProcessor authContextProcessor) {
        this.rundeckAuthContextProcessor = authContextProcessor;
    }
}

