// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by aliasgen. DO NOT EDIT.

// Package admin aliases all exported identifiers in package
// "cloud.google.com/go/bigtable/admin/apiv2/adminpb".
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb.
// Please read https://github.com/googleapis/google-cloud-go/blob/main/migration.md
// for more details.
package admin

import (
	src "cloud.google.com/go/bigtable/admin/apiv2/adminpb"
	grpc "google.golang.org/grpc"
)

// Deprecated: Please use consts in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
const (
	AppProfile_DataBoostIsolationReadOnly_COMPUTE_BILLING_OWNER_UNSPECIFIED = src.AppProfile_DataBoostIsolationReadOnly_COMPUTE_BILLING_OWNER_UNSPECIFIED
	AppProfile_DataBoostIsolationReadOnly_HOST_PAYS                         = src.AppProfile_DataBoostIsolationReadOnly_HOST_PAYS
	AppProfile_PRIORITY_HIGH                                                = src.AppProfile_PRIORITY_HIGH
	AppProfile_PRIORITY_LOW                                                 = src.AppProfile_PRIORITY_LOW
	AppProfile_PRIORITY_MEDIUM                                              = src.AppProfile_PRIORITY_MEDIUM
	AppProfile_PRIORITY_UNSPECIFIED                                         = src.AppProfile_PRIORITY_UNSPECIFIED
	AuthorizedView_BASIC                                                    = src.AuthorizedView_BASIC
	AuthorizedView_FULL                                                     = src.AuthorizedView_FULL
	AuthorizedView_NAME_ONLY                                                = src.AuthorizedView_NAME_ONLY
	AuthorizedView_RESPONSE_VIEW_UNSPECIFIED                                = src.AuthorizedView_RESPONSE_VIEW_UNSPECIFIED
	Backup_CREATING                                                         = src.Backup_CREATING
	Backup_READY                                                            = src.Backup_READY
	Backup_STATE_UNSPECIFIED                                                = src.Backup_STATE_UNSPECIFIED
	Cluster_CREATING                                                        = src.Cluster_CREATING
	Cluster_DISABLED                                                        = src.Cluster_DISABLED
	Cluster_READY                                                           = src.Cluster_READY
	Cluster_RESIZING                                                        = src.Cluster_RESIZING
	Cluster_STATE_NOT_KNOWN                                                 = src.Cluster_STATE_NOT_KNOWN
	CreateClusterMetadata_TableProgress_CANCELLED                           = src.CreateClusterMetadata_TableProgress_CANCELLED
	CreateClusterMetadata_TableProgress_COMPLETED                           = src.CreateClusterMetadata_TableProgress_COMPLETED
	CreateClusterMetadata_TableProgress_COPYING                             = src.CreateClusterMetadata_TableProgress_COPYING
	CreateClusterMetadata_TableProgress_PENDING                             = src.CreateClusterMetadata_TableProgress_PENDING
	CreateClusterMetadata_TableProgress_STATE_UNSPECIFIED                   = src.CreateClusterMetadata_TableProgress_STATE_UNSPECIFIED
	EncryptionInfo_CUSTOMER_MANAGED_ENCRYPTION                              = src.EncryptionInfo_CUSTOMER_MANAGED_ENCRYPTION
	EncryptionInfo_ENCRYPTION_TYPE_UNSPECIFIED                              = src.EncryptionInfo_ENCRYPTION_TYPE_UNSPECIFIED
	EncryptionInfo_GOOGLE_DEFAULT_ENCRYPTION                                = src.EncryptionInfo_GOOGLE_DEFAULT_ENCRYPTION
	Instance_CREATING                                                       = src.Instance_CREATING
	Instance_DEVELOPMENT                                                    = src.Instance_DEVELOPMENT
	Instance_PRODUCTION                                                     = src.Instance_PRODUCTION
	Instance_READY                                                          = src.Instance_READY
	Instance_STATE_NOT_KNOWN                                                = src.Instance_STATE_NOT_KNOWN
	Instance_TYPE_UNSPECIFIED                                               = src.Instance_TYPE_UNSPECIFIED
	RestoreSourceType_BACKUP                                                = src.RestoreSourceType_BACKUP
	RestoreSourceType_RESTORE_SOURCE_TYPE_UNSPECIFIED                       = src.RestoreSourceType_RESTORE_SOURCE_TYPE_UNSPECIFIED
	Snapshot_CREATING                                                       = src.Snapshot_CREATING
	Snapshot_READY                                                          = src.Snapshot_READY
	Snapshot_STATE_NOT_KNOWN                                                = src.Snapshot_STATE_NOT_KNOWN
	StorageType_HDD                                                         = src.StorageType_HDD
	StorageType_SSD                                                         = src.StorageType_SSD
	StorageType_STORAGE_TYPE_UNSPECIFIED                                    = src.StorageType_STORAGE_TYPE_UNSPECIFIED
	Table_ClusterState_INITIALIZING                                         = src.Table_ClusterState_INITIALIZING
	Table_ClusterState_PLANNED_MAINTENANCE                                  = src.Table_ClusterState_PLANNED_MAINTENANCE
	Table_ClusterState_READY                                                = src.Table_ClusterState_READY
	Table_ClusterState_READY_OPTIMIZING                                     = src.Table_ClusterState_READY_OPTIMIZING
	Table_ClusterState_STATE_NOT_KNOWN                                      = src.Table_ClusterState_STATE_NOT_KNOWN
	Table_ClusterState_UNPLANNED_MAINTENANCE                                = src.Table_ClusterState_UNPLANNED_MAINTENANCE
	Table_ENCRYPTION_VIEW                                                   = src.Table_ENCRYPTION_VIEW
	Table_FULL                                                              = src.Table_FULL
	Table_MILLIS                                                            = src.Table_MILLIS
	Table_NAME_ONLY                                                         = src.Table_NAME_ONLY
	Table_REPLICATION_VIEW                                                  = src.Table_REPLICATION_VIEW
	Table_SCHEMA_VIEW                                                       = src.Table_SCHEMA_VIEW
	Table_TIMESTAMP_GRANULARITY_UNSPECIFIED                                 = src.Table_TIMESTAMP_GRANULARITY_UNSPECIFIED
	Table_VIEW_UNSPECIFIED                                                  = src.Table_VIEW_UNSPECIFIED
)

// Deprecated: Please use vars in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
var (
	AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner_name  = src.AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner_name
	AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner_value = src.AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner_value
	AppProfile_Priority_name                                        = src.AppProfile_Priority_name
	AppProfile_Priority_value                                       = src.AppProfile_Priority_value
	AuthorizedView_ResponseView_name                                = src.AuthorizedView_ResponseView_name
	AuthorizedView_ResponseView_value                               = src.AuthorizedView_ResponseView_value
	Backup_State_name                                               = src.Backup_State_name
	Backup_State_value                                              = src.Backup_State_value
	Cluster_State_name                                              = src.Cluster_State_name
	Cluster_State_value                                             = src.Cluster_State_value
	CreateClusterMetadata_TableProgress_State_name                  = src.CreateClusterMetadata_TableProgress_State_name
	CreateClusterMetadata_TableProgress_State_value                 = src.CreateClusterMetadata_TableProgress_State_value
	EncryptionInfo_EncryptionType_name                              = src.EncryptionInfo_EncryptionType_name
	EncryptionInfo_EncryptionType_value                             = src.EncryptionInfo_EncryptionType_value
	File_google_bigtable_admin_v2_bigtable_instance_admin_proto     = src.File_google_bigtable_admin_v2_bigtable_instance_admin_proto
	File_google_bigtable_admin_v2_bigtable_table_admin_proto        = src.File_google_bigtable_admin_v2_bigtable_table_admin_proto
	File_google_bigtable_admin_v2_common_proto                      = src.File_google_bigtable_admin_v2_common_proto
	File_google_bigtable_admin_v2_instance_proto                    = src.File_google_bigtable_admin_v2_instance_proto
	File_google_bigtable_admin_v2_table_proto                       = src.File_google_bigtable_admin_v2_table_proto
	File_google_bigtable_admin_v2_types_proto                       = src.File_google_bigtable_admin_v2_types_proto
	Instance_State_name                                             = src.Instance_State_name
	Instance_State_value                                            = src.Instance_State_value
	Instance_Type_name                                              = src.Instance_Type_name
	Instance_Type_value                                             = src.Instance_Type_value
	RestoreSourceType_name                                          = src.RestoreSourceType_name
	RestoreSourceType_value                                         = src.RestoreSourceType_value
	Snapshot_State_name                                             = src.Snapshot_State_name
	Snapshot_State_value                                            = src.Snapshot_State_value
	StorageType_name                                                = src.StorageType_name
	StorageType_value                                               = src.StorageType_value
	Table_ClusterState_ReplicationState_name                        = src.Table_ClusterState_ReplicationState_name
	Table_ClusterState_ReplicationState_value                       = src.Table_ClusterState_ReplicationState_value
	Table_TimestampGranularity_name                                 = src.Table_TimestampGranularity_name
	Table_TimestampGranularity_value                                = src.Table_TimestampGranularity_value
	Table_View_name                                                 = src.Table_View_name
	Table_View_value                                                = src.Table_View_value
)

// A configuration object describing how Cloud Bigtable should treat traffic
// from a particular end user application.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AppProfile = src.AppProfile

// Data Boost is a serverless compute capability that lets you run
// high-throughput read jobs on your Bigtable data, without impacting the
// performance of the clusters that handle your application traffic. Currently,
// Data Boost exclusively supports read-only use-cases with single-cluster
// routing. Data Boost reads are only guaranteed to see the results of writes
// that were written at least 30 minutes ago. This means newly written values
// may not become visible for up to 30m, and also means that old values may
// remain visible for up to 30m after being deleted or overwritten. To mitigate
// the staleness of the data, users may either wait 30m, or use
// CheckConsistency.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AppProfile_DataBoostIsolationReadOnly = src.AppProfile_DataBoostIsolationReadOnly
type AppProfile_DataBoostIsolationReadOnly_ = src.AppProfile_DataBoostIsolationReadOnly_

// Compute Billing Owner specifies how usage should be accounted when using
// Data Boost. Compute Billing Owner also configures which Cloud Project is
// charged for relevant quota.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner = src.AppProfile_DataBoostIsolationReadOnly_ComputeBillingOwner

// Read/write requests are routed to the nearest cluster in the instance, and
// will fail over to the nearest cluster that is available in the event of
// transient errors or delays. Clusters in a region are considered equidistant.
// Choosing this option sacrifices read-your-writes consistency to improve
// availability.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AppProfile_MultiClusterRoutingUseAny = src.AppProfile_MultiClusterRoutingUseAny
type AppProfile_MultiClusterRoutingUseAny_ = src.AppProfile_MultiClusterRoutingUseAny_

// Possible priorities for an app profile. Note that higher priority writes
// can sometimes queue behind lower priority writes to the same tablet, as
// writes must be strictly sequenced in the durability log.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AppProfile_Priority = src.AppProfile_Priority
type AppProfile_Priority_ = src.AppProfile_Priority_

// Unconditionally routes all read/write requests to a specific cluster. This
// option preserves read-your-writes consistency but does not improve
// availability.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AppProfile_SingleClusterRouting = src.AppProfile_SingleClusterRouting
type AppProfile_SingleClusterRouting_ = src.AppProfile_SingleClusterRouting_

// Standard options for isolating this app profile's traffic from other use
// cases.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AppProfile_StandardIsolation = src.AppProfile_StandardIsolation
type AppProfile_StandardIsolation_ = src.AppProfile_StandardIsolation_

// AuthorizedViews represent subsets of a particular Cloud Bigtable table.
// Users can configure access to each Authorized View independently from the
// table and use the existing Data APIs to access the subset of data.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AuthorizedView = src.AuthorizedView

// Subsets of a column family that are included in this AuthorizedView.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AuthorizedView_FamilySubsets = src.AuthorizedView_FamilySubsets

// Defines a subset of an AuthorizedView's fields.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AuthorizedView_ResponseView = src.AuthorizedView_ResponseView

// Defines a simple AuthorizedView that is a subset of the underlying Table.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AuthorizedView_SubsetView = src.AuthorizedView_SubsetView
type AuthorizedView_SubsetView_ = src.AuthorizedView_SubsetView_

// Limits for the number of nodes a Cluster can autoscale up/down to.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AutoscalingLimits = src.AutoscalingLimits

// The Autoscaling targets for a Cluster. These determine the recommended
// nodes.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type AutoscalingTargets = src.AutoscalingTargets

// A backup of a Cloud Bigtable table.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Backup = src.Backup

// Information about a backup.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type BackupInfo = src.BackupInfo

// Indicates the current state of the backup.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Backup_State = src.Backup_State

// BigtableInstanceAdminClient is the client API for BigtableInstanceAdmin
// service. For semantics around ctx use and closing/ending streaming RPCs,
// please refer to
// https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type BigtableInstanceAdminClient = src.BigtableInstanceAdminClient

// BigtableInstanceAdminServer is the server API for BigtableInstanceAdmin
// service.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type BigtableInstanceAdminServer = src.BigtableInstanceAdminServer

// BigtableTableAdminClient is the client API for BigtableTableAdmin service.
// For semantics around ctx use and closing/ending streaming RPCs, please refer
// to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type BigtableTableAdminClient = src.BigtableTableAdminClient

// BigtableTableAdminServer is the server API for BigtableTableAdmin service.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type BigtableTableAdminServer = src.BigtableTableAdminServer

// Change stream configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ChangeStreamConfig = src.ChangeStreamConfig

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency][google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CheckConsistencyRequest = src.CheckConsistencyRequest
type CheckConsistencyRequest_DataBoostReadLocalWrites = src.CheckConsistencyRequest_DataBoostReadLocalWrites
type CheckConsistencyRequest_StandardReadRemoteWrites = src.CheckConsistencyRequest_StandardReadRemoteWrites

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency][google.bigtable.admin.v2.BigtableTableAdmin.CheckConsistency]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CheckConsistencyResponse = src.CheckConsistencyResponse

// A resizable group of nodes in a particular cloud location, capable of
// serving all [Tables][google.bigtable.admin.v2.Table] in the parent
// [Instance][google.bigtable.admin.v2.Instance].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Cluster = src.Cluster

// Autoscaling config for a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Cluster_ClusterAutoscalingConfig = src.Cluster_ClusterAutoscalingConfig

// Configuration for a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Cluster_ClusterConfig = src.Cluster_ClusterConfig
type Cluster_ClusterConfig_ = src.Cluster_ClusterConfig_

// Cloud Key Management Service (Cloud KMS) settings for a CMEK-protected
// cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Cluster_EncryptionConfig = src.Cluster_EncryptionConfig

// Possible states of a cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Cluster_State = src.Cluster_State

// A set of columns within a table which share a common configuration.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ColumnFamily = src.ColumnFamily

// Metadata type for the google.longrunning.Operation returned by
// [CopyBackup][google.bigtable.admin.v2.BigtableTableAdmin.CopyBackup].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CopyBackupMetadata = src.CopyBackupMetadata

// The request for
// [CopyBackup][google.bigtable.admin.v2.BigtableTableAdmin.CopyBackup].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CopyBackupRequest = src.CopyBackupRequest

// Request message for BigtableInstanceAdmin.CreateAppProfile.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateAppProfileRequest = src.CreateAppProfileRequest

// The metadata for the Operation returned by CreateAuthorizedView.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateAuthorizedViewMetadata = src.CreateAuthorizedViewMetadata

// The request for
// [CreateAuthorizedView][google.bigtable.admin.v2.BigtableTableAdmin.CreateAuthorizedView]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateAuthorizedViewRequest = src.CreateAuthorizedViewRequest

// Metadata type for the operation returned by
// [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateBackupMetadata = src.CreateBackupMetadata

// The request for
// [CreateBackup][google.bigtable.admin.v2.BigtableTableAdmin.CreateBackup].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateBackupRequest = src.CreateBackupRequest

// The metadata for the Operation returned by CreateCluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateClusterMetadata = src.CreateClusterMetadata

// Progress info for copying a table's data to the new cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateClusterMetadata_TableProgress = src.CreateClusterMetadata_TableProgress
type CreateClusterMetadata_TableProgress_State = src.CreateClusterMetadata_TableProgress_State

// Request message for BigtableInstanceAdmin.CreateCluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateClusterRequest = src.CreateClusterRequest

// The metadata for the Operation returned by CreateInstance.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateInstanceMetadata = src.CreateInstanceMetadata

// Request message for BigtableInstanceAdmin.CreateInstance.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateInstanceRequest = src.CreateInstanceRequest

// The metadata for the Operation returned by CreateTableFromSnapshot. Note:
// This is a private alpha release of Cloud Bigtable snapshots. This feature is
// not currently available to most Cloud Bigtable customers. This feature might
// be changed in backward-incompatible ways and is not recommended for
// production use. It is not subject to any SLA or deprecation policy.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateTableFromSnapshotMetadata = src.CreateTableFromSnapshotMetadata

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CreateTableFromSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.CreateTableFromSnapshot]
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not
// recommended for production use. It is not subject to any SLA or deprecation
// policy.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateTableFromSnapshotRequest = src.CreateTableFromSnapshotRequest

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.CreateTable][google.bigtable.admin.v2.BigtableTableAdmin.CreateTable]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateTableRequest = src.CreateTableRequest

// An initial split point for a newly created table.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type CreateTableRequest_Split = src.CreateTableRequest_Split

// Checks that all writes before the consistency token was generated in the
// same cluster are readable by Databoost.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type DataBoostReadLocalWrites = src.DataBoostReadLocalWrites

// Request message for BigtableInstanceAdmin.DeleteAppProfile.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type DeleteAppProfileRequest = src.DeleteAppProfileRequest

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DeleteAuthorizedView][google.bigtable.admin.v2.BigtableTableAdmin.DeleteAuthorizedView]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type DeleteAuthorizedViewRequest = src.DeleteAuthorizedViewRequest

// The request for
// [DeleteBackup][google.bigtable.admin.v2.BigtableTableAdmin.DeleteBackup].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type DeleteBackupRequest = src.DeleteBackupRequest

// Request message for BigtableInstanceAdmin.DeleteCluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type DeleteClusterRequest = src.DeleteClusterRequest

// Request message for BigtableInstanceAdmin.DeleteInstance.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type DeleteInstanceRequest = src.DeleteInstanceRequest

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DeleteSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.DeleteSnapshot]
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not
// recommended for production use. It is not subject to any SLA or deprecation
// policy.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type DeleteSnapshotRequest = src.DeleteSnapshotRequest

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DeleteTable][google.bigtable.admin.v2.BigtableTableAdmin.DeleteTable]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type DeleteTableRequest = src.DeleteTableRequest

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange][google.bigtable.admin.v2.BigtableTableAdmin.DropRowRange]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type DropRowRangeRequest = src.DropRowRangeRequest
type DropRowRangeRequest_DeleteAllDataFromTable = src.DropRowRangeRequest_DeleteAllDataFromTable
type DropRowRangeRequest_RowKeyPrefix = src.DropRowRangeRequest_RowKeyPrefix

// Encryption information for a given resource. If this resource is protected
// with customer managed encryption, the in-use Cloud Key Management Service
// (Cloud KMS) key version is specified along with its status.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type EncryptionInfo = src.EncryptionInfo

// Possible encryption types for a resource.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type EncryptionInfo_EncryptionType = src.EncryptionInfo_EncryptionType

// Rule for determining which cells to delete during garbage collection.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GcRule = src.GcRule

// A GcRule which deletes cells matching all of the given rules.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GcRule_Intersection = src.GcRule_Intersection
type GcRule_Intersection_ = src.GcRule_Intersection_
type GcRule_MaxAge = src.GcRule_MaxAge
type GcRule_MaxNumVersions = src.GcRule_MaxNumVersions

// A GcRule which deletes cells matching any of the given rules.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GcRule_Union = src.GcRule_Union
type GcRule_Union_ = src.GcRule_Union_

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken][google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GenerateConsistencyTokenRequest = src.GenerateConsistencyTokenRequest

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken][google.bigtable.admin.v2.BigtableTableAdmin.GenerateConsistencyToken]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GenerateConsistencyTokenResponse = src.GenerateConsistencyTokenResponse

// Request message for BigtableInstanceAdmin.GetAppProfile.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GetAppProfileRequest = src.GetAppProfileRequest

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GetAuthorizedView][google.bigtable.admin.v2.BigtableTableAdmin.GetAuthorizedView]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GetAuthorizedViewRequest = src.GetAuthorizedViewRequest

// The request for
// [GetBackup][google.bigtable.admin.v2.BigtableTableAdmin.GetBackup].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GetBackupRequest = src.GetBackupRequest

// Request message for BigtableInstanceAdmin.GetCluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GetClusterRequest = src.GetClusterRequest

// Request message for BigtableInstanceAdmin.GetInstance.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GetInstanceRequest = src.GetInstanceRequest

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GetSnapshot][google.bigtable.admin.v2.BigtableTableAdmin.GetSnapshot]
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not
// recommended for production use. It is not subject to any SLA or deprecation
// policy.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GetSnapshotRequest = src.GetSnapshotRequest

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.GetTable][google.bigtable.admin.v2.BigtableTableAdmin.GetTable]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type GetTableRequest = src.GetTableRequest

// A tablet is a defined by a start and end key and is explained in
// https://cloud.google.com/bigtable/docs/overview#architecture and
// https://cloud.google.com/bigtable/docs/performance#optimization. A Hot
// tablet is a tablet that exhibits high average cpu usage during the time
// interval from start time to end time.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type HotTablet = src.HotTablet

// A collection of Bigtable [Tables][google.bigtable.admin.v2.Table] and the
// resources that serve them. All tables in an instance are served from all
// [Clusters][google.bigtable.admin.v2.Cluster] in the instance.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Instance = src.Instance

// Possible states of an instance.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Instance_State = src.Instance_State

// The type of the instance.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Instance_Type = src.Instance_Type

// Request message for BigtableInstanceAdmin.ListAppProfiles.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListAppProfilesRequest = src.ListAppProfilesRequest

// Response message for BigtableInstanceAdmin.ListAppProfiles.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListAppProfilesResponse = src.ListAppProfilesResponse

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListAuthorizedViews][google.bigtable.admin.v2.BigtableTableAdmin.ListAuthorizedViews]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListAuthorizedViewsRequest = src.ListAuthorizedViewsRequest

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListAuthorizedViews][google.bigtable.admin.v2.BigtableTableAdmin.ListAuthorizedViews]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListAuthorizedViewsResponse = src.ListAuthorizedViewsResponse

// The request for
// [ListBackups][google.bigtable.admin.v2.BigtableTableAdmin.ListBackups].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListBackupsRequest = src.ListBackupsRequest

// The response for
// [ListBackups][google.bigtable.admin.v2.BigtableTableAdmin.ListBackups].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListBackupsResponse = src.ListBackupsResponse

// Request message for BigtableInstanceAdmin.ListClusters.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListClustersRequest = src.ListClustersRequest

// Response message for BigtableInstanceAdmin.ListClusters.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListClustersResponse = src.ListClustersResponse

// Request message for BigtableInstanceAdmin.ListHotTablets.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListHotTabletsRequest = src.ListHotTabletsRequest

// Response message for BigtableInstanceAdmin.ListHotTablets.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListHotTabletsResponse = src.ListHotTabletsResponse

// Request message for BigtableInstanceAdmin.ListInstances.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListInstancesRequest = src.ListInstancesRequest

// Response message for BigtableInstanceAdmin.ListInstances.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListInstancesResponse = src.ListInstancesResponse

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots][google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots]
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not
// recommended for production use. It is not subject to any SLA or deprecation
// policy.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListSnapshotsRequest = src.ListSnapshotsRequest

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots][google.bigtable.admin.v2.BigtableTableAdmin.ListSnapshots]
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not
// recommended for production use. It is not subject to any SLA or deprecation
// policy.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListSnapshotsResponse = src.ListSnapshotsResponse

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListTables][google.bigtable.admin.v2.BigtableTableAdmin.ListTables]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListTablesRequest = src.ListTablesRequest

// Response message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ListTables][google.bigtable.admin.v2.BigtableTableAdmin.ListTables]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ListTablesResponse = src.ListTablesResponse

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies][google.bigtable.admin.v2.BigtableTableAdmin.ModifyColumnFamilies]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ModifyColumnFamiliesRequest = src.ModifyColumnFamiliesRequest

// A create, update, or delete of a particular column family.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type ModifyColumnFamiliesRequest_Modification = src.ModifyColumnFamiliesRequest_Modification
type ModifyColumnFamiliesRequest_Modification_Create = src.ModifyColumnFamiliesRequest_Modification_Create
type ModifyColumnFamiliesRequest_Modification_Drop = src.ModifyColumnFamiliesRequest_Modification_Drop
type ModifyColumnFamiliesRequest_Modification_Update = src.ModifyColumnFamiliesRequest_Modification_Update

// Encapsulates progress related information for a Cloud Bigtable long running
// operation.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type OperationProgress = src.OperationProgress

// Metadata type for the long-running operation used to track the progress of
// optimizations performed on a newly restored table. This long-running
// operation is automatically created by the system after the successful
// completion of a table restore, and cannot be cancelled.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type OptimizeRestoredTableMetadata = src.OptimizeRestoredTableMetadata

// The metadata for the Operation returned by PartialUpdateCluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type PartialUpdateClusterMetadata = src.PartialUpdateClusterMetadata

// Request message for BigtableInstanceAdmin.PartialUpdateCluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type PartialUpdateClusterRequest = src.PartialUpdateClusterRequest

// Request message for BigtableInstanceAdmin.PartialUpdateInstance.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type PartialUpdateInstanceRequest = src.PartialUpdateInstanceRequest

// Information about a table restore.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type RestoreInfo = src.RestoreInfo
type RestoreInfo_BackupInfo = src.RestoreInfo_BackupInfo

// Indicates the type of the restore source.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type RestoreSourceType = src.RestoreSourceType

// Metadata type for the long-running operation returned by
// [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type RestoreTableMetadata = src.RestoreTableMetadata
type RestoreTableMetadata_BackupInfo = src.RestoreTableMetadata_BackupInfo

// The request for
// [RestoreTable][google.bigtable.admin.v2.BigtableTableAdmin.RestoreTable].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type RestoreTableRequest = src.RestoreTableRequest
type RestoreTableRequest_Backup = src.RestoreTableRequest_Backup

// A snapshot of a table at a particular time. A snapshot can be used as a
// checkpoint for data restoration or a data source for a new table. Note: This
// is a private alpha release of Cloud Bigtable snapshots. This feature is not
// currently available to most Cloud Bigtable customers. This feature might be
// changed in backward-incompatible ways and is not recommended for production
// use. It is not subject to any SLA or deprecation policy.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Snapshot = src.Snapshot

// The metadata for the Operation returned by SnapshotTable. Note: This is a
// private alpha release of Cloud Bigtable snapshots. This feature is not
// currently available to most Cloud Bigtable customers. This feature might be
// changed in backward-incompatible ways and is not recommended for production
// use. It is not subject to any SLA or deprecation policy.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type SnapshotTableMetadata = src.SnapshotTableMetadata

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable][google.bigtable.admin.v2.BigtableTableAdmin.SnapshotTable]
// Note: This is a private alpha release of Cloud Bigtable snapshots. This
// feature is not currently available to most Cloud Bigtable customers. This
// feature might be changed in backward-incompatible ways and is not
// recommended for production use. It is not subject to any SLA or deprecation
// policy.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type SnapshotTableRequest = src.SnapshotTableRequest

// Possible states of a snapshot.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Snapshot_State = src.Snapshot_State

// Checks that all writes before the consistency token was generated are
// replicated in every cluster and readable.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type StandardReadRemoteWrites = src.StandardReadRemoteWrites

// Storage media types for persisting Bigtable data.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type StorageType = src.StorageType

// A collection of user data indexed by row, column, and timestamp. Each table
// is served using the resources of its parent cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Table = src.Table

// Defines an automated backup policy for a table
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Table_AutomatedBackupPolicy = src.Table_AutomatedBackupPolicy
type Table_AutomatedBackupPolicy_ = src.Table_AutomatedBackupPolicy_

// The state of a table's data in a particular cluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Table_ClusterState = src.Table_ClusterState

// Table replication states.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Table_ClusterState_ReplicationState = src.Table_ClusterState_ReplicationState

// Possible timestamp granularities to use when keeping multiple versions of
// data in a table.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Table_TimestampGranularity = src.Table_TimestampGranularity

// Defines a view over a table's fields.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Table_View = src.Table_View

// `Type` represents the type of data that is written to, read from, or stored
// in Bigtable. It is heavily based on the GoogleSQL standard to help maintain
// familiarity and consistency across products and features. For compatibility
// with Bigtable's existing untyped APIs, each `Type` includes an `Encoding`
// which describes how to convert to/from the underlying data. Each encoding
// also defines the following properties: - Order-preserving: Does the encoded
// value sort consistently with the original typed value? Note that Bigtable
// will always sort data based on the raw encoded value, *not* the decoded
// type. - Example: BYTES values sort in the same order as their raw encodings.
// - Counterexample: Encoding INT64 as a fixed-width decimal string does *not*
// preserve sort order when dealing with negative numbers. `INT64(1) >
// INT64(-1)`, but `STRING("-00001") > STRING("00001)`. - Self-delimiting: If
// we concatenate two encoded values, can we always tell where the first one
// ends and the second one begins? - Example: If we encode INT64s to
// fixed-width STRINGs, the first value will always contain exactly N digits,
// possibly preceded by a sign. - Counterexample: If we concatenate two UTF-8
// encoded STRINGs, we have no way to tell where the first one ends. -
// Compatibility: Which other systems have matching encoding schemes? For
// example, does this encoding have a GoogleSQL equivalent? HBase? Java?
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type = src.Type

// A value that combines incremental updates into a summarized value. Data is
// never directly written or read using type `Aggregate`. Writes will provide
// either the `input_type` or `state_type`, and reads will always return the
// `state_type` .
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Aggregate = src.Type_Aggregate
type Type_AggregateType = src.Type_AggregateType
type Type_Aggregate_HllppUniqueCount = src.Type_Aggregate_HllppUniqueCount

// Computes an approximate unique count over the input values. When using raw
// data as input, be careful to use a consistent encoding. Otherwise the same
// value encoded differently could count more than once, or two distinct values
// could count as identical. Input: Any, or omit for Raw State: TBD Special
// state conversions: `Int64` (the unique count estimate)
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Aggregate_HyperLogLogPlusPlusUniqueCount = src.Type_Aggregate_HyperLogLogPlusPlusUniqueCount

// Computes the max of the input values. Allowed input: `Int64` State: same as
// input
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Aggregate_Max = src.Type_Aggregate_Max
type Type_Aggregate_Max_ = src.Type_Aggregate_Max_

// Computes the min of the input values. Allowed input: `Int64` State: same as
// input
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Aggregate_Min = src.Type_Aggregate_Min
type Type_Aggregate_Min_ = src.Type_Aggregate_Min_

// Computes the sum of the input values. Allowed input: `Int64` State: same as
// input
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Aggregate_Sum = src.Type_Aggregate_Sum
type Type_Aggregate_Sum_ = src.Type_Aggregate_Sum_

// An ordered list of elements of a given type. Values of type `Array` are
// stored in `Value.array_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Array = src.Type_Array
type Type_ArrayType = src.Type_ArrayType

// bool Values of type `Bool` are stored in `Value.bool_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Bool = src.Type_Bool
type Type_BoolType = src.Type_BoolType

// Bytes Values of type `Bytes` are stored in `Value.bytes_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Bytes = src.Type_Bytes
type Type_BytesType = src.Type_BytesType

// Rules used to convert to/from lower level types.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Bytes_Encoding = src.Type_Bytes_Encoding

// Leaves the value "as-is" * Order-preserving? Yes * Self-delimiting? No *
// Compatibility? N/A
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Bytes_Encoding_Raw = src.Type_Bytes_Encoding_Raw
type Type_Bytes_Encoding_Raw_ = src.Type_Bytes_Encoding_Raw_

// Date Values of type `Date` are stored in `Value.date_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Date = src.Type_Date
type Type_DateType = src.Type_DateType

// Float32 Values of type `Float32` are stored in `Value.float_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Float32 = src.Type_Float32
type Type_Float32Type = src.Type_Float32Type

// Float64 Values of type `Float64` are stored in `Value.float_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Float64 = src.Type_Float64
type Type_Float64Type = src.Type_Float64Type

// Int64 Values of type `Int64` are stored in `Value.int_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Int64 = src.Type_Int64
type Type_Int64Type = src.Type_Int64Type

// Rules used to convert to/from lower level types.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Int64_Encoding = src.Type_Int64_Encoding

// Encodes the value as an 8-byte big endian twos complement `Bytes` value. *
// Order-preserving? No (positive values only) * Self-delimiting? Yes *
// Compatibility? - BigQuery Federation `BINARY` encoding - HBase
// `Bytes.toBytes` - Java `ByteBuffer.putLong()` with `ByteOrder.BIG_ENDIAN`
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Int64_Encoding_BigEndianBytes = src.Type_Int64_Encoding_BigEndianBytes
type Type_Int64_Encoding_BigEndianBytes_ = src.Type_Int64_Encoding_BigEndianBytes_

// A mapping of keys to values of a given type. Values of type `Map` are
// stored in a `Value.array_value` where each entry is another
// `Value.array_value` with two elements (the key and the value, in that
// order). Normally encoded Map values won't have repeated keys, however,
// clients are expected to handle the case in which they do. If the same key
// appears multiple times, the _last_ value takes precedence.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Map = src.Type_Map
type Type_MapType = src.Type_MapType

// String Values of type `String` are stored in `Value.string_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_String = src.Type_String
type Type_StringType = src.Type_StringType

// Rules used to convert to/from lower level types.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_String_Encoding = src.Type_String_Encoding

// UTF-8 encoding * Order-preserving? Yes (code point order) *
// Self-delimiting? No * Compatibility? - BigQuery Federation `TEXT` encoding -
// HBase `Bytes.toBytes` - Java `String#getBytes(StandardCharsets.UTF_8)`
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_String_Encoding_Utf8Bytes = src.Type_String_Encoding_Utf8Bytes
type Type_String_Encoding_Utf8Bytes_ = src.Type_String_Encoding_Utf8Bytes_

// Deprecated: prefer the equivalent `Utf8Bytes`. Deprecated: Marked as
// deprecated in google/bigtable/admin/v2/types.proto.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_String_Encoding_Utf8Raw = src.Type_String_Encoding_Utf8Raw
type Type_String_Encoding_Utf8Raw_ = src.Type_String_Encoding_Utf8Raw_

// A structured data value, consisting of fields which map to dynamically
// typed values. Values of type `Struct` are stored in `Value.array_value`
// where entries are in the same order and number as `field_types`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Struct = src.Type_Struct
type Type_StructType = src.Type_StructType

// A struct field and its type.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Struct_Field = src.Type_Struct_Field

// Timestamp Values of type `Timestamp` are stored in `Value.timestamp_value`.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type Type_Timestamp = src.Type_Timestamp
type Type_TimestampType = src.Type_TimestampType

// Metadata type for the operation returned by
// [google.bigtable.admin.v2.BigtableTableAdmin.UndeleteTable][google.bigtable.admin.v2.BigtableTableAdmin.UndeleteTable].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UndeleteTableMetadata = src.UndeleteTableMetadata

// Request message for
// [google.bigtable.admin.v2.BigtableTableAdmin.UndeleteTable][google.bigtable.admin.v2.BigtableTableAdmin.UndeleteTable]
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UndeleteTableRequest = src.UndeleteTableRequest

// UnimplementedBigtableInstanceAdminServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UnimplementedBigtableInstanceAdminServer = src.UnimplementedBigtableInstanceAdminServer

// UnimplementedBigtableTableAdminServer can be embedded to have forward
// compatible implementations.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UnimplementedBigtableTableAdminServer = src.UnimplementedBigtableTableAdminServer

// The metadata for the Operation returned by UpdateAppProfile.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UpdateAppProfileMetadata = src.UpdateAppProfileMetadata

// Request message for BigtableInstanceAdmin.UpdateAppProfile.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UpdateAppProfileRequest = src.UpdateAppProfileRequest

// Metadata for the google.longrunning.Operation returned by
// [UpdateAuthorizedView][google.bigtable.admin.v2.BigtableTableAdmin.UpdateAuthorizedView].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UpdateAuthorizedViewMetadata = src.UpdateAuthorizedViewMetadata

// The request for
// [UpdateAuthorizedView][google.bigtable.admin.v2.BigtableTableAdmin.UpdateAuthorizedView].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UpdateAuthorizedViewRequest = src.UpdateAuthorizedViewRequest

// The request for
// [UpdateBackup][google.bigtable.admin.v2.BigtableTableAdmin.UpdateBackup].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UpdateBackupRequest = src.UpdateBackupRequest

// The metadata for the Operation returned by UpdateCluster.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UpdateClusterMetadata = src.UpdateClusterMetadata

// The metadata for the Operation returned by UpdateInstance.
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UpdateInstanceMetadata = src.UpdateInstanceMetadata

// Metadata type for the operation returned by
// [UpdateTable][google.bigtable.admin.v2.BigtableTableAdmin.UpdateTable].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UpdateTableMetadata = src.UpdateTableMetadata

// The request for
// [UpdateTable][google.bigtable.admin.v2.BigtableTableAdmin.UpdateTable].
//
// Deprecated: Please use types in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
type UpdateTableRequest = src.UpdateTableRequest

// Deprecated: Please use funcs in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
func NewBigtableInstanceAdminClient(cc grpc.ClientConnInterface) BigtableInstanceAdminClient {
	return src.NewBigtableInstanceAdminClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
func NewBigtableTableAdminClient(cc grpc.ClientConnInterface) BigtableTableAdminClient {
	return src.NewBigtableTableAdminClient(cc)
}

// Deprecated: Please use funcs in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
func RegisterBigtableInstanceAdminServer(s *grpc.Server, srv BigtableInstanceAdminServer) {
	src.RegisterBigtableInstanceAdminServer(s, srv)
}

// Deprecated: Please use funcs in: cloud.google.com/go/bigtable/admin/apiv2/adminpb
func RegisterBigtableTableAdminServer(s *grpc.Server, srv BigtableTableAdminServer) {
	src.RegisterBigtableTableAdminServer(s, srv)
}
