// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/dataflow/v1beta3/metrics.proto

package dataflowpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	MetricsV1Beta3_GetJobMetrics_FullMethodName            = "/google.dataflow.v1beta3.MetricsV1Beta3/GetJobMetrics"
	MetricsV1Beta3_GetJobExecutionDetails_FullMethodName   = "/google.dataflow.v1beta3.MetricsV1Beta3/GetJobExecutionDetails"
	MetricsV1Beta3_GetStageExecutionDetails_FullMethodName = "/google.dataflow.v1beta3.MetricsV1Beta3/GetStageExecutionDetails"
)

// MetricsV1Beta3Client is the client API for MetricsV1Beta3 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MetricsV1Beta3Client interface {
	// Request the job status.
	//
	// To request the status of a job, we recommend using
	// `projects.locations.jobs.getMetrics` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.getMetrics` is not recommended, as you can only request the
	// status of jobs that are running in `us-central1`.
	GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*JobMetrics, error)
	// Request detailed information about the execution status of the job.
	//
	// EXPERIMENTAL.  This API is subject to change or removal without notice.
	GetJobExecutionDetails(ctx context.Context, in *GetJobExecutionDetailsRequest, opts ...grpc.CallOption) (*JobExecutionDetails, error)
	// Request detailed information about the execution status of a stage of the
	// job.
	//
	// EXPERIMENTAL.  This API is subject to change or removal without notice.
	GetStageExecutionDetails(ctx context.Context, in *GetStageExecutionDetailsRequest, opts ...grpc.CallOption) (*StageExecutionDetails, error)
}

type metricsV1Beta3Client struct {
	cc grpc.ClientConnInterface
}

func NewMetricsV1Beta3Client(cc grpc.ClientConnInterface) MetricsV1Beta3Client {
	return &metricsV1Beta3Client{cc}
}

func (c *metricsV1Beta3Client) GetJobMetrics(ctx context.Context, in *GetJobMetricsRequest, opts ...grpc.CallOption) (*JobMetrics, error) {
	out := new(JobMetrics)
	err := c.cc.Invoke(ctx, MetricsV1Beta3_GetJobMetrics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsV1Beta3Client) GetJobExecutionDetails(ctx context.Context, in *GetJobExecutionDetailsRequest, opts ...grpc.CallOption) (*JobExecutionDetails, error) {
	out := new(JobExecutionDetails)
	err := c.cc.Invoke(ctx, MetricsV1Beta3_GetJobExecutionDetails_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *metricsV1Beta3Client) GetStageExecutionDetails(ctx context.Context, in *GetStageExecutionDetailsRequest, opts ...grpc.CallOption) (*StageExecutionDetails, error) {
	out := new(StageExecutionDetails)
	err := c.cc.Invoke(ctx, MetricsV1Beta3_GetStageExecutionDetails_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MetricsV1Beta3Server is the server API for MetricsV1Beta3 service.
// All implementations should embed UnimplementedMetricsV1Beta3Server
// for forward compatibility
type MetricsV1Beta3Server interface {
	// Request the job status.
	//
	// To request the status of a job, we recommend using
	// `projects.locations.jobs.getMetrics` with a [regional endpoint]
	// (https://cloud.google.com/dataflow/docs/concepts/regional-endpoints). Using
	// `projects.jobs.getMetrics` is not recommended, as you can only request the
	// status of jobs that are running in `us-central1`.
	GetJobMetrics(context.Context, *GetJobMetricsRequest) (*JobMetrics, error)
	// Request detailed information about the execution status of the job.
	//
	// EXPERIMENTAL.  This API is subject to change or removal without notice.
	GetJobExecutionDetails(context.Context, *GetJobExecutionDetailsRequest) (*JobExecutionDetails, error)
	// Request detailed information about the execution status of a stage of the
	// job.
	//
	// EXPERIMENTAL.  This API is subject to change or removal without notice.
	GetStageExecutionDetails(context.Context, *GetStageExecutionDetailsRequest) (*StageExecutionDetails, error)
}

// UnimplementedMetricsV1Beta3Server should be embedded to have forward compatible implementations.
type UnimplementedMetricsV1Beta3Server struct {
}

func (UnimplementedMetricsV1Beta3Server) GetJobMetrics(context.Context, *GetJobMetricsRequest) (*JobMetrics, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobMetrics not implemented")
}
func (UnimplementedMetricsV1Beta3Server) GetJobExecutionDetails(context.Context, *GetJobExecutionDetailsRequest) (*JobExecutionDetails, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJobExecutionDetails not implemented")
}
func (UnimplementedMetricsV1Beta3Server) GetStageExecutionDetails(context.Context, *GetStageExecutionDetailsRequest) (*StageExecutionDetails, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetStageExecutionDetails not implemented")
}

// UnsafeMetricsV1Beta3Server may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MetricsV1Beta3Server will
// result in compilation errors.
type UnsafeMetricsV1Beta3Server interface {
	mustEmbedUnimplementedMetricsV1Beta3Server()
}

func RegisterMetricsV1Beta3Server(s grpc.ServiceRegistrar, srv MetricsV1Beta3Server) {
	s.RegisterService(&MetricsV1Beta3_ServiceDesc, srv)
}

func _MetricsV1Beta3_GetJobMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsV1Beta3Server).GetJobMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetricsV1Beta3_GetJobMetrics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsV1Beta3Server).GetJobMetrics(ctx, req.(*GetJobMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsV1Beta3_GetJobExecutionDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobExecutionDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsV1Beta3Server).GetJobExecutionDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetricsV1Beta3_GetJobExecutionDetails_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsV1Beta3Server).GetJobExecutionDetails(ctx, req.(*GetJobExecutionDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MetricsV1Beta3_GetStageExecutionDetails_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetStageExecutionDetailsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MetricsV1Beta3Server).GetStageExecutionDetails(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MetricsV1Beta3_GetStageExecutionDetails_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MetricsV1Beta3Server).GetStageExecutionDetails(ctx, req.(*GetStageExecutionDetailsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MetricsV1Beta3_ServiceDesc is the grpc.ServiceDesc for MetricsV1Beta3 service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MetricsV1Beta3_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.dataflow.v1beta3.MetricsV1Beta3",
	HandlerType: (*MetricsV1Beta3Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetJobMetrics",
			Handler:    _MetricsV1Beta3_GetJobMetrics_Handler,
		},
		{
			MethodName: "GetJobExecutionDetails",
			Handler:    _MetricsV1Beta3_GetJobExecutionDetails_Handler,
		},
		{
			MethodName: "GetStageExecutionDetails",
			Handler:    _MetricsV1Beta3_GetStageExecutionDetails_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/dataflow/v1beta3/metrics.proto",
}
