// Code generated by gotmpl. DO NOT MODIFY.
// source: internal/shared/x/x_text.go.tmpl

// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

package x

import (
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
)

const (
	mockKey  = "OTEL_GO_X_MOCK_FEATURE"
	mockKey2 = "OTEL_GO_X_MOCK_FEATURE2"
)

var mockFeature = newFeature([]string{"MOCK_FEATURE", "MOCK_FEATURE2"}, func(v string) (string, bool) {
	if strings.EqualFold(v, "true") {
		return v, true
	}
	return "", false
})

func TestFeature(t *testing.T) {
	require.Contains(t, mockFeature.Keys(), mockKey)
	require.Contains(t, mockFeature.Keys(), mockKey2)

	t.Run("100", run(setenv(mockKey, "100"), assertDisabled(mockFeature)))
	t.Run("true", run(setenv(mockKey, "true"), assertEnabled(mockFeature, "true")))
	t.Run("True", run(setenv(mockKey, "True"), assertEnabled(mockFeature, "True")))
	t.Run("false", run(setenv(mockKey, "false"), assertDisabled(mockFeature)))
	t.Run("empty", run(assertDisabled(mockFeature)))
}

func run(steps ...func(*testing.T)) func(*testing.T) {
	return func(t *testing.T) {
		t.Helper()
		for _, step := range steps {
			step(t)
		}
	}
}

func setenv(k, v string) func(t *testing.T) { //nolint:unparam // This is a reusable test utility function.
	return func(t *testing.T) { t.Setenv(k, v) }
}

func assertEnabled[T any](f Feature[T], want T) func(*testing.T) {
	return func(t *testing.T) {
		t.Helper()
		assert.True(t, f.Enabled(), "not enabled")

		v, ok := f.Lookup()
		assert.True(t, ok, "Lookup state")
		assert.Equal(t, want, v, "Lookup value")
	}
}

func assertDisabled[T any](f Feature[T]) func(*testing.T) {
	var zero T
	return func(t *testing.T) {
		t.Helper()

		assert.False(t, f.Enabled(), "enabled")

		v, ok := f.Lookup()
		assert.False(t, ok, "Lookup state")
		assert.Equal(t, zero, v, "Lookup value")
	}
}
