// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/policytroubleshooter/v1/checker.proto

package policytroubleshooterpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	IamChecker_TroubleshootIamPolicy_FullMethodName = "/google.cloud.policytroubleshooter.v1.IamChecker/TroubleshootIamPolicy"
)

// IamCheckerClient is the client API for IamChecker service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type IamCheckerClient interface {
	// Checks whether a principal has a specific permission for a specific
	// resource, and explains why the principal does or does not have that
	// permission.
	TroubleshootIamPolicy(ctx context.Context, in *TroubleshootIamPolicyRequest, opts ...grpc.CallOption) (*TroubleshootIamPolicyResponse, error)
}

type iamCheckerClient struct {
	cc grpc.ClientConnInterface
}

func NewIamCheckerClient(cc grpc.ClientConnInterface) IamCheckerClient {
	return &iamCheckerClient{cc}
}

func (c *iamCheckerClient) TroubleshootIamPolicy(ctx context.Context, in *TroubleshootIamPolicyRequest, opts ...grpc.CallOption) (*TroubleshootIamPolicyResponse, error) {
	out := new(TroubleshootIamPolicyResponse)
	err := c.cc.Invoke(ctx, IamChecker_TroubleshootIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IamCheckerServer is the server API for IamChecker service.
// All implementations should embed UnimplementedIamCheckerServer
// for forward compatibility
type IamCheckerServer interface {
	// Checks whether a principal has a specific permission for a specific
	// resource, and explains why the principal does or does not have that
	// permission.
	TroubleshootIamPolicy(context.Context, *TroubleshootIamPolicyRequest) (*TroubleshootIamPolicyResponse, error)
}

// UnimplementedIamCheckerServer should be embedded to have forward compatible implementations.
type UnimplementedIamCheckerServer struct {
}

func (UnimplementedIamCheckerServer) TroubleshootIamPolicy(context.Context, *TroubleshootIamPolicyRequest) (*TroubleshootIamPolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TroubleshootIamPolicy not implemented")
}

// UnsafeIamCheckerServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to IamCheckerServer will
// result in compilation errors.
type UnsafeIamCheckerServer interface {
	mustEmbedUnimplementedIamCheckerServer()
}

func RegisterIamCheckerServer(s grpc.ServiceRegistrar, srv IamCheckerServer) {
	s.RegisterService(&IamChecker_ServiceDesc, srv)
}

func _IamChecker_TroubleshootIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TroubleshootIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IamCheckerServer).TroubleshootIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: IamChecker_TroubleshootIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IamCheckerServer).TroubleshootIamPolicy(ctx, req.(*TroubleshootIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// IamChecker_ServiceDesc is the grpc.ServiceDesc for IamChecker service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var IamChecker_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.policytroubleshooter.v1.IamChecker",
	HandlerType: (*IamCheckerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TroubleshootIamPolicy",
			Handler:    _IamChecker_TroubleshootIamPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/policytroubleshooter/v1/checker.proto",
}
