package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

type VulnerabilityReports struct {

	// 漏洞报告生成时间
	GeneratedAt *string `json:"generated_at,omitempty"`

	// 制品扫描报告的总体严重程度，None(无评分), Low(低危), Medium(中危), High(高危), Critical(严重), Security(安全)
	Severity *VulnerabilityReportsSeverity `json:"severity,omitempty"`

	Scanner *Scanner `json:"scanner,omitempty"`

	// 漏洞列表
	Vulnerabilities *[]Vulnerability `json:"vulnerabilities,omitempty"`
}

func (o VulnerabilityReports) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityReports struct{}"
	}

	return strings.Join([]string{"VulnerabilityReports", string(data)}, " ")
}

type VulnerabilityReportsSeverity struct {
	value string
}

type VulnerabilityReportsSeverityEnum struct {
	NONE     VulnerabilityReportsSeverity
	LOW      VulnerabilityReportsSeverity
	MEDIUM   VulnerabilityReportsSeverity
	HIGH     VulnerabilityReportsSeverity
	CRITICAL VulnerabilityReportsSeverity
	SECURITY VulnerabilityReportsSeverity
}

func GetVulnerabilityReportsSeverityEnum() VulnerabilityReportsSeverityEnum {
	return VulnerabilityReportsSeverityEnum{
		NONE: VulnerabilityReportsSeverity{
			value: "None",
		},
		LOW: VulnerabilityReportsSeverity{
			value: "Low",
		},
		MEDIUM: VulnerabilityReportsSeverity{
			value: "Medium",
		},
		HIGH: VulnerabilityReportsSeverity{
			value: "High",
		},
		CRITICAL: VulnerabilityReportsSeverity{
			value: "Critical",
		},
		SECURITY: VulnerabilityReportsSeverity{
			value: "Security",
		},
	}
}

func (c VulnerabilityReportsSeverity) Value() string {
	return c.value
}

func (c VulnerabilityReportsSeverity) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *VulnerabilityReportsSeverity) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
