package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// VulnerabilityDetail 漏洞详情
type VulnerabilityDetail struct {

	// 漏洞id
	Id *string `json:"id,omitempty"`

	// 格式版本
	FormatVersion *int32 `json:"format_version,omitempty"`

	// 版本
	Version *int32 `json:"version,omitempty"`

	// 当前项目的id
	ProjectId *string `json:"project_id,omitempty"`

	// 当前的工作空间id
	WorkspaceId *string `json:"workspace_id,omitempty"`

	// 创建时间，格式ISO8601：YYYY-MM-DDTHH:mm:ss.ms+timezone。时区信息为事件发生时区，无法解析时区的时间，默认时区填东八区
	CreateTime *string `json:"create_time,omitempty"`

	// 更新时间，格式ISO8601：YYYY-MM-DDTHH:mm:ss.ms+timezone。时区信息为事件发生时区，无法解析时区的时间，默认时区填东八区
	UpdateTime *string `json:"update_time,omitempty"`

	DataclassRef *VulnerabilityDetailDataclassRef `json:"dataclass_ref,omitempty"`

	DataObject *VulnerabilityDataObject `json:"data_object,omitempty"`
}

func (o VulnerabilityDetail) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityDetail struct{}"
	}

	return strings.Join([]string{"VulnerabilityDetail", string(data)}, " ")
}
