// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2beta1/tool.proto

package dialogflowpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Types of confirmation requirement.
type Tool_ConfirmationRequirement int32

const (
	// Unspecified. Whether the action requires confirmation is inferred from
	// method_type.
	Tool_CONFIRMATION_REQUIREMENT_UNSPECIFIED Tool_ConfirmationRequirement = 0
	// Conformation is required.
	Tool_REQUIRED Tool_ConfirmationRequirement = 1
	// Conformation is not required.
	Tool_NOT_REQUIRED Tool_ConfirmationRequirement = 2
)

// Enum value maps for Tool_ConfirmationRequirement.
var (
	Tool_ConfirmationRequirement_name = map[int32]string{
		0: "CONFIRMATION_REQUIREMENT_UNSPECIFIED",
		1: "REQUIRED",
		2: "NOT_REQUIRED",
	}
	Tool_ConfirmationRequirement_value = map[string]int32{
		"CONFIRMATION_REQUIREMENT_UNSPECIFIED": 0,
		"REQUIRED":                             1,
		"NOT_REQUIRED":                         2,
	}
)

func (x Tool_ConfirmationRequirement) Enum() *Tool_ConfirmationRequirement {
	p := new(Tool_ConfirmationRequirement)
	*p = x
	return p
}

func (x Tool_ConfirmationRequirement) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_ConfirmationRequirement) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[0].Descriptor()
}

func (Tool_ConfirmationRequirement) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[0]
}

func (x Tool_ConfirmationRequirement) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_ConfirmationRequirement.Descriptor instead.
func (Tool_ConfirmationRequirement) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 0}
}

// The method type of the function.
type Tool_MethodType int32

const (
	// Unspecified.
	Tool_METHOD_TYPE_UNSPECIFIED Tool_MethodType = 0
	// GET method.
	Tool_GET Tool_MethodType = 1
	// POST method.
	Tool_POST Tool_MethodType = 2
	// PUT method.
	Tool_PUT Tool_MethodType = 3
	// DELETE method.
	Tool_DELETE Tool_MethodType = 4
	// PATCH method.
	Tool_PATCH Tool_MethodType = 5
)

// Enum value maps for Tool_MethodType.
var (
	Tool_MethodType_name = map[int32]string{
		0: "METHOD_TYPE_UNSPECIFIED",
		1: "GET",
		2: "POST",
		3: "PUT",
		4: "DELETE",
		5: "PATCH",
	}
	Tool_MethodType_value = map[string]int32{
		"METHOD_TYPE_UNSPECIFIED": 0,
		"GET":                     1,
		"POST":                    2,
		"PUT":                     3,
		"DELETE":                  4,
		"PATCH":                   5,
	}
)

func (x Tool_MethodType) Enum() *Tool_MethodType {
	p := new(Tool_MethodType)
	*p = x
	return p
}

func (x Tool_MethodType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_MethodType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[1].Descriptor()
}

func (Tool_MethodType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[1]
}

func (x Tool_MethodType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_MethodType.Descriptor instead.
func (Tool_MethodType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 1}
}

// The operation to perform on the entity.
type Tool_ConnectorTool_Action_EntityOperation_OperationType int32

const (
	// Operation type unspecified. Invalid, ConnectorTool create/update
	// will fail.
	Tool_ConnectorTool_Action_EntityOperation_OPERATION_TYPE_UNSPECIFIED Tool_ConnectorTool_Action_EntityOperation_OperationType = 0
	// List operation.
	Tool_ConnectorTool_Action_EntityOperation_LIST Tool_ConnectorTool_Action_EntityOperation_OperationType = 1
	// Get operation.
	Tool_ConnectorTool_Action_EntityOperation_GET Tool_ConnectorTool_Action_EntityOperation_OperationType = 2
	// Create operation.
	Tool_ConnectorTool_Action_EntityOperation_CREATE Tool_ConnectorTool_Action_EntityOperation_OperationType = 3
	// Update operation.
	Tool_ConnectorTool_Action_EntityOperation_UPDATE Tool_ConnectorTool_Action_EntityOperation_OperationType = 4
	// Delete operation.
	Tool_ConnectorTool_Action_EntityOperation_DELETE Tool_ConnectorTool_Action_EntityOperation_OperationType = 5
)

// Enum value maps for Tool_ConnectorTool_Action_EntityOperation_OperationType.
var (
	Tool_ConnectorTool_Action_EntityOperation_OperationType_name = map[int32]string{
		0: "OPERATION_TYPE_UNSPECIFIED",
		1: "LIST",
		2: "GET",
		3: "CREATE",
		4: "UPDATE",
		5: "DELETE",
	}
	Tool_ConnectorTool_Action_EntityOperation_OperationType_value = map[string]int32{
		"OPERATION_TYPE_UNSPECIFIED": 0,
		"LIST":                       1,
		"GET":                        2,
		"CREATE":                     3,
		"UPDATE":                     4,
		"DELETE":                     5,
	}
)

func (x Tool_ConnectorTool_Action_EntityOperation_OperationType) Enum() *Tool_ConnectorTool_Action_EntityOperation_OperationType {
	p := new(Tool_ConnectorTool_Action_EntityOperation_OperationType)
	*p = x
	return p
}

func (x Tool_ConnectorTool_Action_EntityOperation_OperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_ConnectorTool_Action_EntityOperation_OperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[2].Descriptor()
}

func (Tool_ConnectorTool_Action_EntityOperation_OperationType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[2]
}

func (x Tool_ConnectorTool_Action_EntityOperation_OperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_ConnectorTool_Action_EntityOperation_OperationType.Descriptor instead.
func (Tool_ConnectorTool_Action_EntityOperation_OperationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 3, 0, 0, 0}
}

// The location of the API key in the request.
type Tool_Authentication_RequestLocation int32

const (
	// Default value. This value is unused.
	Tool_Authentication_REQUEST_LOCATION_UNSPECIFIED Tool_Authentication_RequestLocation = 0
	// Represents the key in http header.
	Tool_Authentication_HEADER Tool_Authentication_RequestLocation = 1
	// Represents the key in query string.
	Tool_Authentication_QUERY_STRING Tool_Authentication_RequestLocation = 2
)

// Enum value maps for Tool_Authentication_RequestLocation.
var (
	Tool_Authentication_RequestLocation_name = map[int32]string{
		0: "REQUEST_LOCATION_UNSPECIFIED",
		1: "HEADER",
		2: "QUERY_STRING",
	}
	Tool_Authentication_RequestLocation_value = map[string]int32{
		"REQUEST_LOCATION_UNSPECIFIED": 0,
		"HEADER":                       1,
		"QUERY_STRING":                 2,
	}
)

func (x Tool_Authentication_RequestLocation) Enum() *Tool_Authentication_RequestLocation {
	p := new(Tool_Authentication_RequestLocation)
	*p = x
	return p
}

func (x Tool_Authentication_RequestLocation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_Authentication_RequestLocation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[3].Descriptor()
}

func (Tool_Authentication_RequestLocation) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[3]
}

func (x Tool_Authentication_RequestLocation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_Authentication_RequestLocation.Descriptor instead.
func (Tool_Authentication_RequestLocation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 4, 0}
}

// OAuth grant types. Only [client credential
// grant](https://oauth.net/2/grant-types/client-credentials) is
// supported.
type Tool_Authentication_OAuthConfig_OauthGrantType int32

const (
	// Default value. This value is unused.
	Tool_Authentication_OAuthConfig_OAUTH_GRANT_TYPE_UNSPECIFIED Tool_Authentication_OAuthConfig_OauthGrantType = 0
	// Represents the [client credential
	// flow](https://oauth.net/2/grant-types/client-credentials).
	Tool_Authentication_OAuthConfig_CLIENT_CREDENTIAL Tool_Authentication_OAuthConfig_OauthGrantType = 1
)

// Enum value maps for Tool_Authentication_OAuthConfig_OauthGrantType.
var (
	Tool_Authentication_OAuthConfig_OauthGrantType_name = map[int32]string{
		0: "OAUTH_GRANT_TYPE_UNSPECIFIED",
		1: "CLIENT_CREDENTIAL",
	}
	Tool_Authentication_OAuthConfig_OauthGrantType_value = map[string]int32{
		"OAUTH_GRANT_TYPE_UNSPECIFIED": 0,
		"CLIENT_CREDENTIAL":            1,
	}
)

func (x Tool_Authentication_OAuthConfig_OauthGrantType) Enum() *Tool_Authentication_OAuthConfig_OauthGrantType {
	p := new(Tool_Authentication_OAuthConfig_OauthGrantType)
	*p = x
	return p
}

func (x Tool_Authentication_OAuthConfig_OauthGrantType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_Authentication_OAuthConfig_OauthGrantType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[4].Descriptor()
}

func (Tool_Authentication_OAuthConfig_OauthGrantType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[4]
}

func (x Tool_Authentication_OAuthConfig_OauthGrantType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_Authentication_OAuthConfig_OauthGrantType.Descriptor instead.
func (Tool_Authentication_OAuthConfig_OauthGrantType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 4, 1, 0}
}

// Indicate the auth token type generated from the [Diaglogflow service
// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
type Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth int32

const (
	// Service agent auth type unspecified. Default to ID_TOKEN.
	Tool_Authentication_ServiceAgentAuthConfig_SERVICE_AGENT_AUTH_UNSPECIFIED Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth = 0
	// Use [ID
	// token](https://cloud.google.com/docs/authentication/token-types#id)
	// generated from service agent. This can be used to access Cloud
	// Function and Cloud Run after you grant Invoker role to
	// `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	Tool_Authentication_ServiceAgentAuthConfig_ID_TOKEN Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth = 1
	// Use [access
	// token](https://cloud.google.com/docs/authentication/token-types#access)
	// generated from service agent. This can be used to access other Google
	// Cloud APIs after you grant required roles to
	// `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	Tool_Authentication_ServiceAgentAuthConfig_ACCESS_TOKEN Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth = 2
)

// Enum value maps for Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth.
var (
	Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth_name = map[int32]string{
		0: "SERVICE_AGENT_AUTH_UNSPECIFIED",
		1: "ID_TOKEN",
		2: "ACCESS_TOKEN",
	}
	Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth_value = map[string]int32{
		"SERVICE_AGENT_AUTH_UNSPECIFIED": 0,
		"ID_TOKEN":                       1,
		"ACCESS_TOKEN":                   2,
	}
)

func (x Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) Enum() *Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth {
	p := new(Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth)
	*p = x
	return p
}

func (x Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[5].Descriptor()
}

func (Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes[5]
}

func (x Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth.Descriptor instead.
func (Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 4, 2, 0}
}

// Request message of CreateTool.
type CreateToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project/location to create tool for. Format:
	// `projects/<Project ID>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The tool to create.
	Tool *Tool `protobuf:"bytes,2,opt,name=tool,proto3" json:"tool,omitempty"`
	// Optional. The ID to use for the tool, which will become the final
	// component of the tool's resource name.
	//
	// The tool ID must be compliant with the regression formula
	// `[a-zA-Z][a-zA-Z0-9_-]*` with the characters length in range of [3,64].
	// If the field is not provide, an Id will be auto-generated.
	// If the field is provided, the caller is responsible for
	// 1. the uniqueness of the ID, otherwise the request will be rejected.
	// 2. the consistency for whether to use custom ID or not under a project to
	// better ensure uniqueness.
	ToolId string `protobuf:"bytes,3,opt,name=tool_id,json=toolId,proto3" json:"tool_id,omitempty"`
}

func (x *CreateToolRequest) Reset() {
	*x = CreateToolRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateToolRequest) ProtoMessage() {}

func (x *CreateToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateToolRequest.ProtoReflect.Descriptor instead.
func (*CreateToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{0}
}

func (x *CreateToolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateToolRequest) GetTool() *Tool {
	if x != nil {
		return x.Tool
	}
	return nil
}

func (x *CreateToolRequest) GetToolId() string {
	if x != nil {
		return x.ToolId
	}
	return ""
}

// Request message of GetTool.
type GetToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The tool resource name to retrieve. Format:
	// `projects/<Project ID>/locations/<Location ID>/tools/<Tool ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetToolRequest) Reset() {
	*x = GetToolRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetToolRequest) ProtoMessage() {}

func (x *GetToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetToolRequest.ProtoReflect.Descriptor instead.
func (*GetToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{1}
}

func (x *GetToolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message of ListTools.
type ListToolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project/location to list tools for. Format:
	// `projects/<Project ID>/locations/<Location ID>`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Maximum number of conversation models to return in a single page.
	// Default to 10.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListToolsRequest) Reset() {
	*x = ListToolsRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListToolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListToolsRequest) ProtoMessage() {}

func (x *ListToolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListToolsRequest.ProtoReflect.Descriptor instead.
func (*ListToolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{2}
}

func (x *ListToolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListToolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListToolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response of ListTools.
type ListToolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of tools retrieved.
	Tools []*Tool `protobuf:"bytes,1,rep,name=tools,proto3" json:"tools,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListToolsResponse) Reset() {
	*x = ListToolsResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListToolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListToolsResponse) ProtoMessage() {}

func (x *ListToolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListToolsResponse.ProtoReflect.Descriptor instead.
func (*ListToolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{3}
}

func (x *ListToolsResponse) GetTools() []*Tool {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *ListToolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request of DeleteTool.
type DeleteToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The tool resource name to delete. Format:
	// `projects/<Project ID>/locations/<Location ID>/tools/<Tool ID>`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteToolRequest) Reset() {
	*x = DeleteToolRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteToolRequest) ProtoMessage() {}

func (x *DeleteToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteToolRequest.ProtoReflect.Descriptor instead.
func (*DeleteToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteToolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request of UpdateTool.
type UpdateToolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The tool to update.
	// The name field of tool is to identify the tool to
	// update.
	Tool *Tool `protobuf:"bytes,1,opt,name=tool,proto3" json:"tool,omitempty"`
	// Optional. The list of fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateToolRequest) Reset() {
	*x = UpdateToolRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateToolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateToolRequest) ProtoMessage() {}

func (x *UpdateToolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateToolRequest.ProtoReflect.Descriptor instead.
func (*UpdateToolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateToolRequest) GetTool() *Tool {
	if x != nil {
		return x.Tool
	}
	return nil
}

func (x *UpdateToolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Represents a tool.
type Tool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of the tool. Format:
	// `projects/<Project ID>/locations/<Location ID>/tools/<Tool ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. A human readable short name of the tool, which should be unique
	// within the project. It should only contain letters, numbers, and
	// underscores, and it will be used by LLM to identify the tool.
	ToolKey string `protobuf:"bytes,2,opt,name=tool_key,json=toolKey,proto3" json:"tool_key,omitempty"`
	// Optional. A human readable short name of the tool, to be shown on the UI.
	DisplayName string `protobuf:"bytes,19,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. A human readable description of the tool.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Confirmation requirement for the actions. Each key is an action
	// name in the action_schemas. If an action's confirmation requirement is
	// unspecified (either the key is not present, or its value is
	// CONFIRMATION_REQUIREMENT_UNSPECIFIED), the requirement is inferred from the
	// action's method_type - confirmation is not required if and only if
	// method_type is GET.
	ActionConfirmationRequirement map[string]Tool_ConfirmationRequirement `protobuf:"bytes,17,rep,name=action_confirmation_requirement,json=actionConfirmationRequirement,proto3" json:"action_confirmation_requirement,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=google.cloud.dialogflow.v2beta1.Tool_ConfirmationRequirement"`
	// Specification of the Tool.
	//
	// Types that are assignable to Specification:
	//
	//	*Tool_ExtensionSpec
	//	*Tool_FunctionSpec
	//	*Tool_ConnectorSpec
	//	*Tool_OpenApiSpec
	Specification isTool_Specification `protobuf_oneof:"specification"`
	// Output only. Creation time of this tool.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time of this tool.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. A read only boolean field reflecting Zone Separation
	// status of the tool. If the field is absent, it means the status is unknown.
	SatisfiesPzs *bool `protobuf:"varint,14,opt,name=satisfies_pzs,json=satisfiesPzs,proto3,oneof" json:"satisfies_pzs,omitempty"`
	// Output only. A read only boolean field reflecting Zone Isolation status
	// of the tool. If the field is absent, it means the status is unknown.
	SatisfiesPzi *bool `protobuf:"varint,15,opt,name=satisfies_pzi,json=satisfiesPzi,proto3,oneof" json:"satisfies_pzi,omitempty"`
}

func (x *Tool) Reset() {
	*x = Tool{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool) ProtoMessage() {}

func (x *Tool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool.ProtoReflect.Descriptor instead.
func (*Tool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6}
}

func (x *Tool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tool) GetToolKey() string {
	if x != nil {
		return x.ToolKey
	}
	return ""
}

func (x *Tool) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Tool) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Tool) GetActionConfirmationRequirement() map[string]Tool_ConfirmationRequirement {
	if x != nil {
		return x.ActionConfirmationRequirement
	}
	return nil
}

func (m *Tool) GetSpecification() isTool_Specification {
	if m != nil {
		return m.Specification
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/tool.proto.
func (x *Tool) GetExtensionSpec() *Tool_ExtensionTool {
	if x, ok := x.GetSpecification().(*Tool_ExtensionSpec); ok {
		return x.ExtensionSpec
	}
	return nil
}

func (x *Tool) GetFunctionSpec() *Tool_FunctionTool {
	if x, ok := x.GetSpecification().(*Tool_FunctionSpec); ok {
		return x.FunctionSpec
	}
	return nil
}

func (x *Tool) GetConnectorSpec() *Tool_ConnectorTool {
	if x, ok := x.GetSpecification().(*Tool_ConnectorSpec); ok {
		return x.ConnectorSpec
	}
	return nil
}

func (x *Tool) GetOpenApiSpec() *Tool_OpenApiTool {
	if x, ok := x.GetSpecification().(*Tool_OpenApiSpec); ok {
		return x.OpenApiSpec
	}
	return nil
}

func (x *Tool) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Tool) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Tool) GetSatisfiesPzs() bool {
	if x != nil && x.SatisfiesPzs != nil {
		return *x.SatisfiesPzs
	}
	return false
}

func (x *Tool) GetSatisfiesPzi() bool {
	if x != nil && x.SatisfiesPzi != nil {
		return *x.SatisfiesPzi
	}
	return false
}

type isTool_Specification interface {
	isTool_Specification()
}

type Tool_ExtensionSpec struct {
	// Vertex extension tool specification.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/tool.proto.
	ExtensionSpec *Tool_ExtensionTool `protobuf:"bytes,4,opt,name=extension_spec,json=extensionSpec,proto3,oneof"`
}

type Tool_FunctionSpec struct {
	// Client side executed function specification.
	FunctionSpec *Tool_FunctionTool `protobuf:"bytes,13,opt,name=function_spec,json=functionSpec,proto3,oneof"`
}

type Tool_ConnectorSpec struct {
	// Integration connectors tool specification.
	ConnectorSpec *Tool_ConnectorTool `protobuf:"bytes,18,opt,name=connector_spec,json=connectorSpec,proto3,oneof"`
}

type Tool_OpenApiSpec struct {
	// OpenAPI tool.
	OpenApiSpec *Tool_OpenApiTool `protobuf:"bytes,20,opt,name=open_api_spec,json=openApiSpec,proto3,oneof"`
}

func (*Tool_ExtensionSpec) isTool_Specification() {}

func (*Tool_FunctionSpec) isTool_Specification() {}

func (*Tool_ConnectorSpec) isTool_Specification() {}

func (*Tool_OpenApiSpec) isTool_Specification() {}

// An ExtensionTool is a way to use Vertex Extensions as a tool.
type Tool_ExtensionTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full name of the referenced vertex extension.
	// Format:
	// `projects/{project}/locations/{location}/extensions/{extension}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Tool_ExtensionTool) Reset() {
	*x = Tool_ExtensionTool{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_ExtensionTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_ExtensionTool) ProtoMessage() {}

func (x *Tool_ExtensionTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_ExtensionTool.ProtoReflect.Descriptor instead.
func (*Tool_ExtensionTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Tool_ExtensionTool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// A Function tool describes the functions to be invoked on the client side.
type Tool_FunctionTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The JSON schema is encapsulated in a
	// [google.protobuf.Struct][google.protobuf.Struct] to describe the input of
	// the function. This input is a JSON object that contains the function's
	// parameters as properties of the object.
	InputSchema *structpb.Struct `protobuf:"bytes,1,opt,name=input_schema,json=inputSchema,proto3" json:"input_schema,omitempty"`
	// Optional. The JSON schema is encapsulated in a
	// [google.protobuf.Struct][google.protobuf.Struct] to describe the output
	// of the function. This output is a JSON object that contains the
	// function's parameters as properties of the object.
	OutputSchema *structpb.Struct `protobuf:"bytes,2,opt,name=output_schema,json=outputSchema,proto3" json:"output_schema,omitempty"`
	// Optional. The method type of the function. If not specified, the default
	// value is GET.
	MethodType Tool_MethodType `protobuf:"varint,4,opt,name=method_type,json=methodType,proto3,enum=google.cloud.dialogflow.v2beta1.Tool_MethodType" json:"method_type,omitempty"`
}

func (x *Tool_FunctionTool) Reset() {
	*x = Tool_FunctionTool{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_FunctionTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_FunctionTool) ProtoMessage() {}

func (x *Tool_FunctionTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_FunctionTool.ProtoReflect.Descriptor instead.
func (*Tool_FunctionTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Tool_FunctionTool) GetInputSchema() *structpb.Struct {
	if x != nil {
		return x.InputSchema
	}
	return nil
}

func (x *Tool_FunctionTool) GetOutputSchema() *structpb.Struct {
	if x != nil {
		return x.OutputSchema
	}
	return nil
}

func (x *Tool_FunctionTool) GetMethodType() Tool_MethodType {
	if x != nil {
		return x.MethodType
	}
	return Tool_METHOD_TYPE_UNSPECIFIED
}

// An OpenAPI tool is a way to provide the Tool specifications in the Open API
// schema format.
type Tool_OpenApiTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Schema representation.
	//
	// Types that are assignable to Schema:
	//
	//	*Tool_OpenApiTool_TextSchema
	Schema isTool_OpenApiTool_Schema `protobuf_oneof:"schema"`
	// Optional. Authentication information required by the API.
	Authentication *Tool_Authentication `protobuf:"bytes,2,opt,name=authentication,proto3" json:"authentication,omitempty"`
	// Optional. TLS configuration for the HTTPS verification.
	TlsConfig *Tool_TLSConfig `protobuf:"bytes,3,opt,name=tls_config,json=tlsConfig,proto3" json:"tls_config,omitempty"`
	// Optional. Service Directory configuration.
	ServiceDirectoryConfig *Tool_ServiceDirectoryConfig `protobuf:"bytes,4,opt,name=service_directory_config,json=serviceDirectoryConfig,proto3" json:"service_directory_config,omitempty"`
}

func (x *Tool_OpenApiTool) Reset() {
	*x = Tool_OpenApiTool{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_OpenApiTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_OpenApiTool) ProtoMessage() {}

func (x *Tool_OpenApiTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_OpenApiTool.ProtoReflect.Descriptor instead.
func (*Tool_OpenApiTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 2}
}

func (m *Tool_OpenApiTool) GetSchema() isTool_OpenApiTool_Schema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (x *Tool_OpenApiTool) GetTextSchema() string {
	if x, ok := x.GetSchema().(*Tool_OpenApiTool_TextSchema); ok {
		return x.TextSchema
	}
	return ""
}

func (x *Tool_OpenApiTool) GetAuthentication() *Tool_Authentication {
	if x != nil {
		return x.Authentication
	}
	return nil
}

func (x *Tool_OpenApiTool) GetTlsConfig() *Tool_TLSConfig {
	if x != nil {
		return x.TlsConfig
	}
	return nil
}

func (x *Tool_OpenApiTool) GetServiceDirectoryConfig() *Tool_ServiceDirectoryConfig {
	if x != nil {
		return x.ServiceDirectoryConfig
	}
	return nil
}

type isTool_OpenApiTool_Schema interface {
	isTool_OpenApiTool_Schema()
}

type Tool_OpenApiTool_TextSchema struct {
	// Required. The OpenAPI schema specified as a text.
	TextSchema string `protobuf:"bytes,1,opt,name=text_schema,json=textSchema,proto3,oneof"`
}

func (*Tool_OpenApiTool_TextSchema) isTool_OpenApiTool_Schema() {}

// A ConnectorTool enabling using Integration Connectors Connections as tools.
type Tool_ConnectorTool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full resource name of the referenced Integration Connectors
	// Connection. Format: 'projects/*/locations/*/connections/*'
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Actions for the tool to use.
	Actions []*Tool_ConnectorTool_Action `protobuf:"bytes,2,rep,name=actions,proto3" json:"actions,omitempty"`
}

func (x *Tool_ConnectorTool) Reset() {
	*x = Tool_ConnectorTool{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_ConnectorTool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_ConnectorTool) ProtoMessage() {}

func (x *Tool_ConnectorTool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_ConnectorTool.ProtoReflect.Descriptor instead.
func (*Tool_ConnectorTool) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 3}
}

func (x *Tool_ConnectorTool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tool_ConnectorTool) GetActions() []*Tool_ConnectorTool_Action {
	if x != nil {
		return x.Actions
	}
	return nil
}

// Authentication information required for API calls
type Tool_Authentication struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The auth configuration.
	//
	// Types that are assignable to AuthConfig:
	//
	//	*Tool_Authentication_ApiKeyConfig_
	//	*Tool_Authentication_OauthConfig
	//	*Tool_Authentication_ServiceAgentAuthConfig_
	//	*Tool_Authentication_BearerTokenConfig_
	AuthConfig isTool_Authentication_AuthConfig `protobuf_oneof:"auth_config"`
}

func (x *Tool_Authentication) Reset() {
	*x = Tool_Authentication{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication) ProtoMessage() {}

func (x *Tool_Authentication) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication.ProtoReflect.Descriptor instead.
func (*Tool_Authentication) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 4}
}

func (m *Tool_Authentication) GetAuthConfig() isTool_Authentication_AuthConfig {
	if m != nil {
		return m.AuthConfig
	}
	return nil
}

func (x *Tool_Authentication) GetApiKeyConfig() *Tool_Authentication_ApiKeyConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_ApiKeyConfig_); ok {
		return x.ApiKeyConfig
	}
	return nil
}

func (x *Tool_Authentication) GetOauthConfig() *Tool_Authentication_OAuthConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_OauthConfig); ok {
		return x.OauthConfig
	}
	return nil
}

func (x *Tool_Authentication) GetServiceAgentAuthConfig() *Tool_Authentication_ServiceAgentAuthConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_ServiceAgentAuthConfig_); ok {
		return x.ServiceAgentAuthConfig
	}
	return nil
}

func (x *Tool_Authentication) GetBearerTokenConfig() *Tool_Authentication_BearerTokenConfig {
	if x, ok := x.GetAuthConfig().(*Tool_Authentication_BearerTokenConfig_); ok {
		return x.BearerTokenConfig
	}
	return nil
}

type isTool_Authentication_AuthConfig interface {
	isTool_Authentication_AuthConfig()
}

type Tool_Authentication_ApiKeyConfig_ struct {
	// Config for API key auth.
	ApiKeyConfig *Tool_Authentication_ApiKeyConfig `protobuf:"bytes,1,opt,name=api_key_config,json=apiKeyConfig,proto3,oneof"`
}

type Tool_Authentication_OauthConfig struct {
	// Config for OAuth.
	OauthConfig *Tool_Authentication_OAuthConfig `protobuf:"bytes,2,opt,name=oauth_config,json=oauthConfig,proto3,oneof"`
}

type Tool_Authentication_ServiceAgentAuthConfig_ struct {
	// Config for [Diglogflow service
	// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent)
	// auth.
	ServiceAgentAuthConfig *Tool_Authentication_ServiceAgentAuthConfig `protobuf:"bytes,3,opt,name=service_agent_auth_config,json=serviceAgentAuthConfig,proto3,oneof"`
}

type Tool_Authentication_BearerTokenConfig_ struct {
	// Config for bearer token auth.
	BearerTokenConfig *Tool_Authentication_BearerTokenConfig `protobuf:"bytes,4,opt,name=bearer_token_config,json=bearerTokenConfig,proto3,oneof"`
}

func (*Tool_Authentication_ApiKeyConfig_) isTool_Authentication_AuthConfig() {}

func (*Tool_Authentication_OauthConfig) isTool_Authentication_AuthConfig() {}

func (*Tool_Authentication_ServiceAgentAuthConfig_) isTool_Authentication_AuthConfig() {}

func (*Tool_Authentication_BearerTokenConfig_) isTool_Authentication_AuthConfig() {}

// The TLS configuration.
type Tool_TLSConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specifies a list of allowed custom CA certificates for HTTPS
	// verification.
	CaCerts []*Tool_TLSConfig_CACert `protobuf:"bytes,1,rep,name=ca_certs,json=caCerts,proto3" json:"ca_certs,omitempty"`
}

func (x *Tool_TLSConfig) Reset() {
	*x = Tool_TLSConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_TLSConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_TLSConfig) ProtoMessage() {}

func (x *Tool_TLSConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_TLSConfig.ProtoReflect.Descriptor instead.
func (*Tool_TLSConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 5}
}

func (x *Tool_TLSConfig) GetCaCerts() []*Tool_TLSConfig_CACert {
	if x != nil {
		return x.CaCerts
	}
	return nil
}

// Configuration for tools using Service Directory.
type Tool_ServiceDirectoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of [Service
	// Directory](https://cloud.google.com/service-directory) service.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/namespaces/<NamespaceID>/services/<ServiceID>`.
	// `LocationID` of the service directory must be the same as the location
	// of the tool.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
}

func (x *Tool_ServiceDirectoryConfig) Reset() {
	*x = Tool_ServiceDirectoryConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_ServiceDirectoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_ServiceDirectoryConfig) ProtoMessage() {}

func (x *Tool_ServiceDirectoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_ServiceDirectoryConfig.ProtoReflect.Descriptor instead.
func (*Tool_ServiceDirectoryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 6}
}

func (x *Tool_ServiceDirectoryConfig) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

// Configuration of a Connection operation for the tool to use.
type Tool_ConnectorTool_Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Specification for an action to configure for the tool to use.
	//
	// Types that are assignable to ActionSpec:
	//
	//	*Tool_ConnectorTool_Action_ConnectionActionId
	//	*Tool_ConnectorTool_Action_EntityOperation_
	ActionSpec isTool_ConnectorTool_Action_ActionSpec `protobuf_oneof:"action_spec"`
	// Optional. Entity fields to use as inputs for the operation.
	// If no fields are specified, all fields of the Entity will be used.
	InputFields []string `protobuf:"bytes,2,rep,name=input_fields,json=inputFields,proto3" json:"input_fields,omitempty"`
	// Optional. Entity fields to return from the operation.
	// If no fields are specified, all fields of the Entity will be returned.
	OutputFields []string `protobuf:"bytes,3,rep,name=output_fields,json=outputFields,proto3" json:"output_fields,omitempty"`
}

func (x *Tool_ConnectorTool_Action) Reset() {
	*x = Tool_ConnectorTool_Action{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_ConnectorTool_Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_ConnectorTool_Action) ProtoMessage() {}

func (x *Tool_ConnectorTool_Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_ConnectorTool_Action.ProtoReflect.Descriptor instead.
func (*Tool_ConnectorTool_Action) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 3, 0}
}

func (m *Tool_ConnectorTool_Action) GetActionSpec() isTool_ConnectorTool_Action_ActionSpec {
	if m != nil {
		return m.ActionSpec
	}
	return nil
}

func (x *Tool_ConnectorTool_Action) GetConnectionActionId() string {
	if x, ok := x.GetActionSpec().(*Tool_ConnectorTool_Action_ConnectionActionId); ok {
		return x.ConnectionActionId
	}
	return ""
}

func (x *Tool_ConnectorTool_Action) GetEntityOperation() *Tool_ConnectorTool_Action_EntityOperation {
	if x, ok := x.GetActionSpec().(*Tool_ConnectorTool_Action_EntityOperation_); ok {
		return x.EntityOperation
	}
	return nil
}

func (x *Tool_ConnectorTool_Action) GetInputFields() []string {
	if x != nil {
		return x.InputFields
	}
	return nil
}

func (x *Tool_ConnectorTool_Action) GetOutputFields() []string {
	if x != nil {
		return x.OutputFields
	}
	return nil
}

type isTool_ConnectorTool_Action_ActionSpec interface {
	isTool_ConnectorTool_Action_ActionSpec()
}

type Tool_ConnectorTool_Action_ConnectionActionId struct {
	// ID of a Connection action for the tool to use.
	ConnectionActionId string `protobuf:"bytes,4,opt,name=connection_action_id,json=connectionActionId,proto3,oneof"`
}

type Tool_ConnectorTool_Action_EntityOperation_ struct {
	// Entity operation configuration for the tool to use.
	EntityOperation *Tool_ConnectorTool_Action_EntityOperation `protobuf:"bytes,5,opt,name=entity_operation,json=entityOperation,proto3,oneof"`
}

func (*Tool_ConnectorTool_Action_ConnectionActionId) isTool_ConnectorTool_Action_ActionSpec() {}

func (*Tool_ConnectorTool_Action_EntityOperation_) isTool_ConnectorTool_Action_ActionSpec() {}

// Entity CRUD operation specification.
type Tool_ConnectorTool_Action_EntityOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. ID of the entity.
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Required. Operation to perform on the entity.
	Operation Tool_ConnectorTool_Action_EntityOperation_OperationType `protobuf:"varint,2,opt,name=operation,proto3,enum=google.cloud.dialogflow.v2beta1.Tool_ConnectorTool_Action_EntityOperation_OperationType" json:"operation,omitempty"`
}

func (x *Tool_ConnectorTool_Action_EntityOperation) Reset() {
	*x = Tool_ConnectorTool_Action_EntityOperation{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_ConnectorTool_Action_EntityOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_ConnectorTool_Action_EntityOperation) ProtoMessage() {}

func (x *Tool_ConnectorTool_Action_EntityOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_ConnectorTool_Action_EntityOperation.ProtoReflect.Descriptor instead.
func (*Tool_ConnectorTool_Action_EntityOperation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 3, 0, 0}
}

func (x *Tool_ConnectorTool_Action_EntityOperation) GetEntityId() string {
	if x != nil {
		return x.EntityId
	}
	return ""
}

func (x *Tool_ConnectorTool_Action_EntityOperation) GetOperation() Tool_ConnectorTool_Action_EntityOperation_OperationType {
	if x != nil {
		return x.Operation
	}
	return Tool_ConnectorTool_Action_EntityOperation_OPERATION_TYPE_UNSPECIFIED
}

// Config for authentication with API key.
type Tool_Authentication_ApiKeyConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parameter name or the header name of the API key.
	// E.g., If the API request is "https://example.com/act?X-Api-Key=<API
	// KEY>", "X-Api-Key" would be the parameter name.
	KeyName string `protobuf:"bytes,1,opt,name=key_name,json=keyName,proto3" json:"key_name,omitempty"`
	// Optional. The API key. If the `secret_version_for_api_key` field is
	// set, this field will be ignored.
	ApiKey string `protobuf:"bytes,2,opt,name=api_key,json=apiKey,proto3" json:"api_key,omitempty"`
	// Optional. The name of the SecretManager secret version resource storing
	// the API key. If this field is set, the `api_key` field will be ignored.
	// Format: `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForApiKey string `protobuf:"bytes,4,opt,name=secret_version_for_api_key,json=secretVersionForApiKey,proto3" json:"secret_version_for_api_key,omitempty"`
	// Required. Key location in the request.
	RequestLocation Tool_Authentication_RequestLocation `protobuf:"varint,3,opt,name=request_location,json=requestLocation,proto3,enum=google.cloud.dialogflow.v2beta1.Tool_Authentication_RequestLocation" json:"request_location,omitempty"`
}

func (x *Tool_Authentication_ApiKeyConfig) Reset() {
	*x = Tool_Authentication_ApiKeyConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication_ApiKeyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_ApiKeyConfig) ProtoMessage() {}

func (x *Tool_Authentication_ApiKeyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_ApiKeyConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_ApiKeyConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 4, 0}
}

func (x *Tool_Authentication_ApiKeyConfig) GetKeyName() string {
	if x != nil {
		return x.KeyName
	}
	return ""
}

func (x *Tool_Authentication_ApiKeyConfig) GetApiKey() string {
	if x != nil {
		return x.ApiKey
	}
	return ""
}

func (x *Tool_Authentication_ApiKeyConfig) GetSecretVersionForApiKey() string {
	if x != nil {
		return x.SecretVersionForApiKey
	}
	return ""
}

func (x *Tool_Authentication_ApiKeyConfig) GetRequestLocation() Tool_Authentication_RequestLocation {
	if x != nil {
		return x.RequestLocation
	}
	return Tool_Authentication_REQUEST_LOCATION_UNSPECIFIED
}

// Config for authentication with OAuth.
type Tool_Authentication_OAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. OAuth grant types.
	OauthGrantType Tool_Authentication_OAuthConfig_OauthGrantType `protobuf:"varint,1,opt,name=oauth_grant_type,json=oauthGrantType,proto3,enum=google.cloud.dialogflow.v2beta1.Tool_Authentication_OAuthConfig_OauthGrantType" json:"oauth_grant_type,omitempty"`
	// Required. The client ID from the OAuth provider.
	ClientId string `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Optional. The client secret from the OAuth provider. If the
	// `secret_version_for_client_secret` field is set, this field will be
	// ignored.
	ClientSecret string `protobuf:"bytes,3,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
	// Optional. The name of the SecretManager secret version resource storing
	// the client secret. If this field is set, the `client_secret` field will
	// be ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForClientSecret string `protobuf:"bytes,6,opt,name=secret_version_for_client_secret,json=secretVersionForClientSecret,proto3" json:"secret_version_for_client_secret,omitempty"`
	// Required. The token endpoint in the OAuth provider to exchange for an
	// access token.
	TokenEndpoint string `protobuf:"bytes,4,opt,name=token_endpoint,json=tokenEndpoint,proto3" json:"token_endpoint,omitempty"`
	// Optional. The OAuth scopes to grant.
	Scopes []string `protobuf:"bytes,5,rep,name=scopes,proto3" json:"scopes,omitempty"`
}

func (x *Tool_Authentication_OAuthConfig) Reset() {
	*x = Tool_Authentication_OAuthConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication_OAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_OAuthConfig) ProtoMessage() {}

func (x *Tool_Authentication_OAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_OAuthConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_OAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 4, 1}
}

func (x *Tool_Authentication_OAuthConfig) GetOauthGrantType() Tool_Authentication_OAuthConfig_OauthGrantType {
	if x != nil {
		return x.OauthGrantType
	}
	return Tool_Authentication_OAuthConfig_OAUTH_GRANT_TYPE_UNSPECIFIED
}

func (x *Tool_Authentication_OAuthConfig) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetClientSecret() string {
	if x != nil {
		return x.ClientSecret
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetSecretVersionForClientSecret() string {
	if x != nil {
		return x.SecretVersionForClientSecret
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetTokenEndpoint() string {
	if x != nil {
		return x.TokenEndpoint
	}
	return ""
}

func (x *Tool_Authentication_OAuthConfig) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// Config for auth using [Dialogflow service
// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
type Tool_Authentication_ServiceAgentAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Indicate the auth token type generated from the [Diglogflow
	// service
	// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	// The generated token is sent in the Authorization header.
	ServiceAgentAuth Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth `protobuf:"varint,1,opt,name=service_agent_auth,json=serviceAgentAuth,proto3,enum=google.cloud.dialogflow.v2beta1.Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth" json:"service_agent_auth,omitempty"`
}

func (x *Tool_Authentication_ServiceAgentAuthConfig) Reset() {
	*x = Tool_Authentication_ServiceAgentAuthConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication_ServiceAgentAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_ServiceAgentAuthConfig) ProtoMessage() {}

func (x *Tool_Authentication_ServiceAgentAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_ServiceAgentAuthConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_ServiceAgentAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 4, 2}
}

func (x *Tool_Authentication_ServiceAgentAuthConfig) GetServiceAgentAuth() Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth {
	if x != nil {
		return x.ServiceAgentAuth
	}
	return Tool_Authentication_ServiceAgentAuthConfig_SERVICE_AGENT_AUTH_UNSPECIFIED
}

// Config for authentication using bearer token.
type Tool_Authentication_BearerTokenConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The text token appended to the text `Bearer` to the request
	// Authorization header.
	// [Session parameters
	// reference](https://cloud.google.com/dialogflow/cx/docs/concept/parameter#session-ref)
	// can be used to pass the token dynamically, e.g.
	// `$session.params.parameter-id`.
	Token string `protobuf:"bytes,1,opt,name=token,proto3" json:"token,omitempty"`
	// Optional. The name of the SecretManager secret version resource storing
	// the Bearer token. If this field is set, the `token` field will be
	// ignored. Format:
	// `projects/{project}/secrets/{secret}/versions/{version}`
	SecretVersionForToken string `protobuf:"bytes,2,opt,name=secret_version_for_token,json=secretVersionForToken,proto3" json:"secret_version_for_token,omitempty"`
}

func (x *Tool_Authentication_BearerTokenConfig) Reset() {
	*x = Tool_Authentication_BearerTokenConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_Authentication_BearerTokenConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_Authentication_BearerTokenConfig) ProtoMessage() {}

func (x *Tool_Authentication_BearerTokenConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_Authentication_BearerTokenConfig.ProtoReflect.Descriptor instead.
func (*Tool_Authentication_BearerTokenConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 4, 3}
}

func (x *Tool_Authentication_BearerTokenConfig) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *Tool_Authentication_BearerTokenConfig) GetSecretVersionForToken() string {
	if x != nil {
		return x.SecretVersionForToken
	}
	return ""
}

// The CA certificate.
type Tool_TLSConfig_CACert struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the allowed custom CA certificates. This
	// can be used to disambiguate the custom CA certificates.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The allowed custom CA certificates (in DER format) for
	// HTTPS verification. This overrides the default SSL trust store. If this
	// is empty or unspecified, Dialogflow will use Google's default trust
	// store to verify certificates. N.B. Make sure the HTTPS server
	// certificates are signed with "subject alt name". For instance a
	// certificate can be self-signed using the following command,
	// ```
	//
	//	openssl x509 -req -days 200 -in example.com.csr \
	//	  -signkey example.com.key \
	//	  -out example.com.crt \
	//	  -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
	//
	// ```
	Cert []byte `protobuf:"bytes,2,opt,name=cert,proto3" json:"cert,omitempty"`
}

func (x *Tool_TLSConfig_CACert) Reset() {
	*x = Tool_TLSConfig_CACert{}
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tool_TLSConfig_CACert) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tool_TLSConfig_CACert) ProtoMessage() {}

func (x *Tool_TLSConfig_CACert) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tool_TLSConfig_CACert.ProtoReflect.Descriptor instead.
func (*Tool_TLSConfig_CACert) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP(), []int{6, 5, 0}
}

func (x *Tool_TLSConfig_CACert) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Tool_TLSConfig_CACert) GetCert() []byte {
	if x != nil {
		return x.Cert
	}
	return nil
}

var File_google_cloud_dialogflow_v2beta1_tool_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2beta1_tool_proto_rawDesc = []byte{
	0x0a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb1,
	0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x1c, 0x0a, 0x07, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x74, 0x6f, 0x6f, 0x6c,
	0x49, 0x64, 0x22, 0x4c, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x98, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x78, 0x0a, 0x11, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x3b, 0x0a, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4f, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54,
	0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20,
	0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x04,
	0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xdf,
	0x25, 0x0a, 0x04, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x74, 0x6f, 0x6f, 0x6c,
	0x4b, 0x65, 0x79, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x95, 0x01, 0x0a, 0x1f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69,
	0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72,
	0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1d, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x60, 0x0a, 0x0e, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f, 0x6c, 0x42, 0x02, 0x18, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x65,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x59, 0x0a, 0x0d,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5c, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x54, 0x6f, 0x6f, 0x6c, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x53, 0x70, 0x65, 0x63, 0x12, 0x57, 0x0a, 0x0d, 0x6f, 0x70, 0x65, 0x6e, 0x5f, 0x61, 0x70,
	0x69, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x2e, 0x4f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x54, 0x6f, 0x6f, 0x6c, 0x48,
	0x00, 0x52, 0x0b, 0x6f, 0x70, 0x65, 0x6e, 0x41, 0x70, 0x69, 0x53, 0x70, 0x65, 0x63, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f,
	0x70, 0x7a, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x88, 0x01,
	0x01, 0x12, 0x2d, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70,
	0x7a, 0x69, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x02, 0x52,
	0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x88, 0x01, 0x01,
	0x1a, 0x28, 0x0a, 0x0d, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f,
	0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0xea, 0x01, 0x0a, 0x0c, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x3f, 0x0a, 0x0c, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x41, 0x0a, 0x0d,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12,
	0x56, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x4d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xf4, 0x02, 0x0a, 0x0b, 0x4f, 0x70, 0x65, 0x6e,
	0x41, 0x70, 0x69, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x26, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12,
	0x61, 0x0a, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41,
	0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0a, 0x74, 0x6c, 0x73, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x54, 0x4c,
	0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x74, 0x6c,
	0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7b, 0x0a, 0x18, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0xb7,
	0x05, 0x0a, 0x0d, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x6f, 0x6f, 0x6c,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x59, 0x0a, 0x07, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f,
	0x6c, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x6f, 0x6f, 0x6c, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0xb1, 0x04, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x32, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x77, 0x0a, 0x10, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x6f,
	0x6f, 0x6c, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0c,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x1a, 0x98,
	0x02, 0x0a, 0x0f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x09, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x49, 0x64, 0x12, 0x7b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x66, 0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49, 0x53, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03,
	0x47, 0x45, 0x54, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x10,
	0x03, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10, 0x04, 0x12, 0x0a, 0x0a,
	0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x05, 0x42, 0x0d, 0x0a, 0x0b, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x1a, 0x8d, 0x0e, 0x0a, 0x0e, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x0e, 0x61,
	0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65,
	0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x70, 0x69, 0x4b, 0x65, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00,
	0x52, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x88, 0x01,
	0x0a, 0x19, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00,
	0x52, 0x16, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x78, 0x0a, 0x13, 0x62, 0x65, 0x61, 0x72,
	0x65, 0x72, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x42, 0x65, 0x61, 0x72,
	0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52,
	0x11, 0x62, 0x65, 0x61, 0x72, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0xb2, 0x02, 0x0a, 0x0c, 0x41, 0x70, 0x69, 0x4b, 0x65, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x1e, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x1c, 0x0a, 0x07, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x70, 0x69, 0x4b, 0x65,
	0x79, 0x12, 0x6e, 0x0a, 0x1a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x61, 0x70, 0x69, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x6f, 0x72, 0x41, 0x70, 0x69, 0x4b, 0x65,
	0x79, 0x12, 0x74, 0x0a, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f,
	0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xe9, 0x03, 0x0a, 0x0b, 0x4f, 0x41, 0x75, 0x74,
	0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7e, 0x0a, 0x10, 0x6f, 0x61, 0x75, 0x74, 0x68,
	0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4f, 0x61, 0x75, 0x74, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6f, 0x61, 0x75, 0x74, 0x68, 0x47, 0x72,
	0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x12, 0x7a, 0x0a, 0x20, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x1c, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x46, 0x6f, 0x72, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x12,
	0x2a, 0x0a, 0x0e, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x73,
	0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x22, 0x49, 0x0a, 0x0e, 0x4f, 0x61, 0x75, 0x74,
	0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x20, 0x0a, 0x1c, 0x4f, 0x41,
	0x55, 0x54, 0x48, 0x5f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11,
	0x43, 0x4c, 0x49, 0x45, 0x4e, 0x54, 0x5f, 0x43, 0x52, 0x45, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x41,
	0x4c, 0x10, 0x01, 0x1a, 0x82, 0x02, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x8f,
	0x01, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x61, 0x75, 0x74, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f,
	0x6f, 0x6c, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68,
	0x22, 0x56, 0x0a, 0x10, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x41, 0x75, 0x74, 0x68, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x44, 0x5f, 0x54,
	0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53,
	0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x02, 0x1a, 0x9b, 0x01, 0x0a, 0x11, 0x42, 0x65, 0x61,
	0x72, 0x65, 0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x19,
	0x0a, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x6b, 0x0a, 0x18, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x6f, 0x72, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x15, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x46, 0x6f,
	0x72, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x51, 0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x51,
	0x55, 0x45, 0x53, 0x54, 0x5f, 0x4c, 0x4f, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x48,
	0x45, 0x41, 0x44, 0x45, 0x52, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x51, 0x55, 0x45, 0x52, 0x59,
	0x5f, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x42, 0x0d, 0x0a, 0x0b, 0x61, 0x75, 0x74,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xae, 0x01, 0x0a, 0x09, 0x54, 0x4c, 0x53,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x56, 0x0a, 0x08, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e,
	0x54, 0x4c, 0x53, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x41, 0x43, 0x65, 0x72, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x61, 0x43, 0x65, 0x72, 0x74, 0x73, 0x1a, 0x49,
	0x0a, 0x06, 0x43, 0x41, 0x43, 0x65, 0x72, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x63, 0x65, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x04, 0x63, 0x65, 0x72, 0x74, 0x1a, 0x63, 0x0a, 0x16, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x49, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x1a, 0x8f,
	0x01, 0x0a, 0x22, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x53, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x2e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x22, 0x63, 0x0a, 0x17, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x24, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x51, 0x55,
	0x49, 0x52, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x51, 0x55, 0x49, 0x52, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x4e, 0x4f, 0x54, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x49,
	0x52, 0x45, 0x44, 0x10, 0x02, 0x22, 0x5c, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x47, 0x45, 0x54, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x4f, 0x53,
	0x54, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x55, 0x54, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x50, 0x41, 0x54, 0x43,
	0x48, 0x10, 0x05, 0x3a, 0x66, 0xea, 0x41, 0x63, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x74, 0x6f, 0x6f, 0x6c, 0x7d, 0x2a, 0x05,
	0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x32, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x42, 0x0f, 0x0a, 0x0d, 0x73,
	0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x42, 0x10,
	0x0a, 0x0e, 0x5f, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69,
	0x32, 0xf2, 0x07, 0x0a, 0x05, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0xbb, 0x01, 0x0a, 0x0a, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x6f, 0x6f, 0x6c, 0x22, 0x52, 0xda, 0x41, 0x13, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x74, 0x6f, 0x6f, 0x6c, 0x2c, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x36, 0x3a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x22, 0x2e, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0xa0, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74,
	0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x22, 0x3d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x12, 0x2e, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xb3, 0x01, 0x0a, 0x09,
	0x4c, 0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x3f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x30, 0x12, 0x2e, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x12, 0x97, 0x01, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x3d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x2a, 0x2e, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbd, 0x01, 0x0a, 0x0a,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x22, 0x54, 0xda, 0x41, 0x10, 0x74, 0x6f, 0x6f, 0x6c, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b,
	0x3a, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x32, 0x33, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x78, 0xca, 0x41, 0x19,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x85, 0x02, 0xea, 0x41, 0x64, 0x0a, 0x2a, 0x73, 0x65, 0x63,
	0x72, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x63, 0x72,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x7d, 0x2f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x0a,
	0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x42, 0x09, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32, 0x42, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescData = file_google_cloud_dialogflow_v2beta1_tool_proto_rawDesc
)

func file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2beta1_tool_proto_rawDescData
}

var file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes = make([]protoimpl.MessageInfo, 22)
var file_google_cloud_dialogflow_v2beta1_tool_proto_goTypes = []any{
	(Tool_ConfirmationRequirement)(0),                                // 0: google.cloud.dialogflow.v2beta1.Tool.ConfirmationRequirement
	(Tool_MethodType)(0),                                             // 1: google.cloud.dialogflow.v2beta1.Tool.MethodType
	(Tool_ConnectorTool_Action_EntityOperation_OperationType)(0),     // 2: google.cloud.dialogflow.v2beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType
	(Tool_Authentication_RequestLocation)(0),                         // 3: google.cloud.dialogflow.v2beta1.Tool.Authentication.RequestLocation
	(Tool_Authentication_OAuthConfig_OauthGrantType)(0),              // 4: google.cloud.dialogflow.v2beta1.Tool.Authentication.OAuthConfig.OauthGrantType
	(Tool_Authentication_ServiceAgentAuthConfig_ServiceAgentAuth)(0), // 5: google.cloud.dialogflow.v2beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth
	(*CreateToolRequest)(nil),                                        // 6: google.cloud.dialogflow.v2beta1.CreateToolRequest
	(*GetToolRequest)(nil),                                           // 7: google.cloud.dialogflow.v2beta1.GetToolRequest
	(*ListToolsRequest)(nil),                                         // 8: google.cloud.dialogflow.v2beta1.ListToolsRequest
	(*ListToolsResponse)(nil),                                        // 9: google.cloud.dialogflow.v2beta1.ListToolsResponse
	(*DeleteToolRequest)(nil),                                        // 10: google.cloud.dialogflow.v2beta1.DeleteToolRequest
	(*UpdateToolRequest)(nil),                                        // 11: google.cloud.dialogflow.v2beta1.UpdateToolRequest
	(*Tool)(nil),                                                     // 12: google.cloud.dialogflow.v2beta1.Tool
	(*Tool_ExtensionTool)(nil),                                       // 13: google.cloud.dialogflow.v2beta1.Tool.ExtensionTool
	(*Tool_FunctionTool)(nil),                                        // 14: google.cloud.dialogflow.v2beta1.Tool.FunctionTool
	(*Tool_OpenApiTool)(nil),                                         // 15: google.cloud.dialogflow.v2beta1.Tool.OpenApiTool
	(*Tool_ConnectorTool)(nil),                                       // 16: google.cloud.dialogflow.v2beta1.Tool.ConnectorTool
	(*Tool_Authentication)(nil),                                      // 17: google.cloud.dialogflow.v2beta1.Tool.Authentication
	(*Tool_TLSConfig)(nil),                                           // 18: google.cloud.dialogflow.v2beta1.Tool.TLSConfig
	(*Tool_ServiceDirectoryConfig)(nil),                              // 19: google.cloud.dialogflow.v2beta1.Tool.ServiceDirectoryConfig
	nil,                                                              // 20: google.cloud.dialogflow.v2beta1.Tool.ActionConfirmationRequirementEntry
	(*Tool_ConnectorTool_Action)(nil),                                // 21: google.cloud.dialogflow.v2beta1.Tool.ConnectorTool.Action
	(*Tool_ConnectorTool_Action_EntityOperation)(nil),                // 22: google.cloud.dialogflow.v2beta1.Tool.ConnectorTool.Action.EntityOperation
	(*Tool_Authentication_ApiKeyConfig)(nil),                         // 23: google.cloud.dialogflow.v2beta1.Tool.Authentication.ApiKeyConfig
	(*Tool_Authentication_OAuthConfig)(nil),                          // 24: google.cloud.dialogflow.v2beta1.Tool.Authentication.OAuthConfig
	(*Tool_Authentication_ServiceAgentAuthConfig)(nil),               // 25: google.cloud.dialogflow.v2beta1.Tool.Authentication.ServiceAgentAuthConfig
	(*Tool_Authentication_BearerTokenConfig)(nil),                    // 26: google.cloud.dialogflow.v2beta1.Tool.Authentication.BearerTokenConfig
	(*Tool_TLSConfig_CACert)(nil),                                    // 27: google.cloud.dialogflow.v2beta1.Tool.TLSConfig.CACert
	(*fieldmaskpb.FieldMask)(nil),                                    // 28: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),                                    // 29: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                                          // 30: google.protobuf.Struct
	(*emptypb.Empty)(nil),                                            // 31: google.protobuf.Empty
}
var file_google_cloud_dialogflow_v2beta1_tool_proto_depIdxs = []int32{
	12, // 0: google.cloud.dialogflow.v2beta1.CreateToolRequest.tool:type_name -> google.cloud.dialogflow.v2beta1.Tool
	12, // 1: google.cloud.dialogflow.v2beta1.ListToolsResponse.tools:type_name -> google.cloud.dialogflow.v2beta1.Tool
	12, // 2: google.cloud.dialogflow.v2beta1.UpdateToolRequest.tool:type_name -> google.cloud.dialogflow.v2beta1.Tool
	28, // 3: google.cloud.dialogflow.v2beta1.UpdateToolRequest.update_mask:type_name -> google.protobuf.FieldMask
	20, // 4: google.cloud.dialogflow.v2beta1.Tool.action_confirmation_requirement:type_name -> google.cloud.dialogflow.v2beta1.Tool.ActionConfirmationRequirementEntry
	13, // 5: google.cloud.dialogflow.v2beta1.Tool.extension_spec:type_name -> google.cloud.dialogflow.v2beta1.Tool.ExtensionTool
	14, // 6: google.cloud.dialogflow.v2beta1.Tool.function_spec:type_name -> google.cloud.dialogflow.v2beta1.Tool.FunctionTool
	16, // 7: google.cloud.dialogflow.v2beta1.Tool.connector_spec:type_name -> google.cloud.dialogflow.v2beta1.Tool.ConnectorTool
	15, // 8: google.cloud.dialogflow.v2beta1.Tool.open_api_spec:type_name -> google.cloud.dialogflow.v2beta1.Tool.OpenApiTool
	29, // 9: google.cloud.dialogflow.v2beta1.Tool.create_time:type_name -> google.protobuf.Timestamp
	29, // 10: google.cloud.dialogflow.v2beta1.Tool.update_time:type_name -> google.protobuf.Timestamp
	30, // 11: google.cloud.dialogflow.v2beta1.Tool.FunctionTool.input_schema:type_name -> google.protobuf.Struct
	30, // 12: google.cloud.dialogflow.v2beta1.Tool.FunctionTool.output_schema:type_name -> google.protobuf.Struct
	1,  // 13: google.cloud.dialogflow.v2beta1.Tool.FunctionTool.method_type:type_name -> google.cloud.dialogflow.v2beta1.Tool.MethodType
	17, // 14: google.cloud.dialogflow.v2beta1.Tool.OpenApiTool.authentication:type_name -> google.cloud.dialogflow.v2beta1.Tool.Authentication
	18, // 15: google.cloud.dialogflow.v2beta1.Tool.OpenApiTool.tls_config:type_name -> google.cloud.dialogflow.v2beta1.Tool.TLSConfig
	19, // 16: google.cloud.dialogflow.v2beta1.Tool.OpenApiTool.service_directory_config:type_name -> google.cloud.dialogflow.v2beta1.Tool.ServiceDirectoryConfig
	21, // 17: google.cloud.dialogflow.v2beta1.Tool.ConnectorTool.actions:type_name -> google.cloud.dialogflow.v2beta1.Tool.ConnectorTool.Action
	23, // 18: google.cloud.dialogflow.v2beta1.Tool.Authentication.api_key_config:type_name -> google.cloud.dialogflow.v2beta1.Tool.Authentication.ApiKeyConfig
	24, // 19: google.cloud.dialogflow.v2beta1.Tool.Authentication.oauth_config:type_name -> google.cloud.dialogflow.v2beta1.Tool.Authentication.OAuthConfig
	25, // 20: google.cloud.dialogflow.v2beta1.Tool.Authentication.service_agent_auth_config:type_name -> google.cloud.dialogflow.v2beta1.Tool.Authentication.ServiceAgentAuthConfig
	26, // 21: google.cloud.dialogflow.v2beta1.Tool.Authentication.bearer_token_config:type_name -> google.cloud.dialogflow.v2beta1.Tool.Authentication.BearerTokenConfig
	27, // 22: google.cloud.dialogflow.v2beta1.Tool.TLSConfig.ca_certs:type_name -> google.cloud.dialogflow.v2beta1.Tool.TLSConfig.CACert
	0,  // 23: google.cloud.dialogflow.v2beta1.Tool.ActionConfirmationRequirementEntry.value:type_name -> google.cloud.dialogflow.v2beta1.Tool.ConfirmationRequirement
	22, // 24: google.cloud.dialogflow.v2beta1.Tool.ConnectorTool.Action.entity_operation:type_name -> google.cloud.dialogflow.v2beta1.Tool.ConnectorTool.Action.EntityOperation
	2,  // 25: google.cloud.dialogflow.v2beta1.Tool.ConnectorTool.Action.EntityOperation.operation:type_name -> google.cloud.dialogflow.v2beta1.Tool.ConnectorTool.Action.EntityOperation.OperationType
	3,  // 26: google.cloud.dialogflow.v2beta1.Tool.Authentication.ApiKeyConfig.request_location:type_name -> google.cloud.dialogflow.v2beta1.Tool.Authentication.RequestLocation
	4,  // 27: google.cloud.dialogflow.v2beta1.Tool.Authentication.OAuthConfig.oauth_grant_type:type_name -> google.cloud.dialogflow.v2beta1.Tool.Authentication.OAuthConfig.OauthGrantType
	5,  // 28: google.cloud.dialogflow.v2beta1.Tool.Authentication.ServiceAgentAuthConfig.service_agent_auth:type_name -> google.cloud.dialogflow.v2beta1.Tool.Authentication.ServiceAgentAuthConfig.ServiceAgentAuth
	6,  // 29: google.cloud.dialogflow.v2beta1.Tools.CreateTool:input_type -> google.cloud.dialogflow.v2beta1.CreateToolRequest
	7,  // 30: google.cloud.dialogflow.v2beta1.Tools.GetTool:input_type -> google.cloud.dialogflow.v2beta1.GetToolRequest
	8,  // 31: google.cloud.dialogflow.v2beta1.Tools.ListTools:input_type -> google.cloud.dialogflow.v2beta1.ListToolsRequest
	10, // 32: google.cloud.dialogflow.v2beta1.Tools.DeleteTool:input_type -> google.cloud.dialogflow.v2beta1.DeleteToolRequest
	11, // 33: google.cloud.dialogflow.v2beta1.Tools.UpdateTool:input_type -> google.cloud.dialogflow.v2beta1.UpdateToolRequest
	12, // 34: google.cloud.dialogflow.v2beta1.Tools.CreateTool:output_type -> google.cloud.dialogflow.v2beta1.Tool
	12, // 35: google.cloud.dialogflow.v2beta1.Tools.GetTool:output_type -> google.cloud.dialogflow.v2beta1.Tool
	9,  // 36: google.cloud.dialogflow.v2beta1.Tools.ListTools:output_type -> google.cloud.dialogflow.v2beta1.ListToolsResponse
	31, // 37: google.cloud.dialogflow.v2beta1.Tools.DeleteTool:output_type -> google.protobuf.Empty
	12, // 38: google.cloud.dialogflow.v2beta1.Tools.UpdateTool:output_type -> google.cloud.dialogflow.v2beta1.Tool
	34, // [34:39] is the sub-list for method output_type
	29, // [29:34] is the sub-list for method input_type
	29, // [29:29] is the sub-list for extension type_name
	29, // [29:29] is the sub-list for extension extendee
	0,  // [0:29] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2beta1_tool_proto_init() }
func file_google_cloud_dialogflow_v2beta1_tool_proto_init() {
	if File_google_cloud_dialogflow_v2beta1_tool_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[6].OneofWrappers = []any{
		(*Tool_ExtensionSpec)(nil),
		(*Tool_FunctionSpec)(nil),
		(*Tool_ConnectorSpec)(nil),
		(*Tool_OpenApiSpec)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[9].OneofWrappers = []any{
		(*Tool_OpenApiTool_TextSchema)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[11].OneofWrappers = []any{
		(*Tool_Authentication_ApiKeyConfig_)(nil),
		(*Tool_Authentication_OauthConfig)(nil),
		(*Tool_Authentication_ServiceAgentAuthConfig_)(nil),
		(*Tool_Authentication_BearerTokenConfig_)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes[15].OneofWrappers = []any{
		(*Tool_ConnectorTool_Action_ConnectionActionId)(nil),
		(*Tool_ConnectorTool_Action_EntityOperation_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2beta1_tool_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   22,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2beta1_tool_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2beta1_tool_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2beta1_tool_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2beta1_tool_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2beta1_tool_proto = out.File
	file_google_cloud_dialogflow_v2beta1_tool_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2beta1_tool_proto_goTypes = nil
	file_google_cloud_dialogflow_v2beta1_tool_proto_depIdxs = nil
}
