// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/v2beta1/participant.proto

package dialogflowpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Enumeration of the roles a participant can play in a conversation.
type Participant_Role int32

const (
	// Participant role not set.
	Participant_ROLE_UNSPECIFIED Participant_Role = 0
	// Participant is a human agent.
	Participant_HUMAN_AGENT Participant_Role = 1
	// Participant is an automated agent, such as a Dialogflow agent.
	Participant_AUTOMATED_AGENT Participant_Role = 2
	// Participant is an end user that has called or chatted with
	// Dialogflow services.
	Participant_END_USER Participant_Role = 3
)

// Enum value maps for Participant_Role.
var (
	Participant_Role_name = map[int32]string{
		0: "ROLE_UNSPECIFIED",
		1: "HUMAN_AGENT",
		2: "AUTOMATED_AGENT",
		3: "END_USER",
	}
	Participant_Role_value = map[string]int32{
		"ROLE_UNSPECIFIED": 0,
		"HUMAN_AGENT":      1,
		"AUTOMATED_AGENT":  2,
		"END_USER":         3,
	}
)

func (x Participant_Role) Enum() *Participant_Role {
	p := new(Participant_Role)
	*p = x
	return p
}

func (x Participant_Role) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Participant_Role) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes[0].Descriptor()
}

func (Participant_Role) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes[0]
}

func (x Participant_Role) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Participant_Role.Descriptor instead.
func (Participant_Role) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{0, 0}
}

// Represents different automated agent reply types.
type AutomatedAgentReply_AutomatedAgentReplyType int32

const (
	// Not specified. This should never happen.
	AutomatedAgentReply_AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED AutomatedAgentReply_AutomatedAgentReplyType = 0
	// Partial reply. e.g. Aggregated responses in a `Fulfillment` that enables
	// `return_partial_response` can be returned as partial reply.
	// WARNING: partial reply is not eligible for barge-in.
	AutomatedAgentReply_PARTIAL AutomatedAgentReply_AutomatedAgentReplyType = 1
	// Final reply.
	AutomatedAgentReply_FINAL AutomatedAgentReply_AutomatedAgentReplyType = 2
)

// Enum value maps for AutomatedAgentReply_AutomatedAgentReplyType.
var (
	AutomatedAgentReply_AutomatedAgentReplyType_name = map[int32]string{
		0: "AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED",
		1: "PARTIAL",
		2: "FINAL",
	}
	AutomatedAgentReply_AutomatedAgentReplyType_value = map[string]int32{
		"AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED": 0,
		"PARTIAL":                                1,
		"FINAL":                                  2,
	}
)

func (x AutomatedAgentReply_AutomatedAgentReplyType) Enum() *AutomatedAgentReply_AutomatedAgentReplyType {
	p := new(AutomatedAgentReply_AutomatedAgentReplyType)
	*p = x
	return p
}

func (x AutomatedAgentReply_AutomatedAgentReplyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutomatedAgentReply_AutomatedAgentReplyType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes[1].Descriptor()
}

func (AutomatedAgentReply_AutomatedAgentReplyType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes[1]
}

func (x AutomatedAgentReply_AutomatedAgentReplyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutomatedAgentReply_AutomatedAgentReplyType.Descriptor instead.
func (AutomatedAgentReply_AutomatedAgentReplyType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{9, 0}
}

// Indicate what type of action to take with the tool call.
type SuggestionInput_Action int32

const (
	// Action not specified.
	SuggestionInput_ACTION_UNSPECIFIED SuggestionInput_Action = 0
	// Indicates the user chooses to not make the tool call. It
	// is only applicable to tool calls that are waiting for user
	// confirmation.
	SuggestionInput_CANCEL SuggestionInput_Action = 1
	// Makes the tool call with provided parameters. This action is intended
	// for tool calls that only read but not write data.
	SuggestionInput_REVISE SuggestionInput_Action = 2
	// Makes the tool call with provided parameters. This action is intended
	// for tool calls that may write data.
	SuggestionInput_CONFIRM SuggestionInput_Action = 3
)

// Enum value maps for SuggestionInput_Action.
var (
	SuggestionInput_Action_name = map[int32]string{
		0: "ACTION_UNSPECIFIED",
		1: "CANCEL",
		2: "REVISE",
		3: "CONFIRM",
	}
	SuggestionInput_Action_value = map[string]int32{
		"ACTION_UNSPECIFIED": 0,
		"CANCEL":             1,
		"REVISE":             2,
		"CONFIRM":            3,
	}
)

func (x SuggestionInput_Action) Enum() *SuggestionInput_Action {
	p := new(SuggestionInput_Action)
	*p = x
	return p
}

func (x SuggestionInput_Action) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SuggestionInput_Action) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes[2].Descriptor()
}

func (SuggestionInput_Action) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes[2]
}

func (x SuggestionInput_Action) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SuggestionInput_Action.Descriptor instead.
func (SuggestionInput_Action) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{10, 0}
}

// Defines the type of Human Agent Assistant feature.
type SuggestionFeature_Type int32

const (
	// Unspecified feature type.
	SuggestionFeature_TYPE_UNSPECIFIED SuggestionFeature_Type = 0
	// Run article suggestion model for chat.
	SuggestionFeature_ARTICLE_SUGGESTION SuggestionFeature_Type = 1
	// Run FAQ model.
	SuggestionFeature_FAQ SuggestionFeature_Type = 2
	// Run smart reply model for chat.
	SuggestionFeature_SMART_REPLY SuggestionFeature_Type = 3
	// Run Dialogflow assist model for chat, which will return automated agent
	// response as suggestion.
	SuggestionFeature_DIALOGFLOW_ASSIST SuggestionFeature_Type = 4
	// Run conversation summarization model for chat.
	SuggestionFeature_CONVERSATION_SUMMARIZATION SuggestionFeature_Type = 8
	// Run knowledge search with text input from agent or text generated query.
	SuggestionFeature_KNOWLEDGE_SEARCH SuggestionFeature_Type = 14
	// Run knowledge assist with automatic query generation.
	SuggestionFeature_KNOWLEDGE_ASSIST SuggestionFeature_Type = 15
)

// Enum value maps for SuggestionFeature_Type.
var (
	SuggestionFeature_Type_name = map[int32]string{
		0:  "TYPE_UNSPECIFIED",
		1:  "ARTICLE_SUGGESTION",
		2:  "FAQ",
		3:  "SMART_REPLY",
		4:  "DIALOGFLOW_ASSIST",
		8:  "CONVERSATION_SUMMARIZATION",
		14: "KNOWLEDGE_SEARCH",
		15: "KNOWLEDGE_ASSIST",
	}
	SuggestionFeature_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":           0,
		"ARTICLE_SUGGESTION":         1,
		"FAQ":                        2,
		"SMART_REPLY":                3,
		"DIALOGFLOW_ASSIST":          4,
		"CONVERSATION_SUMMARIZATION": 8,
		"KNOWLEDGE_SEARCH":           14,
		"KNOWLEDGE_ASSIST":           15,
	}
)

func (x SuggestionFeature_Type) Enum() *SuggestionFeature_Type {
	p := new(SuggestionFeature_Type)
	*p = x
	return p
}

func (x SuggestionFeature_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SuggestionFeature_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes[3].Descriptor()
}

func (SuggestionFeature_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes[3]
}

func (x SuggestionFeature_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SuggestionFeature_Type.Descriptor instead.
func (SuggestionFeature_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{12, 0}
}

// Represents a conversation participant (human agent, virtual agent, end-user).
type Participant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of this participant.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. The role this participant plays in the conversation. This field
	// must be set during participant creation and is then immutable.
	Role Participant_Role `protobuf:"varint,2,opt,name=role,proto3,enum=google.cloud.dialogflow.v2beta1.Participant_Role" json:"role,omitempty"`
	// Optional. Obfuscated user id that should be associated with the created
	// participant.
	//
	// You can specify a user id as follows:
	//
	//  1. If you set this field in
	//     [CreateParticipantRequest][google.cloud.dialogflow.v2beta1.CreateParticipantRequest.participant]
	//     or
	//     [UpdateParticipantRequest][google.cloud.dialogflow.v2beta1.UpdateParticipantRequest.participant],
	//     Dialogflow adds the obfuscated user id with the participant.
	//
	//  2. If you set this field in
	//     [AnalyzeContent][google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.obfuscated_external_user_id]
	//     or
	//     [StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.obfuscated_external_user_id],
	//     Dialogflow will update
	//     [Participant.obfuscated_external_user_id][google.cloud.dialogflow.v2beta1.Participant.obfuscated_external_user_id].
	//
	// Dialogflow uses this user id for billing and measurement. If a user with
	// the same obfuscated_external_user_id is created in a later conversation,
	// Dialogflow will know it's the same user.
	//
	// Dialogflow also uses this user id for Agent Assist suggestion
	// personalization. For example, Dialogflow can use it to provide personalized
	// smart reply suggestions for this user.
	//
	// Note:
	//
	//   - Please never pass raw user ids to Dialogflow. Always obfuscate your user
	//     id first.
	//   - Dialogflow only accepts a UTF-8 encoded string, e.g., a hex digest of a
	//     hash function like SHA-512.
	//   - The length of the user id must be <= 256 characters.
	ObfuscatedExternalUserId string `protobuf:"bytes,7,opt,name=obfuscated_external_user_id,json=obfuscatedExternalUserId,proto3" json:"obfuscated_external_user_id,omitempty"`
	// Optional. Key-value filters on the metadata of documents returned by
	// article suggestion. If specified, article suggestion only returns suggested
	// documents that match all filters in their
	// [Document.metadata][google.cloud.dialogflow.v2beta1.Document.metadata].
	// Multiple values for a metadata key should be concatenated by comma. For
	// example, filters to match all documents that have 'US' or 'CA' in their
	// market metadata values and 'agent' in their user metadata values will be
	// ```
	//
	//	documents_metadata_filters {
	//	  key: "market"
	//	  value: "US,CA"
	//	}
	//
	//	documents_metadata_filters {
	//	  key: "user"
	//	  value: "agent"
	//	}
	//
	// ```
	DocumentsMetadataFilters map[string]string `protobuf:"bytes,8,rep,name=documents_metadata_filters,json=documentsMetadataFilters,proto3" json:"documents_metadata_filters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Participant) Reset() {
	*x = Participant{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Participant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Participant) ProtoMessage() {}

func (x *Participant) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Participant.ProtoReflect.Descriptor instead.
func (*Participant) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{0}
}

func (x *Participant) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Participant) GetRole() Participant_Role {
	if x != nil {
		return x.Role
	}
	return Participant_ROLE_UNSPECIFIED
}

func (x *Participant) GetObfuscatedExternalUserId() string {
	if x != nil {
		return x.ObfuscatedExternalUserId
	}
	return ""
}

func (x *Participant) GetDocumentsMetadataFilters() map[string]string {
	if x != nil {
		return x.DocumentsMetadataFilters
	}
	return nil
}

// Represents a message posted into a conversation.
type Message struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique identifier of the message.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The message content.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Optional. Automated agent responses.
	ResponseMessages []*ResponseMessage `protobuf:"bytes,11,rep,name=response_messages,json=responseMessages,proto3" json:"response_messages,omitempty"`
	// Optional. The message language.
	// This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
	// language tag. Example: "en-US".
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Output only. The participant that sends this message.
	Participant string `protobuf:"bytes,4,opt,name=participant,proto3" json:"participant,omitempty"`
	// Output only. The role of the participant.
	ParticipantRole Participant_Role `protobuf:"varint,5,opt,name=participant_role,json=participantRole,proto3,enum=google.cloud.dialogflow.v2beta1.Participant_Role" json:"participant_role,omitempty"`
	// Output only. The time when the message was created in Contact Center AI.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. The time when the message was sent. For voice messages, this is
	// the time when an utterance started.
	SendTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=send_time,json=sendTime,proto3" json:"send_time,omitempty"`
	// Output only. The annotation for the message.
	MessageAnnotation *MessageAnnotation `protobuf:"bytes,7,opt,name=message_annotation,json=messageAnnotation,proto3" json:"message_annotation,omitempty"`
	// Output only. The sentiment analysis result for the message.
	SentimentAnalysis *SentimentAnalysisResult `protobuf:"bytes,8,opt,name=sentiment_analysis,json=sentimentAnalysis,proto3" json:"sentiment_analysis,omitempty"`
}

func (x *Message) Reset() {
	*x = Message{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Message) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Message) ProtoMessage() {}

func (x *Message) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Message.ProtoReflect.Descriptor instead.
func (*Message) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{1}
}

func (x *Message) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Message) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

func (x *Message) GetResponseMessages() []*ResponseMessage {
	if x != nil {
		return x.ResponseMessages
	}
	return nil
}

func (x *Message) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Message) GetParticipant() string {
	if x != nil {
		return x.Participant
	}
	return ""
}

func (x *Message) GetParticipantRole() Participant_Role {
	if x != nil {
		return x.ParticipantRole
	}
	return Participant_ROLE_UNSPECIFIED
}

func (x *Message) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Message) GetSendTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SendTime
	}
	return nil
}

func (x *Message) GetMessageAnnotation() *MessageAnnotation {
	if x != nil {
		return x.MessageAnnotation
	}
	return nil
}

func (x *Message) GetSentimentAnalysis() *SentimentAnalysisResult {
	if x != nil {
		return x.SentimentAnalysis
	}
	return nil
}

// The request message for
// [Participants.CreateParticipant][google.cloud.dialogflow.v2beta1.Participants.CreateParticipant].
type CreateParticipantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource identifier of the conversation adding the participant.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The participant to create.
	Participant *Participant `protobuf:"bytes,2,opt,name=participant,proto3" json:"participant,omitempty"`
}

func (x *CreateParticipantRequest) Reset() {
	*x = CreateParticipantRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateParticipantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateParticipantRequest) ProtoMessage() {}

func (x *CreateParticipantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateParticipantRequest.ProtoReflect.Descriptor instead.
func (*CreateParticipantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{2}
}

func (x *CreateParticipantRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateParticipantRequest) GetParticipant() *Participant {
	if x != nil {
		return x.Participant
	}
	return nil
}

// The request message for
// [Participants.GetParticipant][google.cloud.dialogflow.v2beta1.Participants.GetParticipant].
type GetParticipantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant. Format:
	// `projects/<Project ID>/locations/<Location ID>/conversations/<Conversation
	// ID>/participants/<Participant ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetParticipantRequest) Reset() {
	*x = GetParticipantRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetParticipantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetParticipantRequest) ProtoMessage() {}

func (x *GetParticipantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetParticipantRequest.ProtoReflect.Descriptor instead.
func (*GetParticipantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{3}
}

func (x *GetParticipantRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Participants.ListParticipants][google.cloud.dialogflow.v2beta1.Participants.ListParticipants].
type ListParticipantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The conversation to list all participants from.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListParticipantsRequest) Reset() {
	*x = ListParticipantsRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListParticipantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantsRequest) ProtoMessage() {}

func (x *ListParticipantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantsRequest.ProtoReflect.Descriptor instead.
func (*ListParticipantsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{4}
}

func (x *ListParticipantsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListParticipantsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListParticipantsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Participants.ListParticipants][google.cloud.dialogflow.v2beta1.Participants.ListParticipants].
type ListParticipantsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of participants. There is a maximum number of items
	// returned based on the page_size field in the request.
	Participants []*Participant `protobuf:"bytes,1,rep,name=participants,proto3" json:"participants,omitempty"`
	// Token to retrieve the next page of results or empty if there are no
	// more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListParticipantsResponse) Reset() {
	*x = ListParticipantsResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListParticipantsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListParticipantsResponse) ProtoMessage() {}

func (x *ListParticipantsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListParticipantsResponse.ProtoReflect.Descriptor instead.
func (*ListParticipantsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{5}
}

func (x *ListParticipantsResponse) GetParticipants() []*Participant {
	if x != nil {
		return x.Participants
	}
	return nil
}

func (x *ListParticipantsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Participants.UpdateParticipant][google.cloud.dialogflow.v2beta1.Participants.UpdateParticipant].
type UpdateParticipantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The participant to update.
	Participant *Participant `protobuf:"bytes,1,opt,name=participant,proto3" json:"participant,omitempty"`
	// Required. The mask to specify which fields to update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateParticipantRequest) Reset() {
	*x = UpdateParticipantRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateParticipantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateParticipantRequest) ProtoMessage() {}

func (x *UpdateParticipantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateParticipantRequest.ProtoReflect.Descriptor instead.
func (*UpdateParticipantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateParticipantRequest) GetParticipant() *Participant {
	if x != nil {
		return x.Participant
	}
	return nil
}

func (x *UpdateParticipantRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Represents the natural language speech audio to be processed.
type AudioInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Instructs the speech recognizer how to process the speech audio.
	Config *InputAudioConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The natural language speech audio to be processed.
	// A single request can contain up to 2 minutes of speech audio data.
	// The transcribed text cannot contain more than 256 bytes for virtual agent
	// interactions.
	Audio []byte `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
}

func (x *AudioInput) Reset() {
	*x = AudioInput{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AudioInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AudioInput) ProtoMessage() {}

func (x *AudioInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AudioInput.ProtoReflect.Descriptor instead.
func (*AudioInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{7}
}

func (x *AudioInput) GetConfig() *InputAudioConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *AudioInput) GetAudio() []byte {
	if x != nil {
		return x.Audio
	}
	return nil
}

// Represents the natural language speech audio to be played to the end user.
type OutputAudio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Instructs the speech synthesizer how to generate the speech
	// audio.
	Config *OutputAudioConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// Required. The natural language speech audio.
	Audio []byte `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
}

func (x *OutputAudio) Reset() {
	*x = OutputAudio{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OutputAudio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OutputAudio) ProtoMessage() {}

func (x *OutputAudio) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OutputAudio.ProtoReflect.Descriptor instead.
func (*OutputAudio) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{8}
}

func (x *OutputAudio) GetConfig() *OutputAudioConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *OutputAudio) GetAudio() []byte {
	if x != nil {
		return x.Audio
	}
	return nil
}

// Represents a response from an automated agent.
type AutomatedAgentReply struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to Response:
	//
	//	*AutomatedAgentReply_DetectIntentResponse
	Response isAutomatedAgentReply_Response `protobuf_oneof:"response"`
	// Response messages from the automated agent.
	ResponseMessages []*ResponseMessage `protobuf:"bytes,3,rep,name=response_messages,json=responseMessages,proto3" json:"response_messages,omitempty"`
	// Info on the query match for the automated agent response.
	//
	// Types that are assignable to Match:
	//
	//	*AutomatedAgentReply_Intent
	//	*AutomatedAgentReply_Event
	Match isAutomatedAgentReply_Match `protobuf_oneof:"match"`
	// The confidence of the match. Values range from 0.0 (completely uncertain)
	// to 1.0 (completely certain).
	// This value is for informational purpose only and is only used to help match
	// the best intent within the classification threshold. This value may change
	// for the same end-user expression at any time due to a model retraining or
	// change in implementation.
	MatchConfidence float32 `protobuf:"fixed32,9,opt,name=match_confidence,json=matchConfidence,proto3" json:"match_confidence,omitempty"`
	// The collection of current parameters at the time of this response.
	Parameters *structpb.Struct `protobuf:"bytes,10,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// The collection of current Dialogflow CX agent session parameters at the
	// time of this response.
	// Deprecated: Use `parameters` instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/participant.proto.
	CxSessionParameters *structpb.Struct `protobuf:"bytes,6,opt,name=cx_session_parameters,json=cxSessionParameters,proto3" json:"cx_session_parameters,omitempty"`
	// AutomatedAgentReply type.
	AutomatedAgentReplyType AutomatedAgentReply_AutomatedAgentReplyType `protobuf:"varint,7,opt,name=automated_agent_reply_type,json=automatedAgentReplyType,proto3,enum=google.cloud.dialogflow.v2beta1.AutomatedAgentReply_AutomatedAgentReplyType" json:"automated_agent_reply_type,omitempty"`
	// Indicates whether the partial automated agent reply is interruptible when a
	// later reply message arrives. e.g. if the agent specified some music as
	// partial response, it can be cancelled.
	AllowCancellation bool `protobuf:"varint,8,opt,name=allow_cancellation,json=allowCancellation,proto3" json:"allow_cancellation,omitempty"`
	// The unique identifier of the current Dialogflow CX conversation page.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/pages/<Page ID>`.
	CxCurrentPage string `protobuf:"bytes,11,opt,name=cx_current_page,json=cxCurrentPage,proto3" json:"cx_current_page,omitempty"`
	// The auth code for accessing Call Companion UI.
	CallCompanionAuthCode []byte `protobuf:"bytes,12,opt,name=call_companion_auth_code,json=callCompanionAuthCode,proto3" json:"call_companion_auth_code,omitempty"`
}

func (x *AutomatedAgentReply) Reset() {
	*x = AutomatedAgentReply{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutomatedAgentReply) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutomatedAgentReply) ProtoMessage() {}

func (x *AutomatedAgentReply) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutomatedAgentReply.ProtoReflect.Descriptor instead.
func (*AutomatedAgentReply) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{9}
}

func (m *AutomatedAgentReply) GetResponse() isAutomatedAgentReply_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *AutomatedAgentReply) GetDetectIntentResponse() *DetectIntentResponse {
	if x, ok := x.GetResponse().(*AutomatedAgentReply_DetectIntentResponse); ok {
		return x.DetectIntentResponse
	}
	return nil
}

func (x *AutomatedAgentReply) GetResponseMessages() []*ResponseMessage {
	if x != nil {
		return x.ResponseMessages
	}
	return nil
}

func (m *AutomatedAgentReply) GetMatch() isAutomatedAgentReply_Match {
	if m != nil {
		return m.Match
	}
	return nil
}

func (x *AutomatedAgentReply) GetIntent() string {
	if x, ok := x.GetMatch().(*AutomatedAgentReply_Intent); ok {
		return x.Intent
	}
	return ""
}

func (x *AutomatedAgentReply) GetEvent() string {
	if x, ok := x.GetMatch().(*AutomatedAgentReply_Event); ok {
		return x.Event
	}
	return ""
}

func (x *AutomatedAgentReply) GetMatchConfidence() float32 {
	if x != nil {
		return x.MatchConfidence
	}
	return 0
}

func (x *AutomatedAgentReply) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/participant.proto.
func (x *AutomatedAgentReply) GetCxSessionParameters() *structpb.Struct {
	if x != nil {
		return x.CxSessionParameters
	}
	return nil
}

func (x *AutomatedAgentReply) GetAutomatedAgentReplyType() AutomatedAgentReply_AutomatedAgentReplyType {
	if x != nil {
		return x.AutomatedAgentReplyType
	}
	return AutomatedAgentReply_AUTOMATED_AGENT_REPLY_TYPE_UNSPECIFIED
}

func (x *AutomatedAgentReply) GetAllowCancellation() bool {
	if x != nil {
		return x.AllowCancellation
	}
	return false
}

func (x *AutomatedAgentReply) GetCxCurrentPage() string {
	if x != nil {
		return x.CxCurrentPage
	}
	return ""
}

func (x *AutomatedAgentReply) GetCallCompanionAuthCode() []byte {
	if x != nil {
		return x.CallCompanionAuthCode
	}
	return nil
}

type isAutomatedAgentReply_Response interface {
	isAutomatedAgentReply_Response()
}

type AutomatedAgentReply_DetectIntentResponse struct {
	// Response of the Dialogflow
	// [Sessions.DetectIntent][google.cloud.dialogflow.v2beta1.Sessions.DetectIntent]
	// call.
	DetectIntentResponse *DetectIntentResponse `protobuf:"bytes,1,opt,name=detect_intent_response,json=detectIntentResponse,proto3,oneof"`
}

func (*AutomatedAgentReply_DetectIntentResponse) isAutomatedAgentReply_Response() {}

type isAutomatedAgentReply_Match interface {
	isAutomatedAgentReply_Match()
}

type AutomatedAgentReply_Intent struct {
	// Name of the intent if an intent is matched for the query.
	// For a V2 query, the value format is `projects/<Project ID>/locations/
	// <Location ID>/agent/intents/<Intent ID>`.
	// For a V3 query, the value format is `projects/<Project ID>/locations/
	// <Location ID>/agents/<Agent ID>/intents/<Intent ID>`.
	Intent string `protobuf:"bytes,4,opt,name=intent,proto3,oneof"`
}

type AutomatedAgentReply_Event struct {
	// Event name if an event is triggered for the query.
	Event string `protobuf:"bytes,5,opt,name=event,proto3,oneof"`
}

func (*AutomatedAgentReply_Intent) isAutomatedAgentReply_Match() {}

func (*AutomatedAgentReply_Event) isAutomatedAgentReply_Match() {}

// Represents the action to take for a tool call that requires confirmation.
type SuggestionInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Format: `projects/<Project ID>/locations/<Location
	// ID>/answerRecords/<Answer Record ID>`
	// The answer record associated with the tool call.
	AnswerRecord string `protobuf:"bytes,1,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
	// Optional. If the customer edited the suggestion before using it, include
	// the revised text here.
	TextOverride *TextInput `protobuf:"bytes,2,opt,name=text_override,json=textOverride,proto3" json:"text_override,omitempty"`
	// Parameters to be used for the tool call.  If not provided, the tool
	// will be called without any parameters.
	Parameters *structpb.Struct `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. The type of action to take with the tool.
	Action SuggestionInput_Action `protobuf:"varint,5,opt,name=action,proto3,enum=google.cloud.dialogflow.v2beta1.SuggestionInput_Action" json:"action,omitempty"`
	// The intent to be triggered on V3 agent.
	IntentInput *IntentInput `protobuf:"bytes,6,opt,name=intent_input,json=intentInput,proto3" json:"intent_input,omitempty"`
	// Optional. Time when the current suggest input is sent. For tool calls, this
	// timestamp (along with the answer record) will be included in the
	// corresponding tool call result so that it can be identified.
	SendTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=send_time,json=sendTime,proto3" json:"send_time,omitempty"`
}

func (x *SuggestionInput) Reset() {
	*x = SuggestionInput{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestionInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestionInput) ProtoMessage() {}

func (x *SuggestionInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestionInput.ProtoReflect.Descriptor instead.
func (*SuggestionInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{10}
}

func (x *SuggestionInput) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

func (x *SuggestionInput) GetTextOverride() *TextInput {
	if x != nil {
		return x.TextOverride
	}
	return nil
}

func (x *SuggestionInput) GetParameters() *structpb.Struct {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *SuggestionInput) GetAction() SuggestionInput_Action {
	if x != nil {
		return x.Action
	}
	return SuggestionInput_ACTION_UNSPECIFIED
}

func (x *SuggestionInput) GetIntentInput() *IntentInput {
	if x != nil {
		return x.IntentInput
	}
	return nil
}

func (x *SuggestionInput) GetSendTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SendTime
	}
	return nil
}

// Represents the intent to trigger programmatically rather than as a result of
// natural language processing. The intent input is only used for V3 agent.
type IntentInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the intent in V3 agent.
	// Format: `projects/<Project ID>/locations/<Location ID>/locations/<Location
	// ID>/agents/<Agent ID>/intents/<Intent ID>`.
	Intent string `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	// Required. The language of this conversational query. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *IntentInput) Reset() {
	*x = IntentInput{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntentInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentInput) ProtoMessage() {}

func (x *IntentInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentInput.ProtoReflect.Descriptor instead.
func (*IntentInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{11}
}

func (x *IntentInput) GetIntent() string {
	if x != nil {
		return x.Intent
	}
	return ""
}

func (x *IntentInput) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The type of Human Agent Assistant API suggestion to perform, and the maximum
// number of results to return for that type. Multiple `Feature` objects can
// be specified in the `features` list.
type SuggestionFeature struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of Human Agent Assistant API feature to request.
	Type SuggestionFeature_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.dialogflow.v2beta1.SuggestionFeature_Type" json:"type,omitempty"`
}

func (x *SuggestionFeature) Reset() {
	*x = SuggestionFeature{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestionFeature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestionFeature) ProtoMessage() {}

func (x *SuggestionFeature) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestionFeature.ProtoReflect.Descriptor instead.
func (*SuggestionFeature) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{12}
}

func (x *SuggestionFeature) GetType() SuggestionFeature_Type {
	if x != nil {
		return x.Type
	}
	return SuggestionFeature_TYPE_UNSPECIFIED
}

// Represents the parameters of human assist query.
type AssistQueryParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key-value filters on the metadata of documents returned by article
	// suggestion. If specified, article suggestion only returns suggested
	// documents that match all filters in their
	// [Document.metadata][google.cloud.dialogflow.v2beta1.Document.metadata].
	// Multiple values for a metadata key should be concatenated by comma. For
	// example, filters to match all documents that have 'US' or 'CA' in their
	// market metadata values and 'agent' in their user metadata values will be
	// ```
	//
	//	documents_metadata_filters {
	//	  key: "market"
	//	  value: "US,CA"
	//	}
	//
	//	documents_metadata_filters {
	//	  key: "user"
	//	  value: "agent"
	//	}
	//
	// ```
	DocumentsMetadataFilters map[string]string `protobuf:"bytes,1,rep,name=documents_metadata_filters,json=documentsMetadataFilters,proto3" json:"documents_metadata_filters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AssistQueryParameters) Reset() {
	*x = AssistQueryParameters{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AssistQueryParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AssistQueryParameters) ProtoMessage() {}

func (x *AssistQueryParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AssistQueryParameters.ProtoReflect.Descriptor instead.
func (*AssistQueryParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{13}
}

func (x *AssistQueryParameters) GetDocumentsMetadataFilters() map[string]string {
	if x != nil {
		return x.DocumentsMetadataFilters
	}
	return nil
}

// The request message for
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent].
type AnalyzeContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant this text comes from.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Participant string `protobuf:"bytes,1,opt,name=participant,proto3" json:"participant,omitempty"`
	// Required. The input content.
	//
	// Types that are assignable to Input:
	//
	//	*AnalyzeContentRequest_TextInput
	//	*AnalyzeContentRequest_AudioInput
	//	*AnalyzeContentRequest_EventInput
	//	*AnalyzeContentRequest_SuggestionInput
	//	*AnalyzeContentRequest_IntentInput
	Input isAnalyzeContentRequest_Input `protobuf_oneof:"input"`
	// Speech synthesis configuration.
	// The speech synthesis settings for a virtual agent that may be configured
	// for the associated conversation profile are not used when calling
	// AnalyzeContent. If this configuration is not supplied, speech synthesis
	// is disabled.
	ReplyAudioConfig *OutputAudioConfig `protobuf:"bytes,5,opt,name=reply_audio_config,json=replyAudioConfig,proto3" json:"reply_audio_config,omitempty"`
	// Parameters for a Dialogflow virtual-agent query.
	QueryParams *QueryParameters `protobuf:"bytes,9,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Parameters for a human assist query.
	AssistQueryParams *AssistQueryParameters `protobuf:"bytes,14,opt,name=assist_query_params,json=assistQueryParams,proto3" json:"assist_query_params,omitempty"`
	// Additional parameters to be put into Dialogflow CX session parameters. To
	// remove a parameter from the session, clients should explicitly set the
	// parameter value to null.
	//
	// Note: this field should only be used if you are connecting to a Dialogflow
	// CX agent.
	CxParameters *structpb.Struct `protobuf:"bytes,18,opt,name=cx_parameters,json=cxParameters,proto3" json:"cx_parameters,omitempty"`
	// The unique identifier of the Dialogflow CX page to override the
	// `current_page` in the session.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/pages/<Page ID>`.
	//
	// If `cx_current_page` is specified, the previous state of the session will
	// be ignored by Dialogflow CX, including the [previous
	// page][QueryResult.current_page] and the [previous session
	// parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
	// `cx_parameters` should be configured together to direct a session to a
	// specific state.
	//
	// Note: this field should only be used if you are connecting to a Dialogflow
	// CX agent.
	CxCurrentPage string `protobuf:"bytes,20,opt,name=cx_current_page,json=cxCurrentPage,proto3" json:"cx_current_page,omitempty"`
	// Optional. The send time of the message from end user or human agent's
	// perspective. It is used for identifying the same message under one
	// participant.
	//
	// For BatchCreateMessages API only:
	// Given two messages under the same participant:
	// * If send time are different regardless of whether the content of the
	// messages are exactly the same, the conversation will regard them as
	// two distinct messages sent by the participant.
	// * If send time is the same regardless of whether the content of the
	// messages are exactly the same, the conversation will regard them as
	// same message, and ignore the message received later.
	//
	// If the value is not provided, a new request will always be regarded as a
	// new message without any de-duplication.
	MessageSendTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=message_send_time,json=messageSendTime,proto3" json:"message_send_time,omitempty"`
	// A unique identifier for this request. Restricted to 36 ASCII characters.
	// A random UUID is recommended.
	// This request is only idempotent if a `request_id` is provided.
	RequestId string `protobuf:"bytes,11,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *AnalyzeContentRequest) Reset() {
	*x = AnalyzeContentRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnalyzeContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeContentRequest) ProtoMessage() {}

func (x *AnalyzeContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeContentRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeContentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{14}
}

func (x *AnalyzeContentRequest) GetParticipant() string {
	if x != nil {
		return x.Participant
	}
	return ""
}

func (m *AnalyzeContentRequest) GetInput() isAnalyzeContentRequest_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *AnalyzeContentRequest) GetTextInput() *TextInput {
	if x, ok := x.GetInput().(*AnalyzeContentRequest_TextInput); ok {
		return x.TextInput
	}
	return nil
}

func (x *AnalyzeContentRequest) GetAudioInput() *AudioInput {
	if x, ok := x.GetInput().(*AnalyzeContentRequest_AudioInput); ok {
		return x.AudioInput
	}
	return nil
}

func (x *AnalyzeContentRequest) GetEventInput() *EventInput {
	if x, ok := x.GetInput().(*AnalyzeContentRequest_EventInput); ok {
		return x.EventInput
	}
	return nil
}

func (x *AnalyzeContentRequest) GetSuggestionInput() *SuggestionInput {
	if x, ok := x.GetInput().(*AnalyzeContentRequest_SuggestionInput); ok {
		return x.SuggestionInput
	}
	return nil
}

func (x *AnalyzeContentRequest) GetIntentInput() *IntentInput {
	if x, ok := x.GetInput().(*AnalyzeContentRequest_IntentInput); ok {
		return x.IntentInput
	}
	return nil
}

func (x *AnalyzeContentRequest) GetReplyAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.ReplyAudioConfig
	}
	return nil
}

func (x *AnalyzeContentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *AnalyzeContentRequest) GetAssistQueryParams() *AssistQueryParameters {
	if x != nil {
		return x.AssistQueryParams
	}
	return nil
}

func (x *AnalyzeContentRequest) GetCxParameters() *structpb.Struct {
	if x != nil {
		return x.CxParameters
	}
	return nil
}

func (x *AnalyzeContentRequest) GetCxCurrentPage() string {
	if x != nil {
		return x.CxCurrentPage
	}
	return ""
}

func (x *AnalyzeContentRequest) GetMessageSendTime() *timestamppb.Timestamp {
	if x != nil {
		return x.MessageSendTime
	}
	return nil
}

func (x *AnalyzeContentRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

type isAnalyzeContentRequest_Input interface {
	isAnalyzeContentRequest_Input()
}

type AnalyzeContentRequest_TextInput struct {
	// The natural language text to be processed.
	TextInput *TextInput `protobuf:"bytes,6,opt,name=text_input,json=textInput,proto3,oneof"`
}

type AnalyzeContentRequest_AudioInput struct {
	// The natural language speech audio to be processed.
	AudioInput *AudioInput `protobuf:"bytes,7,opt,name=audio_input,json=audioInput,proto3,oneof"`
}

type AnalyzeContentRequest_EventInput struct {
	// An input event to send to Dialogflow.
	EventInput *EventInput `protobuf:"bytes,8,opt,name=event_input,json=eventInput,proto3,oneof"`
}

type AnalyzeContentRequest_SuggestionInput struct {
	// An input representing the selection of a suggestion.
	SuggestionInput *SuggestionInput `protobuf:"bytes,12,opt,name=suggestion_input,json=suggestionInput,proto3,oneof"`
}

type AnalyzeContentRequest_IntentInput struct {
	// The intent to be triggered on V3 agent.
	IntentInput *IntentInput `protobuf:"bytes,13,opt,name=intent_input,json=intentInput,proto3,oneof"`
}

func (*AnalyzeContentRequest_TextInput) isAnalyzeContentRequest_Input() {}

func (*AnalyzeContentRequest_AudioInput) isAnalyzeContentRequest_Input() {}

func (*AnalyzeContentRequest_EventInput) isAnalyzeContentRequest_Input() {}

func (*AnalyzeContentRequest_SuggestionInput) isAnalyzeContentRequest_Input() {}

func (*AnalyzeContentRequest_IntentInput) isAnalyzeContentRequest_Input() {}

// The message in the response that indicates the parameters of DTMF.
type DtmfParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether DTMF input can be handled in the next request.
	AcceptsDtmfInput bool `protobuf:"varint,1,opt,name=accepts_dtmf_input,json=acceptsDtmfInput,proto3" json:"accepts_dtmf_input,omitempty"`
}

func (x *DtmfParameters) Reset() {
	*x = DtmfParameters{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DtmfParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DtmfParameters) ProtoMessage() {}

func (x *DtmfParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DtmfParameters.ProtoReflect.Descriptor instead.
func (*DtmfParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{15}
}

func (x *DtmfParameters) GetAcceptsDtmfInput() bool {
	if x != nil {
		return x.AcceptsDtmfInput
	}
	return false
}

// The response message for
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent].
type AnalyzeContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The output text content.
	// This field is set if the automated agent responded with text to show to
	// the user.
	ReplyText string `protobuf:"bytes,1,opt,name=reply_text,json=replyText,proto3" json:"reply_text,omitempty"`
	// Optional. The audio data bytes encoded as specified in the request.
	// This field is set if:
	//
	//   - `reply_audio_config` was specified in the request, or
	//   - The automated agent responded with audio to play to the user. In such
	//     case, `reply_audio.config` contains settings used to synthesize the
	//     speech.
	//
	// In some scenarios, multiple output audio fields may be present in the
	// response structure. In these cases, only the top-most-level audio output
	// has content.
	ReplyAudio *OutputAudio `protobuf:"bytes,2,opt,name=reply_audio,json=replyAudio,proto3" json:"reply_audio,omitempty"`
	// Optional. Only set if a Dialogflow automated agent has responded.
	// Note that: [AutomatedAgentReply.detect_intent_response.output_audio][]
	// and [AutomatedAgentReply.detect_intent_response.output_audio_config][]
	// are always empty, use
	// [reply_audio][google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.reply_audio]
	// instead.
	AutomatedAgentReply *AutomatedAgentReply `protobuf:"bytes,3,opt,name=automated_agent_reply,json=automatedAgentReply,proto3" json:"automated_agent_reply,omitempty"`
	// Output only. Message analyzed by CCAI.
	Message *Message `protobuf:"bytes,5,opt,name=message,proto3" json:"message,omitempty"`
	// The suggestions for most recent human agent. The order is the same as
	// [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
	// of
	// [HumanAgentAssistantConfig.human_agent_suggestion_config][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.human_agent_suggestion_config].
	//
	// Note that any failure of Agent Assist features will not lead to the overall
	// failure of an AnalyzeContent API call. Instead, the features will
	// fail silently with the error field set in the corresponding
	// SuggestionResult.
	HumanAgentSuggestionResults []*SuggestionResult `protobuf:"bytes,6,rep,name=human_agent_suggestion_results,json=humanAgentSuggestionResults,proto3" json:"human_agent_suggestion_results,omitempty"`
	// The suggestions for end user. The order is the same as
	// [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
	// of
	// [HumanAgentAssistantConfig.end_user_suggestion_config][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.end_user_suggestion_config].
	//
	// Same as human_agent_suggestion_results, any failure of Agent Assist
	// features will not lead to the overall failure of an AnalyzeContent API
	// call. Instead, the features will fail silently with the error field set in
	// the corresponding SuggestionResult.
	EndUserSuggestionResults []*SuggestionResult `protobuf:"bytes,7,rep,name=end_user_suggestion_results,json=endUserSuggestionResults,proto3" json:"end_user_suggestion_results,omitempty"`
	// Indicates the parameters of DTMF.
	DtmfParameters *DtmfParameters `protobuf:"bytes,9,opt,name=dtmf_parameters,json=dtmfParameters,proto3" json:"dtmf_parameters,omitempty"`
}

func (x *AnalyzeContentResponse) Reset() {
	*x = AnalyzeContentResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnalyzeContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeContentResponse) ProtoMessage() {}

func (x *AnalyzeContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeContentResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeContentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{16}
}

func (x *AnalyzeContentResponse) GetReplyText() string {
	if x != nil {
		return x.ReplyText
	}
	return ""
}

func (x *AnalyzeContentResponse) GetReplyAudio() *OutputAudio {
	if x != nil {
		return x.ReplyAudio
	}
	return nil
}

func (x *AnalyzeContentResponse) GetAutomatedAgentReply() *AutomatedAgentReply {
	if x != nil {
		return x.AutomatedAgentReply
	}
	return nil
}

func (x *AnalyzeContentResponse) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *AnalyzeContentResponse) GetHumanAgentSuggestionResults() []*SuggestionResult {
	if x != nil {
		return x.HumanAgentSuggestionResults
	}
	return nil
}

func (x *AnalyzeContentResponse) GetEndUserSuggestionResults() []*SuggestionResult {
	if x != nil {
		return x.EndUserSuggestionResults
	}
	return nil
}

func (x *AnalyzeContentResponse) GetDtmfParameters() *DtmfParameters {
	if x != nil {
		return x.DtmfParameters
	}
	return nil
}

// Defines the language used in the input text.
type InputTextConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The language of this conversational query. See [Language
	// Support](https://cloud.google.com/dialogflow/docs/reference/language)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
}

func (x *InputTextConfig) Reset() {
	*x = InputTextConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InputTextConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InputTextConfig) ProtoMessage() {}

func (x *InputTextConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InputTextConfig.ProtoReflect.Descriptor instead.
func (*InputTextConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{17}
}

func (x *InputTextConfig) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

// The top-level message sent by the client to the
// [Participants.StreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent]
// method.
//
// Multiple request messages should be sent in order:
//
//  1. The first message must contain
//     [participant][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.participant],
//     [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
//     and optionally
//     [query_params][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.query_params].
//     If you want to receive an audio response, it should also contain
//     [reply_audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.reply_audio_config].
//     The message must not contain
//     [input][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input].
//
// 2.  If
// [config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
// in the first message
//
//	   was set to
//	   [audio_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.audio_config],
//	   all subsequent messages must contain
//	   [input_audio][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_audio]
//	   to continue with Speech recognition. If you decide to rather analyze text
//	   input after you already started Speech recognition, please send a message
//	   with
//	   [StreamingAnalyzeContentRequest.input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
//
//	   However, note that:
//
//	   * Dialogflow will bill you for the audio so far.
//	   * Dialogflow discards all Speech recognition results in favor of the
//	     text input.
//
//	3. If
//	[StreamingAnalyzeContentRequest.config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.config]
//	in the first message was set
//	  to
//	  [StreamingAnalyzeContentRequest.text_config][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.text_config],
//	  then the second message must contain only
//	  [input_text][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_text].
//	  Moreover, you must not send more than two messages.
//
//	After you sent all input, you must half-close or abort the request stream.
type StreamingAnalyzeContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant this text comes from.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Participant string `protobuf:"bytes,1,opt,name=participant,proto3" json:"participant,omitempty"`
	// Required. The input config.
	//
	// Types that are assignable to Config:
	//
	//	*StreamingAnalyzeContentRequest_AudioConfig
	//	*StreamingAnalyzeContentRequest_TextConfig
	Config isStreamingAnalyzeContentRequest_Config `protobuf_oneof:"config"`
	// Speech synthesis configuration.
	// The speech synthesis settings for a virtual agent that may be configured
	// for the associated conversation profile are not used when calling
	// StreamingAnalyzeContent. If this configuration is not supplied, speech
	// synthesis is disabled.
	ReplyAudioConfig *OutputAudioConfig `protobuf:"bytes,4,opt,name=reply_audio_config,json=replyAudioConfig,proto3" json:"reply_audio_config,omitempty"`
	// Required. The input.
	//
	// Types that are assignable to Input:
	//
	//	*StreamingAnalyzeContentRequest_InputAudio
	//	*StreamingAnalyzeContentRequest_InputText
	//	*StreamingAnalyzeContentRequest_InputDtmf
	//	*StreamingAnalyzeContentRequest_InputIntent
	//	*StreamingAnalyzeContentRequest_InputEvent
	Input isStreamingAnalyzeContentRequest_Input `protobuf_oneof:"input"`
	// Parameters for a Dialogflow virtual-agent query.
	QueryParams *QueryParameters `protobuf:"bytes,7,opt,name=query_params,json=queryParams,proto3" json:"query_params,omitempty"`
	// Parameters for a human assist query.
	AssistQueryParams *AssistQueryParameters `protobuf:"bytes,8,opt,name=assist_query_params,json=assistQueryParams,proto3" json:"assist_query_params,omitempty"`
	// Additional parameters to be put into Dialogflow CX session parameters. To
	// remove a parameter from the session, clients should explicitly set the
	// parameter value to null.
	//
	// Note: this field should only be used if you are connecting to a Dialogflow
	// CX agent.
	CxParameters *structpb.Struct `protobuf:"bytes,13,opt,name=cx_parameters,json=cxParameters,proto3" json:"cx_parameters,omitempty"`
	// The unique identifier of the Dialogflow CX page to override the
	// `current_page` in the session.
	// Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
	// ID>/flows/<Flow ID>/pages/<Page ID>`.
	//
	// If `cx_current_page` is specified, the previous state of the session will
	// be ignored by Dialogflow CX, including the [previous
	// page][QueryResult.current_page] and the [previous session
	// parameters][QueryResult.parameters]. In most cases, `cx_current_page` and
	// `cx_parameters` should be configured together to direct a session to a
	// specific state.
	//
	// Note: this field should only be used if you are connecting to a Dialogflow
	// CX agent.
	CxCurrentPage string `protobuf:"bytes,15,opt,name=cx_current_page,json=cxCurrentPage,proto3" json:"cx_current_page,omitempty"`
	// Optional. Enable full bidirectional streaming. You can keep streaming the
	// audio until timeout, and there's no need to half close the stream to get
	// the response.
	//
	// Restrictions:
	//
	// - Timeout: 3 mins.
	// - Audio Encoding: only supports
	// [AudioEncoding.AUDIO_ENCODING_LINEAR_16][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_LINEAR_16]
	// and
	// [AudioEncoding.AUDIO_ENCODING_MULAW][google.cloud.dialogflow.v2beta1.AudioEncoding.AUDIO_ENCODING_MULAW]
	//   - Lifecycle: conversation should be in `Assist Stage`, go to
	//     [Conversation.CreateConversation][] for more information.
	//
	// InvalidArgument Error will be returned if the one of restriction checks
	// failed.
	//
	// You can find more details in
	// https://cloud.google.com/agent-assist/docs/extended-streaming
	EnableExtendedStreaming bool `protobuf:"varint,11,opt,name=enable_extended_streaming,json=enableExtendedStreaming,proto3" json:"enable_extended_streaming,omitempty"`
	// Optional. Enable partial responses from Dialogflow CX agent. If this flag
	// is not enabled, response stream still contains only one final response even
	// if some `Fulfillment`s in Dialogflow CX agent have been configured to
	// return partial responses.
	EnablePartialAutomatedAgentReply bool `protobuf:"varint,12,opt,name=enable_partial_automated_agent_reply,json=enablePartialAutomatedAgentReply,proto3" json:"enable_partial_automated_agent_reply,omitempty"`
	// if true, `StreamingAnalyzeContentResponse.debugging_info` will get
	// populated.
	EnableDebuggingInfo bool `protobuf:"varint,19,opt,name=enable_debugging_info,json=enableDebuggingInfo,proto3" json:"enable_debugging_info,omitempty"`
}

func (x *StreamingAnalyzeContentRequest) Reset() {
	*x = StreamingAnalyzeContentRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingAnalyzeContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingAnalyzeContentRequest) ProtoMessage() {}

func (x *StreamingAnalyzeContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingAnalyzeContentRequest.ProtoReflect.Descriptor instead.
func (*StreamingAnalyzeContentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{18}
}

func (x *StreamingAnalyzeContentRequest) GetParticipant() string {
	if x != nil {
		return x.Participant
	}
	return ""
}

func (m *StreamingAnalyzeContentRequest) GetConfig() isStreamingAnalyzeContentRequest_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *StreamingAnalyzeContentRequest) GetAudioConfig() *InputAudioConfig {
	if x, ok := x.GetConfig().(*StreamingAnalyzeContentRequest_AudioConfig); ok {
		return x.AudioConfig
	}
	return nil
}

func (x *StreamingAnalyzeContentRequest) GetTextConfig() *InputTextConfig {
	if x, ok := x.GetConfig().(*StreamingAnalyzeContentRequest_TextConfig); ok {
		return x.TextConfig
	}
	return nil
}

func (x *StreamingAnalyzeContentRequest) GetReplyAudioConfig() *OutputAudioConfig {
	if x != nil {
		return x.ReplyAudioConfig
	}
	return nil
}

func (m *StreamingAnalyzeContentRequest) GetInput() isStreamingAnalyzeContentRequest_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *StreamingAnalyzeContentRequest) GetInputAudio() []byte {
	if x, ok := x.GetInput().(*StreamingAnalyzeContentRequest_InputAudio); ok {
		return x.InputAudio
	}
	return nil
}

func (x *StreamingAnalyzeContentRequest) GetInputText() string {
	if x, ok := x.GetInput().(*StreamingAnalyzeContentRequest_InputText); ok {
		return x.InputText
	}
	return ""
}

func (x *StreamingAnalyzeContentRequest) GetInputDtmf() *TelephonyDtmfEvents {
	if x, ok := x.GetInput().(*StreamingAnalyzeContentRequest_InputDtmf); ok {
		return x.InputDtmf
	}
	return nil
}

func (x *StreamingAnalyzeContentRequest) GetInputIntent() string {
	if x, ok := x.GetInput().(*StreamingAnalyzeContentRequest_InputIntent); ok {
		return x.InputIntent
	}
	return ""
}

func (x *StreamingAnalyzeContentRequest) GetInputEvent() string {
	if x, ok := x.GetInput().(*StreamingAnalyzeContentRequest_InputEvent); ok {
		return x.InputEvent
	}
	return ""
}

func (x *StreamingAnalyzeContentRequest) GetQueryParams() *QueryParameters {
	if x != nil {
		return x.QueryParams
	}
	return nil
}

func (x *StreamingAnalyzeContentRequest) GetAssistQueryParams() *AssistQueryParameters {
	if x != nil {
		return x.AssistQueryParams
	}
	return nil
}

func (x *StreamingAnalyzeContentRequest) GetCxParameters() *structpb.Struct {
	if x != nil {
		return x.CxParameters
	}
	return nil
}

func (x *StreamingAnalyzeContentRequest) GetCxCurrentPage() string {
	if x != nil {
		return x.CxCurrentPage
	}
	return ""
}

func (x *StreamingAnalyzeContentRequest) GetEnableExtendedStreaming() bool {
	if x != nil {
		return x.EnableExtendedStreaming
	}
	return false
}

func (x *StreamingAnalyzeContentRequest) GetEnablePartialAutomatedAgentReply() bool {
	if x != nil {
		return x.EnablePartialAutomatedAgentReply
	}
	return false
}

func (x *StreamingAnalyzeContentRequest) GetEnableDebuggingInfo() bool {
	if x != nil {
		return x.EnableDebuggingInfo
	}
	return false
}

type isStreamingAnalyzeContentRequest_Config interface {
	isStreamingAnalyzeContentRequest_Config()
}

type StreamingAnalyzeContentRequest_AudioConfig struct {
	// Instructs the speech recognizer how to process the speech audio.
	AudioConfig *InputAudioConfig `protobuf:"bytes,2,opt,name=audio_config,json=audioConfig,proto3,oneof"`
}

type StreamingAnalyzeContentRequest_TextConfig struct {
	// The natural language text to be processed.
	TextConfig *InputTextConfig `protobuf:"bytes,3,opt,name=text_config,json=textConfig,proto3,oneof"`
}

func (*StreamingAnalyzeContentRequest_AudioConfig) isStreamingAnalyzeContentRequest_Config() {}

func (*StreamingAnalyzeContentRequest_TextConfig) isStreamingAnalyzeContentRequest_Config() {}

type isStreamingAnalyzeContentRequest_Input interface {
	isStreamingAnalyzeContentRequest_Input()
}

type StreamingAnalyzeContentRequest_InputAudio struct {
	// The input audio content to be recognized. Must be sent if `audio_config`
	// is set in the first message. The complete audio over all streaming
	// messages must not exceed 1 minute.
	InputAudio []byte `protobuf:"bytes,5,opt,name=input_audio,json=inputAudio,proto3,oneof"`
}

type StreamingAnalyzeContentRequest_InputText struct {
	// The UTF-8 encoded natural language text to be processed. Must be sent if
	// `text_config` is set in the first message. Text length must not exceed
	// 256 bytes for virtual agent interactions. The `input_text` field can be
	// only sent once, and would cancel the speech recognition if any ongoing.
	InputText string `protobuf:"bytes,6,opt,name=input_text,json=inputText,proto3,oneof"`
}

type StreamingAnalyzeContentRequest_InputDtmf struct {
	// The DTMF digits used to invoke intent and fill in parameter value.
	//
	// This input is ignored if the previous response indicated that DTMF input
	// is not accepted.
	InputDtmf *TelephonyDtmfEvents `protobuf:"bytes,9,opt,name=input_dtmf,json=inputDtmf,proto3,oneof"`
}

type StreamingAnalyzeContentRequest_InputIntent struct {
	// The intent to be triggered on V3 agent.
	// Format: `projects/<Project ID>/locations/<Location ID>/locations/
	// <Location ID>/agents/<Agent ID>/intents/<Intent ID>`. This can only be
	// used to trigger the Welcome intent id if you are using text_config.
	InputIntent string `protobuf:"bytes,17,opt,name=input_intent,json=inputIntent,proto3,oneof"`
}

type StreamingAnalyzeContentRequest_InputEvent struct {
	// The input event name.
	// This can only be sent once and would cancel the ongoing speech
	// recognition if any. To trigger the Welcome intent use the event "WELCOME"
	InputEvent string `protobuf:"bytes,20,opt,name=input_event,json=inputEvent,proto3,oneof"`
}

func (*StreamingAnalyzeContentRequest_InputAudio) isStreamingAnalyzeContentRequest_Input() {}

func (*StreamingAnalyzeContentRequest_InputText) isStreamingAnalyzeContentRequest_Input() {}

func (*StreamingAnalyzeContentRequest_InputDtmf) isStreamingAnalyzeContentRequest_Input() {}

func (*StreamingAnalyzeContentRequest_InputIntent) isStreamingAnalyzeContentRequest_Input() {}

func (*StreamingAnalyzeContentRequest_InputEvent) isStreamingAnalyzeContentRequest_Input() {}

// The top-level message returned from the `StreamingAnalyzeContent` method.
//
// Multiple response messages can be returned in order:
//
//  1. If the input was set to streaming audio, the first one or more messages
//     contain `recognition_result`. Each `recognition_result` represents a more
//     complete transcript of what the user said. The last `recognition_result`
//     has `is_final` set to `true`.
//
//  2. In virtual agent stage: if `enable_partial_automated_agent_reply` is
//     true, the following N (currently 1 <= N <= 4) messages
//     contain `automated_agent_reply` and optionally `reply_audio`
//     returned by the virtual agent. The first (N-1)
//     `automated_agent_reply`s will have `automated_agent_reply_type` set to
//     `PARTIAL`. The last `automated_agent_reply` has
//     `automated_agent_reply_type` set to `FINAL`.
//     If `enable_partial_automated_agent_reply` is not enabled, response stream
//     only contains the final reply.
//
//     In human assist stage: the following N (N >= 1) messages contain
//     `human_agent_suggestion_results`, `end_user_suggestion_results` or
//     `message`.
type StreamingAnalyzeContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,1,opt,name=recognition_result,json=recognitionResult,proto3" json:"recognition_result,omitempty"`
	// Optional. The output text content.
	// This field is set if an automated agent responded with a text for the user.
	ReplyText string `protobuf:"bytes,2,opt,name=reply_text,json=replyText,proto3" json:"reply_text,omitempty"`
	// Optional. The audio data bytes encoded as specified in the request.
	// This field is set if:
	//
	//   - The `reply_audio_config` field is specified in the request.
	//   - The automated agent, which this output comes from, responded with audio.
	//     In such case, the `reply_audio.config` field contains settings used to
	//     synthesize the speech.
	//
	// In some scenarios, multiple output audio fields may be present in the
	// response structure. In these cases, only the top-most-level audio output
	// has content.
	ReplyAudio *OutputAudio `protobuf:"bytes,3,opt,name=reply_audio,json=replyAudio,proto3" json:"reply_audio,omitempty"`
	// Optional. Only set if a Dialogflow automated agent has responded.
	// Note that: [AutomatedAgentReply.detect_intent_response.output_audio][]
	// and [AutomatedAgentReply.detect_intent_response.output_audio_config][]
	// are always empty, use
	// [reply_audio][google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.reply_audio]
	// instead.
	AutomatedAgentReply *AutomatedAgentReply `protobuf:"bytes,4,opt,name=automated_agent_reply,json=automatedAgentReply,proto3" json:"automated_agent_reply,omitempty"`
	// Output only. Message analyzed by CCAI.
	Message *Message `protobuf:"bytes,6,opt,name=message,proto3" json:"message,omitempty"`
	// The suggestions for most recent human agent. The order is the same as
	// [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
	// of
	// [HumanAgentAssistantConfig.human_agent_suggestion_config][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.human_agent_suggestion_config].
	HumanAgentSuggestionResults []*SuggestionResult `protobuf:"bytes,7,rep,name=human_agent_suggestion_results,json=humanAgentSuggestionResults,proto3" json:"human_agent_suggestion_results,omitempty"`
	// The suggestions for end user. The order is the same as
	// [HumanAgentAssistantConfig.SuggestionConfig.feature_configs][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.SuggestionConfig.feature_configs]
	// of
	// [HumanAgentAssistantConfig.end_user_suggestion_config][google.cloud.dialogflow.v2beta1.HumanAgentAssistantConfig.end_user_suggestion_config].
	EndUserSuggestionResults []*SuggestionResult `protobuf:"bytes,8,rep,name=end_user_suggestion_results,json=endUserSuggestionResults,proto3" json:"end_user_suggestion_results,omitempty"`
	// Indicates the parameters of DTMF.
	DtmfParameters *DtmfParameters `protobuf:"bytes,10,opt,name=dtmf_parameters,json=dtmfParameters,proto3" json:"dtmf_parameters,omitempty"`
	// Debugging info that would get populated when
	// `StreamingAnalyzeContentRequest.enable_debugging_info` is set to true.
	DebuggingInfo *CloudConversationDebuggingInfo `protobuf:"bytes,11,opt,name=debugging_info,json=debuggingInfo,proto3" json:"debugging_info,omitempty"`
	// The name of the actual Cloud speech model used for speech recognition.
	SpeechModel string `protobuf:"bytes,13,opt,name=speech_model,json=speechModel,proto3" json:"speech_model,omitempty"`
}

func (x *StreamingAnalyzeContentResponse) Reset() {
	*x = StreamingAnalyzeContentResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingAnalyzeContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingAnalyzeContentResponse) ProtoMessage() {}

func (x *StreamingAnalyzeContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingAnalyzeContentResponse.ProtoReflect.Descriptor instead.
func (*StreamingAnalyzeContentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{19}
}

func (x *StreamingAnalyzeContentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if x != nil {
		return x.RecognitionResult
	}
	return nil
}

func (x *StreamingAnalyzeContentResponse) GetReplyText() string {
	if x != nil {
		return x.ReplyText
	}
	return ""
}

func (x *StreamingAnalyzeContentResponse) GetReplyAudio() *OutputAudio {
	if x != nil {
		return x.ReplyAudio
	}
	return nil
}

func (x *StreamingAnalyzeContentResponse) GetAutomatedAgentReply() *AutomatedAgentReply {
	if x != nil {
		return x.AutomatedAgentReply
	}
	return nil
}

func (x *StreamingAnalyzeContentResponse) GetMessage() *Message {
	if x != nil {
		return x.Message
	}
	return nil
}

func (x *StreamingAnalyzeContentResponse) GetHumanAgentSuggestionResults() []*SuggestionResult {
	if x != nil {
		return x.HumanAgentSuggestionResults
	}
	return nil
}

func (x *StreamingAnalyzeContentResponse) GetEndUserSuggestionResults() []*SuggestionResult {
	if x != nil {
		return x.EndUserSuggestionResults
	}
	return nil
}

func (x *StreamingAnalyzeContentResponse) GetDtmfParameters() *DtmfParameters {
	if x != nil {
		return x.DtmfParameters
	}
	return nil
}

func (x *StreamingAnalyzeContentResponse) GetDebuggingInfo() *CloudConversationDebuggingInfo {
	if x != nil {
		return x.DebuggingInfo
	}
	return nil
}

func (x *StreamingAnalyzeContentResponse) GetSpeechModel() string {
	if x != nil {
		return x.SpeechModel
	}
	return ""
}

// Represents a part of a message possibly annotated with an entity. The part
// can be an entity or purely a part of the message between two entities or
// message start/end.
type AnnotatedMessagePart struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A part of a message possibly annotated with an entity.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. The [Dialogflow system entity
	// type](https://cloud.google.com/dialogflow/docs/reference/system-entities)
	// of this message part. If this is empty, Dialogflow could not annotate the
	// phrase part with a system entity.
	EntityType string `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The [Dialogflow system entity formatted value
	// ](https://cloud.google.com/dialogflow/docs/reference/system-entities) of
	// this message part. For example for a system entity of type
	// `@sys.unit-currency`, this may contain:
	// <pre>
	//
	//	{
	//	  "amount": 5,
	//	  "currency": "USD"
	//	}
	//
	// </pre>
	FormattedValue *structpb.Value `protobuf:"bytes,3,opt,name=formatted_value,json=formattedValue,proto3" json:"formatted_value,omitempty"`
}

func (x *AnnotatedMessagePart) Reset() {
	*x = AnnotatedMessagePart{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AnnotatedMessagePart) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnnotatedMessagePart) ProtoMessage() {}

func (x *AnnotatedMessagePart) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnnotatedMessagePart.ProtoReflect.Descriptor instead.
func (*AnnotatedMessagePart) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{20}
}

func (x *AnnotatedMessagePart) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *AnnotatedMessagePart) GetEntityType() string {
	if x != nil {
		return x.EntityType
	}
	return ""
}

func (x *AnnotatedMessagePart) GetFormattedValue() *structpb.Value {
	if x != nil {
		return x.FormattedValue
	}
	return nil
}

// Represents the result of annotation for the message.
type MessageAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The collection of annotated message parts ordered by their
	// position in the message. You can recover the annotated message by
	// concatenating [AnnotatedMessagePart.text].
	Parts []*AnnotatedMessagePart `protobuf:"bytes,1,rep,name=parts,proto3" json:"parts,omitempty"`
	// Required. Indicates whether the text message contains entities.
	ContainEntities bool `protobuf:"varint,2,opt,name=contain_entities,json=containEntities,proto3" json:"contain_entities,omitempty"`
}

func (x *MessageAnnotation) Reset() {
	*x = MessageAnnotation{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MessageAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MessageAnnotation) ProtoMessage() {}

func (x *MessageAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MessageAnnotation.ProtoReflect.Descriptor instead.
func (*MessageAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{21}
}

func (x *MessageAnnotation) GetParts() []*AnnotatedMessagePart {
	if x != nil {
		return x.Parts
	}
	return nil
}

func (x *MessageAnnotation) GetContainEntities() bool {
	if x != nil {
		return x.ContainEntities
	}
	return false
}

// Represents article answer.
type ArticleAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The article title.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// The article URI.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Output only. Article snippets.
	Snippets []string `protobuf:"bytes,3,rep,name=snippets,proto3" json:"snippets,omitempty"`
	// A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of answer record, in the format of
	// "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
	// ID>"
	AnswerRecord string `protobuf:"bytes,6,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *ArticleAnswer) Reset() {
	*x = ArticleAnswer{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ArticleAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArticleAnswer) ProtoMessage() {}

func (x *ArticleAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArticleAnswer.ProtoReflect.Descriptor instead.
func (*ArticleAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{22}
}

func (x *ArticleAnswer) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *ArticleAnswer) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ArticleAnswer) GetSnippets() []string {
	if x != nil {
		return x.Snippets
	}
	return nil
}

func (x *ArticleAnswer) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ArticleAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// Represents answer from "frequently asked questions".
type FaqAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The piece of text from the `source` knowledge base document.
	Answer string `protobuf:"bytes,1,opt,name=answer,proto3" json:"answer,omitempty"`
	// The system's confidence score that this Knowledge answer is a good match
	// for this conversational query, range from 0.0 (completely uncertain)
	// to 1.0 (completely certain).
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The corresponding FAQ question.
	Question string `protobuf:"bytes,3,opt,name=question,proto3" json:"question,omitempty"`
	// Indicates which Knowledge Document this answer was extracted
	// from.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/agent/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`.
	Source string `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
	// A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The name of answer record, in the format of
	// "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
	// ID>"
	AnswerRecord string `protobuf:"bytes,6,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *FaqAnswer) Reset() {
	*x = FaqAnswer{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FaqAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FaqAnswer) ProtoMessage() {}

func (x *FaqAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FaqAnswer.ProtoReflect.Descriptor instead.
func (*FaqAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{23}
}

func (x *FaqAnswer) GetAnswer() string {
	if x != nil {
		return x.Answer
	}
	return ""
}

func (x *FaqAnswer) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *FaqAnswer) GetQuestion() string {
	if x != nil {
		return x.Question
	}
	return ""
}

func (x *FaqAnswer) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *FaqAnswer) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *FaqAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// Represents a smart reply answer.
type SmartReplyAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The content of the reply.
	Reply string `protobuf:"bytes,1,opt,name=reply,proto3" json:"reply,omitempty"`
	// Smart reply confidence.
	// The system's confidence score that this reply is a good match for
	// this conversation, as a value from 0.0 (completely uncertain) to 1.0
	// (completely certain).
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The name of answer record, in the format of
	// "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
	// ID>"
	AnswerRecord string `protobuf:"bytes,3,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *SmartReplyAnswer) Reset() {
	*x = SmartReplyAnswer{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SmartReplyAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SmartReplyAnswer) ProtoMessage() {}

func (x *SmartReplyAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SmartReplyAnswer.ProtoReflect.Descriptor instead.
func (*SmartReplyAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{24}
}

func (x *SmartReplyAnswer) GetReply() string {
	if x != nil {
		return x.Reply
	}
	return ""
}

func (x *SmartReplyAnswer) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *SmartReplyAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// Represents an intent suggestion.
type IntentSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The display name of the intent.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The name of the intent.
	//
	// Types that are assignable to Intent:
	//
	//	*IntentSuggestion_IntentV2
	Intent isIntentSuggestion_Intent `protobuf_oneof:"intent"`
	// Human readable description for better understanding an intent like its
	// scope, content, result etc. Maximum character limit: 140 characters.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *IntentSuggestion) Reset() {
	*x = IntentSuggestion{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *IntentSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IntentSuggestion) ProtoMessage() {}

func (x *IntentSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IntentSuggestion.ProtoReflect.Descriptor instead.
func (*IntentSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{25}
}

func (x *IntentSuggestion) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *IntentSuggestion) GetIntent() isIntentSuggestion_Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (x *IntentSuggestion) GetIntentV2() string {
	if x, ok := x.GetIntent().(*IntentSuggestion_IntentV2); ok {
		return x.IntentV2
	}
	return ""
}

func (x *IntentSuggestion) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

type isIntentSuggestion_Intent interface {
	isIntentSuggestion_Intent()
}

type IntentSuggestion_IntentV2 struct {
	// The unique identifier of this
	// [intent][google.cloud.dialogflow.v2beta1.Intent]. Format:
	// `projects/<Project ID>/locations/<Location ID>/agent/intents/<Intent
	// ID>`.
	IntentV2 string `protobuf:"bytes,2,opt,name=intent_v2,json=intentV2,proto3,oneof"`
}

func (*IntentSuggestion_IntentV2) isIntentSuggestion_Intent() {}

// Represents a Dialogflow assist answer.
type DialogflowAssistAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Result from DetectIntent for one matched intent.
	//
	// Types that are assignable to Result:
	//
	//	*DialogflowAssistAnswer_QueryResult
	//	*DialogflowAssistAnswer_IntentSuggestion
	Result isDialogflowAssistAnswer_Result `protobuf_oneof:"result"`
	// The name of answer record, in the format of
	// "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer Record
	// ID>"
	AnswerRecord string `protobuf:"bytes,2,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *DialogflowAssistAnswer) Reset() {
	*x = DialogflowAssistAnswer{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DialogflowAssistAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DialogflowAssistAnswer) ProtoMessage() {}

func (x *DialogflowAssistAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DialogflowAssistAnswer.ProtoReflect.Descriptor instead.
func (*DialogflowAssistAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{26}
}

func (m *DialogflowAssistAnswer) GetResult() isDialogflowAssistAnswer_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (x *DialogflowAssistAnswer) GetQueryResult() *QueryResult {
	if x, ok := x.GetResult().(*DialogflowAssistAnswer_QueryResult); ok {
		return x.QueryResult
	}
	return nil
}

func (x *DialogflowAssistAnswer) GetIntentSuggestion() *IntentSuggestion {
	if x, ok := x.GetResult().(*DialogflowAssistAnswer_IntentSuggestion); ok {
		return x.IntentSuggestion
	}
	return nil
}

func (x *DialogflowAssistAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

type isDialogflowAssistAnswer_Result interface {
	isDialogflowAssistAnswer_Result()
}

type DialogflowAssistAnswer_QueryResult struct {
	// Result from v2 agent.
	QueryResult *QueryResult `protobuf:"bytes,1,opt,name=query_result,json=queryResult,proto3,oneof"`
}

type DialogflowAssistAnswer_IntentSuggestion struct {
	// An intent suggestion generated from conversation.
	IntentSuggestion *IntentSuggestion `protobuf:"bytes,5,opt,name=intent_suggestion,json=intentSuggestion,proto3,oneof"`
}

func (*DialogflowAssistAnswer_QueryResult) isDialogflowAssistAnswer_Result() {}

func (*DialogflowAssistAnswer_IntentSuggestion) isDialogflowAssistAnswer_Result() {}

// One response of different type of suggestion response which is used in
// the response of
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent]
// and
// [Participants.AnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent],
// as well as
// [HumanAgentAssistantEvent][google.cloud.dialogflow.v2beta1.HumanAgentAssistantEvent].
type SuggestionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Different type of suggestion response.
	//
	// Types that are assignable to SuggestionResponse:
	//
	//	*SuggestionResult_Error
	//	*SuggestionResult_SuggestArticlesResponse
	//	*SuggestionResult_SuggestKnowledgeAssistResponse
	//	*SuggestionResult_SuggestFaqAnswersResponse
	//	*SuggestionResult_SuggestSmartRepliesResponse
	//	*SuggestionResult_SuggestDialogflowAssistsResponse
	//	*SuggestionResult_SuggestEntityExtractionResponse
	//	*SuggestionResult_GenerateSuggestionsResponse
	SuggestionResponse isSuggestionResult_SuggestionResponse `protobuf_oneof:"suggestion_response"`
}

func (x *SuggestionResult) Reset() {
	*x = SuggestionResult{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestionResult) ProtoMessage() {}

func (x *SuggestionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestionResult.ProtoReflect.Descriptor instead.
func (*SuggestionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{27}
}

func (m *SuggestionResult) GetSuggestionResponse() isSuggestionResult_SuggestionResponse {
	if m != nil {
		return m.SuggestionResponse
	}
	return nil
}

func (x *SuggestionResult) GetError() *status.Status {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_Error); ok {
		return x.Error
	}
	return nil
}

func (x *SuggestionResult) GetSuggestArticlesResponse() *SuggestArticlesResponse {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_SuggestArticlesResponse); ok {
		return x.SuggestArticlesResponse
	}
	return nil
}

func (x *SuggestionResult) GetSuggestKnowledgeAssistResponse() *SuggestKnowledgeAssistResponse {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_SuggestKnowledgeAssistResponse); ok {
		return x.SuggestKnowledgeAssistResponse
	}
	return nil
}

func (x *SuggestionResult) GetSuggestFaqAnswersResponse() *SuggestFaqAnswersResponse {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_SuggestFaqAnswersResponse); ok {
		return x.SuggestFaqAnswersResponse
	}
	return nil
}

func (x *SuggestionResult) GetSuggestSmartRepliesResponse() *SuggestSmartRepliesResponse {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_SuggestSmartRepliesResponse); ok {
		return x.SuggestSmartRepliesResponse
	}
	return nil
}

func (x *SuggestionResult) GetSuggestDialogflowAssistsResponse() *SuggestDialogflowAssistsResponse {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_SuggestDialogflowAssistsResponse); ok {
		return x.SuggestDialogflowAssistsResponse
	}
	return nil
}

func (x *SuggestionResult) GetSuggestEntityExtractionResponse() *SuggestDialogflowAssistsResponse {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_SuggestEntityExtractionResponse); ok {
		return x.SuggestEntityExtractionResponse
	}
	return nil
}

func (x *SuggestionResult) GetGenerateSuggestionsResponse() *GenerateSuggestionsResponse {
	if x, ok := x.GetSuggestionResponse().(*SuggestionResult_GenerateSuggestionsResponse); ok {
		return x.GenerateSuggestionsResponse
	}
	return nil
}

type isSuggestionResult_SuggestionResponse interface {
	isSuggestionResult_SuggestionResponse()
}

type SuggestionResult_Error struct {
	// Error status if the request failed.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3,oneof"`
}

type SuggestionResult_SuggestArticlesResponse struct {
	// SuggestArticlesResponse if request is for ARTICLE_SUGGESTION.
	SuggestArticlesResponse *SuggestArticlesResponse `protobuf:"bytes,2,opt,name=suggest_articles_response,json=suggestArticlesResponse,proto3,oneof"`
}

type SuggestionResult_SuggestKnowledgeAssistResponse struct {
	// SuggestKnowledgeAssistResponse if request is for KNOWLEDGE_ASSIST.
	SuggestKnowledgeAssistResponse *SuggestKnowledgeAssistResponse `protobuf:"bytes,8,opt,name=suggest_knowledge_assist_response,json=suggestKnowledgeAssistResponse,proto3,oneof"`
}

type SuggestionResult_SuggestFaqAnswersResponse struct {
	// SuggestFaqAnswersResponse if request is for FAQ_ANSWER.
	SuggestFaqAnswersResponse *SuggestFaqAnswersResponse `protobuf:"bytes,3,opt,name=suggest_faq_answers_response,json=suggestFaqAnswersResponse,proto3,oneof"`
}

type SuggestionResult_SuggestSmartRepliesResponse struct {
	// SuggestSmartRepliesResponse if request is for SMART_REPLY.
	SuggestSmartRepliesResponse *SuggestSmartRepliesResponse `protobuf:"bytes,4,opt,name=suggest_smart_replies_response,json=suggestSmartRepliesResponse,proto3,oneof"`
}

type SuggestionResult_SuggestDialogflowAssistsResponse struct {
	// SuggestDialogflowAssistsResponse if request is for DIALOGFLOW_ASSIST.
	SuggestDialogflowAssistsResponse *SuggestDialogflowAssistsResponse `protobuf:"bytes,5,opt,name=suggest_dialogflow_assists_response,json=suggestDialogflowAssistsResponse,proto3,oneof"`
}

type SuggestionResult_SuggestEntityExtractionResponse struct {
	// SuggestDialogflowAssistsResponse if request is for ENTITY_EXTRACTION.
	SuggestEntityExtractionResponse *SuggestDialogflowAssistsResponse `protobuf:"bytes,7,opt,name=suggest_entity_extraction_response,json=suggestEntityExtractionResponse,proto3,oneof"`
}

type SuggestionResult_GenerateSuggestionsResponse struct {
	// Suggestions generated using generators triggered by customer or agent
	// messages.
	GenerateSuggestionsResponse *GenerateSuggestionsResponse `protobuf:"bytes,9,opt,name=generate_suggestions_response,json=generateSuggestionsResponse,proto3,oneof"`
}

func (*SuggestionResult_Error) isSuggestionResult_SuggestionResponse() {}

func (*SuggestionResult_SuggestArticlesResponse) isSuggestionResult_SuggestionResponse() {}

func (*SuggestionResult_SuggestKnowledgeAssistResponse) isSuggestionResult_SuggestionResponse() {}

func (*SuggestionResult_SuggestFaqAnswersResponse) isSuggestionResult_SuggestionResponse() {}

func (*SuggestionResult_SuggestSmartRepliesResponse) isSuggestionResult_SuggestionResponse() {}

func (*SuggestionResult_SuggestDialogflowAssistsResponse) isSuggestionResult_SuggestionResponse() {}

func (*SuggestionResult_SuggestEntityExtractionResponse) isSuggestionResult_SuggestionResponse() {}

func (*SuggestionResult_GenerateSuggestionsResponse) isSuggestionResult_SuggestionResponse() {}

// The request message for
// [Participants.SuggestArticles][google.cloud.dialogflow.v2beta1.Participants.SuggestArticles].
type SuggestArticlesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant to fetch suggestion for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The name of the latest conversation message to compile suggestion
	// for. If empty, it will be the latest message of the conversation.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Optional. Max number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2beta1.SuggestArticlesRequest.latest_message]
	// to use as context when compiling the suggestion. By default 20 and at
	// most 50.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
	// Optional. Parameters for a human assist query.
	AssistQueryParams *AssistQueryParameters `protobuf:"bytes,4,opt,name=assist_query_params,json=assistQueryParams,proto3" json:"assist_query_params,omitempty"`
}

func (x *SuggestArticlesRequest) Reset() {
	*x = SuggestArticlesRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestArticlesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestArticlesRequest) ProtoMessage() {}

func (x *SuggestArticlesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestArticlesRequest.ProtoReflect.Descriptor instead.
func (*SuggestArticlesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{28}
}

func (x *SuggestArticlesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SuggestArticlesRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestArticlesRequest) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

func (x *SuggestArticlesRequest) GetAssistQueryParams() *AssistQueryParameters {
	if x != nil {
		return x.AssistQueryParams
	}
	return nil
}

// The response message for
// [Participants.SuggestArticles][google.cloud.dialogflow.v2beta1.Participants.SuggestArticles].
type SuggestArticlesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Articles ordered by score in descending order.
	ArticleAnswers []*ArticleAnswer `protobuf:"bytes,1,rep,name=article_answers,json=articleAnswers,proto3" json:"article_answers,omitempty"`
	// The name of the latest conversation message used to compile
	// suggestion for.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.latest_message]
	// to compile the suggestion. It may be smaller than the
	// [SuggestArticlesResponse.context_size][google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.context_size]
	// field in the request if there aren't that many messages in the
	// conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestArticlesResponse) Reset() {
	*x = SuggestArticlesResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestArticlesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestArticlesResponse) ProtoMessage() {}

func (x *SuggestArticlesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestArticlesResponse.ProtoReflect.Descriptor instead.
func (*SuggestArticlesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{29}
}

func (x *SuggestArticlesResponse) GetArticleAnswers() []*ArticleAnswer {
	if x != nil {
		return x.ArticleAnswers
	}
	return nil
}

func (x *SuggestArticlesResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestArticlesResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The request message for
// [Participants.SuggestFaqAnswers][google.cloud.dialogflow.v2beta1.Participants.SuggestFaqAnswers].
type SuggestFaqAnswersRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant to fetch suggestion for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The name of the latest conversation message to compile suggestion
	// for. If empty, it will be the latest message of the conversation.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Optional. Max number of messages prior to and including
	// [latest_message] to use as context when compiling the
	// suggestion. By default 20 and at most 50.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
	// Optional. Parameters for a human assist query.
	AssistQueryParams *AssistQueryParameters `protobuf:"bytes,4,opt,name=assist_query_params,json=assistQueryParams,proto3" json:"assist_query_params,omitempty"`
}

func (x *SuggestFaqAnswersRequest) Reset() {
	*x = SuggestFaqAnswersRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestFaqAnswersRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestFaqAnswersRequest) ProtoMessage() {}

func (x *SuggestFaqAnswersRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestFaqAnswersRequest.ProtoReflect.Descriptor instead.
func (*SuggestFaqAnswersRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{30}
}

func (x *SuggestFaqAnswersRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SuggestFaqAnswersRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestFaqAnswersRequest) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

func (x *SuggestFaqAnswersRequest) GetAssistQueryParams() *AssistQueryParameters {
	if x != nil {
		return x.AssistQueryParams
	}
	return nil
}

// The request message for
// [Participants.SuggestFaqAnswers][google.cloud.dialogflow.v2beta1.Participants.SuggestFaqAnswers].
type SuggestFaqAnswersResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Answers extracted from FAQ documents.
	FaqAnswers []*FaqAnswer `protobuf:"bytes,1,rep,name=faq_answers,json=faqAnswers,proto3" json:"faq_answers,omitempty"`
	// The name of the latest conversation message used to compile
	// suggestion for.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.latest_message]
	// to compile the suggestion. It may be smaller than the
	// [SuggestFaqAnswersRequest.context_size][google.cloud.dialogflow.v2beta1.SuggestFaqAnswersRequest.context_size]
	// field in the request if there aren't that many messages in the
	// conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestFaqAnswersResponse) Reset() {
	*x = SuggestFaqAnswersResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestFaqAnswersResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestFaqAnswersResponse) ProtoMessage() {}

func (x *SuggestFaqAnswersResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestFaqAnswersResponse.ProtoReflect.Descriptor instead.
func (*SuggestFaqAnswersResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{31}
}

func (x *SuggestFaqAnswersResponse) GetFaqAnswers() []*FaqAnswer {
	if x != nil {
		return x.FaqAnswers
	}
	return nil
}

func (x *SuggestFaqAnswersResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestFaqAnswersResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The request message for
// [Participants.SuggestSmartReplies][google.cloud.dialogflow.v2beta1.Participants.SuggestSmartReplies].
type SuggestSmartRepliesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant to fetch suggestion for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The current natural language text segment to compile suggestion
	// for. This provides a way for user to get follow up smart reply suggestion
	// after a smart reply selection, without sending a text message.
	CurrentTextInput *TextInput `protobuf:"bytes,4,opt,name=current_text_input,json=currentTextInput,proto3" json:"current_text_input,omitempty"`
	// The name of the latest conversation message to compile suggestion
	// for. If empty, it will be the latest message of the conversation.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Optional. Max number of messages prior to and including
	// [latest_message] to use as context when compiling the
	// suggestion. By default 20 and at most 50.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestSmartRepliesRequest) Reset() {
	*x = SuggestSmartRepliesRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestSmartRepliesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestSmartRepliesRequest) ProtoMessage() {}

func (x *SuggestSmartRepliesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestSmartRepliesRequest.ProtoReflect.Descriptor instead.
func (*SuggestSmartRepliesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{32}
}

func (x *SuggestSmartRepliesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SuggestSmartRepliesRequest) GetCurrentTextInput() *TextInput {
	if x != nil {
		return x.CurrentTextInput
	}
	return nil
}

func (x *SuggestSmartRepliesRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestSmartRepliesRequest) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The response message for
// [Participants.SuggestSmartReplies][google.cloud.dialogflow.v2beta1.Participants.SuggestSmartReplies].
type SuggestSmartRepliesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Multiple reply options provided by smart reply service. The
	// order is based on the rank of the model prediction.
	// The maximum number of the returned replies is set in SmartReplyConfig.
	SmartReplyAnswers []*SmartReplyAnswer `protobuf:"bytes,1,rep,name=smart_reply_answers,json=smartReplyAnswers,proto3" json:"smart_reply_answers,omitempty"`
	// The name of the latest conversation message used to compile
	// suggestion for.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.latest_message]
	// to compile the suggestion. It may be smaller than the
	// [SuggestSmartRepliesRequest.context_size][google.cloud.dialogflow.v2beta1.SuggestSmartRepliesRequest.context_size]
	// field in the request if there aren't that many messages in the
	// conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestSmartRepliesResponse) Reset() {
	*x = SuggestSmartRepliesResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestSmartRepliesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestSmartRepliesResponse) ProtoMessage() {}

func (x *SuggestSmartRepliesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestSmartRepliesResponse.ProtoReflect.Descriptor instead.
func (*SuggestSmartRepliesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{33}
}

func (x *SuggestSmartRepliesResponse) GetSmartReplyAnswers() []*SmartReplyAnswer {
	if x != nil {
		return x.SmartReplyAnswers
	}
	return nil
}

func (x *SuggestSmartRepliesResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestSmartRepliesResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The response message for
// [Conversations.GenerateSuggestions][google.cloud.dialogflow.v2beta1.Conversations.GenerateSuggestions].
type GenerateSuggestionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The answers generated for the conversation based on context.
	GeneratorSuggestionAnswers []*GenerateSuggestionsResponse_GeneratorSuggestionAnswer `protobuf:"bytes,1,rep,name=generator_suggestion_answers,json=generatorSuggestionAnswers,proto3" json:"generator_suggestion_answers,omitempty"`
	// The name of the latest conversation message used as context for
	// compiling suggestion.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
}

func (x *GenerateSuggestionsResponse) Reset() {
	*x = GenerateSuggestionsResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateSuggestionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateSuggestionsResponse) ProtoMessage() {}

func (x *GenerateSuggestionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateSuggestionsResponse.ProtoReflect.Descriptor instead.
func (*GenerateSuggestionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{34}
}

func (x *GenerateSuggestionsResponse) GetGeneratorSuggestionAnswers() []*GenerateSuggestionsResponse_GeneratorSuggestionAnswer {
	if x != nil {
		return x.GeneratorSuggestionAnswers
	}
	return nil
}

func (x *GenerateSuggestionsResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

// The response message for
// [Participants.SuggestDialogflowAssists][google.cloud.dialogflow.v2beta1.Participants.SuggestDialogflowAssists].
type SuggestDialogflowAssistsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Multiple reply options provided by Dialogflow assist
	// service. The order is based on the rank of the model prediction.
	DialogflowAssistAnswers []*DialogflowAssistAnswer `protobuf:"bytes,1,rep,name=dialogflow_assist_answers,json=dialogflowAssistAnswers,proto3" json:"dialogflow_assist_answers,omitempty"`
	// The name of the latest conversation message used to suggest answer.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2beta1.SuggestDialogflowAssistsResponse.latest_message]
	// to compile the suggestion. It may be smaller than the
	// [SuggestDialogflowAssistsRequest.context_size][google.cloud.dialogflow.v2beta1.SuggestDialogflowAssistsRequest.context_size]
	// field in the request if there aren't that many messages in the
	// conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestDialogflowAssistsResponse) Reset() {
	*x = SuggestDialogflowAssistsResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestDialogflowAssistsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestDialogflowAssistsResponse) ProtoMessage() {}

func (x *SuggestDialogflowAssistsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestDialogflowAssistsResponse.ProtoReflect.Descriptor instead.
func (*SuggestDialogflowAssistsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{35}
}

func (x *SuggestDialogflowAssistsResponse) GetDialogflowAssistAnswers() []*DialogflowAssistAnswer {
	if x != nil {
		return x.DialogflowAssistAnswers
	}
	return nil
}

func (x *SuggestDialogflowAssistsResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestDialogflowAssistsResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// Represents a suggestion for a human agent.
//
// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/participant.proto.
type Suggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of this suggestion.
	// Format:
	// `projects/<Project ID>/locations/<Location ID>/conversations/<Conversation
	// ID>/participants/*/suggestions/<Suggestion ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Articles ordered by score in descending order.
	Articles []*Suggestion_Article `protobuf:"bytes,2,rep,name=articles,proto3" json:"articles,omitempty"`
	// Output only. Answers extracted from FAQ documents.
	FaqAnswers []*Suggestion_FaqAnswer `protobuf:"bytes,4,rep,name=faq_answers,json=faqAnswers,proto3" json:"faq_answers,omitempty"`
	// Output only. The time the suggestion was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Latest message used as context to compile this suggestion.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,7,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
}

func (x *Suggestion) Reset() {
	*x = Suggestion{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Suggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Suggestion) ProtoMessage() {}

func (x *Suggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Suggestion.ProtoReflect.Descriptor instead.
func (*Suggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{36}
}

func (x *Suggestion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Suggestion) GetArticles() []*Suggestion_Article {
	if x != nil {
		return x.Articles
	}
	return nil
}

func (x *Suggestion) GetFaqAnswers() []*Suggestion_FaqAnswer {
	if x != nil {
		return x.FaqAnswers
	}
	return nil
}

func (x *Suggestion) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Suggestion) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

// The request message for
// [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions].
//
// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/participant.proto.
type ListSuggestionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant to fetch suggestions for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return in a single page. The
	// default value is 100; the maximum value is 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filter on suggestions fields. Currently predicates on
	// `create_time` and `create_time_epoch_microseconds` are supported.
	// `create_time` only support milliseconds accuracy. E.g.,
	// `create_time_epoch_microseconds > 1551790877964485` or
	// `create_time > "2017-01-15T01:30:15.01Z"`
	//
	// For more information about filtering, see
	// [API Filtering](https://aip.dev/160).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSuggestionsRequest) Reset() {
	*x = ListSuggestionsRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSuggestionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSuggestionsRequest) ProtoMessage() {}

func (x *ListSuggestionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSuggestionsRequest.ProtoReflect.Descriptor instead.
func (*ListSuggestionsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{37}
}

func (x *ListSuggestionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSuggestionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSuggestionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSuggestionsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// The response message for
// [Participants.ListSuggestions][google.cloud.dialogflow.v2beta1.Participants.ListSuggestions].
//
// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/participant.proto.
type ListSuggestionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The list of suggestions. There will be a maximum number of items
	// returned based on the page_size field in the request. `suggestions` is
	// sorted by `create_time` in descending order.
	Suggestions []*Suggestion `protobuf:"bytes,1,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
	// Optional. Token to retrieve the next page of results or empty if there are
	// no more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSuggestionsResponse) Reset() {
	*x = ListSuggestionsResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSuggestionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSuggestionsResponse) ProtoMessage() {}

func (x *ListSuggestionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSuggestionsResponse.ProtoReflect.Descriptor instead.
func (*ListSuggestionsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{38}
}

func (x *ListSuggestionsResponse) GetSuggestions() []*Suggestion {
	if x != nil {
		return x.Suggestions
	}
	return nil
}

func (x *ListSuggestionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Participants.CompileSuggestion][google.cloud.dialogflow.v2beta1.Participants.CompileSuggestion].
//
// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/participant.proto.
type CompileSuggestionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant to fetch suggestion for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The name of the latest conversation message to compile suggestion
	// for. If empty, it will be the latest message of the conversation.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Optional. Max number of messages prior to and including
	// [latest_message] to use as context when compiling the
	// suggestion. If zero or less than zero, 20 is used.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *CompileSuggestionRequest) Reset() {
	*x = CompileSuggestionRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompileSuggestionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompileSuggestionRequest) ProtoMessage() {}

func (x *CompileSuggestionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompileSuggestionRequest.ProtoReflect.Descriptor instead.
func (*CompileSuggestionRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{39}
}

func (x *CompileSuggestionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CompileSuggestionRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *CompileSuggestionRequest) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// The response message for
// [Participants.CompileSuggestion][google.cloud.dialogflow.v2beta1.Participants.CompileSuggestion].
//
// Deprecated: Marked as deprecated in google/cloud/dialogflow/v2beta1/participant.proto.
type CompileSuggestionResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The compiled suggestion.
	Suggestion *Suggestion `protobuf:"bytes,1,opt,name=suggestion,proto3" json:"suggestion,omitempty"`
	// The name of the latest conversation message used to compile
	// suggestion for.
	//
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2beta1.CompileSuggestionResponse.latest_message]
	// to compile the suggestion. It may be smaller than the
	// [CompileSuggestionRequest.context_size][google.cloud.dialogflow.v2beta1.CompileSuggestionRequest.context_size]
	// field in the request if there aren't that many messages in the
	// conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *CompileSuggestionResponse) Reset() {
	*x = CompileSuggestionResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompileSuggestionResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompileSuggestionResponse) ProtoMessage() {}

func (x *CompileSuggestionResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompileSuggestionResponse.ProtoReflect.Descriptor instead.
func (*CompileSuggestionResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{40}
}

func (x *CompileSuggestionResponse) GetSuggestion() *Suggestion {
	if x != nil {
		return x.Suggestion
	}
	return nil
}

func (x *CompileSuggestionResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *CompileSuggestionResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// Response messages from an automated agent.
type ResponseMessage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The rich response message.
	//
	// Types that are assignable to Message:
	//
	//	*ResponseMessage_Text_
	//	*ResponseMessage_Payload
	//	*ResponseMessage_LiveAgentHandoff_
	//	*ResponseMessage_EndInteraction_
	//	*ResponseMessage_MixedAudio_
	//	*ResponseMessage_TelephonyTransferCall_
	Message isResponseMessage_Message `protobuf_oneof:"message"`
}

func (x *ResponseMessage) Reset() {
	*x = ResponseMessage{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage) ProtoMessage() {}

func (x *ResponseMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage.ProtoReflect.Descriptor instead.
func (*ResponseMessage) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{41}
}

func (m *ResponseMessage) GetMessage() isResponseMessage_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (x *ResponseMessage) GetText() *ResponseMessage_Text {
	if x, ok := x.GetMessage().(*ResponseMessage_Text_); ok {
		return x.Text
	}
	return nil
}

func (x *ResponseMessage) GetPayload() *structpb.Struct {
	if x, ok := x.GetMessage().(*ResponseMessage_Payload); ok {
		return x.Payload
	}
	return nil
}

func (x *ResponseMessage) GetLiveAgentHandoff() *ResponseMessage_LiveAgentHandoff {
	if x, ok := x.GetMessage().(*ResponseMessage_LiveAgentHandoff_); ok {
		return x.LiveAgentHandoff
	}
	return nil
}

func (x *ResponseMessage) GetEndInteraction() *ResponseMessage_EndInteraction {
	if x, ok := x.GetMessage().(*ResponseMessage_EndInteraction_); ok {
		return x.EndInteraction
	}
	return nil
}

func (x *ResponseMessage) GetMixedAudio() *ResponseMessage_MixedAudio {
	if x, ok := x.GetMessage().(*ResponseMessage_MixedAudio_); ok {
		return x.MixedAudio
	}
	return nil
}

func (x *ResponseMessage) GetTelephonyTransferCall() *ResponseMessage_TelephonyTransferCall {
	if x, ok := x.GetMessage().(*ResponseMessage_TelephonyTransferCall_); ok {
		return x.TelephonyTransferCall
	}
	return nil
}

type isResponseMessage_Message interface {
	isResponseMessage_Message()
}

type ResponseMessage_Text_ struct {
	// Returns a text response.
	Text *ResponseMessage_Text `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type ResponseMessage_Payload struct {
	// Returns a response containing a custom, platform-specific payload.
	Payload *structpb.Struct `protobuf:"bytes,2,opt,name=payload,proto3,oneof"`
}

type ResponseMessage_LiveAgentHandoff_ struct {
	// Hands off conversation to a live agent.
	LiveAgentHandoff *ResponseMessage_LiveAgentHandoff `protobuf:"bytes,3,opt,name=live_agent_handoff,json=liveAgentHandoff,proto3,oneof"`
}

type ResponseMessage_EndInteraction_ struct {
	// A signal that indicates the interaction with the Dialogflow agent has
	// ended.
	EndInteraction *ResponseMessage_EndInteraction `protobuf:"bytes,4,opt,name=end_interaction,json=endInteraction,proto3,oneof"`
}

type ResponseMessage_MixedAudio_ struct {
	// An audio response message composed of both the synthesized Dialogflow
	// agent responses and the audios hosted in places known to the client.
	MixedAudio *ResponseMessage_MixedAudio `protobuf:"bytes,5,opt,name=mixed_audio,json=mixedAudio,proto3,oneof"`
}

type ResponseMessage_TelephonyTransferCall_ struct {
	// A signal that the client should transfer the phone call connected to
	// this agent to a third-party endpoint.
	TelephonyTransferCall *ResponseMessage_TelephonyTransferCall `protobuf:"bytes,6,opt,name=telephony_transfer_call,json=telephonyTransferCall,proto3,oneof"`
}

func (*ResponseMessage_Text_) isResponseMessage_Message() {}

func (*ResponseMessage_Payload) isResponseMessage_Message() {}

func (*ResponseMessage_LiveAgentHandoff_) isResponseMessage_Message() {}

func (*ResponseMessage_EndInteraction_) isResponseMessage_Message() {}

func (*ResponseMessage_MixedAudio_) isResponseMessage_Message() {}

func (*ResponseMessage_TelephonyTransferCall_) isResponseMessage_Message() {}

// The request message for
// [Participants.SuggestKnowledgeAssist][google.cloud.dialogflow.v2beta1.Participants.SuggestKnowledgeAssist].
type SuggestKnowledgeAssistRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant to fetch suggestions for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The name of the latest conversation message to compile
	// suggestions for. If empty, it will be the latest message of the
	// conversation. Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Optional. Max number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2beta1.SuggestKnowledgeAssistRequest.latest_message]
	// to use as context when compiling the suggestion. The context size is by
	// default 100 and at most 100.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
	// Optional. The previously suggested query for the given conversation. This
	// helps identify whether the next suggestion we generate is reasonably
	// different from the previous one. This is useful to avoid similar
	// suggestions within the conversation.
	PreviousSuggestedQuery string `protobuf:"bytes,4,opt,name=previous_suggested_query,json=previousSuggestedQuery,proto3" json:"previous_suggested_query,omitempty"`
}

func (x *SuggestKnowledgeAssistRequest) Reset() {
	*x = SuggestKnowledgeAssistRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestKnowledgeAssistRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestKnowledgeAssistRequest) ProtoMessage() {}

func (x *SuggestKnowledgeAssistRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestKnowledgeAssistRequest.ProtoReflect.Descriptor instead.
func (*SuggestKnowledgeAssistRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{42}
}

func (x *SuggestKnowledgeAssistRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SuggestKnowledgeAssistRequest) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestKnowledgeAssistRequest) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

func (x *SuggestKnowledgeAssistRequest) GetPreviousSuggestedQuery() string {
	if x != nil {
		return x.PreviousSuggestedQuery
	}
	return ""
}

// The response message for
// [Participants.SuggestKnowledgeAssist][google.cloud.dialogflow.v2beta1.Participants.SuggestKnowledgeAssist].
type SuggestKnowledgeAssistResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Knowledge Assist suggestion.
	KnowledgeAssistAnswer *KnowledgeAssistAnswer `protobuf:"bytes,1,opt,name=knowledge_assist_answer,json=knowledgeAssistAnswer,proto3" json:"knowledge_assist_answer,omitempty"`
	// The name of the latest conversation message used to compile suggestion for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/messages/<Message ID>`.
	LatestMessage string `protobuf:"bytes,2,opt,name=latest_message,json=latestMessage,proto3" json:"latest_message,omitempty"`
	// Number of messages prior to and including
	// [latest_message][google.cloud.dialogflow.v2beta1.SuggestKnowledgeAssistResponse.latest_message]
	// to compile the suggestion. It may be smaller than the
	// [SuggestKnowledgeAssistRequest.context_size][google.cloud.dialogflow.v2beta1.SuggestKnowledgeAssistRequest.context_size]
	// field in the request if there are fewer messages in the conversation.
	ContextSize int32 `protobuf:"varint,3,opt,name=context_size,json=contextSize,proto3" json:"context_size,omitempty"`
}

func (x *SuggestKnowledgeAssistResponse) Reset() {
	*x = SuggestKnowledgeAssistResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SuggestKnowledgeAssistResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SuggestKnowledgeAssistResponse) ProtoMessage() {}

func (x *SuggestKnowledgeAssistResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SuggestKnowledgeAssistResponse.ProtoReflect.Descriptor instead.
func (*SuggestKnowledgeAssistResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{43}
}

func (x *SuggestKnowledgeAssistResponse) GetKnowledgeAssistAnswer() *KnowledgeAssistAnswer {
	if x != nil {
		return x.KnowledgeAssistAnswer
	}
	return nil
}

func (x *SuggestKnowledgeAssistResponse) GetLatestMessage() string {
	if x != nil {
		return x.LatestMessage
	}
	return ""
}

func (x *SuggestKnowledgeAssistResponse) GetContextSize() int32 {
	if x != nil {
		return x.ContextSize
	}
	return 0
}

// Represents a Knowledge Assist answer.
type KnowledgeAssistAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The query suggested based on the context. Suggestion is made only if it
	// is different from the previous suggestion.
	SuggestedQuery *KnowledgeAssistAnswer_SuggestedQuery `protobuf:"bytes,1,opt,name=suggested_query,json=suggestedQuery,proto3" json:"suggested_query,omitempty"`
	// The answer generated for the suggested query. Whether or not an answer is
	// generated depends on how confident we are about the generated query.
	SuggestedQueryAnswer *KnowledgeAssistAnswer_KnowledgeAnswer `protobuf:"bytes,2,opt,name=suggested_query_answer,json=suggestedQueryAnswer,proto3" json:"suggested_query_answer,omitempty"`
	// The name of the answer record.
	// Format: `projects/<Project ID>/locations/<location ID>/answer
	// Records/<Answer Record ID>`.
	AnswerRecord string `protobuf:"bytes,3,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *KnowledgeAssistAnswer) Reset() {
	*x = KnowledgeAssistAnswer{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KnowledgeAssistAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeAssistAnswer) ProtoMessage() {}

func (x *KnowledgeAssistAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeAssistAnswer.ProtoReflect.Descriptor instead.
func (*KnowledgeAssistAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{44}
}

func (x *KnowledgeAssistAnswer) GetSuggestedQuery() *KnowledgeAssistAnswer_SuggestedQuery {
	if x != nil {
		return x.SuggestedQuery
	}
	return nil
}

func (x *KnowledgeAssistAnswer) GetSuggestedQueryAnswer() *KnowledgeAssistAnswer_KnowledgeAnswer {
	if x != nil {
		return x.SuggestedQueryAnswer
	}
	return nil
}

func (x *KnowledgeAssistAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// The request message for
// [Participants.BidiStreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.BidiStreamingAnalyzeContent].
type BidiStreamingAnalyzeContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Possible request types for BidiStreamingAnalyzeContent.
	//
	// Types that are assignable to Request:
	//
	//	*BidiStreamingAnalyzeContentRequest_Config_
	//	*BidiStreamingAnalyzeContentRequest_Input_
	Request isBidiStreamingAnalyzeContentRequest_Request `protobuf_oneof:"request"`
}

func (x *BidiStreamingAnalyzeContentRequest) Reset() {
	*x = BidiStreamingAnalyzeContentRequest{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiStreamingAnalyzeContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiStreamingAnalyzeContentRequest) ProtoMessage() {}

func (x *BidiStreamingAnalyzeContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiStreamingAnalyzeContentRequest.ProtoReflect.Descriptor instead.
func (*BidiStreamingAnalyzeContentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{45}
}

func (m *BidiStreamingAnalyzeContentRequest) GetRequest() isBidiStreamingAnalyzeContentRequest_Request {
	if m != nil {
		return m.Request
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentRequest) GetConfig() *BidiStreamingAnalyzeContentRequest_Config {
	if x, ok := x.GetRequest().(*BidiStreamingAnalyzeContentRequest_Config_); ok {
		return x.Config
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentRequest) GetInput() *BidiStreamingAnalyzeContentRequest_Input {
	if x, ok := x.GetRequest().(*BidiStreamingAnalyzeContentRequest_Input_); ok {
		return x.Input
	}
	return nil
}

type isBidiStreamingAnalyzeContentRequest_Request interface {
	isBidiStreamingAnalyzeContentRequest_Request()
}

type BidiStreamingAnalyzeContentRequest_Config_ struct {
	// The config message for this conversation.
	Config *BidiStreamingAnalyzeContentRequest_Config `protobuf:"bytes,1,opt,name=config,proto3,oneof"`
}

type BidiStreamingAnalyzeContentRequest_Input_ struct {
	// Text, audio or other multi-modality inputs.
	// This is the second and following messages sent by the client.
	Input *BidiStreamingAnalyzeContentRequest_Input `protobuf:"bytes,2,opt,name=input,proto3,oneof"`
}

func (*BidiStreamingAnalyzeContentRequest_Config_) isBidiStreamingAnalyzeContentRequest_Request() {}

func (*BidiStreamingAnalyzeContentRequest_Input_) isBidiStreamingAnalyzeContentRequest_Request() {}

// The response message for
// [Participants.BidiStreamingAnalyzeContent][google.cloud.dialogflow.v2beta1.Participants.BidiStreamingAnalyzeContent].
type BidiStreamingAnalyzeContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output response.
	//
	// Types that are assignable to Response:
	//
	//	*BidiStreamingAnalyzeContentResponse_RecognitionResult
	//	*BidiStreamingAnalyzeContentResponse_BargeInSignal_
	//	*BidiStreamingAnalyzeContentResponse_AnalyzeContentResponse
	//	*BidiStreamingAnalyzeContentResponse_TurnComplete_
	Response isBidiStreamingAnalyzeContentResponse_Response `protobuf_oneof:"response"`
}

func (x *BidiStreamingAnalyzeContentResponse) Reset() {
	*x = BidiStreamingAnalyzeContentResponse{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiStreamingAnalyzeContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiStreamingAnalyzeContentResponse) ProtoMessage() {}

func (x *BidiStreamingAnalyzeContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiStreamingAnalyzeContentResponse.ProtoReflect.Descriptor instead.
func (*BidiStreamingAnalyzeContentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{46}
}

func (m *BidiStreamingAnalyzeContentResponse) GetResponse() isBidiStreamingAnalyzeContentResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentResponse) GetRecognitionResult() *StreamingRecognitionResult {
	if x, ok := x.GetResponse().(*BidiStreamingAnalyzeContentResponse_RecognitionResult); ok {
		return x.RecognitionResult
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentResponse) GetBargeInSignal() *BidiStreamingAnalyzeContentResponse_BargeInSignal {
	if x, ok := x.GetResponse().(*BidiStreamingAnalyzeContentResponse_BargeInSignal_); ok {
		return x.BargeInSignal
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentResponse) GetAnalyzeContentResponse() *AnalyzeContentResponse {
	if x, ok := x.GetResponse().(*BidiStreamingAnalyzeContentResponse_AnalyzeContentResponse); ok {
		return x.AnalyzeContentResponse
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentResponse) GetTurnComplete() *BidiStreamingAnalyzeContentResponse_TurnComplete {
	if x, ok := x.GetResponse().(*BidiStreamingAnalyzeContentResponse_TurnComplete_); ok {
		return x.TurnComplete
	}
	return nil
}

type isBidiStreamingAnalyzeContentResponse_Response interface {
	isBidiStreamingAnalyzeContentResponse_Response()
}

type BidiStreamingAnalyzeContentResponse_RecognitionResult struct {
	// The result of speech recognition.
	RecognitionResult *StreamingRecognitionResult `protobuf:"bytes,1,opt,name=recognition_result,json=recognitionResult,proto3,oneof"`
}

type BidiStreamingAnalyzeContentResponse_BargeInSignal_ struct {
	// Indicate the user barge-in has been detected, and client should stop
	// playing back the audio.
	BargeInSignal *BidiStreamingAnalyzeContentResponse_BargeInSignal `protobuf:"bytes,2,opt,name=barge_in_signal,json=bargeInSignal,proto3,oneof"`
}

type BidiStreamingAnalyzeContentResponse_AnalyzeContentResponse struct {
	// The agent response from analyze content.
	AnalyzeContentResponse *AnalyzeContentResponse `protobuf:"bytes,3,opt,name=analyze_content_response,json=analyzeContentResponse,proto3,oneof"`
}

type BidiStreamingAnalyzeContentResponse_TurnComplete_ struct {
	// Indicate that the turn is complete.
	TurnComplete *BidiStreamingAnalyzeContentResponse_TurnComplete `protobuf:"bytes,4,opt,name=turn_complete,json=turnComplete,proto3,oneof"`
}

func (*BidiStreamingAnalyzeContentResponse_RecognitionResult) isBidiStreamingAnalyzeContentResponse_Response() {
}

func (*BidiStreamingAnalyzeContentResponse_BargeInSignal_) isBidiStreamingAnalyzeContentResponse_Response() {
}

func (*BidiStreamingAnalyzeContentResponse_AnalyzeContentResponse) isBidiStreamingAnalyzeContentResponse_Response() {
}

func (*BidiStreamingAnalyzeContentResponse_TurnComplete_) isBidiStreamingAnalyzeContentResponse_Response() {
}

// A GeneratorSuggestion answer.
type GenerateSuggestionsResponse_GeneratorSuggestionAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Suggestion details.
	GeneratorSuggestion *GeneratorSuggestion `protobuf:"bytes,1,opt,name=generator_suggestion,json=generatorSuggestion,proto3" json:"generator_suggestion,omitempty"`
	// The name of the generator used to generate this suggestion. Format:
	// `projects/<Project ID>/locations/<Location ID>/generators/<Generator
	// ID>`.
	SourceGenerator string `protobuf:"bytes,2,opt,name=source_generator,json=sourceGenerator,proto3" json:"source_generator,omitempty"`
	// Answer record that uniquely identifies the suggestion. This can be used
	// to provide suggestion feedback.
	AnswerRecord string `protobuf:"bytes,3,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *GenerateSuggestionsResponse_GeneratorSuggestionAnswer) Reset() {
	*x = GenerateSuggestionsResponse_GeneratorSuggestionAnswer{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateSuggestionsResponse_GeneratorSuggestionAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateSuggestionsResponse_GeneratorSuggestionAnswer) ProtoMessage() {}

func (x *GenerateSuggestionsResponse_GeneratorSuggestionAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateSuggestionsResponse_GeneratorSuggestionAnswer.ProtoReflect.Descriptor instead.
func (*GenerateSuggestionsResponse_GeneratorSuggestionAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{34, 0}
}

func (x *GenerateSuggestionsResponse_GeneratorSuggestionAnswer) GetGeneratorSuggestion() *GeneratorSuggestion {
	if x != nil {
		return x.GeneratorSuggestion
	}
	return nil
}

func (x *GenerateSuggestionsResponse_GeneratorSuggestionAnswer) GetSourceGenerator() string {
	if x != nil {
		return x.SourceGenerator
	}
	return ""
}

func (x *GenerateSuggestionsResponse_GeneratorSuggestionAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// Represents suggested article.
type Suggestion_Article struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The article title.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Output only. The article URI.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Output only. Article snippets.
	Snippets []string `protobuf:"bytes,3,rep,name=snippets,proto3" json:"snippets,omitempty"`
	// Output only. A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The name of answer record, in the format of
	// "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer
	// Record ID>"
	AnswerRecord string `protobuf:"bytes,6,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *Suggestion_Article) Reset() {
	*x = Suggestion_Article{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Suggestion_Article) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Suggestion_Article) ProtoMessage() {}

func (x *Suggestion_Article) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Suggestion_Article.ProtoReflect.Descriptor instead.
func (*Suggestion_Article) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{36, 0}
}

func (x *Suggestion_Article) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Suggestion_Article) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Suggestion_Article) GetSnippets() []string {
	if x != nil {
		return x.Snippets
	}
	return nil
}

func (x *Suggestion_Article) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Suggestion_Article) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// Represents suggested answer from "frequently asked questions".
type Suggestion_FaqAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The piece of text from the `source` knowledge base document.
	Answer string `protobuf:"bytes,1,opt,name=answer,proto3" json:"answer,omitempty"`
	// The system's confidence score that this Knowledge answer is a good match
	// for this conversational query, range from 0.0 (completely uncertain)
	// to 1.0 (completely certain).
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. The corresponding FAQ question.
	Question string `protobuf:"bytes,3,opt,name=question,proto3" json:"question,omitempty"`
	// Output only. Indicates which Knowledge Document this answer was extracted
	// from.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/agent/knowledgeBases/<Knowledge Base ID>/documents/<Document ID>`.
	Source string `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
	// Output only. A map that contains metadata about the answer and the
	// document from which it originates.
	Metadata map[string]string `protobuf:"bytes,5,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The name of answer record, in the format of
	// "projects/<Project ID>/locations/<Location ID>/answerRecords/<Answer
	// Record ID>"
	AnswerRecord string `protobuf:"bytes,6,opt,name=answer_record,json=answerRecord,proto3" json:"answer_record,omitempty"`
}

func (x *Suggestion_FaqAnswer) Reset() {
	*x = Suggestion_FaqAnswer{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Suggestion_FaqAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Suggestion_FaqAnswer) ProtoMessage() {}

func (x *Suggestion_FaqAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Suggestion_FaqAnswer.ProtoReflect.Descriptor instead.
func (*Suggestion_FaqAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{36, 1}
}

func (x *Suggestion_FaqAnswer) GetAnswer() string {
	if x != nil {
		return x.Answer
	}
	return ""
}

func (x *Suggestion_FaqAnswer) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *Suggestion_FaqAnswer) GetQuestion() string {
	if x != nil {
		return x.Question
	}
	return ""
}

func (x *Suggestion_FaqAnswer) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *Suggestion_FaqAnswer) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *Suggestion_FaqAnswer) GetAnswerRecord() string {
	if x != nil {
		return x.AnswerRecord
	}
	return ""
}

// The text response message.
type ResponseMessage_Text struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of text response variants. If multiple variants are
	// defined, only one text response variant is returned at runtime.
	Text []string `protobuf:"bytes,1,rep,name=text,proto3" json:"text,omitempty"`
}

func (x *ResponseMessage_Text) Reset() {
	*x = ResponseMessage_Text{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseMessage_Text) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_Text) ProtoMessage() {}

func (x *ResponseMessage_Text) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_Text.ProtoReflect.Descriptor instead.
func (*ResponseMessage_Text) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{41, 0}
}

func (x *ResponseMessage_Text) GetText() []string {
	if x != nil {
		return x.Text
	}
	return nil
}

// Indicates that the conversation should be handed off to a human agent.
//
// Dialogflow only uses this to determine which conversations were handed off
// to a human agent for measurement purposes. What else to do with this signal
// is up to you and your handoff procedures.
//
// You may set this, for example:
//
// * In the entry fulfillment of a Dialogflow CX Page if entering the page
// indicates
//
//		something went extremely wrong in the conversation.
//	  - In a webhook response when you determine that the customer issue can only
//	    be handled by a human.
type ResponseMessage_LiveAgentHandoff struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Custom metadata for your handoff procedure. Dialogflow doesn't impose
	// any structure on this.
	Metadata *structpb.Struct `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *ResponseMessage_LiveAgentHandoff) Reset() {
	*x = ResponseMessage_LiveAgentHandoff{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseMessage_LiveAgentHandoff) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_LiveAgentHandoff) ProtoMessage() {}

func (x *ResponseMessage_LiveAgentHandoff) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_LiveAgentHandoff.ProtoReflect.Descriptor instead.
func (*ResponseMessage_LiveAgentHandoff) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{41, 1}
}

func (x *ResponseMessage_LiveAgentHandoff) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Indicates that interaction with the Dialogflow agent has ended.
type ResponseMessage_EndInteraction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResponseMessage_EndInteraction) Reset() {
	*x = ResponseMessage_EndInteraction{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseMessage_EndInteraction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_EndInteraction) ProtoMessage() {}

func (x *ResponseMessage_EndInteraction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_EndInteraction.ProtoReflect.Descriptor instead.
func (*ResponseMessage_EndInteraction) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{41, 2}
}

// Represents an audio message that is composed of both segments
// synthesized from the Dialogflow agent prompts and ones hosted externally
// at the specified URIs.
type ResponseMessage_MixedAudio struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Segments this audio response is composed of.
	Segments []*ResponseMessage_MixedAudio_Segment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
}

func (x *ResponseMessage_MixedAudio) Reset() {
	*x = ResponseMessage_MixedAudio{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseMessage_MixedAudio) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_MixedAudio) ProtoMessage() {}

func (x *ResponseMessage_MixedAudio) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_MixedAudio.ProtoReflect.Descriptor instead.
func (*ResponseMessage_MixedAudio) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{41, 3}
}

func (x *ResponseMessage_MixedAudio) GetSegments() []*ResponseMessage_MixedAudio_Segment {
	if x != nil {
		return x.Segments
	}
	return nil
}

// Represents the signal that telles the client to transfer the phone call
// connected to the agent to a third-party endpoint.
type ResponseMessage_TelephonyTransferCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Endpoint to transfer the call to.
	//
	// Types that are assignable to Endpoint:
	//
	//	*ResponseMessage_TelephonyTransferCall_PhoneNumber
	//	*ResponseMessage_TelephonyTransferCall_SipUri
	Endpoint isResponseMessage_TelephonyTransferCall_Endpoint `protobuf_oneof:"endpoint"`
}

func (x *ResponseMessage_TelephonyTransferCall) Reset() {
	*x = ResponseMessage_TelephonyTransferCall{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseMessage_TelephonyTransferCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_TelephonyTransferCall) ProtoMessage() {}

func (x *ResponseMessage_TelephonyTransferCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_TelephonyTransferCall.ProtoReflect.Descriptor instead.
func (*ResponseMessage_TelephonyTransferCall) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{41, 4}
}

func (m *ResponseMessage_TelephonyTransferCall) GetEndpoint() isResponseMessage_TelephonyTransferCall_Endpoint {
	if m != nil {
		return m.Endpoint
	}
	return nil
}

func (x *ResponseMessage_TelephonyTransferCall) GetPhoneNumber() string {
	if x, ok := x.GetEndpoint().(*ResponseMessage_TelephonyTransferCall_PhoneNumber); ok {
		return x.PhoneNumber
	}
	return ""
}

func (x *ResponseMessage_TelephonyTransferCall) GetSipUri() string {
	if x, ok := x.GetEndpoint().(*ResponseMessage_TelephonyTransferCall_SipUri); ok {
		return x.SipUri
	}
	return ""
}

type isResponseMessage_TelephonyTransferCall_Endpoint interface {
	isResponseMessage_TelephonyTransferCall_Endpoint()
}

type ResponseMessage_TelephonyTransferCall_PhoneNumber struct {
	// Transfer the call to a phone number
	// in [E.164 format](https://en.wikipedia.org/wiki/E.164).
	PhoneNumber string `protobuf:"bytes,1,opt,name=phone_number,json=phoneNumber,proto3,oneof"`
}

type ResponseMessage_TelephonyTransferCall_SipUri struct {
	// Transfer the call to a SIP endpoint.
	SipUri string `protobuf:"bytes,2,opt,name=sip_uri,json=sipUri,proto3,oneof"`
}

func (*ResponseMessage_TelephonyTransferCall_PhoneNumber) isResponseMessage_TelephonyTransferCall_Endpoint() {
}

func (*ResponseMessage_TelephonyTransferCall_SipUri) isResponseMessage_TelephonyTransferCall_Endpoint() {
}

// Represents one segment of audio.
type ResponseMessage_MixedAudio_Segment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content of the segment.
	//
	// Types that are assignable to Content:
	//
	//	*ResponseMessage_MixedAudio_Segment_Audio
	//	*ResponseMessage_MixedAudio_Segment_Uri
	Content isResponseMessage_MixedAudio_Segment_Content `protobuf_oneof:"content"`
	// Whether the playback of this segment can be interrupted by the end
	// user's speech and the client should then start the next Dialogflow
	// request.
	AllowPlaybackInterruption bool `protobuf:"varint,3,opt,name=allow_playback_interruption,json=allowPlaybackInterruption,proto3" json:"allow_playback_interruption,omitempty"`
}

func (x *ResponseMessage_MixedAudio_Segment) Reset() {
	*x = ResponseMessage_MixedAudio_Segment{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResponseMessage_MixedAudio_Segment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResponseMessage_MixedAudio_Segment) ProtoMessage() {}

func (x *ResponseMessage_MixedAudio_Segment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResponseMessage_MixedAudio_Segment.ProtoReflect.Descriptor instead.
func (*ResponseMessage_MixedAudio_Segment) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{41, 3, 0}
}

func (m *ResponseMessage_MixedAudio_Segment) GetContent() isResponseMessage_MixedAudio_Segment_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *ResponseMessage_MixedAudio_Segment) GetAudio() []byte {
	if x, ok := x.GetContent().(*ResponseMessage_MixedAudio_Segment_Audio); ok {
		return x.Audio
	}
	return nil
}

func (x *ResponseMessage_MixedAudio_Segment) GetUri() string {
	if x, ok := x.GetContent().(*ResponseMessage_MixedAudio_Segment_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *ResponseMessage_MixedAudio_Segment) GetAllowPlaybackInterruption() bool {
	if x != nil {
		return x.AllowPlaybackInterruption
	}
	return false
}

type isResponseMessage_MixedAudio_Segment_Content interface {
	isResponseMessage_MixedAudio_Segment_Content()
}

type ResponseMessage_MixedAudio_Segment_Audio struct {
	// Raw audio synthesized from the Dialogflow agent's response using
	// the output config specified in the request.
	Audio []byte `protobuf:"bytes,1,opt,name=audio,proto3,oneof"`
}

type ResponseMessage_MixedAudio_Segment_Uri struct {
	// Client-specific URI that points to an audio clip accessible to the
	// client.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3,oneof"`
}

func (*ResponseMessage_MixedAudio_Segment_Audio) isResponseMessage_MixedAudio_Segment_Content() {}

func (*ResponseMessage_MixedAudio_Segment_Uri) isResponseMessage_MixedAudio_Segment_Content() {}

// Represents a suggested query.
type KnowledgeAssistAnswer_SuggestedQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Suggested query text.
	QueryText string `protobuf:"bytes,1,opt,name=query_text,json=queryText,proto3" json:"query_text,omitempty"`
}

func (x *KnowledgeAssistAnswer_SuggestedQuery) Reset() {
	*x = KnowledgeAssistAnswer_SuggestedQuery{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KnowledgeAssistAnswer_SuggestedQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeAssistAnswer_SuggestedQuery) ProtoMessage() {}

func (x *KnowledgeAssistAnswer_SuggestedQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeAssistAnswer_SuggestedQuery.ProtoReflect.Descriptor instead.
func (*KnowledgeAssistAnswer_SuggestedQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{44, 0}
}

func (x *KnowledgeAssistAnswer_SuggestedQuery) GetQueryText() string {
	if x != nil {
		return x.QueryText
	}
	return ""
}

// Represents an answer from Knowledge. Currently supports FAQ and Generative
// answers.
type KnowledgeAssistAnswer_KnowledgeAnswer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The piece of text from the `source` that answers this suggested query.
	AnswerText string `protobuf:"bytes,1,opt,name=answer_text,json=answerText,proto3" json:"answer_text,omitempty"`
	// Source of result.
	//
	// Types that are assignable to Source:
	//
	//	*KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource_
	//	*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_
	Source isKnowledgeAssistAnswer_KnowledgeAnswer_Source `protobuf_oneof:"source"`
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer) Reset() {
	*x = KnowledgeAssistAnswer_KnowledgeAnswer{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeAssistAnswer_KnowledgeAnswer) ProtoMessage() {}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeAssistAnswer_KnowledgeAnswer.ProtoReflect.Descriptor instead.
func (*KnowledgeAssistAnswer_KnowledgeAnswer) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{44, 1}
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer) GetAnswerText() string {
	if x != nil {
		return x.AnswerText
	}
	return ""
}

func (m *KnowledgeAssistAnswer_KnowledgeAnswer) GetSource() isKnowledgeAssistAnswer_KnowledgeAnswer_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer) GetFaqSource() *KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource {
	if x, ok := x.GetSource().(*KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource_); ok {
		return x.FaqSource
	}
	return nil
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer) GetGenerativeSource() *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource {
	if x, ok := x.GetSource().(*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_); ok {
		return x.GenerativeSource
	}
	return nil
}

type isKnowledgeAssistAnswer_KnowledgeAnswer_Source interface {
	isKnowledgeAssistAnswer_KnowledgeAnswer_Source()
}

type KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource_ struct {
	// Populated if the prediction came from FAQ.
	FaqSource *KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource `protobuf:"bytes,3,opt,name=faq_source,json=faqSource,proto3,oneof"`
}

type KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_ struct {
	// Populated if the prediction was Generative.
	GenerativeSource *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource `protobuf:"bytes,4,opt,name=generative_source,json=generativeSource,proto3,oneof"`
}

func (*KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource_) isKnowledgeAssistAnswer_KnowledgeAnswer_Source() {
}

func (*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_) isKnowledgeAssistAnswer_KnowledgeAnswer_Source() {
}

// Details about source of FAQ answer.
type KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The corresponding FAQ question.
	Question string `protobuf:"bytes,2,opt,name=question,proto3" json:"question,omitempty"`
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource) Reset() {
	*x = KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource) ProtoMessage() {}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource.ProtoReflect.Descriptor instead.
func (*KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{44, 1, 0}
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource) GetQuestion() string {
	if x != nil {
		return x.Question
	}
	return ""
}

// Details about source of Generative answer.
type KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// All snippets used for this Generative Prediction, with their source URI
	// and data.
	Snippets []*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet `protobuf:"bytes,1,rep,name=snippets,proto3" json:"snippets,omitempty"`
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource) Reset() {
	*x = KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource) ProtoMessage() {}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource.ProtoReflect.Descriptor instead.
func (*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{44, 1, 1}
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource) GetSnippets() []*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet {
	if x != nil {
		return x.Snippets
	}
	return nil
}

// Snippet Source for a Generative Prediction.
type KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI the data is sourced from.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Text taken from that URI.
	Text string `protobuf:"bytes,3,opt,name=text,proto3" json:"text,omitempty"`
	// Title of the document.
	Title string `protobuf:"bytes,4,opt,name=title,proto3" json:"title,omitempty"`
	// Metadata of the document.
	Metadata *structpb.Struct `protobuf:"bytes,5,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet) Reset() {
	*x = KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet) ProtoMessage() {}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet.ProtoReflect.Descriptor instead.
func (*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{44, 1, 1, 0}
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet) GetMetadata() *structpb.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// The config of the session.
type BidiStreamingAnalyzeContentRequest_Config struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the participant to fetch response for.
	// Format: `projects/<Project ID>/locations/<Location
	// ID>/conversations/<Conversation ID>/participants/<Participant ID>`.
	Participant string `protobuf:"bytes,1,opt,name=participant,proto3" json:"participant,omitempty"`
	// The config of the session.
	//
	// Types that are assignable to Config:
	//
	//	*BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig_
	Config isBidiStreamingAnalyzeContentRequest_Config_Config `protobuf_oneof:"config"`
	// Parameters to be passed to the virtual agent at the beginning.
	InitialVirtualAgentParameters *structpb.Struct `protobuf:"bytes,3,opt,name=initial_virtual_agent_parameters,json=initialVirtualAgentParameters,proto3" json:"initial_virtual_agent_parameters,omitempty"`
	// Initial parameters for the virtual-agent.
	InitialVirtualAgentQueryParams *QueryParameters `protobuf:"bytes,4,opt,name=initial_virtual_agent_query_params,json=initialVirtualAgentQueryParams,proto3" json:"initial_virtual_agent_query_params,omitempty"`
}

func (x *BidiStreamingAnalyzeContentRequest_Config) Reset() {
	*x = BidiStreamingAnalyzeContentRequest_Config{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiStreamingAnalyzeContentRequest_Config) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiStreamingAnalyzeContentRequest_Config) ProtoMessage() {}

func (x *BidiStreamingAnalyzeContentRequest_Config) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiStreamingAnalyzeContentRequest_Config.ProtoReflect.Descriptor instead.
func (*BidiStreamingAnalyzeContentRequest_Config) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{45, 0}
}

func (x *BidiStreamingAnalyzeContentRequest_Config) GetParticipant() string {
	if x != nil {
		return x.Participant
	}
	return ""
}

func (m *BidiStreamingAnalyzeContentRequest_Config) GetConfig() isBidiStreamingAnalyzeContentRequest_Config_Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentRequest_Config) GetVoiceSessionConfig() *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig {
	if x, ok := x.GetConfig().(*BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig_); ok {
		return x.VoiceSessionConfig
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentRequest_Config) GetInitialVirtualAgentParameters() *structpb.Struct {
	if x != nil {
		return x.InitialVirtualAgentParameters
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentRequest_Config) GetInitialVirtualAgentQueryParams() *QueryParameters {
	if x != nil {
		return x.InitialVirtualAgentQueryParams
	}
	return nil
}

type isBidiStreamingAnalyzeContentRequest_Config_Config interface {
	isBidiStreamingAnalyzeContentRequest_Config_Config()
}

type BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig_ struct {
	// Configure a voice-based session.
	VoiceSessionConfig *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig `protobuf:"bytes,2,opt,name=voice_session_config,json=voiceSessionConfig,proto3,oneof"`
}

func (*BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig_) isBidiStreamingAnalyzeContentRequest_Config_Config() {
}

// Input that forms data for a single turn.
type BidiStreamingAnalyzeContentRequest_TurnInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Content that indicates the end of the turn.
	//
	// Types that are assignable to MainContent:
	//
	//	*BidiStreamingAnalyzeContentRequest_TurnInput_Text
	//	*BidiStreamingAnalyzeContentRequest_TurnInput_Intent
	//	*BidiStreamingAnalyzeContentRequest_TurnInput_Event
	MainContent isBidiStreamingAnalyzeContentRequest_TurnInput_MainContent `protobuf_oneof:"main_content"`
	// Optional. Parameters to be passed to the virtual agent.
	VirtualAgentParameters *structpb.Struct `protobuf:"bytes,4,opt,name=virtual_agent_parameters,json=virtualAgentParameters,proto3" json:"virtual_agent_parameters,omitempty"`
}

func (x *BidiStreamingAnalyzeContentRequest_TurnInput) Reset() {
	*x = BidiStreamingAnalyzeContentRequest_TurnInput{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiStreamingAnalyzeContentRequest_TurnInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiStreamingAnalyzeContentRequest_TurnInput) ProtoMessage() {}

func (x *BidiStreamingAnalyzeContentRequest_TurnInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiStreamingAnalyzeContentRequest_TurnInput.ProtoReflect.Descriptor instead.
func (*BidiStreamingAnalyzeContentRequest_TurnInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{45, 1}
}

func (m *BidiStreamingAnalyzeContentRequest_TurnInput) GetMainContent() isBidiStreamingAnalyzeContentRequest_TurnInput_MainContent {
	if m != nil {
		return m.MainContent
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentRequest_TurnInput) GetText() string {
	if x, ok := x.GetMainContent().(*BidiStreamingAnalyzeContentRequest_TurnInput_Text); ok {
		return x.Text
	}
	return ""
}

func (x *BidiStreamingAnalyzeContentRequest_TurnInput) GetIntent() string {
	if x, ok := x.GetMainContent().(*BidiStreamingAnalyzeContentRequest_TurnInput_Intent); ok {
		return x.Intent
	}
	return ""
}

func (x *BidiStreamingAnalyzeContentRequest_TurnInput) GetEvent() string {
	if x, ok := x.GetMainContent().(*BidiStreamingAnalyzeContentRequest_TurnInput_Event); ok {
		return x.Event
	}
	return ""
}

func (x *BidiStreamingAnalyzeContentRequest_TurnInput) GetVirtualAgentParameters() *structpb.Struct {
	if x != nil {
		return x.VirtualAgentParameters
	}
	return nil
}

type isBidiStreamingAnalyzeContentRequest_TurnInput_MainContent interface {
	isBidiStreamingAnalyzeContentRequest_TurnInput_MainContent()
}

type BidiStreamingAnalyzeContentRequest_TurnInput_Text struct {
	// The UTF-8 encoded natural language text to be processed.
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type BidiStreamingAnalyzeContentRequest_TurnInput_Intent struct {
	// The intent to be triggered on V3 agent.
	// Format: `projects/<Project ID>/locations/<Location ID>/locations/
	// <Location ID>/agents/<Agent ID>/intents/<Intent ID>`. This can only be
	// used to trigger the Welcome intent id if the modality is text.
	Intent string `protobuf:"bytes,2,opt,name=intent,proto3,oneof"`
}

type BidiStreamingAnalyzeContentRequest_TurnInput_Event struct {
	// The input event name.
	// This can only be sent once and would cancel the ongoing speech
	// recognition if any. To trigger the Welcome intent use the
	// event "WELCOME"
	Event string `protobuf:"bytes,3,opt,name=event,proto3,oneof"`
}

func (*BidiStreamingAnalyzeContentRequest_TurnInput_Text) isBidiStreamingAnalyzeContentRequest_TurnInput_MainContent() {
}

func (*BidiStreamingAnalyzeContentRequest_TurnInput_Intent) isBidiStreamingAnalyzeContentRequest_TurnInput_MainContent() {
}

func (*BidiStreamingAnalyzeContentRequest_TurnInput_Event) isBidiStreamingAnalyzeContentRequest_TurnInput_MainContent() {
}

// Input for the conversation.
type BidiStreamingAnalyzeContentRequest_Input struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Input:
	//
	//	*BidiStreamingAnalyzeContentRequest_Input_Audio
	//	*BidiStreamingAnalyzeContentRequest_Input_Dtmf
	//	*BidiStreamingAnalyzeContentRequest_Input_Turn
	Input isBidiStreamingAnalyzeContentRequest_Input_Input `protobuf_oneof:"input"`
}

func (x *BidiStreamingAnalyzeContentRequest_Input) Reset() {
	*x = BidiStreamingAnalyzeContentRequest_Input{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiStreamingAnalyzeContentRequest_Input) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiStreamingAnalyzeContentRequest_Input) ProtoMessage() {}

func (x *BidiStreamingAnalyzeContentRequest_Input) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiStreamingAnalyzeContentRequest_Input.ProtoReflect.Descriptor instead.
func (*BidiStreamingAnalyzeContentRequest_Input) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{45, 2}
}

func (m *BidiStreamingAnalyzeContentRequest_Input) GetInput() isBidiStreamingAnalyzeContentRequest_Input_Input {
	if m != nil {
		return m.Input
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentRequest_Input) GetAudio() []byte {
	if x, ok := x.GetInput().(*BidiStreamingAnalyzeContentRequest_Input_Audio); ok {
		return x.Audio
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentRequest_Input) GetDtmf() *TelephonyDtmfEvents {
	if x, ok := x.GetInput().(*BidiStreamingAnalyzeContentRequest_Input_Dtmf); ok {
		return x.Dtmf
	}
	return nil
}

func (x *BidiStreamingAnalyzeContentRequest_Input) GetTurn() *BidiStreamingAnalyzeContentRequest_TurnInput {
	if x, ok := x.GetInput().(*BidiStreamingAnalyzeContentRequest_Input_Turn); ok {
		return x.Turn
	}
	return nil
}

type isBidiStreamingAnalyzeContentRequest_Input_Input interface {
	isBidiStreamingAnalyzeContentRequest_Input_Input()
}

type BidiStreamingAnalyzeContentRequest_Input_Audio struct {
	// The content of audio stream to be recognized.
	Audio []byte `protobuf:"bytes,1,opt,name=audio,proto3,oneof"`
}

type BidiStreamingAnalyzeContentRequest_Input_Dtmf struct {
	// The DTMF digits used to invoke intent and fill in parameter value.
	//
	// This input is ignored if the previous response indicated that DTMF
	// input is not accepted.
	Dtmf *TelephonyDtmfEvents `protobuf:"bytes,2,opt,name=dtmf,proto3,oneof"`
}

type BidiStreamingAnalyzeContentRequest_Input_Turn struct {
	// Turn input.
	Turn *BidiStreamingAnalyzeContentRequest_TurnInput `protobuf:"bytes,3,opt,name=turn,proto3,oneof"`
}

func (*BidiStreamingAnalyzeContentRequest_Input_Audio) isBidiStreamingAnalyzeContentRequest_Input_Input() {
}

func (*BidiStreamingAnalyzeContentRequest_Input_Dtmf) isBidiStreamingAnalyzeContentRequest_Input_Input() {
}

func (*BidiStreamingAnalyzeContentRequest_Input_Turn) isBidiStreamingAnalyzeContentRequest_Input_Input() {
}

// The config about how to process the audio for a voice-based session.
type BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The encoding of input audio.
	InputAudioEncoding AudioEncoding `protobuf:"varint,1,opt,name=input_audio_encoding,json=inputAudioEncoding,proto3,enum=google.cloud.dialogflow.v2beta1.AudioEncoding" json:"input_audio_encoding,omitempty"`
	// Required. The sample rate of input audio.
	InputAudioSampleRateHertz int32 `protobuf:"varint,2,opt,name=input_audio_sample_rate_hertz,json=inputAudioSampleRateHertz,proto3" json:"input_audio_sample_rate_hertz,omitempty"`
	// Required. The encoding of output audio.
	OutputAudioEncoding OutputAudioEncoding `protobuf:"varint,3,opt,name=output_audio_encoding,json=outputAudioEncoding,proto3,enum=google.cloud.dialogflow.v2beta1.OutputAudioEncoding" json:"output_audio_encoding,omitempty"`
	// Required. The sample rate of output audio.
	OutputAudioSampleRateHertz int32 `protobuf:"varint,4,opt,name=output_audio_sample_rate_hertz,json=outputAudioSampleRateHertz,proto3" json:"output_audio_sample_rate_hertz,omitempty"`
	// Optional. Whether to enable CX proactive processing.
	EnableCxProactiveProcessing bool `protobuf:"varint,5,opt,name=enable_cx_proactive_processing,json=enableCxProactiveProcessing,proto3" json:"enable_cx_proactive_processing,omitempty"`
	// Optional. If true, Dialogflow will stream the audio bytes from Cloud
	// TTS for speech synthesis using the StreamingSynthesize api.
	EnableStreamingSynthesize bool `protobuf:"varint,23,opt,name=enable_streaming_synthesize,json=enableStreamingSynthesize,proto3" json:"enable_streaming_synthesize,omitempty"`
}

func (x *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) Reset() {
	*x = BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) ProtoMessage() {}

func (x *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig.ProtoReflect.Descriptor instead.
func (*BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{45, 0, 0}
}

func (x *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) GetInputAudioEncoding() AudioEncoding {
	if x != nil {
		return x.InputAudioEncoding
	}
	return AudioEncoding_AUDIO_ENCODING_UNSPECIFIED
}

func (x *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) GetInputAudioSampleRateHertz() int32 {
	if x != nil {
		return x.InputAudioSampleRateHertz
	}
	return 0
}

func (x *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) GetOutputAudioEncoding() OutputAudioEncoding {
	if x != nil {
		return x.OutputAudioEncoding
	}
	return OutputAudioEncoding_OUTPUT_AUDIO_ENCODING_UNSPECIFIED
}

func (x *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) GetOutputAudioSampleRateHertz() int32 {
	if x != nil {
		return x.OutputAudioSampleRateHertz
	}
	return 0
}

func (x *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) GetEnableCxProactiveProcessing() bool {
	if x != nil {
		return x.EnableCxProactiveProcessing
	}
	return false
}

func (x *BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig) GetEnableStreamingSynthesize() bool {
	if x != nil {
		return x.EnableStreamingSynthesize
	}
	return false
}

// Indicate the user barge-in has been detected.
type BidiStreamingAnalyzeContentResponse_BargeInSignal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BidiStreamingAnalyzeContentResponse_BargeInSignal) Reset() {
	*x = BidiStreamingAnalyzeContentResponse_BargeInSignal{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiStreamingAnalyzeContentResponse_BargeInSignal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiStreamingAnalyzeContentResponse_BargeInSignal) ProtoMessage() {}

func (x *BidiStreamingAnalyzeContentResponse_BargeInSignal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiStreamingAnalyzeContentResponse_BargeInSignal.ProtoReflect.Descriptor instead.
func (*BidiStreamingAnalyzeContentResponse_BargeInSignal) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{46, 0}
}

// Indicate that the turn is complete.
type BidiStreamingAnalyzeContentResponse_TurnComplete struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *BidiStreamingAnalyzeContentResponse_TurnComplete) Reset() {
	*x = BidiStreamingAnalyzeContentResponse_TurnComplete{}
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BidiStreamingAnalyzeContentResponse_TurnComplete) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BidiStreamingAnalyzeContentResponse_TurnComplete) ProtoMessage() {}

func (x *BidiStreamingAnalyzeContentResponse_TurnComplete) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BidiStreamingAnalyzeContentResponse_TurnComplete.ProtoReflect.Descriptor instead.
func (*BidiStreamingAnalyzeContentResponse_TurnComplete) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP(), []int{46, 1}
}

var File_google_cloud_dialogflow_v2beta1_participant_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_v2beta1_participant_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65,
	0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc0, 0x05, 0x0a, 0x0b, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4a,
	0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x05, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x42, 0x0a, 0x1b, 0x6f, 0x62,
	0x66, 0x75, 0x73, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x6f, 0x62, 0x66, 0x75, 0x73, 0x63, 0x61, 0x74, 0x65, 0x64,
	0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x12, 0x8d,
	0x01, 0x0a, 0x1a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5f, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x4b,
	0x0a, 0x1d, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x50, 0x0a, 0x04, 0x52,
	0x6f, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x55, 0x4d,
	0x41, 0x4e, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f, 0x41, 0x55,
	0x54, 0x4f, 0x4d, 0x41, 0x54, 0x45, 0x44, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12,
	0x0c, 0x0a, 0x08, 0x45, 0x4e, 0x44, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x10, 0x03, 0x3a, 0xd8, 0x01,
	0xea, 0x41, 0xd4, 0x01, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x4a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x7d, 0x12, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x7d, 0x22, 0xf6, 0x06, 0x0a, 0x07, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x62, 0x0a, 0x11,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x12, 0x61, 0x0a, 0x10, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x52, 0x6f, 0x6c, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x52, 0x6f, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x64,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x66, 0x0a, 0x12, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x12,
	0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65,
	0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x3a, 0xc4, 0x01, 0xea, 0x41, 0xc0,
	0x01, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x42, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x7d, 0x12, 0x57, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x7d, 0x22, 0xb6, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x22, 0x5a, 0x0a, 0x15, 0x47, 0x65,
	0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x94, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x0c,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x52, 0x0c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb1, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x6d, 0x0a, 0x0a, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x49, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x22, 0x6f, 0x0a, 0x0b, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x4a, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x14, 0x0a, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x22, 0x81, 0x07, 0x0a, 0x13, 0x41,
	0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x79, 0x12, 0x6d, 0x0a, 0x16, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x14, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x5d, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x10,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73,
	0x12, 0x3f, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x48, 0x01, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x16, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x01, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x4f, 0x0a,
	0x15, 0x63, 0x78, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x13, 0x63, 0x78, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x89,
	0x01, 0x0a, 0x1a, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x17, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x12, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x26, 0x0a, 0x0f, 0x63, 0x78, 0x5f,
	0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x63, 0x78, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x12, 0x37, 0x0a, 0x18, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e,
	0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0c, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x15, 0x63, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69,
	0x6f, 0x6e, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x5d, 0x0a, 0x17, 0x41, 0x75,
	0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x26, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54,
	0x45, 0x44, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x59, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x09,
	0x0a, 0x05, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x10, 0x02, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x22, 0xec,
	0x03, 0x0a, 0x0f, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x12, 0x4f, 0x0a, 0x0d, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x65, 0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x0c, 0x74, 0x65, 0x78, 0x74,
	0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x37, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x12, 0x54, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x0b, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x3c, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x73, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x45, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x12, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x56, 0x49, 0x53, 0x45, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x10, 0x03, 0x22, 0x54, 0x0a,
	0x0b, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x1b, 0x0a, 0x06,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43,
	0x6f, 0x64, 0x65, 0x22, 0x94, 0x02, 0x0a, 0x11, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x12, 0x4b, 0x0a, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x52, 0x54, 0x49, 0x43, 0x4c, 0x45,
	0x5f, 0x53, 0x55, 0x47, 0x47, 0x45, 0x53, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x07, 0x0a,
	0x03, 0x46, 0x41, 0x51, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x53, 0x4d, 0x41, 0x52, 0x54, 0x5f,
	0x52, 0x45, 0x50, 0x4c, 0x59, 0x10, 0x03, 0x12, 0x15, 0x0a, 0x11, 0x44, 0x49, 0x41, 0x4c, 0x4f,
	0x47, 0x46, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x53, 0x53, 0x49, 0x53, 0x54, 0x10, 0x04, 0x12, 0x1e,
	0x0a, 0x1a, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53,
	0x55, 0x4d, 0x4d, 0x41, 0x52, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x08, 0x12, 0x14,
	0x0a, 0x10, 0x4b, 0x4e, 0x4f, 0x57, 0x4c, 0x45, 0x44, 0x47, 0x45, 0x5f, 0x53, 0x45, 0x41, 0x52,
	0x43, 0x48, 0x10, 0x0e, 0x12, 0x14, 0x0a, 0x10, 0x4b, 0x4e, 0x4f, 0x57, 0x4c, 0x45, 0x44, 0x47,
	0x45, 0x5f, 0x41, 0x53, 0x53, 0x49, 0x53, 0x54, 0x10, 0x0f, 0x22, 0xf9, 0x01, 0x0a, 0x15, 0x41,
	0x73, 0x73, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x92, 0x01, 0x0a, 0x1a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69,
	0x73, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x18, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x1a, 0x4b, 0x0a, 0x1d, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x81, 0x08, 0x0a, 0x15, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x12, 0x4b, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x48, 0x00, 0x52, 0x09, 0x74, 0x65, 0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4e,
	0x0a, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x48, 0x00, 0x52, 0x0a, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4e,
	0x0a, 0x0b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x48, 0x00, 0x52, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x5d,
	0x0a, 0x10, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x73, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x51, 0x0a,
	0x0c, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x60, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x52, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x53, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0b, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x66, 0x0a, 0x13, 0x61, 0x73, 0x73, 0x69, 0x73,
	0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x11, 0x61, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12,
	0x3c, 0x0a, 0x0d, 0x63, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x0c, 0x63, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x63, 0x78, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x18, 0x14, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x78, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x4b, 0x0a, 0x11, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x53, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x22, 0x3e, 0x0a, 0x0e, 0x44, 0x74,
	0x6d, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2c, 0x0a, 0x12,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x5f, 0x64, 0x74, 0x6d, 0x66, 0x5f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74,
	0x73, 0x44, 0x74, 0x6d, 0x66, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x22, 0xf8, 0x04, 0x0a, 0x16, 0x41,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x70, 0x6c, 0x79,
	0x54, 0x65, 0x78, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x12, 0x68, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x52, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x42, 0x0a,
	0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x12, 0x76, 0x0a, 0x1e, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x1b, 0x68, 0x75,
	0x6d, 0x61, 0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x70, 0x0a, 0x1b, 0x65, 0x6e, 0x64,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x52, 0x18, 0x65, 0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x64,
	0x74, 0x6d, 0x66, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x74, 0x6d, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0e, 0x64, 0x74, 0x6d, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x36, 0x0a, 0x0f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x65,
	0x78, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x22, 0xe3, 0x08,
	0x0a, 0x1e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4f, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x12, 0x56, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x41,
	0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x53, 0x0a, 0x0b, 0x74, 0x65, 0x78,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60,
	0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10,
	0x72, 0x65, 0x70, 0x6c, 0x79, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x01, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x12, 0x1f, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x54, 0x65, 0x78, 0x74, 0x12, 0x55, 0x0a, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x64, 0x74,
	0x6d, 0x66, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x70,
	0x68, 0x6f, 0x6e, 0x79, 0x44, 0x74, 0x6d, 0x66, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x48, 0x01,
	0x52, 0x09, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x44, 0x74, 0x6d, 0x66, 0x12, 0x23, 0x0a, 0x0c, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x01, 0x52, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0a, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x53, 0x0a, 0x0c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x0b, 0x71, 0x75, 0x65,
	0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x66, 0x0a, 0x13, 0x61, 0x73, 0x73, 0x69,
	0x73, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x11, 0x61,
	0x73, 0x73, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73,
	0x12, 0x3c, 0x0a, 0x0d, 0x63, 0x78, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x0c, 0x63, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x63, 0x78, 0x5f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x78, 0x43, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x3f, 0x0a, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x17,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x12, 0x53, 0x0a, 0x24, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x20, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74,
	0x65, 0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x32, 0x0a, 0x15,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x44, 0x65, 0x62, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f,
	0x42, 0x08, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x22, 0xf8, 0x06, 0x0a, 0x1f, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6a, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x67,
	0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x52, 0x11, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x54, 0x65,
	0x78, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x52, 0x0a, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x41, 0x75, 0x64, 0x69,
	0x6f, 0x12, 0x68, 0x0a, 0x15, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x52, 0x13, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x42, 0x0a, 0x07, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0x76, 0x0a, 0x1e, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x1b, 0x68, 0x75, 0x6d, 0x61,
	0x6e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x70, 0x0a, 0x1b, 0x65, 0x6e, 0x64, 0x5f, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52,
	0x18, 0x65, 0x6e, 0x64, 0x55, 0x73, 0x65, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x64, 0x74, 0x6d,
	0x66, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x74, 0x6d, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x52, 0x0e, 0x64, 0x74, 0x6d, 0x66, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x66, 0x0a, 0x0e, 0x64, 0x65, 0x62, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x62, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x64, 0x65,
	0x62, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x73,
	0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x8c,
	0x01, 0x0a, 0x14, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x50, 0x61, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3f, 0x0a, 0x0f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0e, 0x66,
	0x6f, 0x72, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x8b, 0x01,
	0x0a, 0x11, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x4b, 0x0a, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x61, 0x72, 0x74, 0x52, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73,
	0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x5f, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x74,
	0x61, 0x69, 0x6e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x22, 0x8f, 0x02, 0x0a, 0x0d,
	0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x14, 0x0a,
	0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74,
	0x73, 0x12, 0x58, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0d, 0x61,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xaf, 0x02,
	0x0a, 0x09, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x61,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x61, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x54, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x71, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a,
	0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f,
	0x72, 0x64, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x9a, 0x01, 0x0a, 0x10, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x79, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x05, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x50, 0x0a, 0x0d, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x0c,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x22, 0x80, 0x01, 0x0a,
	0x10, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x76,
	0x32, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x56, 0x32, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x08, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22,
	0xfc, 0x01, 0x0a, 0x16, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x41, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x51, 0x0a, 0x0c, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00,
	0x52, 0x0b, 0x71, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x60, 0x0a,
	0x11, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x10, 0x69,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x42, 0x08, 0x0a, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x22, 0x8e,
	0x08, 0x0a, 0x10, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x2a, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x48, 0x00, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x76, 0x0a, 0x19, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x6c, 0x65, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69,
	0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x17,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x8c, 0x01, 0x0a, 0x21, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x5f, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x5f, 0x61, 0x73,
	0x73, 0x69, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x4b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x1e, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x4b,
	0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7d, 0x0a, 0x1c, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x5f, 0x66, 0x61, 0x71, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x5f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x19, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x83, 0x01, 0x0a, 0x1e, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x5f, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x5f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x1b,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x92, 0x01, 0x0a, 0x23,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x41, 0x73, 0x73,
	0x69, 0x73, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x20,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x90, 0x01, 0x0a, 0x22, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x5f, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5f, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x48, 0x00, 0x52, 0x1f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x45, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x82, 0x01, 0x0a, 0x1d, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x72, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x1b, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xc6, 0x02, 0x0a, 0x16, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x50, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x6b, 0x0a, 0x13, 0x61,
	0x73, 0x73, 0x69, 0x73, 0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x73,
	0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x22, 0xbc, 0x01, 0x0a, 0x17, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x0f, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x5f,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x0e, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a,
	0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xc8, 0x02, 0x0a, 0x18, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0e, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x6b, 0x0a, 0x13, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x11, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x22, 0xb2, 0x01, 0x0a, 0x19, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61,
	0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4b, 0x0a, 0x0b, 0x66, 0x61, 0x71, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x52, 0x0a, 0x66, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a,
	0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xaf, 0x02, 0x0a, 0x1a, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x58, 0x0a,
	0x12, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x78, 0x74,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x52, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x54, 0x65,
	0x78, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4d, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xf2, 0x01, 0x0a, 0x1b, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x65,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a, 0x13, 0x73, 0x6d, 0x61,
	0x72, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x79, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x11, 0x73, 0x6d, 0x61, 0x72, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x79, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12, 0x4d, 0x0a, 0x0e,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x6c, 0x61,
	0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x8b,
	0x04, 0x0a, 0x1b, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x98,
	0x01, 0x0a, 0x1c, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x5f, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x56, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x1a, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12, 0x4d, 0x0a, 0x0e, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73,
	0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x1a, 0x81, 0x02, 0x0a, 0x19, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x67, 0x0a, 0x14, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x13, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x6f, 0x72, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x29, 0x0a, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x50, 0x0a, 0x0d, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2b, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x52, 0x0c,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x22, 0xe1, 0x01, 0x0a,
	0x20, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x73, 0x0a, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x5f,
	0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x17, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65,
	0x22, 0xff, 0x06, 0x0a, 0x0a, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x08, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x52, 0x08, 0x61, 0x72, 0x74, 0x69,
	0x63, 0x6c, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x0b, 0x66, 0x61, 0x71, 0x5f, 0x61, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x52, 0x0a, 0x66, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x1a, 0x8e, 0x02, 0x0a, 0x07, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73,
	0x12, 0x5d, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65,
	0x63, 0x6f, 0x72, 0x64, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0xba, 0x02, 0x0a, 0x09, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12,
	0x16, 0x0a, 0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5f, 0x0a, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x61, 0x71, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0d,
	0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63, 0x6f, 0x72,
	0x64, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x02,
	0x18, 0x01, 0x22, 0x88, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x3a, 0x02, 0x18, 0x01, 0x22, 0x94, 0x01,
	0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0b, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x3a, 0x02, 0x18, 0x01, 0x22, 0x80, 0x01, 0x0a, 0x18, 0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x74,
	0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53,
	0x69, 0x7a, 0x65, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xb6, 0x01, 0x0a, 0x19, 0x43, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65,
	0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x3a, 0x02, 0x18, 0x01,
	0x22, 0xaf, 0x08, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x12, 0x4b, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x33, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x48, 0x00, 0x52, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x71, 0x0a, 0x12, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x48, 0x61,
	0x6e, 0x64, 0x6f, 0x66, 0x66, 0x48, 0x00, 0x52, 0x10, 0x6c, 0x69, 0x76, 0x65, 0x41, 0x67, 0x65,
	0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x12, 0x6a, 0x0a, 0x0f, 0x65, 0x6e, 0x64,
	0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x2e, 0x45, 0x6e, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5e, 0x0a, 0x0b, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x5f, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x4d, 0x69, 0x78,
	0x65, 0x64, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x48, 0x00, 0x52, 0x0a, 0x6d, 0x69, 0x78, 0x65, 0x64,
	0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x80, 0x01, 0x0a, 0x17, 0x74, 0x65, 0x6c, 0x65, 0x70, 0x68,
	0x6f, 0x6e, 0x79, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x5f, 0x63, 0x61, 0x6c,
	0x6c, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x70, 0x68,
	0x6f, 0x6e, 0x79, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x61, 0x6c, 0x6c, 0x48,
	0x00, 0x52, 0x15, 0x74, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x66, 0x65, 0x72, 0x43, 0x61, 0x6c, 0x6c, 0x1a, 0x1a, 0x0a, 0x04, 0x54, 0x65, 0x78, 0x74,
	0x12, 0x12, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x1a, 0x47, 0x0a, 0x10, 0x4c, 0x69, 0x76, 0x65, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x48, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x66, 0x12, 0x33, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x10, 0x0a,
	0x0e, 0x45, 0x6e, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0xf0, 0x01, 0x0a, 0x0a, 0x4d, 0x69, 0x78, 0x65, 0x64, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x12, 0x5f,
	0x0a, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x2e, 0x4d, 0x69, 0x78, 0x65, 0x64, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x2e, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x1a,
	0x80, 0x01, 0x0a, 0x07, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x16, 0x0a, 0x05, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x05, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x3e, 0x0a, 0x1b, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
	0x5f, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x72,
	0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x19, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72,
	0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x09, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x1a, 0x63, 0x0a, 0x15, 0x54, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x23, 0x0a, 0x0c, 0x70,
	0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x19, 0x0a, 0x07, 0x73, 0x69, 0x70, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x06, 0x73, 0x69, 0x70, 0x55, 0x72, 0x69, 0x42, 0x0a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x22, 0x9f, 0x02, 0x0a, 0x1d, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x4b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x50, 0x0a, 0x0e, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x0d,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x26, 0x0a,
	0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x3d, 0x0a, 0x18, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75,
	0x73, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x70, 0x72,
	0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x22, 0xdf, 0x01, 0x0a, 0x1e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x73, 0x0a, 0x17, 0x6b, 0x6e, 0x6f, 0x77, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x5f, 0x61, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65,
	0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x22, 0xcd, 0x07, 0x0a, 0x15, 0x4b, 0x6e, 0x6f, 0x77, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x12, 0x6e, 0x0a, 0x0f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4b, 0x6e, 0x6f, 0x77,
	0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65,
	0x72, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x0e, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x12, 0x7c, 0x0a, 0x16, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69,
	0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x14, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x23,
	0x0a, 0x0d, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x52, 0x65, 0x63,
	0x6f, 0x72, 0x64, 0x1a, 0x2f, 0x0a, 0x0e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x54, 0x65, 0x78, 0x74, 0x1a, 0xef, 0x04, 0x0a, 0x0f, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
	0x67, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x61, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x61,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x54, 0x65, 0x78, 0x74, 0x12, 0x71, 0x0a, 0x0a, 0x66, 0x61, 0x71,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x50, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x46, 0x61, 0x71, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48,
	0x00, 0x52, 0x09, 0x66, 0x61, 0x71, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x86, 0x01, 0x0a,
	0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c,
	0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x27, 0x0a, 0x09, 0x46, 0x61, 0x71, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x8b,
	0x02, 0x0a, 0x10, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x12, 0x7b, 0x0a, 0x08, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
	0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x4b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x53,
	0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x52, 0x08, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73,
	0x1a, 0x7a, 0x0a, 0x07, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x12, 0x0a,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x65, 0x78,
	0x74, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x33, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x08, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x9f, 0x0d, 0x0a, 0x22, 0x42, 0x69, 0x64, 0x69, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x64, 0x0a,
	0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x42, 0x69, 0x64, 0x69, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69,
	0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52,
	0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x1a, 0xe3, 0x07, 0x0a, 0x06, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x4f, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x12, 0x91, 0x01, 0x0a, 0x14, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x5d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x6f,
	0x69, 0x63, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x12, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x0a, 0x20, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61,
	0x6c, 0x5f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x1d, 0x69, 0x6e, 0x69, 0x74, 0x69,
	0x61, 0x6c, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x7c, 0x0a, 0x22, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x5f, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x52, 0x1e, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x56,
	0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x1a, 0x89, 0x04, 0x0a, 0x12, 0x56, 0x6f, 0x69, 0x63, 0x65,
	0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a,
	0x14, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x65, 0x6e, 0x63,
	0x6f, 0x64, 0x69, 0x6e, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x75,
	0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x12, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x12, 0x45, 0x0a, 0x1d, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x68, 0x65, 0x72, 0x74, 0x7a, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x19, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x53, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65, 0x72, 0x74, 0x7a, 0x12, 0x6d, 0x0a, 0x15, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x65, 0x6e, 0x63, 0x6f,
	0x64, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x41, 0x75, 0x64, 0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x75, 0x64,
	0x69, 0x6f, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x47, 0x0a, 0x1e, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x68, 0x65, 0x72, 0x74, 0x7a, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41,
	0x75, 0x64, 0x69, 0x6f, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74, 0x65, 0x48, 0x65,
	0x72, 0x74, 0x7a, 0x12, 0x48, 0x0a, 0x1e, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x78,
	0x5f, 0x70, 0x72, 0x6f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x78, 0x50, 0x72, 0x6f, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x12, 0x43, 0x0a,
	0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x5f, 0x73, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x53, 0x79, 0x6e, 0x74, 0x68, 0x65, 0x73, 0x69,
	0x7a, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xe2, 0x01, 0x0a,
	0x09, 0x54, 0x75, 0x72, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x14, 0x0a, 0x04, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74,
	0x12, 0x3f, 0x0a, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x06, 0x69, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x12, 0x16, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x56, 0x0a, 0x18, 0x76, 0x69, 0x72,
	0x74, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x76, 0x69, 0x72, 0x74, 0x75,
	0x61, 0x6c, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x6d, 0x61, 0x69, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x1a, 0xd9, 0x01, 0x0a, 0x05, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x16, 0x0a, 0x05, 0x61,
	0x75, 0x64, 0x69, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x48, 0x00, 0x52, 0x05, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x12, 0x4a, 0x0a, 0x04, 0x64, 0x74, 0x6d, 0x66, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x65, 0x6c, 0x65, 0x70, 0x68, 0x6f, 0x6e, 0x79, 0x44, 0x74, 0x6d,
	0x66, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x48, 0x00, 0x52, 0x04, 0x64, 0x74, 0x6d, 0x66, 0x12,
	0x63, 0x0a, 0x04, 0x74, 0x75, 0x72, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x42, 0x69, 0x64, 0x69, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x54, 0x75, 0x72, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x04,
	0x74, 0x75, 0x72, 0x6e, 0x42, 0x07, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x09, 0x0a,
	0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x22, 0xad, 0x04, 0x0a, 0x23, 0x42, 0x69, 0x64,
	0x69, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x6c, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x11, 0x72, 0x65, 0x63,
	0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7c,
	0x0a, 0x0f, 0x62, 0x61, 0x72, 0x67, 0x65, 0x5f, 0x69, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x42, 0x61,
	0x72, 0x67, 0x65, 0x49, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x0d, 0x62,
	0x61, 0x72, 0x67, 0x65, 0x49, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x12, 0x73, 0x0a, 0x18,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x48, 0x00, 0x52, 0x16, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x78, 0x0a, 0x0d, 0x74, 0x75, 0x72, 0x6e, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x54,
	0x75, 0x72, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x48, 0x00, 0x52, 0x0c, 0x74,
	0x75, 0x72, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x1a, 0x0f, 0x0a, 0x0d, 0x42,
	0x61, 0x72, 0x67, 0x65, 0x49, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x1a, 0x0e, 0x0a, 0x0c,
	0x54, 0x75, 0x72, 0x6e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x0a, 0x0a, 0x08,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x32, 0xb2, 0x1f, 0x0a, 0x0c, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0xb9, 0x02, 0x0a, 0x11, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x22, 0xba, 0x01, 0xda, 0x41, 0x12, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9e, 0x01, 0x3a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x5a, 0x54, 0x3a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x22, 0x45, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x22, 0x39, 0x2f, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x8b, 0x02, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x22, 0x92,
	0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x84, 0x01, 0x5a,
	0x47, 0x12, 0x45, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x39, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x9e, 0x02, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x94, 0x01,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x84, 0x01,
	0x5a, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x39, 0x2f, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x73, 0x12, 0xd6, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x22, 0xd7, 0x01, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb6, 0x01, 0x3a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x5a, 0x60, 0x3a, 0x0b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
	0x61, 0x6e, 0x74, 0x32, 0x51, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x45, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61,
	0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8e, 0x03,
	0x0a, 0x0e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x8a, 0x02, 0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x2c, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0xda, 0x41, 0x17,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x2c, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x2c, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb6, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x60, 0x3a, 0x01, 0x2a,
	0x22, 0x5b, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74,
	0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70,
	0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x4f, 0x2f,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0xa2,
	0x01, 0x0a, 0x17, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c,
	0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x3f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28,
	0x01, 0x30, 0x01, 0x12, 0xae, 0x01, 0x0a, 0x1b, 0x42, 0x69, 0x64, 0x69, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x64, 0x69, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00,
	0x28, 0x01, 0x30, 0x01, 0x12, 0xdd, 0x02, 0x0a, 0x0f, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63,
	0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xd6, 0x01, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc6, 0x01, 0x3a, 0x01,
	0x2a, 0x5a, 0x68, 0x3a, 0x01, 0x2a, 0x22, 0x63, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x22, 0x57, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x41, 0x72, 0x74, 0x69,
	0x63, 0x6c, 0x65, 0x73, 0x12, 0xe7, 0x02, 0x0a, 0x11, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46,
	0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xda, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xca, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x6a, 0x3a, 0x01, 0x2a, 0x22, 0x65, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x3a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x73, 0x22, 0x59, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x46, 0x61, 0x71, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x73, 0x12, 0xf1,
	0x02, 0x0a, 0x13, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x53, 0x6d, 0x61,
	0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xde, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0xce, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x6c, 0x3a, 0x01, 0x2a, 0x22, 0x67, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x3a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x65, 0x73, 0x22, 0x5b, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x53, 0x6d, 0x61, 0x72, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x65, 0x73, 0x12, 0xf7, 0x02, 0x0a, 0x16, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x4b, 0x6e,
	0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65,
	0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x4b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65,
	0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xdb,
	0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd4, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x6f, 0x3a, 0x01, 0x2a,
	0x22, 0x6a, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x4b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x22, 0x5e, 0x2f, 0x76,
	0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
	0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x4b, 0x6e, 0x6f,
	0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x41, 0x73, 0x73, 0x69, 0x73, 0x74, 0x12, 0xd8, 0x01, 0x0a,
	0x0f, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x49, 0x12, 0x47, 0x2f, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69,
	0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x88, 0x02, 0x01, 0x12, 0xe9, 0x01, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70,
	0x69, 0x6c, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x39, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x69,
	0x6c, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x54, 0x3a, 0x01, 0x2a, 0x22,
	0x4f, 0x2f, 0x76, 0x32, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x61, 0x72,
	0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x65,
	0x88, 0x02, 0x01, 0x1a, 0x78, 0xca, 0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75,
	0x74, 0x68, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xa5, 0x01,
	0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x76, 0x32,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x10, 0x50, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70,
	0x62, 0x3b, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x70, 0x62, 0xa2, 0x02,
	0x02, 0x44, 0x46, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x56, 0x32,
	0x42, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescData = file_google_cloud_dialogflow_v2beta1_participant_proto_rawDesc
)

func file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_v2beta1_participant_proto_rawDescData
}

var file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes = make([]protoimpl.MessageInfo, 73)
var file_google_cloud_dialogflow_v2beta1_participant_proto_goTypes = []any{
	(Participant_Role)(0),                            // 0: google.cloud.dialogflow.v2beta1.Participant.Role
	(AutomatedAgentReply_AutomatedAgentReplyType)(0), // 1: google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType
	(SuggestionInput_Action)(0),                      // 2: google.cloud.dialogflow.v2beta1.SuggestionInput.Action
	(SuggestionFeature_Type)(0),                      // 3: google.cloud.dialogflow.v2beta1.SuggestionFeature.Type
	(*Participant)(nil),                              // 4: google.cloud.dialogflow.v2beta1.Participant
	(*Message)(nil),                                  // 5: google.cloud.dialogflow.v2beta1.Message
	(*CreateParticipantRequest)(nil),                 // 6: google.cloud.dialogflow.v2beta1.CreateParticipantRequest
	(*GetParticipantRequest)(nil),                    // 7: google.cloud.dialogflow.v2beta1.GetParticipantRequest
	(*ListParticipantsRequest)(nil),                  // 8: google.cloud.dialogflow.v2beta1.ListParticipantsRequest
	(*ListParticipantsResponse)(nil),                 // 9: google.cloud.dialogflow.v2beta1.ListParticipantsResponse
	(*UpdateParticipantRequest)(nil),                 // 10: google.cloud.dialogflow.v2beta1.UpdateParticipantRequest
	(*AudioInput)(nil),                               // 11: google.cloud.dialogflow.v2beta1.AudioInput
	(*OutputAudio)(nil),                              // 12: google.cloud.dialogflow.v2beta1.OutputAudio
	(*AutomatedAgentReply)(nil),                      // 13: google.cloud.dialogflow.v2beta1.AutomatedAgentReply
	(*SuggestionInput)(nil),                          // 14: google.cloud.dialogflow.v2beta1.SuggestionInput
	(*IntentInput)(nil),                              // 15: google.cloud.dialogflow.v2beta1.IntentInput
	(*SuggestionFeature)(nil),                        // 16: google.cloud.dialogflow.v2beta1.SuggestionFeature
	(*AssistQueryParameters)(nil),                    // 17: google.cloud.dialogflow.v2beta1.AssistQueryParameters
	(*AnalyzeContentRequest)(nil),                    // 18: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest
	(*DtmfParameters)(nil),                           // 19: google.cloud.dialogflow.v2beta1.DtmfParameters
	(*AnalyzeContentResponse)(nil),                   // 20: google.cloud.dialogflow.v2beta1.AnalyzeContentResponse
	(*InputTextConfig)(nil),                          // 21: google.cloud.dialogflow.v2beta1.InputTextConfig
	(*StreamingAnalyzeContentRequest)(nil),           // 22: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
	(*StreamingAnalyzeContentResponse)(nil),          // 23: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse
	(*AnnotatedMessagePart)(nil),                     // 24: google.cloud.dialogflow.v2beta1.AnnotatedMessagePart
	(*MessageAnnotation)(nil),                        // 25: google.cloud.dialogflow.v2beta1.MessageAnnotation
	(*ArticleAnswer)(nil),                            // 26: google.cloud.dialogflow.v2beta1.ArticleAnswer
	(*FaqAnswer)(nil),                                // 27: google.cloud.dialogflow.v2beta1.FaqAnswer
	(*SmartReplyAnswer)(nil),                         // 28: google.cloud.dialogflow.v2beta1.SmartReplyAnswer
	(*IntentSuggestion)(nil),                         // 29: google.cloud.dialogflow.v2beta1.IntentSuggestion
	(*DialogflowAssistAnswer)(nil),                   // 30: google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer
	(*SuggestionResult)(nil),                         // 31: google.cloud.dialogflow.v2beta1.SuggestionResult
	(*SuggestArticlesRequest)(nil),                   // 32: google.cloud.dialogflow.v2beta1.SuggestArticlesRequest
	(*SuggestArticlesResponse)(nil),                  // 33: google.cloud.dialogflow.v2beta1.SuggestArticlesResponse
	(*SuggestFaqAnswersRequest)(nil),                 // 34: google.cloud.dialogflow.v2beta1.SuggestFaqAnswersRequest
	(*SuggestFaqAnswersResponse)(nil),                // 35: google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse
	(*SuggestSmartRepliesRequest)(nil),               // 36: google.cloud.dialogflow.v2beta1.SuggestSmartRepliesRequest
	(*SuggestSmartRepliesResponse)(nil),              // 37: google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse
	(*GenerateSuggestionsResponse)(nil),              // 38: google.cloud.dialogflow.v2beta1.GenerateSuggestionsResponse
	(*SuggestDialogflowAssistsResponse)(nil),         // 39: google.cloud.dialogflow.v2beta1.SuggestDialogflowAssistsResponse
	(*Suggestion)(nil),                               // 40: google.cloud.dialogflow.v2beta1.Suggestion
	(*ListSuggestionsRequest)(nil),                   // 41: google.cloud.dialogflow.v2beta1.ListSuggestionsRequest
	(*ListSuggestionsResponse)(nil),                  // 42: google.cloud.dialogflow.v2beta1.ListSuggestionsResponse
	(*CompileSuggestionRequest)(nil),                 // 43: google.cloud.dialogflow.v2beta1.CompileSuggestionRequest
	(*CompileSuggestionResponse)(nil),                // 44: google.cloud.dialogflow.v2beta1.CompileSuggestionResponse
	(*ResponseMessage)(nil),                          // 45: google.cloud.dialogflow.v2beta1.ResponseMessage
	(*SuggestKnowledgeAssistRequest)(nil),            // 46: google.cloud.dialogflow.v2beta1.SuggestKnowledgeAssistRequest
	(*SuggestKnowledgeAssistResponse)(nil),           // 47: google.cloud.dialogflow.v2beta1.SuggestKnowledgeAssistResponse
	(*KnowledgeAssistAnswer)(nil),                    // 48: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer
	(*BidiStreamingAnalyzeContentRequest)(nil),       // 49: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest
	(*BidiStreamingAnalyzeContentResponse)(nil),      // 50: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse
	nil, // 51: google.cloud.dialogflow.v2beta1.Participant.DocumentsMetadataFiltersEntry
	nil, // 52: google.cloud.dialogflow.v2beta1.AssistQueryParameters.DocumentsMetadataFiltersEntry
	nil, // 53: google.cloud.dialogflow.v2beta1.ArticleAnswer.MetadataEntry
	nil, // 54: google.cloud.dialogflow.v2beta1.FaqAnswer.MetadataEntry
	(*GenerateSuggestionsResponse_GeneratorSuggestionAnswer)(nil),          // 55: google.cloud.dialogflow.v2beta1.GenerateSuggestionsResponse.GeneratorSuggestionAnswer
	(*Suggestion_Article)(nil),                                             // 56: google.cloud.dialogflow.v2beta1.Suggestion.Article
	(*Suggestion_FaqAnswer)(nil),                                           // 57: google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer
	nil,                                                                    // 58: google.cloud.dialogflow.v2beta1.Suggestion.Article.MetadataEntry
	nil,                                                                    // 59: google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.MetadataEntry
	(*ResponseMessage_Text)(nil),                                           // 60: google.cloud.dialogflow.v2beta1.ResponseMessage.Text
	(*ResponseMessage_LiveAgentHandoff)(nil),                               // 61: google.cloud.dialogflow.v2beta1.ResponseMessage.LiveAgentHandoff
	(*ResponseMessage_EndInteraction)(nil),                                 // 62: google.cloud.dialogflow.v2beta1.ResponseMessage.EndInteraction
	(*ResponseMessage_MixedAudio)(nil),                                     // 63: google.cloud.dialogflow.v2beta1.ResponseMessage.MixedAudio
	(*ResponseMessage_TelephonyTransferCall)(nil),                          // 64: google.cloud.dialogflow.v2beta1.ResponseMessage.TelephonyTransferCall
	(*ResponseMessage_MixedAudio_Segment)(nil),                             // 65: google.cloud.dialogflow.v2beta1.ResponseMessage.MixedAudio.Segment
	(*KnowledgeAssistAnswer_SuggestedQuery)(nil),                           // 66: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.SuggestedQuery
	(*KnowledgeAssistAnswer_KnowledgeAnswer)(nil),                          // 67: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer
	(*KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource)(nil),                // 68: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.FaqSource
	(*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource)(nil),         // 69: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.GenerativeSource
	(*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_Snippet)(nil), // 70: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.GenerativeSource.Snippet
	(*BidiStreamingAnalyzeContentRequest_Config)(nil),                      // 71: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Config
	(*BidiStreamingAnalyzeContentRequest_TurnInput)(nil),                   // 72: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.TurnInput
	(*BidiStreamingAnalyzeContentRequest_Input)(nil),                       // 73: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Input
	(*BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig)(nil),   // 74: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Config.VoiceSessionConfig
	(*BidiStreamingAnalyzeContentResponse_BargeInSignal)(nil),              // 75: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse.BargeInSignal
	(*BidiStreamingAnalyzeContentResponse_TurnComplete)(nil),               // 76: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse.TurnComplete
	(*timestamppb.Timestamp)(nil),                                          // 77: google.protobuf.Timestamp
	(*SentimentAnalysisResult)(nil),                                        // 78: google.cloud.dialogflow.v2beta1.SentimentAnalysisResult
	(*fieldmaskpb.FieldMask)(nil),                                          // 79: google.protobuf.FieldMask
	(*InputAudioConfig)(nil),                                               // 80: google.cloud.dialogflow.v2beta1.InputAudioConfig
	(*OutputAudioConfig)(nil),                                              // 81: google.cloud.dialogflow.v2beta1.OutputAudioConfig
	(*DetectIntentResponse)(nil),                                           // 82: google.cloud.dialogflow.v2beta1.DetectIntentResponse
	(*structpb.Struct)(nil),                                                // 83: google.protobuf.Struct
	(*TextInput)(nil),                                                      // 84: google.cloud.dialogflow.v2beta1.TextInput
	(*EventInput)(nil),                                                     // 85: google.cloud.dialogflow.v2beta1.EventInput
	(*QueryParameters)(nil),                                                // 86: google.cloud.dialogflow.v2beta1.QueryParameters
	(*TelephonyDtmfEvents)(nil),                                            // 87: google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents
	(*StreamingRecognitionResult)(nil),                                     // 88: google.cloud.dialogflow.v2beta1.StreamingRecognitionResult
	(*CloudConversationDebuggingInfo)(nil),                                 // 89: google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
	(*structpb.Value)(nil),                                                 // 90: google.protobuf.Value
	(*QueryResult)(nil),                                                    // 91: google.cloud.dialogflow.v2beta1.QueryResult
	(*status.Status)(nil),                                                  // 92: google.rpc.Status
	(*GeneratorSuggestion)(nil),                                            // 93: google.cloud.dialogflow.v2beta1.GeneratorSuggestion
	(AudioEncoding)(0),                                                     // 94: google.cloud.dialogflow.v2beta1.AudioEncoding
	(OutputAudioEncoding)(0),                                               // 95: google.cloud.dialogflow.v2beta1.OutputAudioEncoding
}
var file_google_cloud_dialogflow_v2beta1_participant_proto_depIdxs = []int32{
	0,   // 0: google.cloud.dialogflow.v2beta1.Participant.role:type_name -> google.cloud.dialogflow.v2beta1.Participant.Role
	51,  // 1: google.cloud.dialogflow.v2beta1.Participant.documents_metadata_filters:type_name -> google.cloud.dialogflow.v2beta1.Participant.DocumentsMetadataFiltersEntry
	45,  // 2: google.cloud.dialogflow.v2beta1.Message.response_messages:type_name -> google.cloud.dialogflow.v2beta1.ResponseMessage
	0,   // 3: google.cloud.dialogflow.v2beta1.Message.participant_role:type_name -> google.cloud.dialogflow.v2beta1.Participant.Role
	77,  // 4: google.cloud.dialogflow.v2beta1.Message.create_time:type_name -> google.protobuf.Timestamp
	77,  // 5: google.cloud.dialogflow.v2beta1.Message.send_time:type_name -> google.protobuf.Timestamp
	25,  // 6: google.cloud.dialogflow.v2beta1.Message.message_annotation:type_name -> google.cloud.dialogflow.v2beta1.MessageAnnotation
	78,  // 7: google.cloud.dialogflow.v2beta1.Message.sentiment_analysis:type_name -> google.cloud.dialogflow.v2beta1.SentimentAnalysisResult
	4,   // 8: google.cloud.dialogflow.v2beta1.CreateParticipantRequest.participant:type_name -> google.cloud.dialogflow.v2beta1.Participant
	4,   // 9: google.cloud.dialogflow.v2beta1.ListParticipantsResponse.participants:type_name -> google.cloud.dialogflow.v2beta1.Participant
	4,   // 10: google.cloud.dialogflow.v2beta1.UpdateParticipantRequest.participant:type_name -> google.cloud.dialogflow.v2beta1.Participant
	79,  // 11: google.cloud.dialogflow.v2beta1.UpdateParticipantRequest.update_mask:type_name -> google.protobuf.FieldMask
	80,  // 12: google.cloud.dialogflow.v2beta1.AudioInput.config:type_name -> google.cloud.dialogflow.v2beta1.InputAudioConfig
	81,  // 13: google.cloud.dialogflow.v2beta1.OutputAudio.config:type_name -> google.cloud.dialogflow.v2beta1.OutputAudioConfig
	82,  // 14: google.cloud.dialogflow.v2beta1.AutomatedAgentReply.detect_intent_response:type_name -> google.cloud.dialogflow.v2beta1.DetectIntentResponse
	45,  // 15: google.cloud.dialogflow.v2beta1.AutomatedAgentReply.response_messages:type_name -> google.cloud.dialogflow.v2beta1.ResponseMessage
	83,  // 16: google.cloud.dialogflow.v2beta1.AutomatedAgentReply.parameters:type_name -> google.protobuf.Struct
	83,  // 17: google.cloud.dialogflow.v2beta1.AutomatedAgentReply.cx_session_parameters:type_name -> google.protobuf.Struct
	1,   // 18: google.cloud.dialogflow.v2beta1.AutomatedAgentReply.automated_agent_reply_type:type_name -> google.cloud.dialogflow.v2beta1.AutomatedAgentReply.AutomatedAgentReplyType
	84,  // 19: google.cloud.dialogflow.v2beta1.SuggestionInput.text_override:type_name -> google.cloud.dialogflow.v2beta1.TextInput
	83,  // 20: google.cloud.dialogflow.v2beta1.SuggestionInput.parameters:type_name -> google.protobuf.Struct
	2,   // 21: google.cloud.dialogflow.v2beta1.SuggestionInput.action:type_name -> google.cloud.dialogflow.v2beta1.SuggestionInput.Action
	15,  // 22: google.cloud.dialogflow.v2beta1.SuggestionInput.intent_input:type_name -> google.cloud.dialogflow.v2beta1.IntentInput
	77,  // 23: google.cloud.dialogflow.v2beta1.SuggestionInput.send_time:type_name -> google.protobuf.Timestamp
	3,   // 24: google.cloud.dialogflow.v2beta1.SuggestionFeature.type:type_name -> google.cloud.dialogflow.v2beta1.SuggestionFeature.Type
	52,  // 25: google.cloud.dialogflow.v2beta1.AssistQueryParameters.documents_metadata_filters:type_name -> google.cloud.dialogflow.v2beta1.AssistQueryParameters.DocumentsMetadataFiltersEntry
	84,  // 26: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.text_input:type_name -> google.cloud.dialogflow.v2beta1.TextInput
	11,  // 27: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.audio_input:type_name -> google.cloud.dialogflow.v2beta1.AudioInput
	85,  // 28: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.event_input:type_name -> google.cloud.dialogflow.v2beta1.EventInput
	14,  // 29: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.suggestion_input:type_name -> google.cloud.dialogflow.v2beta1.SuggestionInput
	15,  // 30: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.intent_input:type_name -> google.cloud.dialogflow.v2beta1.IntentInput
	81,  // 31: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.reply_audio_config:type_name -> google.cloud.dialogflow.v2beta1.OutputAudioConfig
	86,  // 32: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.query_params:type_name -> google.cloud.dialogflow.v2beta1.QueryParameters
	17,  // 33: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.assist_query_params:type_name -> google.cloud.dialogflow.v2beta1.AssistQueryParameters
	83,  // 34: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.cx_parameters:type_name -> google.protobuf.Struct
	77,  // 35: google.cloud.dialogflow.v2beta1.AnalyzeContentRequest.message_send_time:type_name -> google.protobuf.Timestamp
	12,  // 36: google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.reply_audio:type_name -> google.cloud.dialogflow.v2beta1.OutputAudio
	13,  // 37: google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.automated_agent_reply:type_name -> google.cloud.dialogflow.v2beta1.AutomatedAgentReply
	5,   // 38: google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.message:type_name -> google.cloud.dialogflow.v2beta1.Message
	31,  // 39: google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.human_agent_suggestion_results:type_name -> google.cloud.dialogflow.v2beta1.SuggestionResult
	31,  // 40: google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.end_user_suggestion_results:type_name -> google.cloud.dialogflow.v2beta1.SuggestionResult
	19,  // 41: google.cloud.dialogflow.v2beta1.AnalyzeContentResponse.dtmf_parameters:type_name -> google.cloud.dialogflow.v2beta1.DtmfParameters
	80,  // 42: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.audio_config:type_name -> google.cloud.dialogflow.v2beta1.InputAudioConfig
	21,  // 43: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.text_config:type_name -> google.cloud.dialogflow.v2beta1.InputTextConfig
	81,  // 44: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.reply_audio_config:type_name -> google.cloud.dialogflow.v2beta1.OutputAudioConfig
	87,  // 45: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.input_dtmf:type_name -> google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents
	86,  // 46: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.query_params:type_name -> google.cloud.dialogflow.v2beta1.QueryParameters
	17,  // 47: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.assist_query_params:type_name -> google.cloud.dialogflow.v2beta1.AssistQueryParameters
	83,  // 48: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest.cx_parameters:type_name -> google.protobuf.Struct
	88,  // 49: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.recognition_result:type_name -> google.cloud.dialogflow.v2beta1.StreamingRecognitionResult
	12,  // 50: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.reply_audio:type_name -> google.cloud.dialogflow.v2beta1.OutputAudio
	13,  // 51: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.automated_agent_reply:type_name -> google.cloud.dialogflow.v2beta1.AutomatedAgentReply
	5,   // 52: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.message:type_name -> google.cloud.dialogflow.v2beta1.Message
	31,  // 53: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.human_agent_suggestion_results:type_name -> google.cloud.dialogflow.v2beta1.SuggestionResult
	31,  // 54: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.end_user_suggestion_results:type_name -> google.cloud.dialogflow.v2beta1.SuggestionResult
	19,  // 55: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.dtmf_parameters:type_name -> google.cloud.dialogflow.v2beta1.DtmfParameters
	89,  // 56: google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse.debugging_info:type_name -> google.cloud.dialogflow.v2beta1.CloudConversationDebuggingInfo
	90,  // 57: google.cloud.dialogflow.v2beta1.AnnotatedMessagePart.formatted_value:type_name -> google.protobuf.Value
	24,  // 58: google.cloud.dialogflow.v2beta1.MessageAnnotation.parts:type_name -> google.cloud.dialogflow.v2beta1.AnnotatedMessagePart
	53,  // 59: google.cloud.dialogflow.v2beta1.ArticleAnswer.metadata:type_name -> google.cloud.dialogflow.v2beta1.ArticleAnswer.MetadataEntry
	54,  // 60: google.cloud.dialogflow.v2beta1.FaqAnswer.metadata:type_name -> google.cloud.dialogflow.v2beta1.FaqAnswer.MetadataEntry
	91,  // 61: google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer.query_result:type_name -> google.cloud.dialogflow.v2beta1.QueryResult
	29,  // 62: google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer.intent_suggestion:type_name -> google.cloud.dialogflow.v2beta1.IntentSuggestion
	92,  // 63: google.cloud.dialogflow.v2beta1.SuggestionResult.error:type_name -> google.rpc.Status
	33,  // 64: google.cloud.dialogflow.v2beta1.SuggestionResult.suggest_articles_response:type_name -> google.cloud.dialogflow.v2beta1.SuggestArticlesResponse
	47,  // 65: google.cloud.dialogflow.v2beta1.SuggestionResult.suggest_knowledge_assist_response:type_name -> google.cloud.dialogflow.v2beta1.SuggestKnowledgeAssistResponse
	35,  // 66: google.cloud.dialogflow.v2beta1.SuggestionResult.suggest_faq_answers_response:type_name -> google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse
	37,  // 67: google.cloud.dialogflow.v2beta1.SuggestionResult.suggest_smart_replies_response:type_name -> google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse
	39,  // 68: google.cloud.dialogflow.v2beta1.SuggestionResult.suggest_dialogflow_assists_response:type_name -> google.cloud.dialogflow.v2beta1.SuggestDialogflowAssistsResponse
	39,  // 69: google.cloud.dialogflow.v2beta1.SuggestionResult.suggest_entity_extraction_response:type_name -> google.cloud.dialogflow.v2beta1.SuggestDialogflowAssistsResponse
	38,  // 70: google.cloud.dialogflow.v2beta1.SuggestionResult.generate_suggestions_response:type_name -> google.cloud.dialogflow.v2beta1.GenerateSuggestionsResponse
	17,  // 71: google.cloud.dialogflow.v2beta1.SuggestArticlesRequest.assist_query_params:type_name -> google.cloud.dialogflow.v2beta1.AssistQueryParameters
	26,  // 72: google.cloud.dialogflow.v2beta1.SuggestArticlesResponse.article_answers:type_name -> google.cloud.dialogflow.v2beta1.ArticleAnswer
	17,  // 73: google.cloud.dialogflow.v2beta1.SuggestFaqAnswersRequest.assist_query_params:type_name -> google.cloud.dialogflow.v2beta1.AssistQueryParameters
	27,  // 74: google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse.faq_answers:type_name -> google.cloud.dialogflow.v2beta1.FaqAnswer
	84,  // 75: google.cloud.dialogflow.v2beta1.SuggestSmartRepliesRequest.current_text_input:type_name -> google.cloud.dialogflow.v2beta1.TextInput
	28,  // 76: google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse.smart_reply_answers:type_name -> google.cloud.dialogflow.v2beta1.SmartReplyAnswer
	55,  // 77: google.cloud.dialogflow.v2beta1.GenerateSuggestionsResponse.generator_suggestion_answers:type_name -> google.cloud.dialogflow.v2beta1.GenerateSuggestionsResponse.GeneratorSuggestionAnswer
	30,  // 78: google.cloud.dialogflow.v2beta1.SuggestDialogflowAssistsResponse.dialogflow_assist_answers:type_name -> google.cloud.dialogflow.v2beta1.DialogflowAssistAnswer
	56,  // 79: google.cloud.dialogflow.v2beta1.Suggestion.articles:type_name -> google.cloud.dialogflow.v2beta1.Suggestion.Article
	57,  // 80: google.cloud.dialogflow.v2beta1.Suggestion.faq_answers:type_name -> google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer
	77,  // 81: google.cloud.dialogflow.v2beta1.Suggestion.create_time:type_name -> google.protobuf.Timestamp
	40,  // 82: google.cloud.dialogflow.v2beta1.ListSuggestionsResponse.suggestions:type_name -> google.cloud.dialogflow.v2beta1.Suggestion
	40,  // 83: google.cloud.dialogflow.v2beta1.CompileSuggestionResponse.suggestion:type_name -> google.cloud.dialogflow.v2beta1.Suggestion
	60,  // 84: google.cloud.dialogflow.v2beta1.ResponseMessage.text:type_name -> google.cloud.dialogflow.v2beta1.ResponseMessage.Text
	83,  // 85: google.cloud.dialogflow.v2beta1.ResponseMessage.payload:type_name -> google.protobuf.Struct
	61,  // 86: google.cloud.dialogflow.v2beta1.ResponseMessage.live_agent_handoff:type_name -> google.cloud.dialogflow.v2beta1.ResponseMessage.LiveAgentHandoff
	62,  // 87: google.cloud.dialogflow.v2beta1.ResponseMessage.end_interaction:type_name -> google.cloud.dialogflow.v2beta1.ResponseMessage.EndInteraction
	63,  // 88: google.cloud.dialogflow.v2beta1.ResponseMessage.mixed_audio:type_name -> google.cloud.dialogflow.v2beta1.ResponseMessage.MixedAudio
	64,  // 89: google.cloud.dialogflow.v2beta1.ResponseMessage.telephony_transfer_call:type_name -> google.cloud.dialogflow.v2beta1.ResponseMessage.TelephonyTransferCall
	48,  // 90: google.cloud.dialogflow.v2beta1.SuggestKnowledgeAssistResponse.knowledge_assist_answer:type_name -> google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer
	66,  // 91: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.suggested_query:type_name -> google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.SuggestedQuery
	67,  // 92: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.suggested_query_answer:type_name -> google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer
	71,  // 93: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.config:type_name -> google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Config
	73,  // 94: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.input:type_name -> google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Input
	88,  // 95: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse.recognition_result:type_name -> google.cloud.dialogflow.v2beta1.StreamingRecognitionResult
	75,  // 96: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse.barge_in_signal:type_name -> google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse.BargeInSignal
	20,  // 97: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse.analyze_content_response:type_name -> google.cloud.dialogflow.v2beta1.AnalyzeContentResponse
	76,  // 98: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse.turn_complete:type_name -> google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse.TurnComplete
	93,  // 99: google.cloud.dialogflow.v2beta1.GenerateSuggestionsResponse.GeneratorSuggestionAnswer.generator_suggestion:type_name -> google.cloud.dialogflow.v2beta1.GeneratorSuggestion
	58,  // 100: google.cloud.dialogflow.v2beta1.Suggestion.Article.metadata:type_name -> google.cloud.dialogflow.v2beta1.Suggestion.Article.MetadataEntry
	59,  // 101: google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.metadata:type_name -> google.cloud.dialogflow.v2beta1.Suggestion.FaqAnswer.MetadataEntry
	83,  // 102: google.cloud.dialogflow.v2beta1.ResponseMessage.LiveAgentHandoff.metadata:type_name -> google.protobuf.Struct
	65,  // 103: google.cloud.dialogflow.v2beta1.ResponseMessage.MixedAudio.segments:type_name -> google.cloud.dialogflow.v2beta1.ResponseMessage.MixedAudio.Segment
	68,  // 104: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.faq_source:type_name -> google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.FaqSource
	69,  // 105: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.generative_source:type_name -> google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.GenerativeSource
	70,  // 106: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.GenerativeSource.snippets:type_name -> google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.GenerativeSource.Snippet
	83,  // 107: google.cloud.dialogflow.v2beta1.KnowledgeAssistAnswer.KnowledgeAnswer.GenerativeSource.Snippet.metadata:type_name -> google.protobuf.Struct
	74,  // 108: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Config.voice_session_config:type_name -> google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Config.VoiceSessionConfig
	83,  // 109: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Config.initial_virtual_agent_parameters:type_name -> google.protobuf.Struct
	86,  // 110: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Config.initial_virtual_agent_query_params:type_name -> google.cloud.dialogflow.v2beta1.QueryParameters
	83,  // 111: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.TurnInput.virtual_agent_parameters:type_name -> google.protobuf.Struct
	87,  // 112: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Input.dtmf:type_name -> google.cloud.dialogflow.v2beta1.TelephonyDtmfEvents
	72,  // 113: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Input.turn:type_name -> google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.TurnInput
	94,  // 114: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Config.VoiceSessionConfig.input_audio_encoding:type_name -> google.cloud.dialogflow.v2beta1.AudioEncoding
	95,  // 115: google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest.Config.VoiceSessionConfig.output_audio_encoding:type_name -> google.cloud.dialogflow.v2beta1.OutputAudioEncoding
	6,   // 116: google.cloud.dialogflow.v2beta1.Participants.CreateParticipant:input_type -> google.cloud.dialogflow.v2beta1.CreateParticipantRequest
	7,   // 117: google.cloud.dialogflow.v2beta1.Participants.GetParticipant:input_type -> google.cloud.dialogflow.v2beta1.GetParticipantRequest
	8,   // 118: google.cloud.dialogflow.v2beta1.Participants.ListParticipants:input_type -> google.cloud.dialogflow.v2beta1.ListParticipantsRequest
	10,  // 119: google.cloud.dialogflow.v2beta1.Participants.UpdateParticipant:input_type -> google.cloud.dialogflow.v2beta1.UpdateParticipantRequest
	18,  // 120: google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent:input_type -> google.cloud.dialogflow.v2beta1.AnalyzeContentRequest
	22,  // 121: google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent:input_type -> google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentRequest
	49,  // 122: google.cloud.dialogflow.v2beta1.Participants.BidiStreamingAnalyzeContent:input_type -> google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentRequest
	32,  // 123: google.cloud.dialogflow.v2beta1.Participants.SuggestArticles:input_type -> google.cloud.dialogflow.v2beta1.SuggestArticlesRequest
	34,  // 124: google.cloud.dialogflow.v2beta1.Participants.SuggestFaqAnswers:input_type -> google.cloud.dialogflow.v2beta1.SuggestFaqAnswersRequest
	36,  // 125: google.cloud.dialogflow.v2beta1.Participants.SuggestSmartReplies:input_type -> google.cloud.dialogflow.v2beta1.SuggestSmartRepliesRequest
	46,  // 126: google.cloud.dialogflow.v2beta1.Participants.SuggestKnowledgeAssist:input_type -> google.cloud.dialogflow.v2beta1.SuggestKnowledgeAssistRequest
	41,  // 127: google.cloud.dialogflow.v2beta1.Participants.ListSuggestions:input_type -> google.cloud.dialogflow.v2beta1.ListSuggestionsRequest
	43,  // 128: google.cloud.dialogflow.v2beta1.Participants.CompileSuggestion:input_type -> google.cloud.dialogflow.v2beta1.CompileSuggestionRequest
	4,   // 129: google.cloud.dialogflow.v2beta1.Participants.CreateParticipant:output_type -> google.cloud.dialogflow.v2beta1.Participant
	4,   // 130: google.cloud.dialogflow.v2beta1.Participants.GetParticipant:output_type -> google.cloud.dialogflow.v2beta1.Participant
	9,   // 131: google.cloud.dialogflow.v2beta1.Participants.ListParticipants:output_type -> google.cloud.dialogflow.v2beta1.ListParticipantsResponse
	4,   // 132: google.cloud.dialogflow.v2beta1.Participants.UpdateParticipant:output_type -> google.cloud.dialogflow.v2beta1.Participant
	20,  // 133: google.cloud.dialogflow.v2beta1.Participants.AnalyzeContent:output_type -> google.cloud.dialogflow.v2beta1.AnalyzeContentResponse
	23,  // 134: google.cloud.dialogflow.v2beta1.Participants.StreamingAnalyzeContent:output_type -> google.cloud.dialogflow.v2beta1.StreamingAnalyzeContentResponse
	50,  // 135: google.cloud.dialogflow.v2beta1.Participants.BidiStreamingAnalyzeContent:output_type -> google.cloud.dialogflow.v2beta1.BidiStreamingAnalyzeContentResponse
	33,  // 136: google.cloud.dialogflow.v2beta1.Participants.SuggestArticles:output_type -> google.cloud.dialogflow.v2beta1.SuggestArticlesResponse
	35,  // 137: google.cloud.dialogflow.v2beta1.Participants.SuggestFaqAnswers:output_type -> google.cloud.dialogflow.v2beta1.SuggestFaqAnswersResponse
	37,  // 138: google.cloud.dialogflow.v2beta1.Participants.SuggestSmartReplies:output_type -> google.cloud.dialogflow.v2beta1.SuggestSmartRepliesResponse
	47,  // 139: google.cloud.dialogflow.v2beta1.Participants.SuggestKnowledgeAssist:output_type -> google.cloud.dialogflow.v2beta1.SuggestKnowledgeAssistResponse
	42,  // 140: google.cloud.dialogflow.v2beta1.Participants.ListSuggestions:output_type -> google.cloud.dialogflow.v2beta1.ListSuggestionsResponse
	44,  // 141: google.cloud.dialogflow.v2beta1.Participants.CompileSuggestion:output_type -> google.cloud.dialogflow.v2beta1.CompileSuggestionResponse
	129, // [129:142] is the sub-list for method output_type
	116, // [116:129] is the sub-list for method input_type
	116, // [116:116] is the sub-list for extension type_name
	116, // [116:116] is the sub-list for extension extendee
	0,   // [0:116] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_v2beta1_participant_proto_init() }
func file_google_cloud_dialogflow_v2beta1_participant_proto_init() {
	if File_google_cloud_dialogflow_v2beta1_participant_proto != nil {
		return
	}
	file_google_cloud_dialogflow_v2beta1_audio_config_proto_init()
	file_google_cloud_dialogflow_v2beta1_generator_proto_init()
	file_google_cloud_dialogflow_v2beta1_session_proto_init()
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[9].OneofWrappers = []any{
		(*AutomatedAgentReply_DetectIntentResponse)(nil),
		(*AutomatedAgentReply_Intent)(nil),
		(*AutomatedAgentReply_Event)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[14].OneofWrappers = []any{
		(*AnalyzeContentRequest_TextInput)(nil),
		(*AnalyzeContentRequest_AudioInput)(nil),
		(*AnalyzeContentRequest_EventInput)(nil),
		(*AnalyzeContentRequest_SuggestionInput)(nil),
		(*AnalyzeContentRequest_IntentInput)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[18].OneofWrappers = []any{
		(*StreamingAnalyzeContentRequest_AudioConfig)(nil),
		(*StreamingAnalyzeContentRequest_TextConfig)(nil),
		(*StreamingAnalyzeContentRequest_InputAudio)(nil),
		(*StreamingAnalyzeContentRequest_InputText)(nil),
		(*StreamingAnalyzeContentRequest_InputDtmf)(nil),
		(*StreamingAnalyzeContentRequest_InputIntent)(nil),
		(*StreamingAnalyzeContentRequest_InputEvent)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[25].OneofWrappers = []any{
		(*IntentSuggestion_IntentV2)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[26].OneofWrappers = []any{
		(*DialogflowAssistAnswer_QueryResult)(nil),
		(*DialogflowAssistAnswer_IntentSuggestion)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[27].OneofWrappers = []any{
		(*SuggestionResult_Error)(nil),
		(*SuggestionResult_SuggestArticlesResponse)(nil),
		(*SuggestionResult_SuggestKnowledgeAssistResponse)(nil),
		(*SuggestionResult_SuggestFaqAnswersResponse)(nil),
		(*SuggestionResult_SuggestSmartRepliesResponse)(nil),
		(*SuggestionResult_SuggestDialogflowAssistsResponse)(nil),
		(*SuggestionResult_SuggestEntityExtractionResponse)(nil),
		(*SuggestionResult_GenerateSuggestionsResponse)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[41].OneofWrappers = []any{
		(*ResponseMessage_Text_)(nil),
		(*ResponseMessage_Payload)(nil),
		(*ResponseMessage_LiveAgentHandoff_)(nil),
		(*ResponseMessage_EndInteraction_)(nil),
		(*ResponseMessage_MixedAudio_)(nil),
		(*ResponseMessage_TelephonyTransferCall_)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[45].OneofWrappers = []any{
		(*BidiStreamingAnalyzeContentRequest_Config_)(nil),
		(*BidiStreamingAnalyzeContentRequest_Input_)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[46].OneofWrappers = []any{
		(*BidiStreamingAnalyzeContentResponse_RecognitionResult)(nil),
		(*BidiStreamingAnalyzeContentResponse_BargeInSignal_)(nil),
		(*BidiStreamingAnalyzeContentResponse_AnalyzeContentResponse)(nil),
		(*BidiStreamingAnalyzeContentResponse_TurnComplete_)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[60].OneofWrappers = []any{
		(*ResponseMessage_TelephonyTransferCall_PhoneNumber)(nil),
		(*ResponseMessage_TelephonyTransferCall_SipUri)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[61].OneofWrappers = []any{
		(*ResponseMessage_MixedAudio_Segment_Audio)(nil),
		(*ResponseMessage_MixedAudio_Segment_Uri)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[63].OneofWrappers = []any{
		(*KnowledgeAssistAnswer_KnowledgeAnswer_FaqSource_)(nil),
		(*KnowledgeAssistAnswer_KnowledgeAnswer_GenerativeSource_)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[67].OneofWrappers = []any{
		(*BidiStreamingAnalyzeContentRequest_Config_VoiceSessionConfig_)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[68].OneofWrappers = []any{
		(*BidiStreamingAnalyzeContentRequest_TurnInput_Text)(nil),
		(*BidiStreamingAnalyzeContentRequest_TurnInput_Intent)(nil),
		(*BidiStreamingAnalyzeContentRequest_TurnInput_Event)(nil),
	}
	file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes[69].OneofWrappers = []any{
		(*BidiStreamingAnalyzeContentRequest_Input_Audio)(nil),
		(*BidiStreamingAnalyzeContentRequest_Input_Dtmf)(nil),
		(*BidiStreamingAnalyzeContentRequest_Input_Turn)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_v2beta1_participant_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   73,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_v2beta1_participant_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_v2beta1_participant_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_v2beta1_participant_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_v2beta1_participant_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_v2beta1_participant_proto = out.File
	file_google_cloud_dialogflow_v2beta1_participant_proto_rawDesc = nil
	file_google_cloud_dialogflow_v2beta1_participant_proto_goTypes = nil
	file_google_cloud_dialogflow_v2beta1_participant_proto_depIdxs = nil
}
