// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dataproc provides access to the Cloud Dataproc API.
//
// This package is DEPRECATED. Use package cloud.google.com/go/dataproc/apiv1 instead.
//
// For product documentation, see: https://cloud.google.com/dataproc/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/dataproc/v1"
//	...
//	ctx := context.Background()
//	dataprocService, err := dataproc.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	dataprocService, err := dataproc.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	dataprocService, err := dataproc.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package dataproc // import "google.golang.org/api/dataproc/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "dataproc:v1"
const apiName = "dataproc"
const apiVersion = "v1"
const basePath = "https://dataproc.googleapis.com/"
const basePathTemplate = "https://dataproc.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://dataproc.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	rs.Regions = NewProjectsRegionsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService

	Regions *ProjectsRegionsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AutoscalingPolicies = NewProjectsLocationsAutoscalingPoliciesService(s)
	rs.Batches = NewProjectsLocationsBatchesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.SessionTemplates = NewProjectsLocationsSessionTemplatesService(s)
	rs.Sessions = NewProjectsLocationsSessionsService(s)
	rs.WorkflowTemplates = NewProjectsLocationsWorkflowTemplatesService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AutoscalingPolicies *ProjectsLocationsAutoscalingPoliciesService

	Batches *ProjectsLocationsBatchesService

	Operations *ProjectsLocationsOperationsService

	SessionTemplates *ProjectsLocationsSessionTemplatesService

	Sessions *ProjectsLocationsSessionsService

	WorkflowTemplates *ProjectsLocationsWorkflowTemplatesService
}

func NewProjectsLocationsAutoscalingPoliciesService(s *Service) *ProjectsLocationsAutoscalingPoliciesService {
	rs := &ProjectsLocationsAutoscalingPoliciesService{s: s}
	return rs
}

type ProjectsLocationsAutoscalingPoliciesService struct {
	s *Service
}

func NewProjectsLocationsBatchesService(s *Service) *ProjectsLocationsBatchesService {
	rs := &ProjectsLocationsBatchesService{s: s}
	rs.SparkApplications = NewProjectsLocationsBatchesSparkApplicationsService(s)
	return rs
}

type ProjectsLocationsBatchesService struct {
	s *Service

	SparkApplications *ProjectsLocationsBatchesSparkApplicationsService
}

func NewProjectsLocationsBatchesSparkApplicationsService(s *Service) *ProjectsLocationsBatchesSparkApplicationsService {
	rs := &ProjectsLocationsBatchesSparkApplicationsService{s: s}
	return rs
}

type ProjectsLocationsBatchesSparkApplicationsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsSessionTemplatesService(s *Service) *ProjectsLocationsSessionTemplatesService {
	rs := &ProjectsLocationsSessionTemplatesService{s: s}
	return rs
}

type ProjectsLocationsSessionTemplatesService struct {
	s *Service
}

func NewProjectsLocationsSessionsService(s *Service) *ProjectsLocationsSessionsService {
	rs := &ProjectsLocationsSessionsService{s: s}
	rs.SparkApplications = NewProjectsLocationsSessionsSparkApplicationsService(s)
	return rs
}

type ProjectsLocationsSessionsService struct {
	s *Service

	SparkApplications *ProjectsLocationsSessionsSparkApplicationsService
}

func NewProjectsLocationsSessionsSparkApplicationsService(s *Service) *ProjectsLocationsSessionsSparkApplicationsService {
	rs := &ProjectsLocationsSessionsSparkApplicationsService{s: s}
	return rs
}

type ProjectsLocationsSessionsSparkApplicationsService struct {
	s *Service
}

func NewProjectsLocationsWorkflowTemplatesService(s *Service) *ProjectsLocationsWorkflowTemplatesService {
	rs := &ProjectsLocationsWorkflowTemplatesService{s: s}
	return rs
}

type ProjectsLocationsWorkflowTemplatesService struct {
	s *Service
}

func NewProjectsRegionsService(s *Service) *ProjectsRegionsService {
	rs := &ProjectsRegionsService{s: s}
	rs.AutoscalingPolicies = NewProjectsRegionsAutoscalingPoliciesService(s)
	rs.Clusters = NewProjectsRegionsClustersService(s)
	rs.Jobs = NewProjectsRegionsJobsService(s)
	rs.Operations = NewProjectsRegionsOperationsService(s)
	rs.WorkflowTemplates = NewProjectsRegionsWorkflowTemplatesService(s)
	return rs
}

type ProjectsRegionsService struct {
	s *Service

	AutoscalingPolicies *ProjectsRegionsAutoscalingPoliciesService

	Clusters *ProjectsRegionsClustersService

	Jobs *ProjectsRegionsJobsService

	Operations *ProjectsRegionsOperationsService

	WorkflowTemplates *ProjectsRegionsWorkflowTemplatesService
}

func NewProjectsRegionsAutoscalingPoliciesService(s *Service) *ProjectsRegionsAutoscalingPoliciesService {
	rs := &ProjectsRegionsAutoscalingPoliciesService{s: s}
	return rs
}

type ProjectsRegionsAutoscalingPoliciesService struct {
	s *Service
}

func NewProjectsRegionsClustersService(s *Service) *ProjectsRegionsClustersService {
	rs := &ProjectsRegionsClustersService{s: s}
	rs.NodeGroups = NewProjectsRegionsClustersNodeGroupsService(s)
	return rs
}

type ProjectsRegionsClustersService struct {
	s *Service

	NodeGroups *ProjectsRegionsClustersNodeGroupsService
}

func NewProjectsRegionsClustersNodeGroupsService(s *Service) *ProjectsRegionsClustersNodeGroupsService {
	rs := &ProjectsRegionsClustersNodeGroupsService{s: s}
	return rs
}

type ProjectsRegionsClustersNodeGroupsService struct {
	s *Service
}

func NewProjectsRegionsJobsService(s *Service) *ProjectsRegionsJobsService {
	rs := &ProjectsRegionsJobsService{s: s}
	return rs
}

type ProjectsRegionsJobsService struct {
	s *Service
}

func NewProjectsRegionsOperationsService(s *Service) *ProjectsRegionsOperationsService {
	rs := &ProjectsRegionsOperationsService{s: s}
	return rs
}

type ProjectsRegionsOperationsService struct {
	s *Service
}

func NewProjectsRegionsWorkflowTemplatesService(s *Service) *ProjectsRegionsWorkflowTemplatesService {
	rs := &ProjectsRegionsWorkflowTemplatesService{s: s}
	return rs
}

type ProjectsRegionsWorkflowTemplatesService struct {
	s *Service
}

// AcceleratorConfig: Specifies the type and number of accelerator cards
// attached to the instances of an instance. See GPUs on Compute Engine
// (https://cloud.google.com/compute/docs/gpus/).
type AcceleratorConfig struct {
	// AcceleratorCount: The number of the accelerator cards of this type exposed
	// to this instance.
	AcceleratorCount int64 `json:"acceleratorCount,omitempty"`
	// AcceleratorTypeUri: Full URL, partial URI, or short name of the accelerator
	// type resource to expose to this instance. See Compute Engine
	// AcceleratorTypes
	// (https://cloud.google.com/compute/docs/reference/v1/acceleratorTypes).Examples:
	// https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]/acceleratorTypes/nvidia-tesla-t4
	// projects/[project_id]/zones/[zone]/acceleratorTypes/nvidia-tesla-t4
	// nvidia-tesla-t4Auto Zone Exception: If you are using the Dataproc Auto Zone
	// Placement
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
	// feature, you must use the short name of the accelerator type resource, for
	// example, nvidia-tesla-t4.
	AcceleratorTypeUri string `json:"acceleratorTypeUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceleratorCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceleratorCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AcceleratorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AcceleratorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSessionSparkApplicationEnvironmentInfoResponse: Environment details of
// a Saprk Application.
type AccessSessionSparkApplicationEnvironmentInfoResponse struct {
	// ApplicationEnvironmentInfo: Details about the Environment that the
	// application is running in.
	ApplicationEnvironmentInfo *ApplicationEnvironmentInfo `json:"applicationEnvironmentInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApplicationEnvironmentInfo")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationEnvironmentInfo") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSessionSparkApplicationEnvironmentInfoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSessionSparkApplicationEnvironmentInfoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSessionSparkApplicationJobResponse: Details of a particular job
// associated with Spark Application
type AccessSessionSparkApplicationJobResponse struct {
	// JobData: Output only. Data corresponding to a spark job.
	JobData *JobData `json:"jobData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "JobData") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSessionSparkApplicationJobResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSessionSparkApplicationJobResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSessionSparkApplicationResponse: A summary of Spark Application
type AccessSessionSparkApplicationResponse struct {
	// Application: Output only. High level information corresponding to an
	// application.
	Application *ApplicationInfo `json:"application,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Application") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Application") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSessionSparkApplicationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSessionSparkApplicationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSessionSparkApplicationSqlQueryResponse: Details of a query for a
// Spark Application
type AccessSessionSparkApplicationSqlQueryResponse struct {
	// ExecutionData: SQL Execution Data
	ExecutionData *SqlExecutionUiData `json:"executionData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExecutionData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutionData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSessionSparkApplicationSqlQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSessionSparkApplicationSqlQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSessionSparkApplicationSqlSparkPlanGraphResponse: SparkPlanGraph for a
// Spark Application execution limited to maximum 10000 clusters.
type AccessSessionSparkApplicationSqlSparkPlanGraphResponse struct {
	// SparkPlanGraph: SparkPlanGraph for a Spark Application execution.
	SparkPlanGraph *SparkPlanGraph `json:"sparkPlanGraph,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "SparkPlanGraph") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SparkPlanGraph") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSessionSparkApplicationSqlSparkPlanGraphResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSessionSparkApplicationSqlSparkPlanGraphResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSessionSparkApplicationStageAttemptResponse: Stage Attempt for a Stage
// of a Spark Application
type AccessSessionSparkApplicationStageAttemptResponse struct {
	// StageData: Output only. Data corresponding to a stage.
	StageData *StageData `json:"stageData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "StageData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StageData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSessionSparkApplicationStageAttemptResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSessionSparkApplicationStageAttemptResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSessionSparkApplicationStageRddOperationGraphResponse: RDD operation
// graph for a Spark Application Stage limited to maximum 10000 clusters.
type AccessSessionSparkApplicationStageRddOperationGraphResponse struct {
	// RddOperationGraph: RDD operation graph for a Spark Application Stage.
	RddOperationGraph *RddOperationGraph `json:"rddOperationGraph,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "RddOperationGraph") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RddOperationGraph") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSessionSparkApplicationStageRddOperationGraphResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSessionSparkApplicationStageRddOperationGraphResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSparkApplicationEnvironmentInfoResponse: Environment details of a
// Saprk Application.
type AccessSparkApplicationEnvironmentInfoResponse struct {
	// ApplicationEnvironmentInfo: Details about the Environment that the
	// application is running in.
	ApplicationEnvironmentInfo *ApplicationEnvironmentInfo `json:"applicationEnvironmentInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApplicationEnvironmentInfo")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationEnvironmentInfo") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSparkApplicationEnvironmentInfoResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSparkApplicationEnvironmentInfoResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSparkApplicationJobResponse: Details of a particular job associated
// with Spark Application
type AccessSparkApplicationJobResponse struct {
	// JobData: Output only. Data corresponding to a spark job.
	JobData *JobData `json:"jobData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "JobData") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSparkApplicationJobResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSparkApplicationJobResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSparkApplicationResponse: A summary of Spark Application
type AccessSparkApplicationResponse struct {
	// Application: Output only. High level information corresponding to an
	// application.
	Application *ApplicationInfo `json:"application,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Application") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Application") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSparkApplicationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSparkApplicationResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSparkApplicationSqlQueryResponse: Details of a query for a Spark
// Application
type AccessSparkApplicationSqlQueryResponse struct {
	// ExecutionData: SQL Execution Data
	ExecutionData *SqlExecutionUiData `json:"executionData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ExecutionData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutionData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSparkApplicationSqlQueryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSparkApplicationSqlQueryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSparkApplicationSqlSparkPlanGraphResponse: SparkPlanGraph for a Spark
// Application execution limited to maximum 10000 clusters.
type AccessSparkApplicationSqlSparkPlanGraphResponse struct {
	// SparkPlanGraph: SparkPlanGraph for a Spark Application execution.
	SparkPlanGraph *SparkPlanGraph `json:"sparkPlanGraph,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "SparkPlanGraph") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SparkPlanGraph") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSparkApplicationSqlSparkPlanGraphResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSparkApplicationSqlSparkPlanGraphResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSparkApplicationStageAttemptResponse: Stage Attempt for a Stage of a
// Spark Application
type AccessSparkApplicationStageAttemptResponse struct {
	// StageData: Output only. Data corresponding to a stage.
	StageData *StageData `json:"stageData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "StageData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StageData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSparkApplicationStageAttemptResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSparkApplicationStageAttemptResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AccessSparkApplicationStageRddOperationGraphResponse: RDD operation graph
// for a Spark Application Stage limited to maximum 10000 clusters.
type AccessSparkApplicationStageRddOperationGraphResponse struct {
	// RddOperationGraph: RDD operation graph for a Spark Application Stage.
	RddOperationGraph *RddOperationGraph `json:"rddOperationGraph,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "RddOperationGraph") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RddOperationGraph") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccessSparkApplicationStageRddOperationGraphResponse) MarshalJSON() ([]byte, error) {
	type NoMethod AccessSparkApplicationStageRddOperationGraphResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AccumulableInfo struct {
	AccumullableInfoId int64  `json:"accumullableInfoId,omitempty,string"`
	Name               string `json:"name,omitempty"`
	Update             string `json:"update,omitempty"`
	Value              string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccumullableInfoId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccumullableInfoId") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AccumulableInfo) MarshalJSON() ([]byte, error) {
	type NoMethod AccumulableInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzeBatchRequest: A request to analyze a batch workload.
type AnalyzeBatchRequest struct {
	// RequestId: Optional. A unique ID used to identify the request. If the
	// service receives two AnalyzeBatchRequest
	// (http://cloud/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.AnalyzeBatchRequest)s
	// with the same request_id, the second request is ignored and the Operation
	// that corresponds to the first request created and stored in the backend is
	// returned.Recommendation: Set this value to a UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The value must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
	// (-). The maximum length is 40 characters.
	RequestId string `json:"requestId,omitempty"`
	// RequestorId: Optional. The requestor ID is used to identify if the request
	// comes from a GCA investigation or the old Ask Gemini Experience.
	RequestorId string `json:"requestorId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzeBatchRequest) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzeBatchRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AnalyzeOperationMetadata: Metadata describing the Analyze operation.
type AnalyzeOperationMetadata struct {
	// AnalyzedWorkloadName: Output only. name of the workload being analyzed.
	AnalyzedWorkloadName string `json:"analyzedWorkloadName,omitempty"`
	// AnalyzedWorkloadType: Output only. Type of the workload being analyzed.
	//
	// Possible values:
	//   "WORKLOAD_TYPE_UNSPECIFIED" - Undefined option
	//   "BATCH" - Serverless batch job
	AnalyzedWorkloadType string `json:"analyzedWorkloadType,omitempty"`
	// AnalyzedWorkloadUuid: Output only. unique identifier of the workload
	// typically generated by control plane. E.g. batch uuid.
	AnalyzedWorkloadUuid string `json:"analyzedWorkloadUuid,omitempty"`
	// CreateTime: Output only. The time when the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Output only. Short description of the operation.
	Description string `json:"description,omitempty"`
	// DoneTime: Output only. The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// Labels: Output only. Labels associated with the operation.
	Labels map[string]string `json:"labels,omitempty"`
	// Warnings: Output only. Warnings encountered during operation execution.
	Warnings []string `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AnalyzedWorkloadName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AnalyzedWorkloadName") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AnalyzeOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod AnalyzeOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type AppSummary struct {
	NumCompletedJobs   int64 `json:"numCompletedJobs,omitempty"`
	NumCompletedStages int64 `json:"numCompletedStages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NumCompletedJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumCompletedJobs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AppSummary) MarshalJSON() ([]byte, error) {
	type NoMethod AppSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationAttemptInfo: Specific attempt of an application.
type ApplicationAttemptInfo struct {
	AppSparkVersion string `json:"appSparkVersion,omitempty"`
	AttemptId       string `json:"attemptId,omitempty"`
	Completed       bool   `json:"completed,omitempty"`
	DurationMillis  int64  `json:"durationMillis,omitempty,string"`
	EndTime         string `json:"endTime,omitempty"`
	LastUpdated     string `json:"lastUpdated,omitempty"`
	SparkUser       string `json:"sparkUser,omitempty"`
	StartTime       string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppSparkVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppSparkVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplicationAttemptInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationAttemptInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationEnvironmentInfo: Details about the Environment that the
// application is running in.
type ApplicationEnvironmentInfo struct {
	ClasspathEntries  map[string]string      `json:"classpathEntries,omitempty"`
	HadoopProperties  map[string]string      `json:"hadoopProperties,omitempty"`
	MetricsProperties map[string]string      `json:"metricsProperties,omitempty"`
	ResourceProfiles  []*ResourceProfileInfo `json:"resourceProfiles,omitempty"`
	Runtime           *SparkRuntimeInfo      `json:"runtime,omitempty"`
	SparkProperties   map[string]string      `json:"sparkProperties,omitempty"`
	SystemProperties  map[string]string      `json:"systemProperties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClasspathEntries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClasspathEntries") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApplicationEnvironmentInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationEnvironmentInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApplicationInfo: High level information corresponding to an application.
type ApplicationInfo struct {
	// Possible values:
	//   "APPLICATION_CONTEXT_INGESTION_STATUS_UNSPECIFIED"
	//   "APPLICATION_CONTEXT_INGESTION_STATUS_COMPLETED"
	ApplicationContextIngestionStatus string                    `json:"applicationContextIngestionStatus,omitempty"`
	ApplicationId                     string                    `json:"applicationId,omitempty"`
	Attempts                          []*ApplicationAttemptInfo `json:"attempts,omitempty"`
	CoresGranted                      int64                     `json:"coresGranted,omitempty"`
	CoresPerExecutor                  int64                     `json:"coresPerExecutor,omitempty"`
	MaxCores                          int64                     `json:"maxCores,omitempty"`
	MemoryPerExecutorMb               int64                     `json:"memoryPerExecutorMb,omitempty"`
	Name                              string                    `json:"name,omitempty"`
	// Possible values:
	//   "QUANTILE_DATA_STATUS_UNSPECIFIED"
	//   "QUANTILE_DATA_STATUS_COMPLETED"
	//   "QUANTILE_DATA_STATUS_FAILED"
	QuantileDataStatus string `json:"quantileDataStatus,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "ApplicationContextIngestionStatus") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "ApplicationContextIngestionStatus") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s ApplicationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ApplicationInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthenticationConfig: Authentication configuration for a workload is used to
// set the default identity for the workload execution. The config specifies
// the type of identity (service account or user) that will be used by
// workloads to access resources on the project(s).
type AuthenticationConfig struct {
	// UserWorkloadAuthenticationType: Optional. Authentication type for the user
	// workload running in containers.
	//
	// Possible values:
	//   "AUTHENTICATION_TYPE_UNSPECIFIED" - If AuthenticationType is unspecified
	// then END_USER_CREDENTIALS is used for 3.0 and newer runtimes, and
	// SERVICE_ACCOUNT is used for older runtimes.
	//   "SERVICE_ACCOUNT" - Use service account credentials for authenticating to
	// other services.
	//   "END_USER_CREDENTIALS" - Use OAuth credentials associated with the
	// workload creator/user for authenticating to other services.
	UserWorkloadAuthenticationType string `json:"userWorkloadAuthenticationType,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "UserWorkloadAuthenticationType") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserWorkloadAuthenticationType")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthenticationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuthenticationConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutoscalingConfig: Autoscaling Policy config associated with the cluster.
type AutoscalingConfig struct {
	// PolicyUri: Optional. The autoscaling policy used by the cluster.Only
	// resource names including projectid and location (region) are valid.
	// Examples:
	// https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]
	// projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy
	// _id]Note that the policy must be in the same project and Dataproc region.
	PolicyUri string `json:"policyUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PolicyUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PolicyUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutoscalingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutoscalingPolicy: Describes an autoscaling policy for Dataproc cluster
// autoscaler.
type AutoscalingPolicy struct {
	BasicAlgorithm *BasicAutoscalingAlgorithm `json:"basicAlgorithm,omitempty"`
	// ClusterType: Optional. The type of the clusters for which this autoscaling
	// policy is to be configured.
	//
	// Possible values:
	//   "CLUSTER_TYPE_UNSPECIFIED" - Not set.
	//   "STANDARD" - Standard dataproc cluster with a minimum of two primary
	// workers.
	//   "ZERO_SCALE" - Clusters that can use only secondary workers and be scaled
	// down to zero secondary worker nodes.
	ClusterType string `json:"clusterType,omitempty"`
	// Id: Required. The policy id.The id must contain only letters (a-z, A-Z),
	// numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with
	// underscore or hyphen. Must consist of between 3 and 50 characters.
	Id string `json:"id,omitempty"`
	// Labels: Optional. The labels to associate with this autoscaling policy.
	// Label keys must contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if
	// present, must contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with an autoscaling policy.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The "resource name" of the autoscaling policy, as
	// described in https://cloud.google.com/apis/design/resource_names. For
	// projects.regions.autoscalingPolicies, the resource name of the policy has
	// the following format:
	// projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id} For
	// projects.locations.autoscalingPolicies, the resource name of the policy has
	// the following format:
	// projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}
	Name string `json:"name,omitempty"`
	// SecondaryWorkerConfig: Optional. Describes how the autoscaler will operate
	// for secondary workers.
	SecondaryWorkerConfig *InstanceGroupAutoscalingPolicyConfig `json:"secondaryWorkerConfig,omitempty"`
	// WorkerConfig: Required. Describes how the autoscaler will operate for
	// primary workers.
	WorkerConfig *InstanceGroupAutoscalingPolicyConfig `json:"workerConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BasicAlgorithm") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BasicAlgorithm") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutoscalingPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod AutoscalingPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AutotuningConfig: Autotuning configuration of the workload.
type AutotuningConfig struct {
	// Scenarios: Optional. Scenarios for which tunings are applied.
	//
	// Possible values:
	//   "SCENARIO_UNSPECIFIED" - Default value.
	//   "SCALING" - Scaling recommendations such as initialExecutors.
	//   "BROADCAST_HASH_JOIN" - Adding hints for potential relation broadcasts.
	//   "MEMORY" - Memory management for workloads.
	//   "NONE" - No autotuning.
	//   "AUTO" - Automatic selection of scenarios.
	Scenarios []string `json:"scenarios,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Scenarios") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Scenarios") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AutotuningConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AutotuningConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuxiliaryNodeGroup: Node group identification and configuration information.
type AuxiliaryNodeGroup struct {
	// NodeGroup: Required. Node group configuration.
	NodeGroup *NodeGroup `json:"nodeGroup,omitempty"`
	// NodeGroupId: Optional. A node group ID. Generated if not specified.The ID
	// must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and
	// hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of
	// from 3 to 33 characters.
	NodeGroupId string `json:"nodeGroupId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NodeGroup") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NodeGroup") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuxiliaryNodeGroup) MarshalJSON() ([]byte, error) {
	type NoMethod AuxiliaryNodeGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuxiliaryServicesConfig: Auxiliary services configuration for a Cluster.
type AuxiliaryServicesConfig struct {
	// MetastoreConfig: Optional. The Hive Metastore configuration for this
	// workload.
	MetastoreConfig *MetastoreConfig `json:"metastoreConfig,omitempty"`
	// SparkHistoryServerConfig: Optional. The Spark History Server configuration
	// for the workload.
	SparkHistoryServerConfig *SparkHistoryServerConfig `json:"sparkHistoryServerConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetastoreConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetastoreConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuxiliaryServicesConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuxiliaryServicesConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BasicAutoscalingAlgorithm: Basic algorithm for autoscaling.
type BasicAutoscalingAlgorithm struct {
	// CooldownPeriod: Optional. Duration between scaling events. A scaling period
	// starts after the update operation from the previous event has
	// completed.Bounds: 2m, 1d. Default: 2m.
	CooldownPeriod string `json:"cooldownPeriod,omitempty"`
	// SparkStandaloneConfig: Optional. Spark Standalone autoscaling configuration
	SparkStandaloneConfig *SparkStandaloneAutoscalingConfig `json:"sparkStandaloneConfig,omitempty"`
	// YarnConfig: Optional. YARN autoscaling configuration.
	YarnConfig *BasicYarnAutoscalingConfig `json:"yarnConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CooldownPeriod") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CooldownPeriod") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BasicAutoscalingAlgorithm) MarshalJSON() ([]byte, error) {
	type NoMethod BasicAutoscalingAlgorithm
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BasicYarnAutoscalingConfig: Basic autoscaling configurations for YARN.
type BasicYarnAutoscalingConfig struct {
	// GracefulDecommissionTimeout: Required. Timeout for YARN graceful
	// decommissioning of Node Managers. Specifies the duration to wait for jobs to
	// complete before forcefully removing workers (and potentially interrupting
	// jobs). Only applicable to downscaling operations.Bounds: 0s, 1d.
	GracefulDecommissionTimeout string `json:"gracefulDecommissionTimeout,omitempty"`
	// ScaleDownFactor: Required. Fraction of average YARN pending memory in the
	// last cooldown period for which to remove workers. A scale-down factor of 1
	// will result in scaling down so that there is no available memory remaining
	// after the update (more aggressive scaling). A scale-down factor of 0
	// disables removing workers, which can be beneficial for autoscaling a single
	// job. See How autoscaling works
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works)
	// for more information.Bounds: 0.0, 1.0.
	ScaleDownFactor float64 `json:"scaleDownFactor,omitempty"`
	// ScaleDownMinWorkerFraction: Optional. Minimum scale-down threshold as a
	// fraction of total cluster size before scaling occurs. For example, in a
	// 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at
	// least a 2 worker scale-down for the cluster to scale. A threshold of 0 means
	// the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0.
	// Default: 0.0.
	ScaleDownMinWorkerFraction float64 `json:"scaleDownMinWorkerFraction,omitempty"`
	// ScaleUpFactor: Required. Fraction of average YARN pending memory in the last
	// cooldown period for which to add workers. A scale-up factor of 1.0 will
	// result in scaling up so that there is no pending memory remaining after the
	// update (more aggressive scaling). A scale-up factor closer to 0 will result
	// in a smaller magnitude of scaling up (less aggressive scaling). See How
	// autoscaling works
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works)
	// for more information.Bounds: 0.0, 1.0.
	ScaleUpFactor float64 `json:"scaleUpFactor,omitempty"`
	// ScaleUpMinWorkerFraction: Optional. Minimum scale-up threshold as a fraction
	// of total cluster size before scaling occurs. For example, in a 20-worker
	// cluster, a threshold of 0.1 means the autoscaler must recommend at least a
	// 2-worker scale-up for the cluster to scale. A threshold of 0 means the
	// autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0.
	// Default: 0.0.
	ScaleUpMinWorkerFraction float64 `json:"scaleUpMinWorkerFraction,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "GracefulDecommissionTimeout") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GracefulDecommissionTimeout") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BasicYarnAutoscalingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BasicYarnAutoscalingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *BasicYarnAutoscalingConfig) UnmarshalJSON(data []byte) error {
	type NoMethod BasicYarnAutoscalingConfig
	var s1 struct {
		ScaleDownFactor            gensupport.JSONFloat64 `json:"scaleDownFactor"`
		ScaleDownMinWorkerFraction gensupport.JSONFloat64 `json:"scaleDownMinWorkerFraction"`
		ScaleUpFactor              gensupport.JSONFloat64 `json:"scaleUpFactor"`
		ScaleUpMinWorkerFraction   gensupport.JSONFloat64 `json:"scaleUpMinWorkerFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ScaleDownFactor = float64(s1.ScaleDownFactor)
	s.ScaleDownMinWorkerFraction = float64(s1.ScaleDownMinWorkerFraction)
	s.ScaleUpFactor = float64(s1.ScaleUpFactor)
	s.ScaleUpMinWorkerFraction = float64(s1.ScaleUpMinWorkerFraction)
	return nil
}

// Batch: A representation of a batch workload in the service.
type Batch struct {
	// CreateTime: Output only. The time when the batch was created.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. The email address of the user who created the batch.
	Creator string `json:"creator,omitempty"`
	// EnvironmentConfig: Optional. Environment configuration for the batch
	// execution.
	EnvironmentConfig *EnvironmentConfig `json:"environmentConfig,omitempty"`
	// Labels: Optional. The labels to associate with this batch. Label keys must
	// contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if
	// present, must contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a batch.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The resource name of the batch.
	Name string `json:"name,omitempty"`
	// Operation: Output only. The resource name of the operation associated with
	// this batch.
	Operation string `json:"operation,omitempty"`
	// PysparkBatch: Optional. PySpark batch config.
	PysparkBatch *PySparkBatch `json:"pysparkBatch,omitempty"`
	// RuntimeConfig: Optional. Runtime configuration for the batch execution.
	RuntimeConfig *RuntimeConfig `json:"runtimeConfig,omitempty"`
	// RuntimeInfo: Output only. Runtime information about batch execution.
	RuntimeInfo *RuntimeInfo `json:"runtimeInfo,omitempty"`
	// SparkBatch: Optional. Spark batch config.
	SparkBatch *SparkBatch `json:"sparkBatch,omitempty"`
	// SparkRBatch: Optional. SparkR batch config.
	SparkRBatch *SparkRBatch `json:"sparkRBatch,omitempty"`
	// SparkSqlBatch: Optional. SparkSql batch config.
	SparkSqlBatch *SparkSqlBatch `json:"sparkSqlBatch,omitempty"`
	// State: Output only. The state of the batch.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The batch state is unknown.
	//   "PENDING" - The batch is created before running.
	//   "RUNNING" - The batch is running.
	//   "CANCELLING" - The batch is cancelling.
	//   "CANCELLED" - The batch cancellation was successful.
	//   "SUCCEEDED" - The batch completed successfully.
	//   "FAILED" - The batch is no longer running due to an error.
	State string `json:"state,omitempty"`
	// StateHistory: Output only. Historical state information for the batch.
	StateHistory []*StateHistory `json:"stateHistory,omitempty"`
	// StateMessage: Output only. Batch state details, such as a failure
	// description if the state is FAILED.
	StateMessage string `json:"stateMessage,omitempty"`
	// StateTime: Output only. The time when the batch entered a current state.
	StateTime string `json:"stateTime,omitempty"`
	// Uuid: Output only. A batch UUID (Unique Universal Identifier). The service
	// generates this value when it creates the batch.
	Uuid string `json:"uuid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Batch) MarshalJSON() ([]byte, error) {
	type NoMethod Batch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BatchOperationMetadata: Metadata describing the Batch operation.
type BatchOperationMetadata struct {
	// Batch: Name of the batch for the operation.
	Batch string `json:"batch,omitempty"`
	// BatchUuid: Batch UUID for the operation.
	BatchUuid string `json:"batchUuid,omitempty"`
	// CreateTime: The time when the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Short description of the operation.
	Description string `json:"description,omitempty"`
	// DoneTime: The time when the operation finished.
	DoneTime string `json:"doneTime,omitempty"`
	// Labels: Labels associated with the operation.
	Labels map[string]string `json:"labels,omitempty"`
	// OperationType: The operation type.
	//
	// Possible values:
	//   "BATCH_OPERATION_TYPE_UNSPECIFIED" - Batch operation type is unknown.
	//   "BATCH" - Batch operation type.
	OperationType string `json:"operationType,omitempty"`
	// Warnings: Warnings encountered during operation execution.
	Warnings []string `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Batch") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Batch") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BatchOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod BatchOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates members, or principals, with a role.
type Binding struct {
	// Condition: The condition that is associated with this binding.If the
	// condition evaluates to true, then this binding applies to the current
	// request.If the condition evaluates to false, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding.To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. members can have the following values: allUsers: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. allAuthenticatedUsers: A special identifier that represents
	// anyone who is authenticated with a Google account or a service account. Does
	// not include identities that come from external identity providers (IdPs)
	// through identity federation. user:{emailid}: An email address that
	// represents a specific Google account. For example, alice@example.com .
	// serviceAccount:{emailid}: An email address that represents a Google service
	// account. For example, my-other-app@appspot.gserviceaccount.com.
	// serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, my-project.svc.id.goog[my-namespace/my-kubernetes-sa].
	// group:{emailid}: An email address that represents a Google group. For
	// example, admins@example.com. domain:{domain}: The G Suite domain (primary)
	// that represents all the users of that domain. For example, google.com or
	// example.com.
	// principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/subj
	// ect/{subject_attribute_value}: A single identity in a workforce identity
	// pool.
	// principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/g
	// roup/{group_id}: All workforce identities in a group.
	// principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/a
	// ttribute.{attribute_name}/{attribute_value}: All workforce identities with a
	// specific attribute value.
	// principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/*
	// : All identities in a workforce identity pool.
	// principal://iam.googleapis.com/projects/{project_number}/locations/global/wor
	// kloadIdentityPools/{pool_id}/subject/{subject_attribute_value}: A single
	// identity in a workload identity pool.
	// principalSet://iam.googleapis.com/projects/{project_number}/locations/global/
	// workloadIdentityPools/{pool_id}/group/{group_id}: A workload identity pool
	// group.
	// principalSet://iam.googleapis.com/projects/{project_number}/locations/global/
	// workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}:
	//  All identities in a workload identity pool with a certain attribute.
	// principalSet://iam.googleapis.com/projects/{project_number}/locations/global/
	// workloadIdentityPools/{pool_id}/*: All identities in a workload identity
	// pool. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique
	// identifier) representing a user that has been recently deleted. For example,
	// alice@example.com?uid=123456789012345678901. If the user is recovered, this
	// value reverts to user:{emailid} and the recovered user retains the role in
	// the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email
	// address (plus unique identifier) representing a service account that has
	// been recently deleted. For example,
	// my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the
	// service account is undeleted, this value reverts to serviceAccount:{emailid}
	// and the undeleted service account retains the role in the binding.
	// deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique
	// identifier) representing a Google group that has been recently deleted. For
	// example, admins@example.com?uid=123456789012345678901. If the group is
	// recovered, this value reverts to group:{emailid} and the recovered group
	// retains the role in the binding.
	// deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool_
	// id}/subject/{subject_attribute_value}: Deleted single identity in a
	// workforce identity pool. For example,
	// deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-poo
	// l-id/subject/my-subject-attribute-value.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of members, or principals. For
	// example, roles/viewer, roles/editor, or roles/owner.For an overview of the
	// IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BuildInfo: Native Build Info
type BuildInfo struct {
	// BuildKey: Optional. Build key.
	BuildKey string `json:"buildKey,omitempty"`
	// BuildValue: Optional. Build value.
	BuildValue string `json:"buildValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildKey") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BuildInfo) MarshalJSON() ([]byte, error) {
	type NoMethod BuildInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelJobRequest: A request to cancel a job.
type CancelJobRequest struct {
}

// Cluster: Describes the identifying information, config, and status of a
// Dataproc cluster
type Cluster struct {
	// ClusterName: Required. The cluster name, which must be unique within a
	// project. The name must start with a lowercase letter, and can contain up to
	// 51 lowercase letters, numbers, and hyphens. It cannot end with a hyphen. The
	// name of a deleted cluster can be reused.
	ClusterName string `json:"clusterName,omitempty"`
	// ClusterUuid: Output only. A cluster UUID (Unique Universal Identifier).
	// Dataproc generates this value when it creates the cluster.
	ClusterUuid string `json:"clusterUuid,omitempty"`
	// Config: Optional. The cluster config for a cluster of Compute Engine
	// Instances. Note that Dataproc may set default values, and values may change
	// when clusters are updated.Exactly one of ClusterConfig or
	// VirtualClusterConfig must be specified.
	Config *ClusterConfig `json:"config,omitempty"`
	// Labels: Optional. The labels to associate with this cluster. Label keys must
	// contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if
	// present, must contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a cluster.
	Labels map[string]string `json:"labels,omitempty"`
	// Metrics: Output only. Contains cluster daemon metrics such as HDFS and YARN
	// stats.Beta Feature: This report is available for testing purposes only. It
	// may be changed before final release.
	Metrics *ClusterMetrics `json:"metrics,omitempty"`
	// ProjectId: Required. The Google Cloud Platform project ID that the cluster
	// belongs to.
	ProjectId string `json:"projectId,omitempty"`
	// Status: Output only. Cluster status.
	Status *ClusterStatus `json:"status,omitempty"`
	// StatusHistory: Output only. The previous cluster status.
	StatusHistory []*ClusterStatus `json:"statusHistory,omitempty"`
	// VirtualClusterConfig: Optional. The virtual cluster config is used when
	// creating a Dataproc cluster that does not directly control the underlying
	// compute resources, for example, when creating a Dataproc-on-GKE cluster
	// (https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
	// Dataproc may set default values, and values may change when clusters are
	// updated. Exactly one of config or virtual_cluster_config must be specified.
	VirtualClusterConfig *VirtualClusterConfig `json:"virtualClusterConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClusterName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Cluster) MarshalJSON() ([]byte, error) {
	type NoMethod Cluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterConfig: The cluster config.
type ClusterConfig struct {
	// AutoscalingConfig: Optional. Autoscaling config for the policy associated
	// with the cluster. Cluster does not autoscale if this field is unset.
	AutoscalingConfig *AutoscalingConfig `json:"autoscalingConfig,omitempty"`
	// AuxiliaryNodeGroups: Optional. The node group settings.
	AuxiliaryNodeGroups []*AuxiliaryNodeGroup `json:"auxiliaryNodeGroups,omitempty"`
	// ClusterTier: Optional. The cluster tier.
	//
	// Possible values:
	//   "CLUSTER_TIER_UNSPECIFIED" - Not set. Works the same as
	// CLUSTER_TIER_STANDARD.
	//   "CLUSTER_TIER_STANDARD" - Standard Dataproc cluster.
	//   "CLUSTER_TIER_PREMIUM" - Premium Dataproc cluster.
	ClusterTier string `json:"clusterTier,omitempty"`
	// ClusterType: Optional. The type of the cluster.
	//
	// Possible values:
	//   "CLUSTER_TYPE_UNSPECIFIED" - Not set.
	//   "STANDARD" - Standard dataproc cluster with a minimum of two primary
	// workers.
	//   "SINGLE_NODE" -
	// https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/single-node-clusters
	//   "ZERO_SCALE" - Clusters that can use only secondary workers and be scaled
	// down to zero secondary worker nodes.
	ClusterType string `json:"clusterType,omitempty"`
	// ConfigBucket: Optional. A Cloud Storage bucket used to stage job
	// dependencies, config files, and job driver console output. If you do not
	// specify a staging bucket, Cloud Dataproc will determine a Cloud Storage
	// location (US, ASIA, or EU) for your cluster's staging bucket according to
	// the Compute Engine zone where your cluster is deployed, and then create and
	// manage this project-level, per-location bucket (see Dataproc staging and
	// temp buckets
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
	// This field requires a Cloud Storage bucket name, not a gs://... URI to a
	// Cloud Storage bucket.
	ConfigBucket string `json:"configBucket,omitempty"`
	// DataprocMetricConfig: Optional. The config for Dataproc metrics.
	DataprocMetricConfig *DataprocMetricConfig `json:"dataprocMetricConfig,omitempty"`
	// EncryptionConfig: Optional. Encryption settings for the cluster.
	EncryptionConfig *EncryptionConfig `json:"encryptionConfig,omitempty"`
	// EndpointConfig: Optional. Port/endpoint configuration for this cluster
	EndpointConfig *EndpointConfig `json:"endpointConfig,omitempty"`
	// GceClusterConfig: Optional. The shared Compute Engine config settings for
	// all instances in a cluster.
	GceClusterConfig *GceClusterConfig `json:"gceClusterConfig,omitempty"`
	// GkeClusterConfig: Optional. BETA. The Kubernetes Engine config for Dataproc
	// clusters deployed to The Kubernetes Engine config for Dataproc clusters
	// deployed to Kubernetes. These config settings are mutually exclusive with
	// Compute Engine-based options, such as gce_cluster_config, master_config,
	// worker_config, secondary_worker_config, and autoscaling_config.
	GkeClusterConfig *GkeClusterConfig `json:"gkeClusterConfig,omitempty"`
	// InitializationActions: Optional. Commands to execute on each node after
	// config is completed. By default, executables are run on master and all
	// worker nodes. You can test a node's role metadata to run an executable on a
	// master or worker node, as shown below using curl (you can also use wget):
	// ROLE=$(curl -H Metadata-Flavor:Google
	// http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if [[
	// "${ROLE}" == 'Master' ]]; then ... master specific actions ... else ...
	// worker specific actions ... fi
	InitializationActions []*NodeInitializationAction `json:"initializationActions,omitempty"`
	// LifecycleConfig: Optional. Lifecycle setting for the cluster.
	LifecycleConfig *LifecycleConfig `json:"lifecycleConfig,omitempty"`
	// MasterConfig: Optional. The Compute Engine config settings for the cluster's
	// master instance.
	MasterConfig *InstanceGroupConfig `json:"masterConfig,omitempty"`
	// MetastoreConfig: Optional. Metastore configuration.
	MetastoreConfig *MetastoreConfig `json:"metastoreConfig,omitempty"`
	// SecondaryWorkerConfig: Optional. The Compute Engine config settings for a
	// cluster's secondary worker instances
	SecondaryWorkerConfig *InstanceGroupConfig `json:"secondaryWorkerConfig,omitempty"`
	// SecurityConfig: Optional. Security settings for the cluster.
	SecurityConfig *SecurityConfig `json:"securityConfig,omitempty"`
	// SoftwareConfig: Optional. The config settings for cluster software.
	SoftwareConfig *SoftwareConfig `json:"softwareConfig,omitempty"`
	// TempBucket: Optional. A Cloud Storage bucket used to store ephemeral cluster
	// and jobs data, such as Spark and MapReduce history files. If you do not
	// specify a temp bucket, Dataproc will determine a Cloud Storage location (US,
	// ASIA, or EU) for your cluster's temp bucket according to the Compute Engine
	// zone where your cluster is deployed, and then create and manage this
	// project-level, per-location bucket. The default bucket has a TTL of 90 days,
	// but you can use any TTL (or none) if you specify a bucket (see Dataproc
	// staging and temp buckets
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
	// This field requires a Cloud Storage bucket name, not a gs://... URI to a
	// Cloud Storage bucket.
	TempBucket string `json:"tempBucket,omitempty"`
	// WorkerConfig: Optional. The Compute Engine config settings for the cluster's
	// worker instances.
	WorkerConfig *InstanceGroupConfig `json:"workerConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoscalingConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoscalingConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterMetrics: Contains cluster daemon metrics, such as HDFS and YARN
// stats.Beta Feature: This report is available for testing purposes only. It
// may be changed before final release.
type ClusterMetrics struct {
	// HdfsMetrics: The HDFS metrics.
	HdfsMetrics map[string]string `json:"hdfsMetrics,omitempty"`
	// YarnMetrics: YARN metrics.
	YarnMetrics map[string]string `json:"yarnMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HdfsMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HdfsMetrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterOperation: The cluster operation triggered by a workflow.
type ClusterOperation struct {
	// Done: Output only. Indicates the operation is done.
	Done bool `json:"done,omitempty"`
	// Error: Output only. Error, if operation failed.
	Error string `json:"error,omitempty"`
	// OperationId: Output only. The id of the cluster operation.
	OperationId string `json:"operationId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterOperation) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterOperationMetadata: Metadata describing the operation.
type ClusterOperationMetadata struct {
	// ChildOperationIds: Output only. Child operation ids
	ChildOperationIds []string `json:"childOperationIds,omitempty"`
	// ClusterName: Output only. Name of the cluster for the operation.
	ClusterName string `json:"clusterName,omitempty"`
	// ClusterUuid: Output only. Cluster UUID for the operation.
	ClusterUuid string `json:"clusterUuid,omitempty"`
	// Description: Output only. Short description of operation.
	Description string `json:"description,omitempty"`
	// Labels: Output only. Labels associated with the operation
	Labels map[string]string `json:"labels,omitempty"`
	// OperationType: Output only. The operation type.
	OperationType string `json:"operationType,omitempty"`
	// Status: Output only. Current operation status.
	Status *ClusterOperationStatus `json:"status,omitempty"`
	// StatusHistory: Output only. The previous operation status.
	StatusHistory []*ClusterOperationStatus `json:"statusHistory,omitempty"`
	// Warnings: Output only. Errors encountered during operation execution.
	Warnings []string `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChildOperationIds") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChildOperationIds") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterOperationStatus: The status of the operation.
type ClusterOperationStatus struct {
	// Details: Output only. A message containing any operation metadata details.
	Details string `json:"details,omitempty"`
	// InnerState: Output only. A message containing the detailed operation state.
	InnerState string `json:"innerState,omitempty"`
	// State: Output only. A message containing the operation state.
	//
	// Possible values:
	//   "UNKNOWN" - Unused.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is running.
	//   "DONE" - The operation is done; either cancelled or completed.
	State string `json:"state,omitempty"`
	// StateStartTime: Output only. The time this state was entered.
	StateStartTime string `json:"stateStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterOperationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterOperationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterSelector: A selector that chooses target cluster for jobs based on
// metadata.
type ClusterSelector struct {
	// ClusterLabels: Required. The cluster labels. Cluster must have all labels to
	// match.
	ClusterLabels map[string]string `json:"clusterLabels,omitempty"`
	// Zone: Optional. The zone where workflow process executes. This parameter
	// does not affect the selection of the cluster.If unspecified, the zone of the
	// first cluster matching the selector is used.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterLabels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterSelector) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterStatus: The status of a cluster and its instances.
type ClusterStatus struct {
	// Detail: Optional. Output only. Details of cluster's state.
	Detail string `json:"detail,omitempty"`
	// State: Output only. The cluster's state.
	//
	// Possible values:
	//   "UNKNOWN" - The cluster state is unknown.
	//   "CREATING" - The cluster is being created and set up. It is not ready for
	// use.
	//   "RUNNING" - The cluster is currently running and healthy. It is ready for
	// use.Note: The cluster state changes from "creating" to "running" status
	// after the master node(s), first two primary worker nodes (and the last
	// primary worker node if primary workers > 2) are running.
	//   "ERROR" - The cluster encountered an error. It is not ready for use.
	//   "ERROR_DUE_TO_UPDATE" - The cluster has encountered an error while being
	// updated. Jobs can be submitted to the cluster, but the cluster cannot be
	// updated.
	//   "DELETING" - The cluster is being deleted. It cannot be used.
	//   "UPDATING" - The cluster is being updated. It continues to accept and
	// process jobs.
	//   "STOPPING" - The cluster is being stopped. It cannot be used.
	//   "STOPPED" - The cluster is currently stopped. It is not ready for use.
	//   "STARTING" - The cluster is being started. It is not ready for use.
	//   "REPAIRING" - The cluster is being repaired. It is not ready for use.
	//   "SCHEDULED" - Cluster creation is currently waiting for resources to be
	// available. Once all resources are available, it will transition to CREATING
	// and then RUNNING.
	State string `json:"state,omitempty"`
	// StateStartTime: Output only. Time when this state was entered (see JSON
	// representation of Timestamp
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).
	StateStartTime string `json:"stateStartTime,omitempty"`
	// Substate: Output only. Additional state information that includes status
	// reported by the agent.
	//
	// Possible values:
	//   "UNSPECIFIED" - The cluster substate is unknown.
	//   "UNHEALTHY" - The cluster is known to be in an unhealthy state (for
	// example, critical daemons are not running or HDFS capacity is
	// exhausted).Applies to RUNNING state.
	//   "STALE_STATUS" - The agent-reported status is out of date (may occur if
	// Dataproc loses communication with Agent).Applies to RUNNING state.
	Substate string `json:"substate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Detail") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ClusterToRepair: Cluster to be repaired
type ClusterToRepair struct {
	// ClusterRepairAction: Required. Repair action to take on the cluster
	// resource.
	//
	// Possible values:
	//   "CLUSTER_REPAIR_ACTION_UNSPECIFIED" - No action will be taken by default.
	//   "REPAIR_ERROR_DUE_TO_UPDATE_CLUSTER" - Repair cluster in
	// ERROR_DUE_TO_UPDATE states.
	ClusterRepairAction string `json:"clusterRepairAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterRepairAction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterRepairAction") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ClusterToRepair) MarshalJSON() ([]byte, error) {
	type NoMethod ClusterToRepair
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfidentialInstanceConfig: Confidential Instance Config for clusters using
// Confidential VMs (https://cloud.google.com/compute/confidential-vm/docs)
type ConfidentialInstanceConfig struct {
	// EnableConfidentialCompute: Optional. Defines whether the instance should
	// have confidential compute enabled.
	EnableConfidentialCompute bool `json:"enableConfidentialCompute,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableConfidentialCompute")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableConfidentialCompute") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfidentialInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConfidentialInstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConsolidatedExecutorSummary: Consolidated summary about executors used by
// the application.
type ConsolidatedExecutorSummary struct {
	ActiveTasks         int64          `json:"activeTasks,omitempty"`
	CompletedTasks      int64          `json:"completedTasks,omitempty"`
	Count               int64          `json:"count,omitempty"`
	DiskUsed            int64          `json:"diskUsed,omitempty,string"`
	FailedTasks         int64          `json:"failedTasks,omitempty"`
	IsExcluded          int64          `json:"isExcluded,omitempty"`
	MaxMemory           int64          `json:"maxMemory,omitempty,string"`
	MemoryMetrics       *MemoryMetrics `json:"memoryMetrics,omitempty"`
	MemoryUsed          int64          `json:"memoryUsed,omitempty,string"`
	RddBlocks           int64          `json:"rddBlocks,omitempty"`
	TotalCores          int64          `json:"totalCores,omitempty"`
	TotalDurationMillis int64          `json:"totalDurationMillis,omitempty,string"`
	TotalGcTimeMillis   int64          `json:"totalGcTimeMillis,omitempty,string"`
	TotalInputBytes     int64          `json:"totalInputBytes,omitempty,string"`
	TotalShuffleRead    int64          `json:"totalShuffleRead,omitempty,string"`
	TotalShuffleWrite   int64          `json:"totalShuffleWrite,omitempty,string"`
	TotalTasks          int64          `json:"totalTasks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTasks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTasks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConsolidatedExecutorSummary) MarshalJSON() ([]byte, error) {
	type NoMethod ConsolidatedExecutorSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataprocMetricConfig: Dataproc metric config.
type DataprocMetricConfig struct {
	// Metrics: Required. Metrics sources to enable.
	Metrics []*Metric `json:"metrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataprocMetricConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DataprocMetricConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiagnoseClusterRequest: A request to collect cluster diagnostic information.
type DiagnoseClusterRequest struct {
	// DiagnosisInterval: Optional. Time interval in which diagnosis should be
	// carried out on the cluster.
	DiagnosisInterval *Interval `json:"diagnosisInterval,omitempty"`
	// Job: Optional. DEPRECATED Specifies the job on which diagnosis is to be
	// performed. Format: projects/{project}/regions/{region}/jobs/{job}
	Job string `json:"job,omitempty"`
	// Jobs: Optional. Specifies a list of jobs on which diagnosis is to be
	// performed. Format: projects/{project}/regions/{region}/jobs/{job}
	Jobs []string `json:"jobs,omitempty"`
	// TarballAccess: Optional. (Optional) The access type to the diagnostic
	// tarball. If not specified, falls back to default access of the bucket
	//
	// Possible values:
	//   "TARBALL_ACCESS_UNSPECIFIED" - Tarball Access unspecified. Falls back to
	// default access of the bucket
	//   "GOOGLE_CLOUD_SUPPORT" - Google Cloud Support group has read access to the
	// diagnostic tarball
	//   "GOOGLE_DATAPROC_DIAGNOSE" - Google Cloud Dataproc Diagnose service
	// account has read access to the diagnostic tarball
	TarballAccess string `json:"tarballAccess,omitempty"`
	// TarballGcsDir: Optional. (Optional) The output Cloud Storage directory for
	// the diagnostic tarball. If not specified, a task-specific directory in the
	// cluster's staging bucket will be used.
	TarballGcsDir string `json:"tarballGcsDir,omitempty"`
	// YarnApplicationId: Optional. DEPRECATED Specifies the yarn application on
	// which diagnosis is to be performed.
	YarnApplicationId string `json:"yarnApplicationId,omitempty"`
	// YarnApplicationIds: Optional. Specifies a list of yarn applications on which
	// diagnosis is to be performed.
	YarnApplicationIds []string `json:"yarnApplicationIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiagnosisInterval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiagnosisInterval") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiagnoseClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DiagnoseClusterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiagnoseClusterResults: The location of diagnostic output.
type DiagnoseClusterResults struct {
	// OutputUri: Output only. The Cloud Storage URI of the diagnostic output. The
	// output report is a plain text file with a summary of collected diagnostics.
	OutputUri string `json:"outputUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OutputUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OutputUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiagnoseClusterResults) MarshalJSON() ([]byte, error) {
	type NoMethod DiagnoseClusterResults
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiskConfig: Specifies the config of boot disk and attached disk options for
// a group of VM instances.
type DiskConfig struct {
	// BootDiskProvisionedIops: Optional. Indicates how many IOPS to provision for
	// the disk. This sets the number of I/O operations per second that the disk
	// can handle. This field is supported only if boot_disk_type is
	// hyperdisk-balanced.
	BootDiskProvisionedIops int64 `json:"bootDiskProvisionedIops,omitempty,string"`
	// BootDiskProvisionedThroughput: Optional. Indicates how much throughput to
	// provision for the disk. This sets the number of throughput mb per second
	// that the disk can handle. Values must be greater than or equal to 1. This
	// field is supported only if boot_disk_type is hyperdisk-balanced.
	BootDiskProvisionedThroughput int64 `json:"bootDiskProvisionedThroughput,omitempty,string"`
	// BootDiskSizeGb: Optional. Size in GB of the boot disk (default is 500GB).
	BootDiskSizeGb int64 `json:"bootDiskSizeGb,omitempty"`
	// BootDiskType: Optional. Type of the boot disk (default is "pd-standard").
	// Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive),
	// "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent
	// Disk Hard Disk Drive). See Disk types
	// (https://cloud.google.com/compute/docs/disks#disk-types).
	BootDiskType string `json:"bootDiskType,omitempty"`
	// LocalSsdInterface: Optional. Interface type of local SSDs (default is
	// "scsi"). Valid values: "scsi" (Small Computer System Interface), "nvme"
	// (Non-Volatile Memory Express). See local SSD performance
	// (https://cloud.google.com/compute/docs/disks/local-ssd#performance).
	LocalSsdInterface string `json:"localSsdInterface,omitempty"`
	// NumLocalSsds: Optional. Number of attached SSDs, from 0 to 8 (default is 0).
	// If SSDs are not attached, the boot disk is used to store runtime logs and
	// HDFS (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If
	// one or more SSDs are attached, this runtime bulk data is spread across them,
	// and the boot disk contains only basic config and installed binaries.Note:
	// Local SSD options may vary by machine type and number of vCPUs selected.
	NumLocalSsds int64 `json:"numLocalSsds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BootDiskProvisionedIops") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BootDiskProvisionedIops") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiskConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DiskConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DriverSchedulingConfig: Driver scheduling configuration.
type DriverSchedulingConfig struct {
	// MemoryMb: Required. The amount of memory in MB the driver is requesting.
	MemoryMb int64 `json:"memoryMb,omitempty"`
	// Vcores: Required. The number of vCPUs the driver is requesting.
	Vcores int64 `json:"vcores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MemoryMb") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MemoryMb") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DriverSchedulingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DriverSchedulingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EncryptionConfig: Encryption settings for the cluster.
type EncryptionConfig struct {
	// GcePdKmsKeyName: Optional. The Cloud KMS key resource name to use for
	// persistent disk encryption for all instances in the cluster. See Use CMEK
	// with cluster data
	// (https://cloud.google.com//dataproc/docs/concepts/configuring-clusters/customer-managed-encryption#use_cmek_with_cluster_data)
	// for more information.
	GcePdKmsKeyName string `json:"gcePdKmsKeyName,omitempty"`
	// KmsKey: Optional. The Cloud KMS key resource name to use for cluster
	// persistent disk and job argument encryption. See Use CMEK with cluster data
	// (https://cloud.google.com//dataproc/docs/concepts/configuring-clusters/customer-managed-encryption#use_cmek_with_cluster_data)
	// for more information.When this key resource name is provided, the following
	// job arguments of the following job types submitted to the cluster are
	// encrypted using CMEK: FlinkJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/FlinkJob)
	// HadoopJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/HadoopJob)
	// SparkJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkJob)
	// SparkRJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkRJob)
	// PySparkJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/PySparkJob)
	// SparkSqlJob
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkSqlJob)
	// scriptVariables and queryList.queries HiveJob
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/HiveJob)
	// scriptVariables and queryList.queries PigJob
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/PigJob)
	// scriptVariables and queryList.queries PrestoJob
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/PrestoJob)
	// scriptVariables and queryList.queries
	KmsKey string `json:"kmsKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GcePdKmsKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GcePdKmsKeyName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EncryptionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EncryptionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EndpointConfig: Endpoint config for this cluster
type EndpointConfig struct {
	// EnableHttpPortAccess: Optional. If true, enable http access to specific
	// ports on the cluster from external sources. Defaults to false.
	EnableHttpPortAccess bool `json:"enableHttpPortAccess,omitempty"`
	// HttpPorts: Output only. The map of port descriptions to URLs. Will only be
	// populated if enable_http_port_access is true.
	HttpPorts map[string]string `json:"httpPorts,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableHttpPortAccess") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableHttpPortAccess") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EndpointConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EndpointConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EnvironmentConfig: Environment configuration for a workload.
type EnvironmentConfig struct {
	// ExecutionConfig: Optional. Execution configuration for a workload.
	ExecutionConfig *ExecutionConfig `json:"executionConfig,omitempty"`
	// PeripheralsConfig: Optional. Peripherals configuration that workload has
	// access to.
	PeripheralsConfig *PeripheralsConfig `json:"peripheralsConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecutionConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutionConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnvironmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod EnvironmentConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutionConfig: Execution configuration for a workload.
type ExecutionConfig struct {
	// AuthenticationConfig: Optional. Authentication configuration used to set the
	// default identity for the workload execution. The config specifies the type
	// of identity (service account or user) that will be used by workloads to
	// access resources on the project(s).
	AuthenticationConfig *AuthenticationConfig `json:"authenticationConfig,omitempty"`
	// IdleTtl: Optional. Applies to sessions only. The duration to keep the
	// session alive while it's idling. Exceeding this threshold causes the session
	// to terminate. This field cannot be set on a batch workload. Minimum value is
	// 10 minutes; maximum value is 14 days (see JSON representation of Duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)). Defaults
	// to 1 hour if not set. If both ttl and idle_ttl are specified for an
	// interactive session, the conditions are treated as OR conditions: the
	// workload will be terminated when it has been idle for idle_ttl or when ttl
	// has been exceeded, whichever occurs first.
	IdleTtl string `json:"idleTtl,omitempty"`
	// KmsKey: Optional. The Cloud KMS key to use for encryption.
	KmsKey string `json:"kmsKey,omitempty"`
	// NetworkTags: Optional. Tags used for network traffic control.
	NetworkTags []string `json:"networkTags,omitempty"`
	// NetworkUri: Optional. Network URI to connect workload to.
	NetworkUri string `json:"networkUri,omitempty"`
	// ServiceAccount: Optional. Service account that used to execute workload.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// StagingBucket: Optional. A Cloud Storage bucket used to stage workload
	// dependencies, config files, and store workload output and other ephemeral
	// data, such as Spark history files. If you do not specify a staging bucket,
	// Cloud Dataproc will determine a Cloud Storage location according to the
	// region where your workload is running, and then create and manage
	// project-level, per-location staging and temporary buckets. This field
	// requires a Cloud Storage bucket name, not a gs://... URI to a Cloud Storage
	// bucket.
	StagingBucket string `json:"stagingBucket,omitempty"`
	// SubnetworkUri: Optional. Subnetwork URI to connect workload to.
	SubnetworkUri string `json:"subnetworkUri,omitempty"`
	// Ttl: Optional. The duration after which the workload will be terminated,
	// specified as the JSON representation for Duration
	// (https://protobuf.dev/programming-guides/proto3/#json). When the workload
	// exceeds this duration, it will be unconditionally terminated without waiting
	// for ongoing work to finish. If ttl is not specified for a batch workload,
	// the workload will be allowed to run until it exits naturally (or run forever
	// without exiting). If ttl is not specified for an interactive session, it
	// defaults to 24 hours. If ttl is not specified for a batch that uses 2.1+
	// runtime version, it defaults to 4 hours. Minimum value is 10 minutes;
	// maximum value is 14 days. If both ttl and idle_ttl are specified (for an
	// interactive session), the conditions are treated as OR conditions: the
	// workload will be terminated when it has been idle for idle_ttl or when ttl
	// has been exceeded, whichever occurs first.
	Ttl string `json:"ttl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthenticationConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthenticationConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ExecutorMetrics struct {
	Metrics map[string]string `json:"metrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metrics") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metrics") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutorMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutorMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ExecutorMetricsDistributions struct {
	DiskBytesSpilled    []float64                         `json:"diskBytesSpilled,omitempty"`
	FailedTasks         []float64                         `json:"failedTasks,omitempty"`
	InputBytes          []float64                         `json:"inputBytes,omitempty"`
	InputRecords        []float64                         `json:"inputRecords,omitempty"`
	KilledTasks         []float64                         `json:"killedTasks,omitempty"`
	MemoryBytesSpilled  []float64                         `json:"memoryBytesSpilled,omitempty"`
	OutputBytes         []float64                         `json:"outputBytes,omitempty"`
	OutputRecords       []float64                         `json:"outputRecords,omitempty"`
	PeakMemoryMetrics   *ExecutorPeakMetricsDistributions `json:"peakMemoryMetrics,omitempty"`
	Quantiles           []float64                         `json:"quantiles,omitempty"`
	ShuffleRead         []float64                         `json:"shuffleRead,omitempty"`
	ShuffleReadRecords  []float64                         `json:"shuffleReadRecords,omitempty"`
	ShuffleWrite        []float64                         `json:"shuffleWrite,omitempty"`
	ShuffleWriteRecords []float64                         `json:"shuffleWriteRecords,omitempty"`
	SucceededTasks      []float64                         `json:"succeededTasks,omitempty"`
	TaskTimeMillis      []float64                         `json:"taskTimeMillis,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiskBytesSpilled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiskBytesSpilled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutorMetricsDistributions) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutorMetricsDistributions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ExecutorMetricsDistributions) UnmarshalJSON(data []byte) error {
	type NoMethod ExecutorMetricsDistributions
	var s1 struct {
		DiskBytesSpilled    []gensupport.JSONFloat64 `json:"diskBytesSpilled"`
		FailedTasks         []gensupport.JSONFloat64 `json:"failedTasks"`
		InputBytes          []gensupport.JSONFloat64 `json:"inputBytes"`
		InputRecords        []gensupport.JSONFloat64 `json:"inputRecords"`
		KilledTasks         []gensupport.JSONFloat64 `json:"killedTasks"`
		MemoryBytesSpilled  []gensupport.JSONFloat64 `json:"memoryBytesSpilled"`
		OutputBytes         []gensupport.JSONFloat64 `json:"outputBytes"`
		OutputRecords       []gensupport.JSONFloat64 `json:"outputRecords"`
		Quantiles           []gensupport.JSONFloat64 `json:"quantiles"`
		ShuffleRead         []gensupport.JSONFloat64 `json:"shuffleRead"`
		ShuffleReadRecords  []gensupport.JSONFloat64 `json:"shuffleReadRecords"`
		ShuffleWrite        []gensupport.JSONFloat64 `json:"shuffleWrite"`
		ShuffleWriteRecords []gensupport.JSONFloat64 `json:"shuffleWriteRecords"`
		SucceededTasks      []gensupport.JSONFloat64 `json:"succeededTasks"`
		TaskTimeMillis      []gensupport.JSONFloat64 `json:"taskTimeMillis"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DiskBytesSpilled = make([]float64, len(s1.DiskBytesSpilled))
	for i := range s1.DiskBytesSpilled {
		s.DiskBytesSpilled[i] = float64(s1.DiskBytesSpilled[i])
	}
	s.FailedTasks = make([]float64, len(s1.FailedTasks))
	for i := range s1.FailedTasks {
		s.FailedTasks[i] = float64(s1.FailedTasks[i])
	}
	s.InputBytes = make([]float64, len(s1.InputBytes))
	for i := range s1.InputBytes {
		s.InputBytes[i] = float64(s1.InputBytes[i])
	}
	s.InputRecords = make([]float64, len(s1.InputRecords))
	for i := range s1.InputRecords {
		s.InputRecords[i] = float64(s1.InputRecords[i])
	}
	s.KilledTasks = make([]float64, len(s1.KilledTasks))
	for i := range s1.KilledTasks {
		s.KilledTasks[i] = float64(s1.KilledTasks[i])
	}
	s.MemoryBytesSpilled = make([]float64, len(s1.MemoryBytesSpilled))
	for i := range s1.MemoryBytesSpilled {
		s.MemoryBytesSpilled[i] = float64(s1.MemoryBytesSpilled[i])
	}
	s.OutputBytes = make([]float64, len(s1.OutputBytes))
	for i := range s1.OutputBytes {
		s.OutputBytes[i] = float64(s1.OutputBytes[i])
	}
	s.OutputRecords = make([]float64, len(s1.OutputRecords))
	for i := range s1.OutputRecords {
		s.OutputRecords[i] = float64(s1.OutputRecords[i])
	}
	s.Quantiles = make([]float64, len(s1.Quantiles))
	for i := range s1.Quantiles {
		s.Quantiles[i] = float64(s1.Quantiles[i])
	}
	s.ShuffleRead = make([]float64, len(s1.ShuffleRead))
	for i := range s1.ShuffleRead {
		s.ShuffleRead[i] = float64(s1.ShuffleRead[i])
	}
	s.ShuffleReadRecords = make([]float64, len(s1.ShuffleReadRecords))
	for i := range s1.ShuffleReadRecords {
		s.ShuffleReadRecords[i] = float64(s1.ShuffleReadRecords[i])
	}
	s.ShuffleWrite = make([]float64, len(s1.ShuffleWrite))
	for i := range s1.ShuffleWrite {
		s.ShuffleWrite[i] = float64(s1.ShuffleWrite[i])
	}
	s.ShuffleWriteRecords = make([]float64, len(s1.ShuffleWriteRecords))
	for i := range s1.ShuffleWriteRecords {
		s.ShuffleWriteRecords[i] = float64(s1.ShuffleWriteRecords[i])
	}
	s.SucceededTasks = make([]float64, len(s1.SucceededTasks))
	for i := range s1.SucceededTasks {
		s.SucceededTasks[i] = float64(s1.SucceededTasks[i])
	}
	s.TaskTimeMillis = make([]float64, len(s1.TaskTimeMillis))
	for i := range s1.TaskTimeMillis {
		s.TaskTimeMillis[i] = float64(s1.TaskTimeMillis[i])
	}
	return nil
}

type ExecutorPeakMetricsDistributions struct {
	ExecutorMetrics []*ExecutorMetrics `json:"executorMetrics,omitempty"`
	Quantiles       []float64          `json:"quantiles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecutorMetrics") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutorMetrics") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutorPeakMetricsDistributions) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutorPeakMetricsDistributions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *ExecutorPeakMetricsDistributions) UnmarshalJSON(data []byte) error {
	type NoMethod ExecutorPeakMetricsDistributions
	var s1 struct {
		Quantiles []gensupport.JSONFloat64 `json:"quantiles"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Quantiles = make([]float64, len(s1.Quantiles))
	for i := range s1.Quantiles {
		s.Quantiles[i] = float64(s1.Quantiles[i])
	}
	return nil
}

// ExecutorResourceRequest: Resources used per executor used by the
// application.
type ExecutorResourceRequest struct {
	Amount          int64  `json:"amount,omitempty,string"`
	DiscoveryScript string `json:"discoveryScript,omitempty"`
	ResourceName    string `json:"resourceName,omitempty"`
	Vendor          string `json:"vendor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Amount") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutorResourceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutorResourceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutorStageSummary: Executor resources consumed by a stage.
type ExecutorStageSummary struct {
	DiskBytesSpilled    int64            `json:"diskBytesSpilled,omitempty,string"`
	ExecutorId          string           `json:"executorId,omitempty"`
	FailedTasks         int64            `json:"failedTasks,omitempty"`
	InputBytes          int64            `json:"inputBytes,omitempty,string"`
	InputRecords        int64            `json:"inputRecords,omitempty,string"`
	IsExcludedForStage  bool             `json:"isExcludedForStage,omitempty"`
	KilledTasks         int64            `json:"killedTasks,omitempty"`
	MemoryBytesSpilled  int64            `json:"memoryBytesSpilled,omitempty,string"`
	OutputBytes         int64            `json:"outputBytes,omitempty,string"`
	OutputRecords       int64            `json:"outputRecords,omitempty,string"`
	PeakMemoryMetrics   *ExecutorMetrics `json:"peakMemoryMetrics,omitempty"`
	ShuffleRead         int64            `json:"shuffleRead,omitempty,string"`
	ShuffleReadRecords  int64            `json:"shuffleReadRecords,omitempty,string"`
	ShuffleWrite        int64            `json:"shuffleWrite,omitempty,string"`
	ShuffleWriteRecords int64            `json:"shuffleWriteRecords,omitempty,string"`
	StageAttemptId      int64            `json:"stageAttemptId,omitempty"`
	StageId             int64            `json:"stageId,omitempty,string"`
	SucceededTasks      int64            `json:"succeededTasks,omitempty"`
	TaskTimeMillis      int64            `json:"taskTimeMillis,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "DiskBytesSpilled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiskBytesSpilled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutorStageSummary) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutorStageSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutorSummary: Details about executors used by the application.
type ExecutorSummary struct {
	ActiveTasks         int64                          `json:"activeTasks,omitempty"`
	AddTime             string                         `json:"addTime,omitempty"`
	Attributes          map[string]string              `json:"attributes,omitempty"`
	CompletedTasks      int64                          `json:"completedTasks,omitempty"`
	DiskUsed            int64                          `json:"diskUsed,omitempty,string"`
	ExcludedInStages    googleapi.Int64s               `json:"excludedInStages,omitempty"`
	ExecutorId          string                         `json:"executorId,omitempty"`
	ExecutorLogs        map[string]string              `json:"executorLogs,omitempty"`
	FailedTasks         int64                          `json:"failedTasks,omitempty"`
	HostPort            string                         `json:"hostPort,omitempty"`
	IsActive            bool                           `json:"isActive,omitempty"`
	IsExcluded          bool                           `json:"isExcluded,omitempty"`
	MaxMemory           int64                          `json:"maxMemory,omitempty,string"`
	MaxTasks            int64                          `json:"maxTasks,omitempty"`
	MemoryMetrics       *MemoryMetrics                 `json:"memoryMetrics,omitempty"`
	MemoryUsed          int64                          `json:"memoryUsed,omitempty,string"`
	PeakMemoryMetrics   *ExecutorMetrics               `json:"peakMemoryMetrics,omitempty"`
	RddBlocks           int64                          `json:"rddBlocks,omitempty"`
	RemoveReason        string                         `json:"removeReason,omitempty"`
	RemoveTime          string                         `json:"removeTime,omitempty"`
	ResourceProfileId   int64                          `json:"resourceProfileId,omitempty"`
	Resources           map[string]ResourceInformation `json:"resources,omitempty"`
	TotalCores          int64                          `json:"totalCores,omitempty"`
	TotalDurationMillis int64                          `json:"totalDurationMillis,omitempty,string"`
	TotalGcTimeMillis   int64                          `json:"totalGcTimeMillis,omitempty,string"`
	TotalInputBytes     int64                          `json:"totalInputBytes,omitempty,string"`
	TotalShuffleRead    int64                          `json:"totalShuffleRead,omitempty,string"`
	TotalShuffleWrite   int64                          `json:"totalShuffleWrite,omitempty,string"`
	TotalTasks          int64                          `json:"totalTasks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveTasks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveTasks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutorSummary) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutorSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec.Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FallbackReason: Native SQL Execution Data
type FallbackReason struct {
	// FallbackNode: Optional. Fallback node information.
	FallbackNode string `json:"fallbackNode,omitempty"`
	// FallbackReason: Optional. Fallback to Spark reason.
	FallbackReason string `json:"fallbackReason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FallbackNode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FallbackNode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FallbackReason) MarshalJSON() ([]byte, error) {
	type NoMethod FallbackReason
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FlinkJob: A Dataproc job for running Apache Flink applications on YARN.
type FlinkJob struct {
	// Args: Optional. The arguments to pass to the driver. Do not include
	// arguments, such as --conf, that can be set as job properties, since a
	// collision might occur that causes an incorrect job submission.
	Args []string `json:"args,omitempty"`
	// JarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of
	// the Flink driver and tasks.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// LoggingConfig: Optional. The runtime log config for job execution.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// MainClass: The name of the driver's main class. The jar file that contains
	// the class must be in the default CLASSPATH or specified in jarFileUris.
	MainClass string `json:"mainClass,omitempty"`
	// MainJarFileUri: The HCFS URI of the jar file that contains the main class.
	MainJarFileUri string `json:"mainJarFileUri,omitempty"`
	// Properties: Optional. A mapping of property names to values, used to
	// configure Flink. Properties that conflict with values set by the Dataproc
	// API might be overwritten. Can include properties set in
	// /etc/flink/conf/flink-defaults.conf and classes in user code.
	Properties map[string]string `json:"properties,omitempty"`
	// SavepointUri: Optional. HCFS URI of the savepoint, which contains the last
	// saved progress for starting the current job.
	SavepointUri string `json:"savepointUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlinkJob) MarshalJSON() ([]byte, error) {
	type NoMethod FlinkJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GceClusterConfig: Common config settings for resources of Compute Engine
// cluster instances, applicable to all instances in the cluster.
type GceClusterConfig struct {
	// ConfidentialInstanceConfig: Optional. Confidential Instance Config for
	// clusters using Confidential VMs
	// (https://cloud.google.com/compute/confidential-vm/docs).
	ConfidentialInstanceConfig *ConfidentialInstanceConfig `json:"confidentialInstanceConfig,omitempty"`
	// InternalIpOnly: Optional. This setting applies to subnetwork-enabled
	// networks. It is set to true by default in clusters created with image
	// versions 2.2.x.When set to true: All cluster VMs have internal IP addresses.
	// Google Private Access
	// (https://cloud.google.com/vpc/docs/private-google-access) must be enabled to
	// access Dataproc and other Google Cloud APIs. Off-cluster dependencies must
	// be configured to be accessible without external IP addresses.When set to
	// false: Cluster VMs are not restricted to internal IP addresses. Ephemeral
	// external IP addresses are assigned to each cluster VM.
	InternalIpOnly bool `json:"internalIpOnly,omitempty"`
	// Metadata: Optional. The Compute Engine metadata entries to add to all
	// instances (see Project and instance metadata
	// (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
	Metadata map[string]string `json:"metadata,omitempty"`
	// NetworkUri: Optional. The Compute Engine network to be used for machine
	// communications. Cannot be specified with subnetwork_uri. If neither
	// network_uri nor subnetwork_uri is specified, the "default" network of the
	// project is used, if it exists. Cannot be a "Custom Subnet Network" (see
	// Using Subnetworks (https://cloud.google.com/compute/docs/subnetworks) for
	// more information).A full URL, partial URI, or short name are valid.
	// Examples:
	// https://www.googleapis.com/compute/v1/projects/[project_id]/global/networks/default
	// projects/[project_id]/global/networks/default default
	NetworkUri string `json:"networkUri,omitempty"`
	// NodeGroupAffinity: Optional. Node Group Affinity for sole-tenant clusters.
	NodeGroupAffinity *NodeGroupAffinity `json:"nodeGroupAffinity,omitempty"`
	// PrivateIpv6GoogleAccess: Optional. The type of IPv6 access for a cluster.
	//
	// Possible values:
	//   "PRIVATE_IPV6_GOOGLE_ACCESS_UNSPECIFIED" - If unspecified, Compute Engine
	// default behavior will apply, which is the same as INHERIT_FROM_SUBNETWORK.
	//   "INHERIT_FROM_SUBNETWORK" - Private access to and from Google Services
	// configuration inherited from the subnetwork configuration. This is the
	// default Compute Engine behavior.
	//   "OUTBOUND" - Enables outbound private IPv6 access to Google Services from
	// the Dataproc cluster.
	//   "BIDIRECTIONAL" - Enables bidirectional private IPv6 access between Google
	// Services and the Dataproc cluster.
	PrivateIpv6GoogleAccess string `json:"privateIpv6GoogleAccess,omitempty"`
	// ReservationAffinity: Optional. Reservation Affinity for consuming Zonal
	// reservation.
	ReservationAffinity *ReservationAffinity `json:"reservationAffinity,omitempty"`
	// ResourceManagerTags: Optional. Resource manager tags
	// (https://cloud.google.com/resource-manager/docs/tags/tags-creating-and-managing)
	// to add to all instances (see Use secure tags in Dataproc
	// (https://cloud.google.com/dataproc/docs/guides/attach-secure-tags)).
	ResourceManagerTags map[string]string `json:"resourceManagerTags,omitempty"`
	// ServiceAccount: Optional. The Dataproc service account
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc)
	// (also see VM Data Plane identity
	// (https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity))
	// used by Dataproc cluster VM instances to access Google Cloud Platform
	// services.If not specified, the Compute Engine default service account
	// (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account)
	// is used.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ServiceAccountScopes: Optional. The URIs of service account scopes to be
	// included in Compute Engine instances. The following base set of scopes is
	// always included: https://www.googleapis.com/auth/cloud.useraccounts.readonly
	// https://www.googleapis.com/auth/devstorage.read_write
	// https://www.googleapis.com/auth/logging.writeIf no scopes are specified, the
	// following defaults are also provided:
	// https://www.googleapis.com/auth/bigquery
	// https://www.googleapis.com/auth/bigtable.admin.table
	// https://www.googleapis.com/auth/bigtable.data
	// https://www.googleapis.com/auth/devstorage.full_control
	ServiceAccountScopes []string `json:"serviceAccountScopes,omitempty"`
	// ShieldedInstanceConfig: Optional. Shielded Instance Config for clusters
	// using Compute Engine Shielded VMs
	// (https://cloud.google.com/security/shielded-cloud/shielded-vm).
	ShieldedInstanceConfig *ShieldedInstanceConfig `json:"shieldedInstanceConfig,omitempty"`
	// SubnetworkUri: Optional. The Compute Engine subnetwork to be used for
	// machine communications. Cannot be specified with network_uri.A full URL,
	// partial URI, or short name are valid. Examples:
	// https://www.googleapis.com/compute/v1/projects/[project_id]/regions/[region]/subnetworks/sub0
	// projects/[project_id]/regions/[region]/subnetworks/sub0 sub0
	SubnetworkUri string `json:"subnetworkUri,omitempty"`
	// Tags: The Compute Engine network tags to add to all instances (see Tagging
	// instances (https://cloud.google.com/vpc/docs/add-remove-network-tags)).
	Tags []string `json:"tags,omitempty"`
	// ZoneUri: Optional. The Compute Engine zone where the Dataproc cluster will
	// be located. If omitted, the service will pick a zone in the cluster's
	// Compute Engine region. On a get request, zone will always be present.A full
	// URL, partial URI, or short name are valid. Examples:
	// https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]
	// projects/[project_id]/zones/[zone] [zone]
	ZoneUri string `json:"zoneUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfidentialInstanceConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfidentialInstanceConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GceClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GceClusterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetIamPolicyRequest: Request message for GetIamPolicy method.
type GetIamPolicyRequest struct {
	// Options: OPTIONAL: A GetPolicyOptions object for specifying options to
	// GetIamPolicy.
	Options *GetPolicyOptions `json:"options,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Options") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Options") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GetPolicyOptions: Encapsulates settings provided to GetIamPolicy.
type GetPolicyOptions struct {
	// RequestedPolicyVersion: Optional. The maximum policy version that will be
	// used to format the policy.Valid values are 0, 1, and 3. Requests specifying
	// an invalid value will be rejected.Requests for policies with any conditional
	// role bindings must specify version 3. Policies with no conditional role
	// bindings may specify any valid value or leave the field unset.The policy in
	// the response might use the policy version that you specified, or it might
	// use a lower policy version. For example, if you specify version 3, but the
	// policy has no conditional role bindings, the response uses version 1.To
	// learn which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	RequestedPolicyVersion int64 `json:"requestedPolicyVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestedPolicyVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestedPolicyVersion") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GetPolicyOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GetPolicyOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkeClusterConfig: The cluster's GKE config.
type GkeClusterConfig struct {
	// GkeClusterTarget: Optional. A target GKE cluster to deploy to. It must be in
	// the same project and region as the Dataproc cluster (the GKE cluster can be
	// zonal or regional). Format:
	// 'projects/{project}/locations/{location}/clusters/{cluster_id}'
	GkeClusterTarget string `json:"gkeClusterTarget,omitempty"`
	// NamespacedGkeDeploymentTarget: Optional. Deprecated. Use gkeClusterTarget.
	// Used only for the deprecated beta. A target for the deployment.
	NamespacedGkeDeploymentTarget *NamespacedGkeDeploymentTarget `json:"namespacedGkeDeploymentTarget,omitempty"`
	// NodePoolTarget: Optional. GKE node pools where workloads will be scheduled.
	// At least one node pool must be assigned the DEFAULT GkeNodePoolTarget.Role.
	// If a GkeNodePoolTarget is not specified, Dataproc constructs a DEFAULT
	// GkeNodePoolTarget. Each role can be given to only one GkeNodePoolTarget. All
	// node pools must have the same location settings.
	NodePoolTarget []*GkeNodePoolTarget `json:"nodePoolTarget,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GkeClusterTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GkeClusterTarget") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkeClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GkeClusterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkeNodeConfig: Parameters that describe cluster nodes.
type GkeNodeConfig struct {
	// Accelerators: Optional. A list of hardware accelerators
	// (https://cloud.google.com/compute/docs/gpus) to attach to each node.
	Accelerators []*GkeNodePoolAcceleratorConfig `json:"accelerators,omitempty"`
	// BootDiskKmsKey: Optional. The Customer Managed Encryption Key (CMEK)
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/using-cmek) used to
	// encrypt the boot disk attached to each node in the node pool. Specify the
	// key using the following format:
	// projects/{project}/locations/{location}/keyRings/{key_ring}/cryptoKeys/{crypt
	// o_key}
	BootDiskKmsKey string `json:"bootDiskKmsKey,omitempty"`
	// LocalSsdCount: Optional. The number of local SSD disks to attach to the
	// node, which is limited by the maximum number of disks allowable per zone
	// (see Adding Local SSDs
	// (https://cloud.google.com/compute/docs/disks/local-ssd)).
	LocalSsdCount int64 `json:"localSsdCount,omitempty"`
	// MachineType: Optional. The name of a Compute Engine machine type
	// (https://cloud.google.com/compute/docs/machine-types).
	MachineType string `json:"machineType,omitempty"`
	// MinCpuPlatform: Optional. Minimum CPU platform
	// (https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform)
	// to be used by this instance. The instance may be scheduled on the specified
	// or a newer CPU platform. Specify the friendly names of CPU platforms, such
	// as "Intel Haswell" or Intel Sandy Bridge".
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`
	// Preemptible: Optional. Whether the nodes are created as legacy preemptible
	// VM instances (https://cloud.google.com/compute/docs/instances/preemptible).
	// Also see Spot VMs, preemptible VM instances without a maximum lifetime.
	// Legacy and Spot preemptible nodes cannot be used in a node pool with the
	// CONTROLLER role or in the DEFAULT node pool if the CONTROLLER role is not
	// assigned (the DEFAULT node pool will assume the CONTROLLER role).
	Preemptible bool `json:"preemptible,omitempty"`
	// Spot: Optional. Whether the nodes are created as Spot VM instances
	// (https://cloud.google.com/compute/docs/instances/spot). Spot VMs are the
	// latest update to legacy preemptible VMs. Spot VMs do not have a maximum
	// lifetime. Legacy and Spot preemptible nodes cannot be used in a node pool
	// with the CONTROLLER role or in the DEFAULT node pool if the CONTROLLER role
	// is not assigned (the DEFAULT node pool will assume the CONTROLLER role).
	Spot bool `json:"spot,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accelerators") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accelerators") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkeNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GkeNodeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkeNodePoolAcceleratorConfig: A GkeNodeConfigAcceleratorConfig represents a
// Hardware Accelerator request for a node pool.
type GkeNodePoolAcceleratorConfig struct {
	// AcceleratorCount: The number of accelerator cards exposed to an instance.
	AcceleratorCount int64 `json:"acceleratorCount,omitempty,string"`
	// AcceleratorType: The accelerator type resource namename (see GPUs on Compute
	// Engine).
	AcceleratorType string `json:"acceleratorType,omitempty"`
	// GpuPartitionSize: Size of partitions to create on the GPU. Valid values are
	// described in the NVIDIA mig user guide
	// (https://docs.nvidia.com/datacenter/tesla/mig-user-guide/#partitioning).
	GpuPartitionSize string `json:"gpuPartitionSize,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceleratorCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceleratorCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkeNodePoolAcceleratorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GkeNodePoolAcceleratorConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkeNodePoolAutoscalingConfig: GkeNodePoolAutoscaling contains information
// the cluster autoscaler needs to adjust the size of the node pool to the
// current cluster usage.
type GkeNodePoolAutoscalingConfig struct {
	// MaxNodeCount: The maximum number of nodes in the node pool. Must be >=
	// min_node_count, and must be > 0. Note: Quota must be sufficient to scale up
	// the cluster.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`
	// MinNodeCount: The minimum number of nodes in the node pool. Must be >= 0 and
	// <= max_node_count.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxNodeCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxNodeCount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkeNodePoolAutoscalingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GkeNodePoolAutoscalingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkeNodePoolConfig: The configuration of a GKE node pool used by a
// Dataproc-on-GKE cluster
// (https://cloud.google.com/dataproc/docs/concepts/jobs/dataproc-gke#create-a-dataproc-on-gke-cluster).
type GkeNodePoolConfig struct {
	// Autoscaling: Optional. The autoscaler configuration for this node pool. The
	// autoscaler is enabled only when a valid configuration is present.
	Autoscaling *GkeNodePoolAutoscalingConfig `json:"autoscaling,omitempty"`
	// Config: Optional. The node pool configuration.
	Config *GkeNodeConfig `json:"config,omitempty"`
	// Locations: Optional. The list of Compute Engine zones
	// (https://cloud.google.com/compute/docs/zones#available) where node pool
	// nodes associated with a Dataproc on GKE virtual cluster will be
	// located.Note: All node pools associated with a virtual cluster must be
	// located in the same region as the virtual cluster, and they must be located
	// in the same zone within that region.If a location is not specified during
	// node pool creation, Dataproc on GKE will choose the zone.
	Locations []string `json:"locations,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Autoscaling") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Autoscaling") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkeNodePoolConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GkeNodePoolConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GkeNodePoolTarget: GKE node pools that Dataproc workloads run on.
type GkeNodePoolTarget struct {
	// NodePool: Required. The target GKE node pool. Format:
	// 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{node_p
	// ool}'
	NodePool string `json:"nodePool,omitempty"`
	// NodePoolConfig: Input only. The configuration for the GKE node pool.If
	// specified, Dataproc attempts to create a node pool with the specified shape.
	// If one with the same name already exists, it is verified against all
	// specified fields. If a field differs, the virtual cluster creation will
	// fail.If omitted, any node pool with the specified name is used. If a node
	// pool with the specified name does not exist, Dataproc create a node pool
	// with default values.This is an input only field. It will not be returned by
	// the API.
	NodePoolConfig *GkeNodePoolConfig `json:"nodePoolConfig,omitempty"`
	// Roles: Required. The roles associated with the GKE node pool.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Role is unspecified.
	//   "DEFAULT" - At least one node pool must have the DEFAULT role. Work
	// assigned to a role that is not associated with a node pool is assigned to
	// the node pool with the DEFAULT role. For example, work assigned to the
	// CONTROLLER role will be assigned to the node pool with the DEFAULT role if
	// no node pool has the CONTROLLER role.
	//   "CONTROLLER" - Run work associated with the Dataproc control plane (for
	// example, controllers and webhooks). Very low resource requirements.
	//   "SPARK_DRIVER" - Run work associated with a Spark driver of a job.
	//   "SPARK_EXECUTOR" - Run work associated with a Spark executor of a job.
	Roles []string `json:"roles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NodePool") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NodePool") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GkeNodePoolTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GkeNodePoolTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataprocV1WorkflowTemplateEncryptionConfig: Encryption settings
// for encrypting workflow template job arguments.
type GoogleCloudDataprocV1WorkflowTemplateEncryptionConfig struct {
	// KmsKey: Optional. The Cloud KMS key name to use for encrypting workflow
	// template job arguments.When this this key is provided, the following
	// workflow template job arguments
	// (https://cloud.google.com/dataproc/docs/concepts/workflows/use-workflows#adding_jobs_to_a_template),
	// if present, are CMEK encrypted
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/customer-managed-encryption#use_cmek_with_workflow_template_data):
	// FlinkJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/FlinkJob)
	// HadoopJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/HadoopJob)
	// SparkJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkJob)
	// SparkRJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkRJob)
	// PySparkJob args
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/PySparkJob)
	// SparkSqlJob
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/SparkSqlJob)
	// scriptVariables and queryList.queries HiveJob
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/HiveJob)
	// scriptVariables and queryList.queries PigJob
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/PigJob)
	// scriptVariables and queryList.queries PrestoJob
	// (https://cloud.google.com/dataproc/docs/reference/rest/v1/PrestoJob)
	// scriptVariables and queryList.queries
	KmsKey string `json:"kmsKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKey") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKey") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudDataprocV1WorkflowTemplateEncryptionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataprocV1WorkflowTemplateEncryptionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HadoopJob: A Dataproc job for running Apache Hadoop MapReduce
// (https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html)
// jobs on Apache Hadoop YARN
// (https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
type HadoopJob struct {
	// ArchiveUris: Optional. HCFS URIs of archives to be extracted in the working
	// directory of Hadoop drivers and tasks. Supported file types: .jar, .tar,
	// .tar.gz, .tgz, or .zip.
	ArchiveUris []string `json:"archiveUris,omitempty"`
	// Args: Optional. The arguments to pass to the driver. Do not include
	// arguments, such as -libjars or -Dfoo=bar, that can be set as job properties,
	// since a collision might occur that causes an incorrect job submission.
	Args []string `json:"args,omitempty"`
	// FileUris: Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be
	// copied to the working directory of Hadoop drivers and distributed tasks.
	// Useful for naively parallel tasks.
	FileUris []string `json:"fileUris,omitempty"`
	// JarFileUris: Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop
	// driver and tasks.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// LoggingConfig: Optional. The runtime log config for job execution.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// MainClass: The name of the driver's main class. The jar file containing the
	// class must be in the default CLASSPATH or specified in jar_file_uris.
	MainClass string `json:"mainClass,omitempty"`
	// MainJarFileUri: The HCFS URI of the jar file containing the main class.
	// Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar'
	// 'hdfs:/tmp/test-samples/custom-wordcount.jar'
	// 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
	MainJarFileUri string `json:"mainJarFileUri,omitempty"`
	// Properties: Optional. A mapping of property names to values, used to
	// configure Hadoop. Properties that conflict with values set by the Dataproc
	// API might be overwritten. Can include properties set in
	// /etc/hadoop/conf/*-site and classes in user code.
	Properties map[string]string `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HadoopJob) MarshalJSON() ([]byte, error) {
	type NoMethod HadoopJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HiveJob: A Dataproc job for running Apache Hive (https://hive.apache.org/)
// queries on YARN.
type HiveJob struct {
	// ContinueOnFailure: Optional. Whether to continue executing queries if a
	// query fails. The default value is false. Setting to true can be useful when
	// executing independent parallel queries.
	ContinueOnFailure bool `json:"continueOnFailure,omitempty"`
	// JarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATH of the
	// Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and
	// UDFs.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// Properties: Optional. A mapping of property names and values, used to
	// configure Hive. Properties that conflict with values set by the Dataproc API
	// might be overwritten. Can include properties set in
	// /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in
	// user code.
	Properties map[string]string `json:"properties,omitempty"`
	// QueryFileUri: The HCFS URI of the script that contains Hive queries.
	QueryFileUri string `json:"queryFileUri,omitempty"`
	// QueryList: A list of queries.
	QueryList *QueryList `json:"queryList,omitempty"`
	// ScriptVariables: Optional. Mapping of query variable names to values
	// (equivalent to the Hive command: SET name="value";).
	ScriptVariables map[string]string `json:"scriptVariables,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinueOnFailure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinueOnFailure") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HiveJob) MarshalJSON() ([]byte, error) {
	type NoMethod HiveJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IdentityConfig: Identity related configuration, including service account
// based secure multi-tenancy user mappings.
type IdentityConfig struct {
	// UserServiceAccountMapping: Required. Map of user to service account.
	UserServiceAccountMapping map[string]string `json:"userServiceAccountMapping,omitempty"`
	// ForceSendFields is a list of field names (e.g. "UserServiceAccountMapping")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "UserServiceAccountMapping") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IdentityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod IdentityConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InjectCredentialsRequest: A request to inject credentials into a cluster.
type InjectCredentialsRequest struct {
	// ClusterUuid: Required. The cluster UUID.
	ClusterUuid string `json:"clusterUuid,omitempty"`
	// CredentialsCiphertext: Required. The encrypted credentials being injected in
	// to the cluster.The client is responsible for encrypting the credentials in a
	// way that is supported by the cluster.A wrapped value is used here so that
	// the actual contents of the encrypted credentials are not written to audit
	// logs.
	CredentialsCiphertext string `json:"credentialsCiphertext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterUuid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterUuid") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InjectCredentialsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InjectCredentialsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InputMetrics: Metrics about the input data read by the task.
type InputMetrics struct {
	BytesRead   int64 `json:"bytesRead,omitempty,string"`
	RecordsRead int64 `json:"recordsRead,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BytesRead") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesRead") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod InputMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type InputQuantileMetrics struct {
	BytesRead   *Quantiles `json:"bytesRead,omitempty"`
	RecordsRead *Quantiles `json:"recordsRead,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesRead") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesRead") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InputQuantileMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod InputQuantileMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceFlexibilityPolicy: Instance flexibility Policy allowing a mixture of
// VM shapes and provisioning models.
type InstanceFlexibilityPolicy struct {
	// InstanceSelectionList: Optional. List of instance selection options that the
	// group will use when creating new VMs.
	InstanceSelectionList []*InstanceSelection `json:"instanceSelectionList,omitempty"`
	// InstanceSelectionResults: Output only. A list of instance selection results
	// in the group.
	InstanceSelectionResults []*InstanceSelectionResult `json:"instanceSelectionResults,omitempty"`
	// ProvisioningModelMix: Optional. Defines how the Group selects the
	// provisioning model to ensure required reliability.
	ProvisioningModelMix *ProvisioningModelMix `json:"provisioningModelMix,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceSelectionList") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceSelectionList") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceFlexibilityPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceFlexibilityPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceGroupAutoscalingPolicyConfig: Configuration for the size bounds of
// an instance group, including its proportional size to other groups.
type InstanceGroupAutoscalingPolicyConfig struct {
	// MaxInstances: Required. Maximum number of instances for this group. Required
	// for primary workers. Note that by default, clusters will not use secondary
	// workers. Required for secondary workers if the minimum secondary instances
	// is set.Primary workers - Bounds: [min_instances, ). Secondary workers -
	// Bounds: [min_instances, ). Default: 0.
	MaxInstances int64 `json:"maxInstances,omitempty"`
	// MinInstances: Optional. Minimum number of instances for this group.Primary
	// workers - Bounds: 2, max_instances. Default: 2. Secondary workers - Bounds:
	// 0, max_instances. Default: 0.
	MinInstances int64 `json:"minInstances,omitempty"`
	// Weight: Optional. Weight for the instance group, which is used to determine
	// the fraction of total workers in the cluster from this instance group. For
	// example, if primary workers have weight 2, and secondary workers have weight
	// 1, the cluster will have approximately 2 primary workers for each secondary
	// worker.The cluster may not reach the specified balance if constrained by
	// min/max bounds or other autoscaling settings. For example, if max_instances
	// for secondary workers is 0, then only primary workers will be added. The
	// cluster can also be out of balance when created.If weight is not set on any
	// instance group, the cluster will default to equal weight for all groups: the
	// cluster will attempt to maintain an equal number of workers in each group
	// within the configured size bounds for each group. If weight is set for one
	// group only, the cluster will default to zero weight on the unset group. For
	// example if weight is set only on primary workers, the cluster will use
	// primary workers only and no secondary workers.
	Weight int64 `json:"weight,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxInstances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxInstances") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceGroupAutoscalingPolicyConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupAutoscalingPolicyConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceGroupConfig: The config settings for Compute Engine resources in an
// instance group, such as a master or worker group.
type InstanceGroupConfig struct {
	// Accelerators: Optional. The Compute Engine accelerator configuration for
	// these instances.
	Accelerators []*AcceleratorConfig `json:"accelerators,omitempty"`
	// DiskConfig: Optional. Disk option config settings.
	DiskConfig *DiskConfig `json:"diskConfig,omitempty"`
	// ImageUri: Optional. The Compute Engine image resource used for cluster
	// instances.The URI can represent an image or image family.Image examples:
	// https://www.googleapis.com/compute/v1/projects/[project_id]/global/images/[image-id]
	// projects/[project_id]/global/images/[image-id] image-idImage family
	// examples. Dataproc will use the most recent image from the family:
	// https://www.googleapis.com/compute/v1/projects/[project_id]/global/images/family/[custom-image-family-name]
	// projects/[project_id]/global/images/family/[custom-image-family-name]If the
	// URI is unspecified, it will be inferred from SoftwareConfig.image_version or
	// the system default.
	ImageUri string `json:"imageUri,omitempty"`
	// InstanceFlexibilityPolicy: Optional. Instance flexibility Policy allowing a
	// mixture of VM shapes and provisioning models.
	InstanceFlexibilityPolicy *InstanceFlexibilityPolicy `json:"instanceFlexibilityPolicy,omitempty"`
	// InstanceNames: Output only. The list of instance names. Dataproc derives the
	// names from cluster_name, num_instances, and the instance group.
	InstanceNames []string `json:"instanceNames,omitempty"`
	// InstanceReferences: Output only. List of references to Compute Engine
	// instances.
	InstanceReferences []*InstanceReference `json:"instanceReferences,omitempty"`
	// IsPreemptible: Output only. Specifies that this instance group contains
	// preemptible instances.
	IsPreemptible bool `json:"isPreemptible,omitempty"`
	// MachineTypeUri: Optional. The Compute Engine machine type used for cluster
	// instances.A full URL, partial URI, or short name are valid. Examples:
	// https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]/machineTypes/n1-standard-2
	// projects/[project_id]/zones/[zone]/machineTypes/n1-standard-2
	// n1-standard-2Auto Zone Exception: If you are using the Dataproc Auto Zone
	// Placement
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement)
	// feature, you must use the short name of the machine type resource, for
	// example, n1-standard-2.
	MachineTypeUri string `json:"machineTypeUri,omitempty"`
	// ManagedGroupConfig: Output only. The config for Compute Engine Instance
	// Group Manager that manages this group. This is only used for preemptible
	// instance groups.
	ManagedGroupConfig *ManagedGroupConfig `json:"managedGroupConfig,omitempty"`
	// MinCpuPlatform: Optional. Specifies the minimum cpu platform for the
	// Instance Group. See Dataproc -> Minimum CPU Platform
	// (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
	MinCpuPlatform string `json:"minCpuPlatform,omitempty"`
	// MinNumInstances: Optional. The minimum number of primary worker instances to
	// create. If min_num_instances is set, cluster creation will succeed if the
	// number of primary workers created is at least equal to the min_num_instances
	// number.Example: Cluster creation request with num_instances = 5 and
	// min_num_instances = 3: If 4 VMs are created and 1 instance fails, the failed
	// VM is deleted. The cluster is resized to 4 instances and placed in a RUNNING
	// state. If 2 instances are created and 3 instances fail, the cluster in
	// placed in an ERROR state. The failed VMs are not deleted.
	MinNumInstances int64 `json:"minNumInstances,omitempty"`
	// NumInstances: Optional. The number of VM instances in the instance group.
	// For HA cluster master_config groups, must be set to 3. For standard cluster
	// master_config groups, must be set to 1.
	NumInstances int64 `json:"numInstances,omitempty"`
	// Preemptibility: Optional. Specifies the preemptibility of the instance
	// group.The default value for master and worker groups is NON_PREEMPTIBLE.
	// This default cannot be changed.The default value for secondary instances is
	// PREEMPTIBLE.
	//
	// Possible values:
	//   "PREEMPTIBILITY_UNSPECIFIED" - Preemptibility is unspecified, the system
	// will choose the appropriate setting for each instance group.
	//   "NON_PREEMPTIBLE" - Instances are non-preemptible.This option is allowed
	// for all instance groups and is the only valid value for Master and Worker
	// instance groups.
	//   "PREEMPTIBLE" - Instances are preemptible
	// (https://cloud.google.com/compute/docs/instances/preemptible).This option is
	// allowed only for secondary worker
	// (https://cloud.google.com/dataproc/docs/concepts/compute/secondary-vms)
	// groups.
	//   "SPOT" - Instances are Spot VMs
	// (https://cloud.google.com/compute/docs/instances/spot).This option is
	// allowed only for secondary worker
	// (https://cloud.google.com/dataproc/docs/concepts/compute/secondary-vms)
	// groups. Spot VMs are the latest version of preemptible VMs
	// (https://cloud.google.com/compute/docs/instances/preemptible), and provide
	// additional features.
	Preemptibility string `json:"preemptibility,omitempty"`
	// StartupConfig: Optional. Configuration to handle the startup of instances
	// during cluster create and update process.
	StartupConfig *StartupConfig `json:"startupConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accelerators") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accelerators") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceGroupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceGroupConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceReference: A reference to a Compute Engine instance.
type InstanceReference struct {
	// InstanceId: The unique identifier of the Compute Engine instance.
	InstanceId string `json:"instanceId,omitempty"`
	// InstanceName: The user-friendly name of the Compute Engine instance.
	InstanceName string `json:"instanceName,omitempty"`
	// PublicEciesKey: The public ECIES key used for sharing data with this
	// instance.
	PublicEciesKey string `json:"publicEciesKey,omitempty"`
	// PublicKey: The public RSA key used for sharing data with this instance.
	PublicKey string `json:"publicKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceReference) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceSelection: Defines machines types and a rank to which the machines
// types belong.
type InstanceSelection struct {
	// MachineTypes: Optional. Full machine-type names, e.g. "n1-standard-16".
	MachineTypes []string `json:"machineTypes,omitempty"`
	// Rank: Optional. Preference of this instance selection. Lower number means
	// higher preference. Dataproc will first try to create a VM based on the
	// machine-type with priority rank and fallback to next rank based on
	// availability. Machine types and instance selections with the same priority
	// have the same preference.
	Rank int64 `json:"rank,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MachineTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MachineTypes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceSelection) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceSelection
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceSelectionResult: Defines a mapping from machine types to the number
// of VMs that are created with each machine type.
type InstanceSelectionResult struct {
	// MachineType: Output only. Full machine-type names, e.g. "n1-standard-16".
	MachineType string `json:"machineType,omitempty"`
	// VmCount: Output only. Number of VM provisioned with the machine_type.
	VmCount int64 `json:"vmCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MachineType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MachineType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceSelectionResult) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceSelectionResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstantiateWorkflowTemplateRequest: A request to instantiate a workflow
// template.
type InstantiateWorkflowTemplateRequest struct {
	// Parameters: Optional. Map from parameter names to values that should be used
	// for those parameters. Values may not exceed 1000 characters.
	Parameters map[string]string `json:"parameters,omitempty"`
	// RequestId: Optional. A tag that prevents multiple concurrent workflow
	// instances with the same tag from running. This mitigates risk of concurrent
	// instances started due to retries.It is recommended to always set this value
	// to a UUID (https://en.wikipedia.org/wiki/Universally_unique_identifier).The
	// tag must contain only letters (a-z, A-Z), numbers (0-9), underscores (_),
	// and hyphens (-). The maximum length is 40 characters.
	RequestId string `json:"requestId,omitempty"`
	// Version: Optional. The version of workflow template to instantiate. If
	// specified, the workflow will be instantiated only if the current version of
	// the workflow template has the supplied version.This option cannot be used to
	// instantiate a previous version of workflow template.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parameters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstantiateWorkflowTemplateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstantiateWorkflowTemplateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Interval: Represents a time interval, encoded as a Timestamp start
// (inclusive) and a Timestamp end (exclusive).The start must be less than or
// equal to the end. When the start equals the end, the interval is empty
// (matches no time). When both start and end are unspecified, the interval
// matches any time.
type Interval struct {
	// EndTime: Optional. Exclusive end of the interval.If specified, a Timestamp
	// matching this interval will have to be before the end.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Optional. Inclusive start of the interval.If specified, a
	// Timestamp matching this interval will have to be the same or after the
	// start.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Interval) MarshalJSON() ([]byte, error) {
	type NoMethod Interval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Job: A Dataproc job resource.
type Job struct {
	// Done: Output only. Indicates whether the job is completed. If the value is
	// false, the job is still in progress. If true, the job is completed, and
	// status.state field will indicate if it was successful, failed, or cancelled.
	Done bool `json:"done,omitempty"`
	// DriverControlFilesUri: Output only. If present, the location of
	// miscellaneous control files which can be used as part of job setup and
	// handling. If not present, control files might be placed in the same location
	// as driver_output_uri.
	DriverControlFilesUri string `json:"driverControlFilesUri,omitempty"`
	// DriverOutputResourceUri: Output only. A URI pointing to the location of the
	// stdout of the job's driver program.
	DriverOutputResourceUri string `json:"driverOutputResourceUri,omitempty"`
	// DriverSchedulingConfig: Optional. Driver scheduling configuration.
	DriverSchedulingConfig *DriverSchedulingConfig `json:"driverSchedulingConfig,omitempty"`
	// FlinkJob: Optional. Job is a Flink job.
	FlinkJob *FlinkJob `json:"flinkJob,omitempty"`
	// HadoopJob: Optional. Job is a Hadoop job.
	HadoopJob *HadoopJob `json:"hadoopJob,omitempty"`
	// HiveJob: Optional. Job is a Hive job.
	HiveJob *HiveJob `json:"hiveJob,omitempty"`
	// JobUuid: Output only. A UUID that uniquely identifies a job within the
	// project over time. This is in contrast to a user-settable reference.job_id
	// that might be reused over time.
	JobUuid string `json:"jobUuid,omitempty"`
	// Labels: Optional. The labels to associate with this job. Label keys must
	// contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). Label values can be empty, but, if
	// present, must contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a job.
	Labels map[string]string `json:"labels,omitempty"`
	// PigJob: Optional. Job is a Pig job.
	PigJob *PigJob `json:"pigJob,omitempty"`
	// Placement: Required. Job information, including how, when, and where to run
	// the job.
	Placement *JobPlacement `json:"placement,omitempty"`
	// PrestoJob: Optional. Job is a Presto job.
	PrestoJob *PrestoJob `json:"prestoJob,omitempty"`
	// PysparkJob: Optional. Job is a PySpark job.
	PysparkJob *PySparkJob `json:"pysparkJob,omitempty"`
	// Reference: Optional. The fully qualified reference to the job, which can be
	// used to obtain the equivalent REST path of the job resource. If this
	// property is not specified when a job is created, the server generates a
	// job_id.
	Reference *JobReference `json:"reference,omitempty"`
	// Scheduling: Optional. Job scheduling configuration.
	Scheduling *JobScheduling `json:"scheduling,omitempty"`
	// SparkJob: Optional. Job is a Spark job.
	SparkJob *SparkJob `json:"sparkJob,omitempty"`
	// SparkRJob: Optional. Job is a SparkR job.
	SparkRJob *SparkRJob `json:"sparkRJob,omitempty"`
	// SparkSqlJob: Optional. Job is a SparkSql job.
	SparkSqlJob *SparkSqlJob `json:"sparkSqlJob,omitempty"`
	// Status: Output only. The job status. Additional application-specific status
	// information might be contained in the type_job and yarn_applications fields.
	Status *JobStatus `json:"status,omitempty"`
	// StatusHistory: Output only. The previous job status.
	StatusHistory []*JobStatus `json:"statusHistory,omitempty"`
	// TrinoJob: Optional. Job is a Trino job.
	TrinoJob *TrinoJob `json:"trinoJob,omitempty"`
	// YarnApplications: Output only. The collection of YARN applications spun up
	// by this job.Beta Feature: This report is available for testing purposes
	// only. It might be changed before final release.
	YarnApplications []*YarnApplication `json:"yarnApplications,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Job) MarshalJSON() ([]byte, error) {
	type NoMethod Job
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobData: Data corresponding to a spark job.
type JobData struct {
	CompletionTime      string           `json:"completionTime,omitempty"`
	Description         string           `json:"description,omitempty"`
	JobGroup            string           `json:"jobGroup,omitempty"`
	JobId               int64            `json:"jobId,omitempty,string"`
	KillTasksSummary    map[string]int64 `json:"killTasksSummary,omitempty"`
	Name                string           `json:"name,omitempty"`
	NumActiveStages     int64            `json:"numActiveStages,omitempty"`
	NumActiveTasks      int64            `json:"numActiveTasks,omitempty"`
	NumCompletedIndices int64            `json:"numCompletedIndices,omitempty"`
	NumCompletedStages  int64            `json:"numCompletedStages,omitempty"`
	NumCompletedTasks   int64            `json:"numCompletedTasks,omitempty"`
	NumFailedStages     int64            `json:"numFailedStages,omitempty"`
	NumFailedTasks      int64            `json:"numFailedTasks,omitempty"`
	NumKilledTasks      int64            `json:"numKilledTasks,omitempty"`
	NumSkippedStages    int64            `json:"numSkippedStages,omitempty"`
	NumSkippedTasks     int64            `json:"numSkippedTasks,omitempty"`
	NumTasks            int64            `json:"numTasks,omitempty"`
	SkippedStages       []int64          `json:"skippedStages,omitempty"`
	SqlExecutionId      int64            `json:"sqlExecutionId,omitempty,string"`
	StageIds            googleapi.Int64s `json:"stageIds,omitempty"`
	// Possible values:
	//   "JOB_EXECUTION_STATUS_UNSPECIFIED"
	//   "JOB_EXECUTION_STATUS_RUNNING"
	//   "JOB_EXECUTION_STATUS_SUCCEEDED"
	//   "JOB_EXECUTION_STATUS_FAILED"
	//   "JOB_EXECUTION_STATUS_UNKNOWN"
	Status         string `json:"status,omitempty"`
	SubmissionTime string `json:"submissionTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobData) MarshalJSON() ([]byte, error) {
	type NoMethod JobData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobMetadata: Job Operation metadata.
type JobMetadata struct {
	// JobId: Output only. The job id.
	JobId string `json:"jobId,omitempty"`
	// OperationType: Output only. Operation type.
	OperationType string `json:"operationType,omitempty"`
	// StartTime: Output only. Job submission time.
	StartTime string `json:"startTime,omitempty"`
	// Status: Output only. Most recent job status.
	Status *JobStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JobId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod JobMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobPlacement: Dataproc job config.
type JobPlacement struct {
	// ClusterLabels: Optional. Cluster labels to identify a cluster where the job
	// will be submitted.
	ClusterLabels map[string]string `json:"clusterLabels,omitempty"`
	// ClusterName: Required. The name of the cluster where the job will be
	// submitted.
	ClusterName string `json:"clusterName,omitempty"`
	// ClusterUuid: Output only. A cluster UUID generated by the Dataproc service
	// when the job is submitted.
	ClusterUuid string `json:"clusterUuid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterLabels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterLabels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobPlacement) MarshalJSON() ([]byte, error) {
	type NoMethod JobPlacement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobReference: Encapsulates the full scoping used to reference a job.
type JobReference struct {
	// JobId: Optional. The job ID, which must be unique within the project.The ID
	// must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or
	// hyphens (-). The maximum length is 100 characters.If not specified by the
	// caller, the job ID will be provided by the server.
	JobId string `json:"jobId,omitempty"`
	// ProjectId: Optional. The ID of the Google Cloud Platform project that the
	// job belongs to. If specified, must match the request project ID.
	ProjectId string `json:"projectId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JobId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobReference) MarshalJSON() ([]byte, error) {
	type NoMethod JobReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobScheduling: Job scheduling options.
type JobScheduling struct {
	// MaxFailuresPerHour: Optional. Maximum number of times per hour a driver can
	// be restarted as a result of driver exiting with non-zero code before job is
	// reported failed.A job might be reported as thrashing if the driver exits
	// with a non-zero code four times within a 10-minute window.Maximum value is
	// 10.Note: This restartable job option is not supported in Dataproc workflow
	// templates
	// (https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template).
	MaxFailuresPerHour int64 `json:"maxFailuresPerHour,omitempty"`
	// MaxFailuresTotal: Optional. Maximum total number of times a driver can be
	// restarted as a result of the driver exiting with a non-zero code. After the
	// maximum number is reached, the job will be reported as failed.Maximum value
	// is 240.Note: Currently, this restartable job option is not supported in
	// Dataproc workflow templates
	// (https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template).
	MaxFailuresTotal int64 `json:"maxFailuresTotal,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxFailuresPerHour") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxFailuresPerHour") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobScheduling) MarshalJSON() ([]byte, error) {
	type NoMethod JobScheduling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobStatus: Dataproc job status.
type JobStatus struct {
	// Details: Optional. Output only. Job state details, such as an error
	// description if the state is ERROR.
	Details string `json:"details,omitempty"`
	// State: Output only. A state message specifying the overall job state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The job state is unknown.
	//   "PENDING" - The job is pending; it has been submitted, but is not yet
	// running.
	//   "SETUP_DONE" - Job has been received by the service and completed initial
	// setup; it will soon be submitted to the cluster.
	//   "RUNNING" - The job is running on the cluster.
	//   "CANCEL_PENDING" - A CancelJob request has been received, but is pending.
	//   "CANCEL_STARTED" - Transient in-flight resources have been canceled, and
	// the request to cancel the running job has been issued to the cluster.
	//   "CANCELLED" - The job cancellation was successful.
	//   "DONE" - The job has completed successfully.
	//   "ERROR" - The job has completed, but encountered an error.
	//   "ATTEMPT_FAILURE" - Job attempt has failed. The detail field contains
	// failure details for this attempt.Applies to restartable jobs only.
	State string `json:"state,omitempty"`
	// StateStartTime: Output only. The time when this state was entered.
	StateStartTime string `json:"stateStartTime,omitempty"`
	// Substate: Output only. Additional state information, which includes status
	// reported by the agent.
	//
	// Possible values:
	//   "UNSPECIFIED" - The job substate is unknown.
	//   "SUBMITTED" - The Job is submitted to the agent.Applies to RUNNING state.
	//   "QUEUED" - The Job has been received and is awaiting execution (it might
	// be waiting for a condition to be met). See the "details" field for the
	// reason for the delay.Applies to RUNNING state.
	//   "STALE_STATUS" - The agent-reported status is out of date, which can be
	// caused by a loss of communication between the agent and Dataproc. If the
	// agent does not send a timely update, the job will fail.Applies to RUNNING
	// state.
	Substate string `json:"substate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Details") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Details") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatus) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobsSummary: Data related to Jobs page summary
type JobsSummary struct {
	// ActiveJobs: Number of active jobs
	ActiveJobs int64 `json:"activeJobs,omitempty"`
	// ApplicationId: Spark Application Id
	ApplicationId string `json:"applicationId,omitempty"`
	// Attempts: Attempts info
	Attempts []*ApplicationAttemptInfo `json:"attempts,omitempty"`
	// CompletedJobs: Number of completed jobs
	CompletedJobs int64 `json:"completedJobs,omitempty"`
	// FailedJobs: Number of failed jobs
	FailedJobs int64 `json:"failedJobs,omitempty"`
	// SchedulingMode: Spark Scheduling mode
	SchedulingMode string `json:"schedulingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveJobs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveJobs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobsSummary) MarshalJSON() ([]byte, error) {
	type NoMethod JobsSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JupyterConfig: Jupyter configuration for an interactive session.
type JupyterConfig struct {
	// DisplayName: Optional. Display name, shown in the Jupyter kernelspec card.
	DisplayName string `json:"displayName,omitempty"`
	// Kernel: Optional. Kernel
	//
	// Possible values:
	//   "KERNEL_UNSPECIFIED" - The kernel is unknown.
	//   "PYTHON" - Python kernel.
	//   "SCALA" - Scala kernel.
	Kernel string `json:"kernel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JupyterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod JupyterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KerberosConfig: Specifies Kerberos related configuration.
type KerberosConfig struct {
	// CrossRealmTrustAdminServer: Optional. The admin server (IP or hostname) for
	// the remote trusted realm in a cross realm trust relationship.
	CrossRealmTrustAdminServer string `json:"crossRealmTrustAdminServer,omitempty"`
	// CrossRealmTrustKdc: Optional. The KDC (IP or hostname) for the remote
	// trusted realm in a cross realm trust relationship.
	CrossRealmTrustKdc string `json:"crossRealmTrustKdc,omitempty"`
	// CrossRealmTrustRealm: Optional. The remote realm the Dataproc on-cluster KDC
	// will trust, should the user enable cross realm trust.
	CrossRealmTrustRealm string `json:"crossRealmTrustRealm,omitempty"`
	// CrossRealmTrustSharedPasswordUri: Optional. The Cloud Storage URI of a KMS
	// encrypted file containing the shared password between the on-cluster
	// Kerberos realm and the remote trusted realm, in a cross realm trust
	// relationship.
	CrossRealmTrustSharedPasswordUri string `json:"crossRealmTrustSharedPasswordUri,omitempty"`
	// EnableKerberos: Optional. Flag to indicate whether to Kerberize the cluster
	// (default: false). Set this field to true to enable Kerberos on a cluster.
	EnableKerberos bool `json:"enableKerberos,omitempty"`
	// KdcDbKeyUri: Optional. The Cloud Storage URI of a KMS encrypted file
	// containing the master key of the KDC database.
	KdcDbKeyUri string `json:"kdcDbKeyUri,omitempty"`
	// KeyPasswordUri: Optional. The Cloud Storage URI of a KMS encrypted file
	// containing the password to the user provided key. For the self-signed
	// certificate, this password is generated by Dataproc.
	KeyPasswordUri string `json:"keyPasswordUri,omitempty"`
	// KeystorePasswordUri: Optional. The Cloud Storage URI of a KMS encrypted file
	// containing the password to the user provided keystore. For the self-signed
	// certificate, this password is generated by Dataproc.
	KeystorePasswordUri string `json:"keystorePasswordUri,omitempty"`
	// KeystoreUri: Optional. The Cloud Storage URI of the keystore file used for
	// SSL encryption. If not provided, Dataproc will provide a self-signed
	// certificate.
	KeystoreUri string `json:"keystoreUri,omitempty"`
	// KmsKeyUri: Optional. The URI of the KMS key used to encrypt sensitive files.
	KmsKeyUri string `json:"kmsKeyUri,omitempty"`
	// Realm: Optional. The name of the on-cluster Kerberos realm. If not
	// specified, the uppercased domain of hostnames will be the realm.
	Realm string `json:"realm,omitempty"`
	// RootPrincipalPasswordUri: Optional. The Cloud Storage URI of a KMS encrypted
	// file containing the root principal password.
	RootPrincipalPasswordUri string `json:"rootPrincipalPasswordUri,omitempty"`
	// TgtLifetimeHours: Optional. The lifetime of the ticket granting ticket, in
	// hours. If not specified, or user specifies 0, then default value 10 will be
	// used.
	TgtLifetimeHours int64 `json:"tgtLifetimeHours,omitempty"`
	// TruststorePasswordUri: Optional. The Cloud Storage URI of a KMS encrypted
	// file containing the password to the user provided truststore. For the
	// self-signed certificate, this password is generated by Dataproc.
	TruststorePasswordUri string `json:"truststorePasswordUri,omitempty"`
	// TruststoreUri: Optional. The Cloud Storage URI of the truststore file used
	// for SSL encryption. If not provided, Dataproc will provide a self-signed
	// certificate.
	TruststoreUri string `json:"truststoreUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CrossRealmTrustAdminServer")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CrossRealmTrustAdminServer") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KerberosConfig) MarshalJSON() ([]byte, error) {
	type NoMethod KerberosConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KubernetesClusterConfig: The configuration for running the Dataproc cluster
// on Kubernetes.
type KubernetesClusterConfig struct {
	// GkeClusterConfig: Required. The configuration for running the Dataproc
	// cluster on GKE.
	GkeClusterConfig *GkeClusterConfig `json:"gkeClusterConfig,omitempty"`
	// KubernetesNamespace: Optional. A namespace within the Kubernetes cluster to
	// deploy into. If this namespace does not exist, it is created. If it exists,
	// Dataproc verifies that another Dataproc VirtualCluster is not installed into
	// it. If not specified, the name of the Dataproc Cluster is used.
	KubernetesNamespace string `json:"kubernetesNamespace,omitempty"`
	// KubernetesSoftwareConfig: Optional. The software configuration for this
	// Dataproc cluster running on Kubernetes.
	KubernetesSoftwareConfig *KubernetesSoftwareConfig `json:"kubernetesSoftwareConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GkeClusterConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GkeClusterConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KubernetesClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod KubernetesClusterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KubernetesSoftwareConfig: The software configuration for this Dataproc
// cluster running on Kubernetes.
type KubernetesSoftwareConfig struct {
	// ComponentVersion: The components that should be installed in this Dataproc
	// cluster. The key must be a string from the KubernetesComponent enumeration.
	// The value is the version of the software to be installed. At least one entry
	// must be specified.
	ComponentVersion map[string]string `json:"componentVersion,omitempty"`
	// Properties: The properties to set on daemon config files.Property keys are
	// specified in prefix:property format, for example
	// spark:spark.kubernetes.container.image. The following are supported prefixes
	// and their mappings: spark: spark-defaults.confFor more information, see
	// Cluster properties
	// (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
	Properties map[string]string `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ComponentVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ComponentVersion") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KubernetesSoftwareConfig) MarshalJSON() ([]byte, error) {
	type NoMethod KubernetesSoftwareConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LifecycleConfig: Specifies the cluster auto-delete schedule configuration.
type LifecycleConfig struct {
	// AutoDeleteTime: Optional. The time when cluster will be auto-deleted (see
	// JSON representation of Timestamp
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).
	AutoDeleteTime string `json:"autoDeleteTime,omitempty"`
	// AutoDeleteTtl: Optional. The lifetime duration of cluster. The cluster will
	// be auto-deleted at the end of this period. Minimum value is 10 minutes;
	// maximum value is 14 days (see JSON representation of Duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).
	AutoDeleteTtl string `json:"autoDeleteTtl,omitempty"`
	// AutoStopTime: Optional. The time when cluster will be auto-stopped (see JSON
	// representation of Timestamp
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).
	AutoStopTime string `json:"autoStopTime,omitempty"`
	// AutoStopTtl: Optional. The lifetime duration of the cluster. The cluster
	// will be auto-stopped at the end of this period, calculated from the time of
	// submission of the create or update cluster request. Minimum value is 10
	// minutes; maximum value is 14 days (see JSON representation of Duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).
	AutoStopTtl string `json:"autoStopTtl,omitempty"`
	// IdleDeleteTtl: Optional. The duration to keep the cluster alive while idling
	// (when no jobs are running). Passing this threshold will cause the cluster to
	// be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON
	// representation of Duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).
	IdleDeleteTtl string `json:"idleDeleteTtl,omitempty"`
	// IdleStartTime: Output only. The time when cluster became idle (most recent
	// job finished) and became eligible for deletion due to idleness (see JSON
	// representation of Timestamp
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).
	IdleStartTime string `json:"idleStartTime,omitempty"`
	// IdleStopTtl: Optional. The duration to keep the cluster started while idling
	// (when no jobs are running). Passing this threshold will cause the cluster to
	// be stopped. Minimum value is 5 minutes; maximum value is 14 days (see JSON
	// representation of Duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).
	IdleStopTtl string `json:"idleStopTtl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoDeleteTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoDeleteTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LifecycleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LifecycleConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAutoscalingPoliciesResponse: A response to a request to list autoscaling
// policies in a project.
type ListAutoscalingPoliciesResponse struct {
	// NextPageToken: Output only. This token is included in the response if there
	// are more results to fetch.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Policies: Output only. Autoscaling policies list.
	Policies []*AutoscalingPolicy `json:"policies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAutoscalingPoliciesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAutoscalingPoliciesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBatchesResponse: A list of batch workloads.
type ListBatchesResponse struct {
	// Batches: Output only. The batches from the specified collection.
	Batches []*Batch `json:"batches,omitempty"`
	// NextPageToken: A token, which can be sent as page_token to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Output only. List of Batches that could not be included in the
	// response. Attempting to get one of these resources may indicate why it was
	// not included in the list response.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Batches") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Batches") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBatchesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBatchesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListClustersResponse: The list of all clusters in a project.
type ListClustersResponse struct {
	// Clusters: Output only. The clusters in the project.
	Clusters []*Cluster `json:"clusters,omitempty"`
	// NextPageToken: Output only. This token is included in the response if there
	// are more results to fetch. To fetch additional results, provide this value
	// as the page_token in a subsequent ListClustersRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Clusters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clusters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListClustersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListClustersResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListJobsResponse: A list of jobs in a project.
type ListJobsResponse struct {
	// Jobs: Output only. Jobs list.
	Jobs []*Job `json:"jobs,omitempty"`
	// NextPageToken: Optional. This token is included in the response if there are
	// more results to fetch. To fetch additional results, provide this value as
	// the page_token in a subsequent ListJobsRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Unreachable: Output only. List of jobs with kms_key-encrypted parameters
	// that could not be decrypted. A response to a jobs.get request may indicate
	// the reason for the decryption failure for a specific job.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Jobs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Jobs") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListOperationsResponse: The response message for Operations.ListOperations.
type ListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*Operation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSessionTemplatesResponse: A list of session templates.
type ListSessionTemplatesResponse struct {
	// NextPageToken: A token, which can be sent as page_token to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SessionTemplates: Output only. Session template list
	SessionTemplates []*SessionTemplate `json:"sessionTemplates,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSessionTemplatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSessionTemplatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListSessionsResponse: A list of interactive sessions.
type ListSessionsResponse struct {
	// NextPageToken: A token, which can be sent as page_token, to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Sessions: Output only. The sessions from the specified collection.
	Sessions []*Session `json:"sessions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListSessionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListSessionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListWorkflowTemplatesResponse: A response to a request to list workflow
// templates in a project.
type ListWorkflowTemplatesResponse struct {
	// NextPageToken: Output only. This token is included in the response if there
	// are more results to fetch. To fetch additional results, provide this value
	// as the page_token in a subsequent ListWorkflowTemplatesRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Templates: Output only. WorkflowTemplates list.
	Templates []*WorkflowTemplate `json:"templates,omitempty"`
	// Unreachable: Output only. List of workflow templates that could not be
	// included in the response. Attempting to get one of these resources may
	// indicate why it was not included in the list response.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListWorkflowTemplatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListWorkflowTemplatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LoggingConfig: The runtime logging config of the job.
type LoggingConfig struct {
	// DriverLogLevels: The per-package log levels for the driver. This can include
	// "root" package name to configure rootLogger. Examples: - 'com.google =
	// FATAL' - 'root = INFO' - 'org.apache = DEBUG'
	DriverLogLevels map[string]string `json:"driverLogLevels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DriverLogLevels") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DriverLogLevels") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LoggingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod LoggingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ManagedCluster: Cluster that is managed by the workflow.
type ManagedCluster struct {
	// ClusterName: Required. The cluster name prefix. A unique cluster name will
	// be formed by appending a random suffix.The name must contain only lower-case
	// letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter.
	// Cannot begin or end with hyphen. Must consist of between 2 and 35
	// characters.
	ClusterName string `json:"clusterName,omitempty"`
	// Config: Required. The cluster configuration.
	Config *ClusterConfig `json:"config,omitempty"`
	// Labels: Optional. The labels to associate with this cluster.Label keys must
	// be between 1 and 63 characters long, and must conform to the following PCRE
	// regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63
	// characters long, and must conform to the following PCRE regular expression:
	// \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a
	// given cluster.
	Labels map[string]string `json:"labels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ManagedCluster) MarshalJSON() ([]byte, error) {
	type NoMethod ManagedCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ManagedGroupConfig: Specifies the resources used to actively manage an
// instance group.
type ManagedGroupConfig struct {
	// InstanceGroupManagerName: Output only. The name of the Instance Group
	// Manager for this group.
	InstanceGroupManagerName string `json:"instanceGroupManagerName,omitempty"`
	// InstanceGroupManagerUri: Output only. The partial URI to the instance group
	// manager for this group. E.g.
	// projects/my-project/regions/us-central1/instanceGroupManagers/my-igm.
	InstanceGroupManagerUri string `json:"instanceGroupManagerUri,omitempty"`
	// InstanceTemplateName: Output only. The name of the Instance Template used
	// for the Managed Instance Group.
	InstanceTemplateName string `json:"instanceTemplateName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceGroupManagerName")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceGroupManagerName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ManagedGroupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ManagedGroupConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type MemoryMetrics struct {
	TotalOffHeapStorageMemory int64 `json:"totalOffHeapStorageMemory,omitempty,string"`
	TotalOnHeapStorageMemory  int64 `json:"totalOnHeapStorageMemory,omitempty,string"`
	UsedOffHeapStorageMemory  int64 `json:"usedOffHeapStorageMemory,omitempty,string"`
	UsedOnHeapStorageMemory   int64 `json:"usedOnHeapStorageMemory,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TotalOffHeapStorageMemory")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TotalOffHeapStorageMemory") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MemoryMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod MemoryMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MetastoreConfig: Specifies a Metastore configuration.
type MetastoreConfig struct {
	// DataprocMetastoreService: Required. Resource name of an existing Dataproc
	// Metastore service.Example:
	// projects/[project_id]/locations/[dataproc_region]/services/[service-name]
	DataprocMetastoreService string `json:"dataprocMetastoreService,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataprocMetastoreService")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataprocMetastoreService") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MetastoreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod MetastoreConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Metric: A Dataproc custom metric.
type Metric struct {
	// MetricOverrides: Optional. Specify one or more Custom metrics
	// (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
	// to collect for the metric course (for the SPARK metric source (any Spark
	// metric (https://spark.apache.org/docs/latest/monitoring.html#metrics) can be
	// specified).Provide metrics in the following format: METRIC_SOURCE:
	// INSTANCE:GROUP:METRIC Use camelcase as appropriate.Examples:
	// yarn:ResourceManager:QueueMetrics:AppsCompleted
	// spark:driver:DAGScheduler:job.allJobs
	// sparkHistoryServer:JVM:Memory:NonHeapMemoryUsage.committed
	// hiveserver2:JVM:Memory:NonHeapMemoryUsage.used Notes: Only the specified
	// overridden metrics are collected for the metric source. For example, if one
	// or more spark:executive metrics are listed as metric overrides, other SPARK
	// metrics are not collected. The collection of the metrics for other enabled
	// custom metric sources is unaffected. For example, if both SPARK and YARN
	// metric sources are enabled, and overrides are provided for Spark metrics
	// only, all YARN metrics are collected.
	MetricOverrides []string `json:"metricOverrides,omitempty"`
	// MetricSource: Required. A standard set of metrics is collected unless
	// metricOverrides are specified for the metric source (see Custom metrics
	// (https://cloud.google.com/dataproc/docs/guides/dataproc-metrics#custom_metrics)
	// for more information).
	//
	// Possible values:
	//   "METRIC_SOURCE_UNSPECIFIED" - Required unspecified metric source.
	//   "MONITORING_AGENT_DEFAULTS" - Monitoring agent metrics. If this source is
	// enabled, Dataproc enables the monitoring agent in Compute Engine, and
	// collects monitoring agent metrics, which are published with an
	// agent.googleapis.com prefix.
	//   "HDFS" - HDFS metric source.
	//   "SPARK" - Spark metric source.
	//   "YARN" - YARN metric source.
	//   "SPARK_HISTORY_SERVER" - Spark History Server metric source.
	//   "HIVESERVER2" - Hiveserver2 metric source.
	//   "HIVEMETASTORE" - hivemetastore metric source
	//   "FLINK" - flink metric source
	MetricSource string `json:"metricSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetricOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetricOverrides") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Metric) MarshalJSON() ([]byte, error) {
	type NoMethod Metric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NamespacedGkeDeploymentTarget: Deprecated. Used only for the deprecated
// beta. A full, namespace-isolated deployment target for an existing GKE
// cluster.
type NamespacedGkeDeploymentTarget struct {
	// ClusterNamespace: Optional. A namespace within the GKE cluster to deploy
	// into.
	ClusterNamespace string `json:"clusterNamespace,omitempty"`
	// TargetGkeCluster: Optional. The target GKE cluster to deploy to. Format:
	// 'projects/{project}/locations/{location}/clusters/{cluster_id}'
	TargetGkeCluster string `json:"targetGkeCluster,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterNamespace") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterNamespace") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NamespacedGkeDeploymentTarget) MarshalJSON() ([]byte, error) {
	type NoMethod NamespacedGkeDeploymentTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type NativeBuildInfoUiData struct {
	// BuildClass: Optional. Build class of Native.
	BuildClass string `json:"buildClass,omitempty"`
	// BuildInfo: Optional. Build related details.
	BuildInfo []*BuildInfo `json:"buildInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildClass") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildClass") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NativeBuildInfoUiData) MarshalJSON() ([]byte, error) {
	type NoMethod NativeBuildInfoUiData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NativeSqlExecutionUiData: Native SQL Execution Data
type NativeSqlExecutionUiData struct {
	// Description: Optional. Description of the execution.
	Description string `json:"description,omitempty"`
	// ExecutionId: Required. Execution ID of the Native SQL Execution.
	ExecutionId int64 `json:"executionId,omitempty,string"`
	// FallbackDescription: Optional. Description of the fallback.
	FallbackDescription string `json:"fallbackDescription,omitempty"`
	// FallbackNodeToReason: Optional. Fallback node to reason.
	FallbackNodeToReason []*FallbackReason `json:"fallbackNodeToReason,omitempty"`
	// NumFallbackNodes: Optional. Number of nodes fallen back to Spark.
	NumFallbackNodes int64 `json:"numFallbackNodes,omitempty"`
	// NumNativeNodes: Optional. Number of nodes in Native.
	NumNativeNodes int64 `json:"numNativeNodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NativeSqlExecutionUiData) MarshalJSON() ([]byte, error) {
	type NoMethod NativeSqlExecutionUiData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeGroup: Dataproc Node Group. The Dataproc NodeGroup resource is not
// related to the Dataproc NodeGroupAffinity resource.
type NodeGroup struct {
	// Labels: Optional. Node group labels. Label keys must consist of from 1 to 63
	// characters and conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt).
	// Label values can be empty. If specified, they must consist of from 1 to 63
	// characters and conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt).
	// The node group must have no more than 32 labels.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: The Node group resource name (https://aip.dev/122).
	Name string `json:"name,omitempty"`
	// NodeGroupConfig: Optional. The node group instance group configuration.
	NodeGroupConfig *InstanceGroupConfig `json:"nodeGroupConfig,omitempty"`
	// Roles: Required. Node group roles.
	//
	// Possible values:
	//   "ROLE_UNSPECIFIED" - Required unspecified role.
	//   "DRIVER" - Job drivers run on the node pool.
	Roles []string `json:"roles,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Labels") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Labels") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeGroup) MarshalJSON() ([]byte, error) {
	type NoMethod NodeGroup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeGroupAffinity: Node Group Affinity for clusters using sole-tenant node
// groups. The Dataproc NodeGroupAffinity resource is not related to the
// Dataproc NodeGroup resource.
type NodeGroupAffinity struct {
	// NodeGroupUri: Required. The URI of a sole-tenant node group resource
	// (https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that
	// the cluster will be created on.A full URL, partial URI, or node group name
	// are valid. Examples:
	// https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone]/nodeGroups/node-group-1
	// projects/[project_id]/zones/[zone]/nodeGroups/node-group-1 node-group-1
	NodeGroupUri string `json:"nodeGroupUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NodeGroupUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NodeGroupUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeGroupAffinity) MarshalJSON() ([]byte, error) {
	type NoMethod NodeGroupAffinity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeGroupOperationMetadata: Metadata describing the node group operation.
type NodeGroupOperationMetadata struct {
	// ClusterUuid: Output only. Cluster UUID associated with the node group
	// operation.
	ClusterUuid string `json:"clusterUuid,omitempty"`
	// Description: Output only. Short description of operation.
	Description string `json:"description,omitempty"`
	// Labels: Output only. Labels associated with the operation.
	Labels map[string]string `json:"labels,omitempty"`
	// NodeGroupId: Output only. Node group ID for the operation.
	NodeGroupId string `json:"nodeGroupId,omitempty"`
	// OperationType: The operation type.
	//
	// Possible values:
	//   "NODE_GROUP_OPERATION_TYPE_UNSPECIFIED" - Node group operation type is
	// unknown.
	//   "CREATE" - Create node group operation type.
	//   "UPDATE" - Update node group operation type.
	//   "DELETE" - Delete node group operation type.
	//   "RESIZE" - Resize node group operation type.
	//   "REPAIR" - Repair node group operation type.
	//   "UPDATE_LABELS" - Update node group label operation type.
	//   "START" - Start node group operation type.
	//   "STOP" - Stop node group operation type.
	//   "UPDATE_METADATA_CONFIG" - This operation type is used to update the
	// metadata config of a node group. We update the metadata of the VMs in the
	// node group and await for intended config change to be completed at the node
	// group level. Currently, only the identity config update is supported.
	OperationType string `json:"operationType,omitempty"`
	// Status: Output only. Current operation status.
	Status *ClusterOperationStatus `json:"status,omitempty"`
	// StatusHistory: Output only. The previous operation status.
	StatusHistory []*ClusterOperationStatus `json:"statusHistory,omitempty"`
	// Warnings: Output only. Errors encountered during operation execution.
	Warnings []string `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterUuid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterUuid") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeGroupOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod NodeGroupOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodeInitializationAction: Specifies an executable to run on a fully
// configured node and a timeout period for executable completion.
type NodeInitializationAction struct {
	// ExecutableFile: Required. Cloud Storage URI of executable file.
	ExecutableFile string `json:"executableFile,omitempty"`
	// ExecutionTimeout: Optional. Amount of time executable has to complete.
	// Default is 10 minutes (see JSON representation of Duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).Cluster
	// creation fails with an explanatory error message (the name of the executable
	// that caused the error and the exceeded timeout period) if the executable is
	// not completed at end of the timeout period.
	ExecutionTimeout string `json:"executionTimeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecutableFile") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutableFile") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodeInitializationAction) MarshalJSON() ([]byte, error) {
	type NoMethod NodeInitializationAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NodePool: indicating a list of workers of same type
type NodePool struct {
	// Id: Required. A unique id of the node pool. Primary and Secondary workers
	// can be specified using special reserved ids PRIMARY_WORKER_POOL and
	// SECONDARY_WORKER_POOL respectively. Aux node pools can be referenced using
	// corresponding pool id.
	Id string `json:"id,omitempty"`
	// InstanceNames: Name of instances to be repaired. These instances must belong
	// to specified node pool.
	InstanceNames []string `json:"instanceNames,omitempty"`
	// RepairAction: Required. Repair action to take on specified resources of the
	// node pool.
	//
	// Possible values:
	//   "REPAIR_ACTION_UNSPECIFIED" - No action will be taken by default.
	//   "DELETE" - delete the specified list of nodes.
	RepairAction string `json:"repairAction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NodePool) MarshalJSON() ([]byte, error) {
	type NoMethod NodePool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is the
// result of a network API call.
type Operation struct {
	// Done: If the value is false, it means the operation is still in progress. If
	// true, the operation is completed, and either error or response is available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *Status `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the name
	// should be a resource name ending with operations/{unique_id}.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as Delete, the response is
	// google.protobuf.Empty. If the original method is standard Get/Create/Update,
	// the response should be the resource. For other methods, the response should
	// have the type XxxResponse, where Xxx is the original method name. For
	// example, if the original method name is TakeSnapshot(), the inferred
	// response type is TakeSnapshotResponse.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OrderedJob: A job executed by the workflow.
type OrderedJob struct {
	// FlinkJob: Optional. Job is a Flink job.
	FlinkJob *FlinkJob `json:"flinkJob,omitempty"`
	// HadoopJob: Optional. Job is a Hadoop job.
	HadoopJob *HadoopJob `json:"hadoopJob,omitempty"`
	// HiveJob: Optional. Job is a Hive job.
	HiveJob *HiveJob `json:"hiveJob,omitempty"`
	// Labels: Optional. The labels to associate with this job.Label keys must be
	// between 1 and 63 characters long, and must conform to the following regular
	// expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63
	// characters long, and must conform to the following regular expression:
	// \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a
	// given job.
	Labels map[string]string `json:"labels,omitempty"`
	// PigJob: Optional. Job is a Pig job.
	PigJob *PigJob `json:"pigJob,omitempty"`
	// PrerequisiteStepIds: Optional. The optional list of prerequisite job
	// step_ids. If not specified, the job will start at the beginning of workflow.
	PrerequisiteStepIds []string `json:"prerequisiteStepIds,omitempty"`
	// PrestoJob: Optional. Job is a Presto job.
	PrestoJob *PrestoJob `json:"prestoJob,omitempty"`
	// PysparkJob: Optional. Job is a PySpark job.
	PysparkJob *PySparkJob `json:"pysparkJob,omitempty"`
	// Scheduling: Optional. Job scheduling configuration.
	Scheduling *JobScheduling `json:"scheduling,omitempty"`
	// SparkJob: Optional. Job is a Spark job.
	SparkJob *SparkJob `json:"sparkJob,omitempty"`
	// SparkRJob: Optional. Job is a SparkR job.
	SparkRJob *SparkRJob `json:"sparkRJob,omitempty"`
	// SparkSqlJob: Optional. Job is a SparkSql job.
	SparkSqlJob *SparkSqlJob `json:"sparkSqlJob,omitempty"`
	// StepId: Required. The step id. The id must be unique among all jobs within
	// the template.The step id is used as prefix for job id, as job
	// goog-dataproc-workflow-step-id label, and in prerequisiteStepIds field from
	// other steps.The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). Cannot begin or end with underscore or
	// hyphen. Must consist of between 3 and 50 characters.
	StepId string `json:"stepId,omitempty"`
	// TrinoJob: Optional. Job is a Trino job.
	TrinoJob *TrinoJob `json:"trinoJob,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FlinkJob") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FlinkJob") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OrderedJob) MarshalJSON() ([]byte, error) {
	type NoMethod OrderedJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OutputMetrics: Metrics about the data written by the task.
type OutputMetrics struct {
	BytesWritten   int64 `json:"bytesWritten,omitempty,string"`
	RecordsWritten int64 `json:"recordsWritten,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BytesWritten") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesWritten") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OutputMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod OutputMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type OutputQuantileMetrics struct {
	BytesWritten   *Quantiles `json:"bytesWritten,omitempty"`
	RecordsWritten *Quantiles `json:"recordsWritten,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesWritten") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesWritten") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OutputQuantileMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod OutputQuantileMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ParameterValidation: Configuration for parameter validation.
type ParameterValidation struct {
	// Regex: Validation based on regular expressions.
	Regex *RegexValidation `json:"regex,omitempty"`
	// Values: Validation based on a list of allowed values.
	Values *ValueValidation `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Regex") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Regex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ParameterValidation) MarshalJSON() ([]byte, error) {
	type NoMethod ParameterValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PeripheralsConfig: Auxiliary services configuration for a workload.
type PeripheralsConfig struct {
	// MetastoreService: Optional. Resource name of an existing Dataproc Metastore
	// service.Example:
	// projects/[project_id]/locations/[region]/services/[service_id]
	MetastoreService string `json:"metastoreService,omitempty"`
	// SparkHistoryServerConfig: Optional. The Spark History Server configuration
	// for the workload.
	SparkHistoryServerConfig *SparkHistoryServerConfig `json:"sparkHistoryServerConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MetastoreService") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MetastoreService") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PeripheralsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PeripheralsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PigJob: A Dataproc job for running Apache Pig (https://pig.apache.org/)
// queries on YARN.
type PigJob struct {
	// ContinueOnFailure: Optional. Whether to continue executing queries if a
	// query fails. The default value is false. Setting to true can be useful when
	// executing independent parallel queries.
	ContinueOnFailure bool `json:"continueOnFailure,omitempty"`
	// JarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATH of the
	// Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// LoggingConfig: Optional. The runtime log config for job execution.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// Properties: Optional. A mapping of property names to values, used to
	// configure Pig. Properties that conflict with values set by the Dataproc API
	// might be overwritten. Can include properties set in
	// /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in
	// user code.
	Properties map[string]string `json:"properties,omitempty"`
	// QueryFileUri: The HCFS URI of the script that contains the Pig queries.
	QueryFileUri string `json:"queryFileUri,omitempty"`
	// QueryList: A list of queries.
	QueryList *QueryList `json:"queryList,omitempty"`
	// ScriptVariables: Optional. Mapping of query variable names to values
	// (equivalent to the Pig command: name=[value]).
	ScriptVariables map[string]string `json:"scriptVariables,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContinueOnFailure") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContinueOnFailure") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PigJob) MarshalJSON() ([]byte, error) {
	type NoMethod PigJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources.A Policy is a collection of
// bindings. A binding binds one or more members, or principals, to a single
// role. Principals can be user accounts, service accounts, Google groups, and
// domains (such as G Suite). A role is a named list of permissions; each role
// can be an IAM predefined role or a user-created custom role.For some types
// of Google Cloud resources, a binding can also specify a condition, which is
// a logical expression that allows access to a resource only if the expression
// evaluates to true. A condition can add constraints based on attributes of
// the request, the resource, or both. To learn which resources support
// conditions in their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).JSON
// example: { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } YAML example: bindings: - members: -
// user:mike@example.com - group:admins@example.com - domain:google.com -
// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
// roles/resourcemanager.organizationAdmin - members: - user:eve@example.com
// role: roles/resourcemanager.organizationViewer condition: title: expirable
// access description: Does not grant access after Sep 2020 expression:
// request.time < timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA=
// version: 3 For a description of IAM and its features, see the IAM
// documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// Bindings: Associates a list of members, or principals, with a role.
	// Optionally, may specify a condition that determines how and when the
	// bindings are applied. Each of the bindings must contain at least one
	// principal.The bindings in a Policy can refer to up to 1,500 principals; up
	// to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the bindings grant 50
	// different roles to user:alice@example.com, and not to any other principal,
	// then you can add another 1,450 principals to the bindings in the Policy.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: etag is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the etag in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An etag is returned in the response to getIamPolicy, and systems
	// are expected to put that etag in the request to setIamPolicy to ensure that
	// their change will be applied to the same version of the policy.Important: If
	// you use IAM Conditions, you must include the etag field whenever you call
	// setIamPolicy. If you omit this field, then IAM allows you to overwrite a
	// version 3 policy with a version 1 policy, and all of the conditions in the
	// version 3 policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy.Valid values are 0, 1, and 3.
	// Requests that specify an invalid value are rejected.Any operation that
	// affects conditional role bindings must specify version 3. This requirement
	// applies to the following operations: Getting a policy that includes a
	// conditional role binding Adding a conditional role binding to a policy
	// Changing a conditional role binding in a policy Removing any role binding,
	// with or without a condition, from a policy that includes
	// conditionsImportant: If you use IAM Conditions, you must include the etag
	// field whenever you call setIamPolicy. If you omit this field, then IAM
	// allows you to overwrite a version 3 policy with a version 1 policy, and all
	// of the conditions in the version 3 policy are lost.If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset.To learn which resources support conditions
	// in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Bindings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bindings") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PoolData: Pool Data
type PoolData struct {
	Name     string           `json:"name,omitempty"`
	StageIds googleapi.Int64s `json:"stageIds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PoolData) MarshalJSON() ([]byte, error) {
	type NoMethod PoolData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PrestoJob: A Dataproc job for running Presto (https://prestosql.io/)
// queries. IMPORTANT: The Dataproc Presto Optional Component
// (https://cloud.google.com/dataproc/docs/concepts/components/presto) must be
// enabled when the cluster is created to submit a Presto job to the cluster.
type PrestoJob struct {
	// ClientTags: Optional. Presto client tags to attach to this query
	ClientTags []string `json:"clientTags,omitempty"`
	// ContinueOnFailure: Optional. Whether to continue executing queries if a
	// query fails. The default value is false. Setting to true can be useful when
	// executing independent parallel queries.
	ContinueOnFailure bool `json:"continueOnFailure,omitempty"`
	// LoggingConfig: Optional. The runtime log config for job execution.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// OutputFormat: Optional. The format in which query output will be displayed.
	// See the Presto documentation for supported output formats
	OutputFormat string `json:"outputFormat,omitempty"`
	// Properties: Optional. A mapping of property names to values. Used to set
	// Presto session properties
	// (https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using
	// the --session flag in the Presto CLI
	Properties map[string]string `json:"properties,omitempty"`
	// QueryFileUri: The HCFS URI of the script that contains SQL queries.
	QueryFileUri string `json:"queryFileUri,omitempty"`
	// QueryList: A list of queries.
	QueryList *QueryList `json:"queryList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientTags") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientTags") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PrestoJob) MarshalJSON() ([]byte, error) {
	type NoMethod PrestoJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProcessSummary: Process Summary
type ProcessSummary struct {
	AddTime     string            `json:"addTime,omitempty"`
	HostPort    string            `json:"hostPort,omitempty"`
	IsActive    bool              `json:"isActive,omitempty"`
	ProcessId   string            `json:"processId,omitempty"`
	ProcessLogs map[string]string `json:"processLogs,omitempty"`
	RemoveTime  string            `json:"removeTime,omitempty"`
	TotalCores  int64             `json:"totalCores,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AddTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AddTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProcessSummary) MarshalJSON() ([]byte, error) {
	type NoMethod ProcessSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PropertiesInfo: Properties of the workload organized by origin.
type PropertiesInfo struct {
	// AutotuningProperties: Output only. Properties set by autotuning engine.
	AutotuningProperties map[string]ValueInfo `json:"autotuningProperties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutotuningProperties") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutotuningProperties") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PropertiesInfo) MarshalJSON() ([]byte, error) {
	type NoMethod PropertiesInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ProvisioningModelMix: Defines how Dataproc should create VMs with a mixture
// of provisioning models.
type ProvisioningModelMix struct {
	// StandardCapacityBase: Optional. The base capacity that will always use
	// Standard VMs to avoid risk of more preemption than the minimum capacity you
	// need. Dataproc will create only standard VMs until it reaches
	// standard_capacity_base, then it will start using
	// standard_capacity_percent_above_base to mix Spot with Standard VMs. eg. If
	// 15 instances are requested and standard_capacity_base is 5, Dataproc will
	// create 5 standard VMs and then start mixing spot and standard VMs for
	// remaining 10 instances.
	StandardCapacityBase int64 `json:"standardCapacityBase,omitempty"`
	// StandardCapacityPercentAboveBase: Optional. The percentage of target
	// capacity that should use Standard VM. The remaining percentage will use Spot
	// VMs. The percentage applies only to the capacity above
	// standard_capacity_base. eg. If 15 instances are requested and
	// standard_capacity_base is 5 and standard_capacity_percent_above_base is 30,
	// Dataproc will create 5 standard VMs and then start mixing spot and standard
	// VMs for remaining 10 instances. The mix will be 30% standard and 70% spot.
	StandardCapacityPercentAboveBase int64 `json:"standardCapacityPercentAboveBase,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StandardCapacityBase") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StandardCapacityBase") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ProvisioningModelMix) MarshalJSON() ([]byte, error) {
	type NoMethod ProvisioningModelMix
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PyPiRepositoryConfig: Configuration for PyPi repository
type PyPiRepositoryConfig struct {
	// PypiRepository: Optional. PyPi repository address
	PypiRepository string `json:"pypiRepository,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PypiRepository") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PypiRepository") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PyPiRepositoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PyPiRepositoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PySparkBatch: A configuration for running an Apache PySpark
// (https://spark.apache.org/docs/latest/api/python/getting_started/quickstart.html)
// batch workload.
type PySparkBatch struct {
	// ArchiveUris: Optional. HCFS URIs of archives to be extracted into the
	// working directory of each executor. Supported file types: .jar, .tar,
	// .tar.gz, .tgz, and .zip.
	ArchiveUris []string `json:"archiveUris,omitempty"`
	// Args: Optional. The arguments to pass to the driver. Do not include
	// arguments that can be set as batch properties, such as --conf, since a
	// collision can occur that causes an incorrect batch submission.
	Args []string `json:"args,omitempty"`
	// FileUris: Optional. HCFS URIs of files to be placed in the working directory
	// of each executor.
	FileUris []string `json:"fileUris,omitempty"`
	// JarFileUris: Optional. HCFS URIs of jar files to add to the classpath of the
	// Spark driver and tasks.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// MainPythonFileUri: Required. The HCFS URI of the main Python file to use as
	// the Spark driver. Must be a .py file.
	MainPythonFileUri string `json:"mainPythonFileUri,omitempty"`
	// PythonFileUris: Optional. HCFS file URIs of Python files to pass to the
	// PySpark framework. Supported file types: .py, .egg, and .zip.
	PythonFileUris []string `json:"pythonFileUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PySparkBatch) MarshalJSON() ([]byte, error) {
	type NoMethod PySparkBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PySparkJob: A Dataproc job for running Apache PySpark
// (https://spark.apache.org/docs/latest/api/python/index.html#pyspark-overview)
// applications on YARN.
type PySparkJob struct {
	// ArchiveUris: Optional. HCFS URIs of archives to be extracted into the
	// working directory of each executor. Supported file types: .jar, .tar,
	// .tar.gz, .tgz, and .zip.
	ArchiveUris []string `json:"archiveUris,omitempty"`
	// Args: Optional. The arguments to pass to the driver. Do not include
	// arguments, such as --conf, that can be set as job properties, since a
	// collision may occur that causes an incorrect job submission.
	Args []string `json:"args,omitempty"`
	// FileUris: Optional. HCFS URIs of files to be placed in the working directory
	// of each executor. Useful for naively parallel tasks.
	FileUris []string `json:"fileUris,omitempty"`
	// JarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of
	// the Python driver and tasks.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// LoggingConfig: Optional. The runtime log config for job execution.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// MainPythonFileUri: Required. The HCFS URI of the main Python file to use as
	// the driver. Must be a .py file.
	MainPythonFileUri string `json:"mainPythonFileUri,omitempty"`
	// Properties: Optional. A mapping of property names to values, used to
	// configure PySpark. Properties that conflict with values set by the Dataproc
	// API might be overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `json:"properties,omitempty"`
	// PythonFileUris: Optional. HCFS file URIs of Python files to pass to the
	// PySpark framework. Supported file types: .py, .egg, and .zip.
	PythonFileUris []string `json:"pythonFileUris,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PySparkJob) MarshalJSON() ([]byte, error) {
	type NoMethod PySparkJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Quantiles: Quantile metrics data related to Tasks. Units can be seconds,
// bytes, milliseconds, etc depending on the message type.
type Quantiles struct {
	Count        int64 `json:"count,omitempty,string"`
	Maximum      int64 `json:"maximum,omitempty,string"`
	Minimum      int64 `json:"minimum,omitempty,string"`
	Percentile25 int64 `json:"percentile25,omitempty,string"`
	Percentile50 int64 `json:"percentile50,omitempty,string"`
	Percentile75 int64 `json:"percentile75,omitempty,string"`
	Sum          int64 `json:"sum,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Count") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Quantiles) MarshalJSON() ([]byte, error) {
	type NoMethod Quantiles
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryList: A list of queries to run on a cluster.
type QueryList struct {
	// Queries: Required. The queries to execute. You do not need to end a query
	// expression with a semicolon. Multiple queries can be specified in one string
	// by separating each with a semicolon. Here is an example of a Dataproc API
	// snippet that uses a QueryList to specify a HiveJob: "hiveJob": {
	// "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } }
	Queries []string `json:"queries,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Queries") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Queries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryList) MarshalJSON() ([]byte, error) {
	type NoMethod QueryList
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RddDataDistribution: Details about RDD usage.
type RddDataDistribution struct {
	Address                string `json:"address,omitempty"`
	DiskUsed               int64  `json:"diskUsed,omitempty,string"`
	MemoryRemaining        int64  `json:"memoryRemaining,omitempty,string"`
	MemoryUsed             int64  `json:"memoryUsed,omitempty,string"`
	OffHeapMemoryRemaining int64  `json:"offHeapMemoryRemaining,omitempty,string"`
	OffHeapMemoryUsed      int64  `json:"offHeapMemoryUsed,omitempty,string"`
	OnHeapMemoryRemaining  int64  `json:"onHeapMemoryRemaining,omitempty,string"`
	OnHeapMemoryUsed       int64  `json:"onHeapMemoryUsed,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RddDataDistribution) MarshalJSON() ([]byte, error) {
	type NoMethod RddDataDistribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RddOperationCluster: A grouping of nodes representing higher level
// constructs (stage, job etc.).
type RddOperationCluster struct {
	ChildClusters []*RddOperationCluster `json:"childClusters,omitempty"`
	ChildNodes    []*RddOperationNode    `json:"childNodes,omitempty"`
	Name          string                 `json:"name,omitempty"`
	RddClusterId  string                 `json:"rddClusterId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ChildClusters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ChildClusters") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RddOperationCluster) MarshalJSON() ([]byte, error) {
	type NoMethod RddOperationCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RddOperationEdge: A directed edge representing dependency between two RDDs.
type RddOperationEdge struct {
	FromId int64 `json:"fromId,omitempty"`
	ToId   int64 `json:"toId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FromId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FromId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RddOperationEdge) MarshalJSON() ([]byte, error) {
	type NoMethod RddOperationEdge
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RddOperationGraph: Graph representing RDD dependencies. Consists of edges
// and a root cluster.
type RddOperationGraph struct {
	Edges         []*RddOperationEdge  `json:"edges,omitempty"`
	IncomingEdges []*RddOperationEdge  `json:"incomingEdges,omitempty"`
	OutgoingEdges []*RddOperationEdge  `json:"outgoingEdges,omitempty"`
	RootCluster   *RddOperationCluster `json:"rootCluster,omitempty"`
	StageId       int64                `json:"stageId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Edges") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Edges") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RddOperationGraph) MarshalJSON() ([]byte, error) {
	type NoMethod RddOperationGraph
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RddOperationNode: A node in the RDD operation graph. Corresponds to a single
// RDD.
type RddOperationNode struct {
	Barrier  bool   `json:"barrier,omitempty"`
	Cached   bool   `json:"cached,omitempty"`
	Callsite string `json:"callsite,omitempty"`
	Name     string `json:"name,omitempty"`
	NodeId   int64  `json:"nodeId,omitempty"`
	// Possible values:
	//   "DETERMINISTIC_LEVEL_UNSPECIFIED"
	//   "DETERMINISTIC_LEVEL_DETERMINATE"
	//   "DETERMINISTIC_LEVEL_UNORDERED"
	//   "DETERMINISTIC_LEVEL_INDETERMINATE"
	OutputDeterministicLevel string `json:"outputDeterministicLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Barrier") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Barrier") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RddOperationNode) MarshalJSON() ([]byte, error) {
	type NoMethod RddOperationNode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RddPartitionInfo: Information about RDD partitions.
type RddPartitionInfo struct {
	BlockName    string   `json:"blockName,omitempty"`
	DiskUsed     int64    `json:"diskUsed,omitempty,string"`
	Executors    []string `json:"executors,omitempty"`
	MemoryUsed   int64    `json:"memoryUsed,omitempty,string"`
	StorageLevel string   `json:"storageLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BlockName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BlockName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RddPartitionInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RddPartitionInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RddStorageInfo: Overall data about RDD storage.
type RddStorageInfo struct {
	DataDistribution    []*RddDataDistribution `json:"dataDistribution,omitempty"`
	DiskUsed            int64                  `json:"diskUsed,omitempty,string"`
	MemoryUsed          int64                  `json:"memoryUsed,omitempty,string"`
	Name                string                 `json:"name,omitempty"`
	NumCachedPartitions int64                  `json:"numCachedPartitions,omitempty"`
	NumPartitions       int64                  `json:"numPartitions,omitempty"`
	Partitions          []*RddPartitionInfo    `json:"partitions,omitempty"`
	RddStorageId        int64                  `json:"rddStorageId,omitempty"`
	StorageLevel        string                 `json:"storageLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataDistribution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataDistribution") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RddStorageInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RddStorageInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RegexValidation: Validation based on regular expressions.
type RegexValidation struct {
	// Regexes: Required. RE2 regular expressions used to validate the parameter's
	// value. The value must match the regex in its entirety (substring matches are
	// not sufficient).
	Regexes []string `json:"regexes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Regexes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Regexes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RegexValidation) MarshalJSON() ([]byte, error) {
	type NoMethod RegexValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RepairClusterRequest: A request to repair a cluster.
type RepairClusterRequest struct {
	// Cluster: Optional. Cluster to be repaired
	Cluster *ClusterToRepair `json:"cluster,omitempty"`
	// ClusterUuid: Optional. Specifying the cluster_uuid means the RPC will fail
	// (with error NOT_FOUND) if a cluster with the specified UUID does not exist.
	ClusterUuid string `json:"clusterUuid,omitempty"`
	// GracefulDecommissionTimeout: Optional. Timeout for graceful YARN
	// decommissioning. Graceful decommissioning facilitates the removal of cluster
	// nodes without interrupting jobs in progress. The timeout specifies the
	// amount of time to wait for jobs finish before forcefully removing nodes. The
	// default timeout is 0 for forceful decommissioning, and the maximum timeout
	// period is 1 day. (see JSON Mapping—Duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).graceful_decommission_timeout
	// is supported in Dataproc image versions 1.2+.
	GracefulDecommissionTimeout string `json:"gracefulDecommissionTimeout,omitempty"`
	// NodePools: Optional. Node pools and corresponding repair action to be taken.
	// All node pools should be unique in this request. i.e. Multiple entries for
	// the same node pool id are not allowed.
	NodePools []*NodePool `json:"nodePools,omitempty"`
	// ParentOperationId: Optional. operation id of the parent operation sending
	// the repair request
	ParentOperationId string `json:"parentOperationId,omitempty"`
	// RequestId: Optional. A unique ID used to identify the request. If the server
	// receives two RepairClusterRequests with the same ID, the second request is
	// ignored, and the first google.longrunning.Operation created and stored in
	// the backend is returned.Recommendation: Set this value to a UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
	// (-). The maximum length is 40 characters.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cluster") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cluster") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RepairClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RepairClusterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type RepairNodeGroupRequest struct {
	// InstanceNames: Required. Name of instances to be repaired. These instances
	// must belong to specified node pool.
	InstanceNames []string `json:"instanceNames,omitempty"`
	// RepairAction: Required. Repair action to take on specified resources of the
	// node pool.
	//
	// Possible values:
	//   "REPAIR_ACTION_UNSPECIFIED" - No action will be taken by default.
	//   "REPLACE" - replace the specified list of nodes.
	RepairAction string `json:"repairAction,omitempty"`
	// RequestId: Optional. A unique ID used to identify the request. If the server
	// receives two RepairNodeGroupRequest with the same ID, the second request is
	// ignored and the first google.longrunning.Operation created and stored in the
	// backend is returned.Recommendation: Set this value to a UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
	// (-). The maximum length is 40 characters.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceNames") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceNames") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RepairNodeGroupRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RepairNodeGroupRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RepositoryConfig: Configuration for dependency repositories
type RepositoryConfig struct {
	// PypiRepositoryConfig: Optional. Configuration for PyPi repository.
	PypiRepositoryConfig *PyPiRepositoryConfig `json:"pypiRepositoryConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PypiRepositoryConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PypiRepositoryConfig") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RepositoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RepositoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReservationAffinity: Reservation Affinity for consuming Zonal reservation.
type ReservationAffinity struct {
	// ConsumeReservationType: Optional. Type of reservation to consume
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED"
	//   "NO_RESERVATION" - Do not consume from any allocated capacity.
	//   "ANY_RESERVATION" - Consume any reservation available.
	//   "SPECIFIC_RESERVATION" - Must consume from a specific reservation. Must
	// specify key value fields for specifying the reservations.
	ConsumeReservationType string `json:"consumeReservationType,omitempty"`
	// Key: Optional. Corresponds to the label key of reservation resource.
	Key string `json:"key,omitempty"`
	// Values: Optional. Corresponds to the label values of reservation resource.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsumeReservationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsumeReservationType") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReservationAffinity) MarshalJSON() ([]byte, error) {
	type NoMethod ReservationAffinity
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResizeNodeGroupRequest: A request to resize a node group.
type ResizeNodeGroupRequest struct {
	// GracefulDecommissionTimeout: Optional. Timeout for graceful YARN
	// decommissioning. Graceful decommissioning
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/scaling-clusters#graceful_decommissioning)
	// allows the removal of nodes from the Compute Engine node group without
	// interrupting jobs in progress. This timeout specifies how long to wait for
	// jobs in progress to finish before forcefully removing nodes (and potentially
	// interrupting jobs). Default timeout is 0 (for forceful decommission), and
	// the maximum allowed timeout is 1 day. (see JSON representation of Duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).Only
	// supported on Dataproc image versions 1.2 and higher.
	GracefulDecommissionTimeout string `json:"gracefulDecommissionTimeout,omitempty"`
	// ParentOperationId: Optional. operation id of the parent operation sending
	// the resize request
	ParentOperationId string `json:"parentOperationId,omitempty"`
	// RequestId: Optional. A unique ID used to identify the request. If the server
	// receives two ResizeNodeGroupRequest
	// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.ResizeNodeGroupRequests)
	// with the same ID, the second request is ignored and the first
	// google.longrunning.Operation created and stored in the backend is
	// returned.Recommendation: Set this value to a UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
	// (-). The maximum length is 40 characters.
	RequestId string `json:"requestId,omitempty"`
	// Size: Required. The number of running instances for the node group to
	// maintain. The group adds or removes instances to maintain the number of
	// instances specified by this parameter.
	Size int64 `json:"size,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "GracefulDecommissionTimeout") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GracefulDecommissionTimeout") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResizeNodeGroupRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ResizeNodeGroupRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ResourceInformation struct {
	Addresses []string `json:"addresses,omitempty"`
	Name      string   `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Addresses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Addresses") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceInformation) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceInformation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceProfileInfo: Resource profile that contains information about all
// the resources required by executors and tasks.
type ResourceProfileInfo struct {
	ExecutorResources map[string]ExecutorResourceRequest `json:"executorResources,omitempty"`
	ResourceProfileId int64                              `json:"resourceProfileId,omitempty"`
	TaskResources     map[string]TaskResourceRequest     `json:"taskResources,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecutorResources") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutorResources") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceProfileInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceProfileInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeConfig: Runtime configuration for a workload.
type RuntimeConfig struct {
	// AutotuningConfig: Optional. Autotuning configuration of the workload.
	AutotuningConfig *AutotuningConfig `json:"autotuningConfig,omitempty"`
	// Cohort: Optional. Cohort identifier. Identifies families of the workloads
	// having the same shape, e.g. daily ETL jobs.
	Cohort string `json:"cohort,omitempty"`
	// ContainerImage: Optional. Optional custom container image for the job
	// runtime environment. If not specified, a default container image will be
	// used.
	ContainerImage string `json:"containerImage,omitempty"`
	// Properties: Optional. A mapping of property names to values, which are used
	// to configure workload execution.
	Properties map[string]string `json:"properties,omitempty"`
	// RepositoryConfig: Optional. Dependency repository configuration.
	RepositoryConfig *RepositoryConfig `json:"repositoryConfig,omitempty"`
	// Version: Optional. Version of the batch runtime.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutotuningConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutotuningConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RuntimeInfo: Runtime information about workload execution.
type RuntimeInfo struct {
	// ApproximateUsage: Output only. Approximate workload resource usage,
	// calculated when the workload completes (see Dataproc Serverless pricing
	// (https://cloud.google.com/dataproc-serverless/pricing)).Note: This metric
	// calculation may change in the future, for example, to capture cumulative
	// workload resource consumption during workload execution (see the Dataproc
	// Serverless release notes
	// (https://cloud.google.com/dataproc-serverless/docs/release-notes) for
	// announcements, changes, fixes and other Dataproc developments).
	ApproximateUsage *UsageMetrics `json:"approximateUsage,omitempty"`
	// CurrentUsage: Output only. Snapshot of current workload resource usage.
	CurrentUsage *UsageSnapshot `json:"currentUsage,omitempty"`
	// DiagnosticOutputUri: Output only. A URI pointing to the location of the
	// diagnostics tarball.
	DiagnosticOutputUri string `json:"diagnosticOutputUri,omitempty"`
	// Endpoints: Output only. Map of remote access endpoints (such as web
	// interfaces and APIs) to their URIs.
	Endpoints map[string]string `json:"endpoints,omitempty"`
	// OutputUri: Output only. A URI pointing to the location of the stdout and
	// stderr of the workload.
	OutputUri string `json:"outputUri,omitempty"`
	// PropertiesInfo: Optional. Properties of the workload organized by origin.
	PropertiesInfo *PropertiesInfo `json:"propertiesInfo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApproximateUsage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApproximateUsage") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RuntimeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod RuntimeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSessionSparkApplicationExecutorStageSummaryResponse: List of Executors
// associated with a Spark Application Stage.
type SearchSessionSparkApplicationExecutorStageSummaryResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent
	// SearchSessionSparkApplicationExecutorStageSummaryRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationStageExecutors: Details about executors used by the
	// application stage.
	SparkApplicationStageExecutors []*ExecutorStageSummary `json:"sparkApplicationStageExecutors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSessionSparkApplicationExecutorStageSummaryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSessionSparkApplicationExecutorStageSummaryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSessionSparkApplicationExecutorsResponse: List of Executors associated
// with a Spark Application.
type SearchSessionSparkApplicationExecutorsResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSessionSparkApplicationExecutorsRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationExecutors: Details about executors used by the application.
	SparkApplicationExecutors []*ExecutorSummary `json:"sparkApplicationExecutors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSessionSparkApplicationExecutorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSessionSparkApplicationExecutorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSessionSparkApplicationJobsResponse: A list of Jobs associated with a
// Spark Application.
type SearchSessionSparkApplicationJobsResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSessionSparkApplicationJobsRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationJobs: Output only. Data corresponding to a spark job.
	SparkApplicationJobs []*JobData `json:"sparkApplicationJobs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSessionSparkApplicationJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSessionSparkApplicationJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSessionSparkApplicationSqlQueriesResponse: List of all queries for a
// Spark Application.
type SearchSessionSparkApplicationSqlQueriesResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSessionSparkApplicationSqlQueriesRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationSqlQueries: Output only. SQL Execution Data
	SparkApplicationSqlQueries []*SqlExecutionUiData `json:"sparkApplicationSqlQueries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSessionSparkApplicationSqlQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSessionSparkApplicationSqlQueriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSessionSparkApplicationStageAttemptTasksResponse: List of tasks for a
// stage of a Spark Application
type SearchSessionSparkApplicationStageAttemptTasksResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent
	// SearchSessionSparkApplicationStageAttemptTasksRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationStageAttemptTasks: Output only. Data corresponding to tasks
	// created by spark.
	SparkApplicationStageAttemptTasks []*TaskData `json:"sparkApplicationStageAttemptTasks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSessionSparkApplicationStageAttemptTasksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSessionSparkApplicationStageAttemptTasksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSessionSparkApplicationStageAttemptsResponse: A list of Stage Attempts
// for a Stage of a Spark Application.
type SearchSessionSparkApplicationStageAttemptsResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent
	// SearchSessionSparkApplicationStageAttemptsRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationStageAttempts: Output only. Data corresponding to a stage
	// attempts
	SparkApplicationStageAttempts []*StageData `json:"sparkApplicationStageAttempts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSessionSparkApplicationStageAttemptsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSessionSparkApplicationStageAttemptsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSessionSparkApplicationStagesResponse: A list of stages associated
// with a Spark Application.
type SearchSessionSparkApplicationStagesResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSessionSparkApplicationStages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationStages: Output only. Data corresponding to a stage.
	SparkApplicationStages []*StageData `json:"sparkApplicationStages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSessionSparkApplicationStagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSessionSparkApplicationStagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSessionSparkApplicationsResponse: A list of summary of Spark
// Applications
type SearchSessionSparkApplicationsResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSessionSparkApplicationsRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplications: Output only. High level information corresponding to an
	// application.
	SparkApplications []*SparkApplication `json:"sparkApplications,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSessionSparkApplicationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSessionSparkApplicationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSparkApplicationExecutorStageSummaryResponse: List of Executors
// associated with a Spark Application Stage.
type SearchSparkApplicationExecutorStageSummaryResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSparkApplicationExecutorsListRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationStageExecutors: Details about executors used by the
	// application stage.
	SparkApplicationStageExecutors []*ExecutorStageSummary `json:"sparkApplicationStageExecutors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSparkApplicationExecutorStageSummaryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSparkApplicationExecutorStageSummaryResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSparkApplicationExecutorsResponse: List of Executors associated with a
// Spark Application.
type SearchSparkApplicationExecutorsResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSparkApplicationExecutorsListRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationExecutors: Details about executors used by the application.
	SparkApplicationExecutors []*ExecutorSummary `json:"sparkApplicationExecutors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSparkApplicationExecutorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSparkApplicationExecutorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSparkApplicationJobsResponse: A list of Jobs associated with a Spark
// Application.
type SearchSparkApplicationJobsResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSparkApplicationJobsRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationJobs: Output only. Data corresponding to a spark job.
	SparkApplicationJobs []*JobData `json:"sparkApplicationJobs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSparkApplicationJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSparkApplicationJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSparkApplicationSqlQueriesResponse: List of all queries for a Spark
// Application.
type SearchSparkApplicationSqlQueriesResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSparkApplicationSqlQueriesRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationSqlQueries: Output only. SQL Execution Data
	SparkApplicationSqlQueries []*SqlExecutionUiData `json:"sparkApplicationSqlQueries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSparkApplicationSqlQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSparkApplicationSqlQueriesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSparkApplicationStageAttemptTasksResponse: List of tasks for a stage
// of a Spark Application
type SearchSparkApplicationStageAttemptTasksResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent ListSparkApplicationStageAttemptTasksRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationStageAttemptTasks: Output only. Data corresponding to tasks
	// created by spark.
	SparkApplicationStageAttemptTasks []*TaskData `json:"sparkApplicationStageAttemptTasks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSparkApplicationStageAttemptTasksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSparkApplicationStageAttemptTasksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSparkApplicationStageAttemptsResponse: A list of Stage Attempts for a
// Stage of a Spark Application.
type SearchSparkApplicationStageAttemptsResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent ListSparkApplicationStageAttemptsRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationStageAttempts: Output only. Data corresponding to a stage
	// attempts
	SparkApplicationStageAttempts []*StageData `json:"sparkApplicationStageAttempts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSparkApplicationStageAttemptsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSparkApplicationStageAttemptsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSparkApplicationStagesResponse: A list of stages associated with a
// Spark Application.
type SearchSparkApplicationStagesResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSparkApplicationStages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplicationStages: Output only. Data corresponding to a stage.
	SparkApplicationStages []*StageData `json:"sparkApplicationStages,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSparkApplicationStagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSparkApplicationStagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SearchSparkApplicationsResponse: A list of summary of Spark Applications
type SearchSparkApplicationsResponse struct {
	// NextPageToken: This token is included in the response if there are more
	// results to fetch. To fetch additional results, provide this value as the
	// page_token in a subsequent SearchSparkApplicationsRequest.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// SparkApplications: Output only. High level information corresponding to an
	// application.
	SparkApplications []*SparkApplication `json:"sparkApplications,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SearchSparkApplicationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchSparkApplicationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityConfig: Security related configuration, including encryption,
// Kerberos, etc.
type SecurityConfig struct {
	// IdentityConfig: Optional. Identity related configuration, including service
	// account based secure multi-tenancy user mappings.
	IdentityConfig *IdentityConfig `json:"identityConfig,omitempty"`
	// KerberosConfig: Optional. Kerberos related configuration.
	KerberosConfig *KerberosConfig `json:"kerberosConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IdentityConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IdentityConfig") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Session: A representation of a session.
type Session struct {
	// CreateTime: Output only. The time when the session was created.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. The email address of the user who created the session.
	Creator string `json:"creator,omitempty"`
	// EnvironmentConfig: Optional. Environment configuration for the session
	// execution.
	EnvironmentConfig *EnvironmentConfig `json:"environmentConfig,omitempty"`
	// JupyterSession: Optional. Jupyter session config.
	JupyterSession *JupyterConfig `json:"jupyterSession,omitempty"`
	// Labels: Optional. The labels to associate with the session. Label keys must
	// contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if
	// present, must contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a session.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Identifier. The resource name of the session.
	Name string `json:"name,omitempty"`
	// RuntimeConfig: Optional. Runtime configuration for the session execution.
	RuntimeConfig *RuntimeConfig `json:"runtimeConfig,omitempty"`
	// RuntimeInfo: Output only. Runtime information about session execution.
	RuntimeInfo *RuntimeInfo `json:"runtimeInfo,omitempty"`
	// SessionTemplate: Optional. The session template used by the session.Only
	// resource names, including project ID and location, are valid.Example: *
	// https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_id]
	// *
	// projects/[project_id]/locations/[dataproc_region]/sessionTemplates/[template_
	// id]The template must be in the same project and Dataproc region as the
	// session.
	SessionTemplate string `json:"sessionTemplate,omitempty"`
	// SparkConnectSession: Optional. Spark connect session config.
	SparkConnectSession *SparkConnectConfig `json:"sparkConnectSession,omitempty"`
	// State: Output only. A state of the session.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The session state is unknown.
	//   "CREATING" - The session is created prior to running.
	//   "ACTIVE" - The session is running.
	//   "TERMINATING" - The session is terminating.
	//   "TERMINATED" - The session is terminated successfully.
	//   "FAILED" - The session is no longer running due to an error.
	State string `json:"state,omitempty"`
	// StateHistory: Output only. Historical state information for the session.
	StateHistory []*SessionStateHistory `json:"stateHistory,omitempty"`
	// StateMessage: Output only. Session state details, such as the failure
	// description if the state is FAILED.
	StateMessage string `json:"stateMessage,omitempty"`
	// StateTime: Output only. The time when the session entered the current state.
	StateTime string `json:"stateTime,omitempty"`
	// User: Optional. The email address of the user who owns the session.
	User string `json:"user,omitempty"`
	// Uuid: Output only. A session UUID (Unique Universal Identifier). The service
	// generates this value when it creates the session.
	Uuid string `json:"uuid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Session) MarshalJSON() ([]byte, error) {
	type NoMethod Session
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SessionOperationMetadata: Metadata describing the Session operation.
type SessionOperationMetadata struct {
	// CreateTime: The time when the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// Description: Short description of the operation.
	Description string `json:"description,omitempty"`
	// DoneTime: The time when the operation was finished.
	DoneTime string `json:"doneTime,omitempty"`
	// Labels: Labels associated with the operation.
	Labels map[string]string `json:"labels,omitempty"`
	// OperationType: The operation type.
	//
	// Possible values:
	//   "SESSION_OPERATION_TYPE_UNSPECIFIED" - Session operation type is unknown.
	//   "CREATE" - Create Session operation type.
	//   "TERMINATE" - Terminate Session operation type.
	//   "DELETE" - Delete Session operation type.
	OperationType string `json:"operationType,omitempty"`
	// Session: Name of the session for the operation.
	Session string `json:"session,omitempty"`
	// SessionUuid: Session UUID for the operation.
	SessionUuid string `json:"sessionUuid,omitempty"`
	// Warnings: Warnings encountered during operation execution.
	Warnings []string `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SessionOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod SessionOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SessionStateHistory: Historical state information.
type SessionStateHistory struct {
	// State: Output only. The state of the session at this point in the session
	// history.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The session state is unknown.
	//   "CREATING" - The session is created prior to running.
	//   "ACTIVE" - The session is running.
	//   "TERMINATING" - The session is terminating.
	//   "TERMINATED" - The session is terminated successfully.
	//   "FAILED" - The session is no longer running due to an error.
	State string `json:"state,omitempty"`
	// StateMessage: Output only. Details about the state at this point in the
	// session history.
	StateMessage string `json:"stateMessage,omitempty"`
	// StateStartTime: Output only. The time when the session entered the
	// historical state.
	StateStartTime string `json:"stateStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SessionStateHistory) MarshalJSON() ([]byte, error) {
	type NoMethod SessionStateHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SessionTemplate: A representation of a session template.
type SessionTemplate struct {
	// CreateTime: Output only. The time when the template was created.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. The email address of the user who created the
	// template.
	Creator string `json:"creator,omitempty"`
	// Description: Optional. Brief description of the template.
	Description string `json:"description,omitempty"`
	// EnvironmentConfig: Optional. Environment configuration for session
	// execution.
	EnvironmentConfig *EnvironmentConfig `json:"environmentConfig,omitempty"`
	// JupyterSession: Optional. Jupyter session config.
	JupyterSession *JupyterConfig `json:"jupyterSession,omitempty"`
	// Labels: Optional. Labels to associate with sessions created using this
	// template. Label keys must contain 1 to 63 characters, and must conform to
	// RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values can be empty,
	// but, if present, must contain 1 to 63 characters and conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a session.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Required. Identifier. The resource name of the session template.
	Name string `json:"name,omitempty"`
	// RuntimeConfig: Optional. Runtime configuration for session execution.
	RuntimeConfig *RuntimeConfig `json:"runtimeConfig,omitempty"`
	// SparkConnectSession: Optional. Spark connect session config.
	SparkConnectSession *SparkConnectConfig `json:"sparkConnectSession,omitempty"`
	// UpdateTime: Output only. The time the template was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Uuid: Output only. A session template UUID (Unique Universal Identifier).
	// The service generates this value when it creates the session template.
	Uuid string `json:"uuid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SessionTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod SessionTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for SetIamPolicy method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the resource. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShieldedInstanceConfig: Shielded Instance Config for clusters using Compute
// Engine Shielded VMs
// (https://cloud.google.com/security/shielded-cloud/shielded-vm).
type ShieldedInstanceConfig struct {
	// EnableIntegrityMonitoring: Optional. Defines whether instances have
	// integrity monitoring enabled.
	EnableIntegrityMonitoring bool `json:"enableIntegrityMonitoring,omitempty"`
	// EnableSecureBoot: Optional. Defines whether instances have Secure Boot
	// enabled.
	EnableSecureBoot bool `json:"enableSecureBoot,omitempty"`
	// EnableVtpm: Optional. Defines whether instances have the vTPM enabled.
	EnableVtpm bool `json:"enableVtpm,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnableIntegrityMonitoring")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnableIntegrityMonitoring") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShieldedInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ShieldedInstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShufflePushReadMetrics struct {
	CorruptMergedBlockChunks  int64 `json:"corruptMergedBlockChunks,omitempty,string"`
	LocalMergedBlocksFetched  int64 `json:"localMergedBlocksFetched,omitempty,string"`
	LocalMergedBytesRead      int64 `json:"localMergedBytesRead,omitempty,string"`
	LocalMergedChunksFetched  int64 `json:"localMergedChunksFetched,omitempty,string"`
	MergedFetchFallbackCount  int64 `json:"mergedFetchFallbackCount,omitempty,string"`
	RemoteMergedBlocksFetched int64 `json:"remoteMergedBlocksFetched,omitempty,string"`
	RemoteMergedBytesRead     int64 `json:"remoteMergedBytesRead,omitempty,string"`
	RemoteMergedChunksFetched int64 `json:"remoteMergedChunksFetched,omitempty,string"`
	RemoteMergedReqsDuration  int64 `json:"remoteMergedReqsDuration,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CorruptMergedBlockChunks")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorruptMergedBlockChunks") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShufflePushReadMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ShufflePushReadMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShufflePushReadQuantileMetrics struct {
	CorruptMergedBlockChunks  *Quantiles `json:"corruptMergedBlockChunks,omitempty"`
	LocalMergedBlocksFetched  *Quantiles `json:"localMergedBlocksFetched,omitempty"`
	LocalMergedBytesRead      *Quantiles `json:"localMergedBytesRead,omitempty"`
	LocalMergedChunksFetched  *Quantiles `json:"localMergedChunksFetched,omitempty"`
	MergedFetchFallbackCount  *Quantiles `json:"mergedFetchFallbackCount,omitempty"`
	RemoteMergedBlocksFetched *Quantiles `json:"remoteMergedBlocksFetched,omitempty"`
	RemoteMergedBytesRead     *Quantiles `json:"remoteMergedBytesRead,omitempty"`
	RemoteMergedChunksFetched *Quantiles `json:"remoteMergedChunksFetched,omitempty"`
	RemoteMergedReqsDuration  *Quantiles `json:"remoteMergedReqsDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CorruptMergedBlockChunks")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorruptMergedBlockChunks") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShufflePushReadQuantileMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ShufflePushReadQuantileMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShuffleReadMetrics: Shuffle data read by the task.
type ShuffleReadMetrics struct {
	FetchWaitTimeMillis    int64                   `json:"fetchWaitTimeMillis,omitempty,string"`
	LocalBlocksFetched     int64                   `json:"localBlocksFetched,omitempty,string"`
	LocalBytesRead         int64                   `json:"localBytesRead,omitempty,string"`
	RecordsRead            int64                   `json:"recordsRead,omitempty,string"`
	RemoteBlocksFetched    int64                   `json:"remoteBlocksFetched,omitempty,string"`
	RemoteBytesRead        int64                   `json:"remoteBytesRead,omitempty,string"`
	RemoteBytesReadToDisk  int64                   `json:"remoteBytesReadToDisk,omitempty,string"`
	RemoteReqsDuration     int64                   `json:"remoteReqsDuration,omitempty,string"`
	ShufflePushReadMetrics *ShufflePushReadMetrics `json:"shufflePushReadMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FetchWaitTimeMillis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FetchWaitTimeMillis") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShuffleReadMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ShuffleReadMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShuffleReadQuantileMetrics struct {
	FetchWaitTimeMillis    *Quantiles                      `json:"fetchWaitTimeMillis,omitempty"`
	LocalBlocksFetched     *Quantiles                      `json:"localBlocksFetched,omitempty"`
	ReadBytes              *Quantiles                      `json:"readBytes,omitempty"`
	ReadRecords            *Quantiles                      `json:"readRecords,omitempty"`
	RemoteBlocksFetched    *Quantiles                      `json:"remoteBlocksFetched,omitempty"`
	RemoteBytesRead        *Quantiles                      `json:"remoteBytesRead,omitempty"`
	RemoteBytesReadToDisk  *Quantiles                      `json:"remoteBytesReadToDisk,omitempty"`
	RemoteReqsDuration     *Quantiles                      `json:"remoteReqsDuration,omitempty"`
	ShufflePushReadMetrics *ShufflePushReadQuantileMetrics `json:"shufflePushReadMetrics,omitempty"`
	TotalBlocksFetched     *Quantiles                      `json:"totalBlocksFetched,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FetchWaitTimeMillis") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FetchWaitTimeMillis") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShuffleReadQuantileMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ShuffleReadQuantileMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ShuffleWriteMetrics: Shuffle data written by task.
type ShuffleWriteMetrics struct {
	BytesWritten   int64 `json:"bytesWritten,omitempty,string"`
	RecordsWritten int64 `json:"recordsWritten,omitempty,string"`
	WriteTimeNanos int64 `json:"writeTimeNanos,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BytesWritten") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesWritten") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShuffleWriteMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ShuffleWriteMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ShuffleWriteQuantileMetrics struct {
	WriteBytes     *Quantiles `json:"writeBytes,omitempty"`
	WriteRecords   *Quantiles `json:"writeRecords,omitempty"`
	WriteTimeNanos *Quantiles `json:"writeTimeNanos,omitempty"`
	// ForceSendFields is a list of field names (e.g. "WriteBytes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WriteBytes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ShuffleWriteQuantileMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod ShuffleWriteQuantileMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SinkProgress struct {
	Description   string            `json:"description,omitempty"`
	Metrics       map[string]string `json:"metrics,omitempty"`
	NumOutputRows int64             `json:"numOutputRows,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SinkProgress) MarshalJSON() ([]byte, error) {
	type NoMethod SinkProgress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SoftwareConfig: Specifies the selection and config of software inside the
// cluster.
type SoftwareConfig struct {
	// ImageVersion: Optional. The version of software inside the cluster. It must
	// be one of the supported Dataproc Versions
	// (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported-dataproc-image-versions),
	// such as "1.2" (including a subminor version, such as "1.2.29"), or the
	// "preview" version
	// (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions).
	// If unspecified, it defaults to the latest Debian version.
	ImageVersion string `json:"imageVersion,omitempty"`
	// OptionalComponents: Optional. The set of components to activate on the
	// cluster.
	//
	// Possible values:
	//   "COMPONENT_UNSPECIFIED" - Unspecified component. Specifying this will
	// cause Cluster creation to fail.
	//   "ANACONDA" - The Anaconda component is no longer supported or applicable
	// to supported Dataproc on Compute Engine image versions
	// (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-version-clusters#supported-dataproc-image-versions).
	// It cannot be activated on clusters created with supported Dataproc on
	// Compute Engine image versions.
	//   "DELTA" - Delta Lake.
	//   "DOCKER" - Docker
	//   "DRUID" - The Druid query engine. (alpha)
	//   "FLINK" - Flink
	//   "HBASE" - HBase. (beta)
	//   "HIVE_WEBHCAT" - The Hive Web HCatalog (the REST service for accessing
	// HCatalog).
	//   "HUDI" - Hudi.
	//   "ICEBERG" - Iceberg.
	//   "JUPYTER" - The Jupyter Notebook.
	//   "PIG" - The Pig component.
	//   "PRESTO" - The Presto query engine.
	//   "TRINO" - The Trino query engine.
	//   "RANGER" - The Ranger service.
	//   "SOLR" - The Solr service.
	//   "ZEPPELIN" - The Zeppelin notebook.
	//   "ZOOKEEPER" - The Zookeeper service.
	//   "JUPYTER_KERNEL_GATEWAY" - The Jupyter Kernel Gateway.
	OptionalComponents []string `json:"optionalComponents,omitempty"`
	// Properties: Optional. The properties to set on daemon config files.Property
	// keys are specified in prefix:property format, for example
	// core:hadoop.tmp.dir. The following are supported prefixes and their
	// mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml
	// distcp: distcp-default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred:
	// mapred-site.xml pig: pig.properties spark: spark-defaults.conf yarn:
	// yarn-site.xmlFor more information, see Cluster properties
	// (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
	Properties map[string]string `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImageVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SoftwareConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SoftwareConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SourceProgress struct {
	Description            string            `json:"description,omitempty"`
	EndOffset              string            `json:"endOffset,omitempty"`
	InputRowsPerSecond     float64           `json:"inputRowsPerSecond,omitempty"`
	LatestOffset           string            `json:"latestOffset,omitempty"`
	Metrics                map[string]string `json:"metrics,omitempty"`
	NumInputRows           int64             `json:"numInputRows,omitempty,string"`
	ProcessedRowsPerSecond float64           `json:"processedRowsPerSecond,omitempty"`
	StartOffset            string            `json:"startOffset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SourceProgress) MarshalJSON() ([]byte, error) {
	type NoMethod SourceProgress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *SourceProgress) UnmarshalJSON(data []byte) error {
	type NoMethod SourceProgress
	var s1 struct {
		InputRowsPerSecond     gensupport.JSONFloat64 `json:"inputRowsPerSecond"`
		ProcessedRowsPerSecond gensupport.JSONFloat64 `json:"processedRowsPerSecond"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.InputRowsPerSecond = float64(s1.InputRowsPerSecond)
	s.ProcessedRowsPerSecond = float64(s1.ProcessedRowsPerSecond)
	return nil
}

// SparkApplication: A summary of Spark Application
type SparkApplication struct {
	// Application: Output only. High level information corresponding to an
	// application.
	Application *ApplicationInfo `json:"application,omitempty"`
	// Name: Identifier. Name of the spark application
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Application") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Application") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkApplication) MarshalJSON() ([]byte, error) {
	type NoMethod SparkApplication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkBatch: A configuration for running an Apache Spark
// (https://spark.apache.org/) batch workload.
type SparkBatch struct {
	// ArchiveUris: Optional. HCFS URIs of archives to be extracted into the
	// working directory of each executor. Supported file types: .jar, .tar,
	// .tar.gz, .tgz, and .zip.
	ArchiveUris []string `json:"archiveUris,omitempty"`
	// Args: Optional. The arguments to pass to the driver. Do not include
	// arguments that can be set as batch properties, such as --conf, since a
	// collision can occur that causes an incorrect batch submission.
	Args []string `json:"args,omitempty"`
	// FileUris: Optional. HCFS URIs of files to be placed in the working directory
	// of each executor.
	FileUris []string `json:"fileUris,omitempty"`
	// JarFileUris: Optional. HCFS URIs of jar files to add to the classpath of the
	// Spark driver and tasks.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// MainClass: Optional. The name of the driver main class. The jar file that
	// contains the class must be in the classpath or specified in jar_file_uris.
	MainClass string `json:"mainClass,omitempty"`
	// MainJarFileUri: Optional. The HCFS URI of the jar file that contains the
	// main class.
	MainJarFileUri string `json:"mainJarFileUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkBatch) MarshalJSON() ([]byte, error) {
	type NoMethod SparkBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkConnectConfig: Spark connect configuration for an interactive session.
type SparkConnectConfig struct {
}

// SparkHistoryServerConfig: Spark History Server configuration for the
// workload.
type SparkHistoryServerConfig struct {
	// DataprocCluster: Optional. Resource name of an existing Dataproc Cluster to
	// act as a Spark History Server for the workload.Example:
	// projects/[project_id]/regions/[region]/clusters/[cluster_name]
	DataprocCluster string `json:"dataprocCluster,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataprocCluster") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataprocCluster") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkHistoryServerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SparkHistoryServerConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkJob: A Dataproc job for running Apache Spark
// (https://spark.apache.org/) applications on YARN.
type SparkJob struct {
	// ArchiveUris: Optional. HCFS URIs of archives to be extracted into the
	// working directory of each executor. Supported file types: .jar, .tar,
	// .tar.gz, .tgz, and .zip.
	ArchiveUris []string `json:"archiveUris,omitempty"`
	// Args: Optional. The arguments to pass to the driver. Do not include
	// arguments, such as --conf, that can be set as job properties, since a
	// collision may occur that causes an incorrect job submission.
	Args []string `json:"args,omitempty"`
	// FileUris: Optional. HCFS URIs of files to be placed in the working directory
	// of each executor. Useful for naively parallel tasks.
	FileUris []string `json:"fileUris,omitempty"`
	// JarFileUris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of
	// the Spark driver and tasks.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// LoggingConfig: Optional. The runtime log config for job execution.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// MainClass: The name of the driver's main class. The jar file that contains
	// the class must be in the default CLASSPATH or specified in
	// SparkJob.jar_file_uris.
	MainClass string `json:"mainClass,omitempty"`
	// MainJarFileUri: The HCFS URI of the jar file that contains the main class.
	MainJarFileUri string `json:"mainJarFileUri,omitempty"`
	// Properties: Optional. A mapping of property names to values, used to
	// configure Spark. Properties that conflict with values set by the Dataproc
	// API might be overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkJob) MarshalJSON() ([]byte, error) {
	type NoMethod SparkJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkPlanGraph: A graph used for storing information of an executionPlan of
// DataFrame.
type SparkPlanGraph struct {
	Edges       []*SparkPlanGraphEdge        `json:"edges,omitempty"`
	ExecutionId int64                        `json:"executionId,omitempty,string"`
	Nodes       []*SparkPlanGraphNodeWrapper `json:"nodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Edges") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Edges") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkPlanGraph) MarshalJSON() ([]byte, error) {
	type NoMethod SparkPlanGraph
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkPlanGraphCluster: Represents a tree of spark plan.
type SparkPlanGraphCluster struct {
	Desc                    string                       `json:"desc,omitempty"`
	Metrics                 []*SqlPlanMetric             `json:"metrics,omitempty"`
	Name                    string                       `json:"name,omitempty"`
	Nodes                   []*SparkPlanGraphNodeWrapper `json:"nodes,omitempty"`
	SparkPlanGraphClusterId int64                        `json:"sparkPlanGraphClusterId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Desc") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Desc") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkPlanGraphCluster) MarshalJSON() ([]byte, error) {
	type NoMethod SparkPlanGraphCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkPlanGraphEdge: Represents a directed edge in the spark plan tree from
// child to parent.
type SparkPlanGraphEdge struct {
	FromId int64 `json:"fromId,omitempty,string"`
	ToId   int64 `json:"toId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "FromId") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FromId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkPlanGraphEdge) MarshalJSON() ([]byte, error) {
	type NoMethod SparkPlanGraphEdge
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkPlanGraphNode: Represents a node in the spark plan tree.
type SparkPlanGraphNode struct {
	Desc                 string           `json:"desc,omitempty"`
	Metrics              []*SqlPlanMetric `json:"metrics,omitempty"`
	Name                 string           `json:"name,omitempty"`
	SparkPlanGraphNodeId int64            `json:"sparkPlanGraphNodeId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Desc") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Desc") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkPlanGraphNode) MarshalJSON() ([]byte, error) {
	type NoMethod SparkPlanGraphNode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkPlanGraphNodeWrapper: Wrapper user to represent either a node or a
// cluster.
type SparkPlanGraphNodeWrapper struct {
	Cluster *SparkPlanGraphCluster `json:"cluster,omitempty"`
	Node    *SparkPlanGraphNode    `json:"node,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Cluster") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cluster") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkPlanGraphNodeWrapper) MarshalJSON() ([]byte, error) {
	type NoMethod SparkPlanGraphNodeWrapper
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkRBatch: A configuration for running an Apache SparkR
// (https://spark.apache.org/docs/latest/sparkr.html) batch workload.
type SparkRBatch struct {
	// ArchiveUris: Optional. HCFS URIs of archives to be extracted into the
	// working directory of each executor. Supported file types: .jar, .tar,
	// .tar.gz, .tgz, and .zip.
	ArchiveUris []string `json:"archiveUris,omitempty"`
	// Args: Optional. The arguments to pass to the Spark driver. Do not include
	// arguments that can be set as batch properties, such as --conf, since a
	// collision can occur that causes an incorrect batch submission.
	Args []string `json:"args,omitempty"`
	// FileUris: Optional. HCFS URIs of files to be placed in the working directory
	// of each executor.
	FileUris []string `json:"fileUris,omitempty"`
	// MainRFileUri: Required. The HCFS URI of the main R file to use as the
	// driver. Must be a .R or .r file.
	MainRFileUri string `json:"mainRFileUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkRBatch) MarshalJSON() ([]byte, error) {
	type NoMethod SparkRBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkRJob: A Dataproc job for running Apache SparkR
// (https://spark.apache.org/docs/latest/sparkr.html) applications on YARN.
type SparkRJob struct {
	// ArchiveUris: Optional. HCFS URIs of archives to be extracted into the
	// working directory of each executor. Supported file types: .jar, .tar,
	// .tar.gz, .tgz, and .zip.
	ArchiveUris []string `json:"archiveUris,omitempty"`
	// Args: Optional. The arguments to pass to the driver. Do not include
	// arguments, such as --conf, that can be set as job properties, since a
	// collision may occur that causes an incorrect job submission.
	Args []string `json:"args,omitempty"`
	// FileUris: Optional. HCFS URIs of files to be placed in the working directory
	// of each executor. Useful for naively parallel tasks.
	FileUris []string `json:"fileUris,omitempty"`
	// LoggingConfig: Optional. The runtime log config for job execution.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// MainRFileUri: Required. The HCFS URI of the main R file to use as the
	// driver. Must be a .R file.
	MainRFileUri string `json:"mainRFileUri,omitempty"`
	// Properties: Optional. A mapping of property names to values, used to
	// configure SparkR. Properties that conflict with values set by the Dataproc
	// API might be overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `json:"properties,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArchiveUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkRJob) MarshalJSON() ([]byte, error) {
	type NoMethod SparkRJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SparkRuntimeInfo struct {
	JavaHome     string `json:"javaHome,omitempty"`
	JavaVersion  string `json:"javaVersion,omitempty"`
	ScalaVersion string `json:"scalaVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JavaHome") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JavaHome") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkRuntimeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod SparkRuntimeInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkSqlBatch: A configuration for running Apache Spark SQL
// (https://spark.apache.org/sql/) queries as a batch workload.
type SparkSqlBatch struct {
	// JarFileUris: Optional. HCFS URIs of jar files to be added to the Spark
	// CLASSPATH.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// QueryFileUri: Required. The HCFS URI of the script that contains Spark SQL
	// queries to execute.
	QueryFileUri string `json:"queryFileUri,omitempty"`
	// QueryVariables: Optional. Mapping of query variable names to values
	// (equivalent to the Spark SQL command: SET name="value";).
	QueryVariables map[string]string `json:"queryVariables,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JarFileUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JarFileUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkSqlBatch) MarshalJSON() ([]byte, error) {
	type NoMethod SparkSqlBatch
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkSqlJob: A Dataproc job for running Apache Spark SQL
// (https://spark.apache.org/sql/) queries.
type SparkSqlJob struct {
	// JarFileUris: Optional. HCFS URIs of jar files to be added to the Spark
	// CLASSPATH.
	JarFileUris []string `json:"jarFileUris,omitempty"`
	// LoggingConfig: Optional. The runtime log config for job execution.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// Properties: Optional. A mapping of property names to values, used to
	// configure Spark SQL's SparkConf. Properties that conflict with values set by
	// the Dataproc API might be overwritten.
	Properties map[string]string `json:"properties,omitempty"`
	// QueryFileUri: The HCFS URI of the script that contains SQL queries.
	QueryFileUri string `json:"queryFileUri,omitempty"`
	// QueryList: A list of queries.
	QueryList *QueryList `json:"queryList,omitempty"`
	// ScriptVariables: Optional. Mapping of query variable names to values
	// (equivalent to the Spark SQL command: SET name="value";).
	ScriptVariables map[string]string `json:"scriptVariables,omitempty"`
	// ForceSendFields is a list of field names (e.g. "JarFileUris") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JarFileUris") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkSqlJob) MarshalJSON() ([]byte, error) {
	type NoMethod SparkSqlJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SparkStandaloneAutoscalingConfig: Basic autoscaling configurations for Spark
// Standalone.
type SparkStandaloneAutoscalingConfig struct {
	// GracefulDecommissionTimeout: Required. Timeout for Spark graceful
	// decommissioning of spark workers. Specifies the duration to wait for spark
	// worker to complete spark decommissioning tasks before forcefully removing
	// workers. Only applicable to downscaling operations.Bounds: 0s, 1d.
	GracefulDecommissionTimeout string `json:"gracefulDecommissionTimeout,omitempty"`
	// RemoveOnlyIdleWorkers: Optional. Remove only idle workers when scaling down
	// cluster
	RemoveOnlyIdleWorkers bool `json:"removeOnlyIdleWorkers,omitempty"`
	// ScaleDownFactor: Required. Fraction of required executors to remove from
	// Spark Serverless clusters. A scale-down factor of 1.0 will result in scaling
	// down so that there are no more executors for the Spark Job.(more aggressive
	// scaling). A scale-down factor closer to 0 will result in a smaller magnitude
	// of scaling donw (less aggressive scaling).Bounds: 0.0, 1.0.
	ScaleDownFactor float64 `json:"scaleDownFactor,omitempty"`
	// ScaleDownMinWorkerFraction: Optional. Minimum scale-down threshold as a
	// fraction of total cluster size before scaling occurs. For example, in a
	// 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at
	// least a 2 worker scale-down for the cluster to scale. A threshold of 0 means
	// the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0.
	// Default: 0.0.
	ScaleDownMinWorkerFraction float64 `json:"scaleDownMinWorkerFraction,omitempty"`
	// ScaleUpFactor: Required. Fraction of required workers to add to Spark
	// Standalone clusters. A scale-up factor of 1.0 will result in scaling up so
	// that there are no more required workers for the Spark Job (more aggressive
	// scaling). A scale-up factor closer to 0 will result in a smaller magnitude
	// of scaling up (less aggressive scaling).Bounds: 0.0, 1.0.
	ScaleUpFactor float64 `json:"scaleUpFactor,omitempty"`
	// ScaleUpMinWorkerFraction: Optional. Minimum scale-up threshold as a fraction
	// of total cluster size before scaling occurs. For example, in a 20-worker
	// cluster, a threshold of 0.1 means the autoscaler must recommend at least a
	// 2-worker scale-up for the cluster to scale. A threshold of 0 means the
	// autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0.
	// Default: 0.0.
	ScaleUpMinWorkerFraction float64 `json:"scaleUpMinWorkerFraction,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "GracefulDecommissionTimeout") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GracefulDecommissionTimeout") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkStandaloneAutoscalingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SparkStandaloneAutoscalingConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *SparkStandaloneAutoscalingConfig) UnmarshalJSON(data []byte) error {
	type NoMethod SparkStandaloneAutoscalingConfig
	var s1 struct {
		ScaleDownFactor            gensupport.JSONFloat64 `json:"scaleDownFactor"`
		ScaleDownMinWorkerFraction gensupport.JSONFloat64 `json:"scaleDownMinWorkerFraction"`
		ScaleUpFactor              gensupport.JSONFloat64 `json:"scaleUpFactor"`
		ScaleUpMinWorkerFraction   gensupport.JSONFloat64 `json:"scaleUpMinWorkerFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ScaleDownFactor = float64(s1.ScaleDownFactor)
	s.ScaleDownMinWorkerFraction = float64(s1.ScaleDownMinWorkerFraction)
	s.ScaleUpFactor = float64(s1.ScaleUpFactor)
	s.ScaleUpMinWorkerFraction = float64(s1.ScaleUpMinWorkerFraction)
	return nil
}

// SparkWrapperObject: Outer message that contains the data obtained from spark
// listener, packaged with information that is required to process it.
type SparkWrapperObject struct {
	AppSummary                 *AppSummary                 `json:"appSummary,omitempty"`
	ApplicationEnvironmentInfo *ApplicationEnvironmentInfo `json:"applicationEnvironmentInfo,omitempty"`
	// ApplicationId: Application Id created by Spark.
	ApplicationId   string           `json:"applicationId,omitempty"`
	ApplicationInfo *ApplicationInfo `json:"applicationInfo,omitempty"`
	// EventTimestamp: VM Timestamp associated with the data object.
	EventTimestamp       string                `json:"eventTimestamp,omitempty"`
	ExecutorStageSummary *ExecutorStageSummary `json:"executorStageSummary,omitempty"`
	ExecutorSummary      *ExecutorSummary      `json:"executorSummary,omitempty"`
	JobData              *JobData              `json:"jobData,omitempty"`
	// NativeBuildInfoUiData: Native Build Info
	NativeBuildInfoUiData *NativeBuildInfoUiData `json:"nativeBuildInfoUiData,omitempty"`
	// NativeSqlExecutionUiData: Native SQL Execution Info
	NativeSqlExecutionUiData *NativeSqlExecutionUiData `json:"nativeSqlExecutionUiData,omitempty"`
	PoolData                 *PoolData                 `json:"poolData,omitempty"`
	ProcessSummary           *ProcessSummary           `json:"processSummary,omitempty"`
	RddOperationGraph        *RddOperationGraph        `json:"rddOperationGraph,omitempty"`
	RddStorageInfo           *RddStorageInfo           `json:"rddStorageInfo,omitempty"`
	ResourceProfileInfo      *ResourceProfileInfo      `json:"resourceProfileInfo,omitempty"`
	SparkPlanGraph           *SparkPlanGraph           `json:"sparkPlanGraph,omitempty"`
	SpeculationStageSummary  *SpeculationStageSummary  `json:"speculationStageSummary,omitempty"`
	SqlExecutionUiData       *SqlExecutionUiData       `json:"sqlExecutionUiData,omitempty"`
	StageData                *StageData                `json:"stageData,omitempty"`
	StreamBlockData          *StreamBlockData          `json:"streamBlockData,omitempty"`
	StreamingQueryData       *StreamingQueryData       `json:"streamingQueryData,omitempty"`
	StreamingQueryProgress   *StreamingQueryProgress   `json:"streamingQueryProgress,omitempty"`
	TaskData                 *TaskData                 `json:"taskData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AppSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AppSummary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SparkWrapperObject) MarshalJSON() ([]byte, error) {
	type NoMethod SparkWrapperObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SpeculationStageSummary: Details of the speculation task when speculative
// execution is enabled.
type SpeculationStageSummary struct {
	NumActiveTasks    int64 `json:"numActiveTasks,omitempty"`
	NumCompletedTasks int64 `json:"numCompletedTasks,omitempty"`
	NumFailedTasks    int64 `json:"numFailedTasks,omitempty"`
	NumKilledTasks    int64 `json:"numKilledTasks,omitempty"`
	NumTasks          int64 `json:"numTasks,omitempty"`
	StageAttemptId    int64 `json:"stageAttemptId,omitempty"`
	StageId           int64 `json:"stageId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "NumActiveTasks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NumActiveTasks") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SpeculationStageSummary) MarshalJSON() ([]byte, error) {
	type NoMethod SpeculationStageSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlExecutionUiData: SQL Execution Data
type SqlExecutionUiData struct {
	CompletionTime          string            `json:"completionTime,omitempty"`
	Description             string            `json:"description,omitempty"`
	Details                 string            `json:"details,omitempty"`
	ErrorMessage            string            `json:"errorMessage,omitempty"`
	ExecutionId             int64             `json:"executionId,omitempty,string"`
	Jobs                    map[string]string `json:"jobs,omitempty"`
	MetricValues            map[string]string `json:"metricValues,omitempty"`
	MetricValuesIsNull      bool              `json:"metricValuesIsNull,omitempty"`
	Metrics                 []*SqlPlanMetric  `json:"metrics,omitempty"`
	ModifiedConfigs         map[string]string `json:"modifiedConfigs,omitempty"`
	PhysicalPlanDescription string            `json:"physicalPlanDescription,omitempty"`
	RootExecutionId         int64             `json:"rootExecutionId,omitempty,string"`
	Stages                  googleapi.Int64s  `json:"stages,omitempty"`
	SubmissionTime          string            `json:"submissionTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlExecutionUiData) MarshalJSON() ([]byte, error) {
	type NoMethod SqlExecutionUiData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlPlanMetric: Metrics related to SQL execution.
type SqlPlanMetric struct {
	AccumulatorId int64  `json:"accumulatorId,omitempty,string"`
	MetricType    string `json:"metricType,omitempty"`
	Name          string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccumulatorId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccumulatorId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlPlanMetric) MarshalJSON() ([]byte, error) {
	type NoMethod SqlPlanMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StageAttemptTasksSummary: Data related to tasks summary for a Spark Stage
// Attempt
type StageAttemptTasksSummary struct {
	ApplicationId   string `json:"applicationId,omitempty"`
	NumFailedTasks  int64  `json:"numFailedTasks,omitempty"`
	NumKilledTasks  int64  `json:"numKilledTasks,omitempty"`
	NumPendingTasks int64  `json:"numPendingTasks,omitempty"`
	NumRunningTasks int64  `json:"numRunningTasks,omitempty"`
	NumSuccessTasks int64  `json:"numSuccessTasks,omitempty"`
	NumTasks        int64  `json:"numTasks,omitempty"`
	StageAttemptId  int64  `json:"stageAttemptId,omitempty"`
	StageId         int64  `json:"stageId,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "ApplicationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StageAttemptTasksSummary) MarshalJSON() ([]byte, error) {
	type NoMethod StageAttemptTasksSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StageData: Data corresponding to a stage.
type StageData struct {
	AccumulatorUpdates           []*AccumulableInfo              `json:"accumulatorUpdates,omitempty"`
	CompletionTime               string                          `json:"completionTime,omitempty"`
	Description                  string                          `json:"description,omitempty"`
	Details                      string                          `json:"details,omitempty"`
	ExecutorMetricsDistributions *ExecutorMetricsDistributions   `json:"executorMetricsDistributions,omitempty"`
	ExecutorSummary              map[string]ExecutorStageSummary `json:"executorSummary,omitempty"`
	FailureReason                string                          `json:"failureReason,omitempty"`
	FirstTaskLaunchedTime        string                          `json:"firstTaskLaunchedTime,omitempty"`
	IsShufflePushEnabled         bool                            `json:"isShufflePushEnabled,omitempty"`
	JobIds                       googleapi.Int64s                `json:"jobIds,omitempty"`
	KilledTasksSummary           map[string]int64                `json:"killedTasksSummary,omitempty"`
	Locality                     map[string]string               `json:"locality,omitempty"`
	Name                         string                          `json:"name,omitempty"`
	NumActiveTasks               int64                           `json:"numActiveTasks,omitempty"`
	NumCompleteTasks             int64                           `json:"numCompleteTasks,omitempty"`
	NumCompletedIndices          int64                           `json:"numCompletedIndices,omitempty"`
	NumFailedTasks               int64                           `json:"numFailedTasks,omitempty"`
	NumKilledTasks               int64                           `json:"numKilledTasks,omitempty"`
	NumTasks                     int64                           `json:"numTasks,omitempty"`
	ParentStageIds               googleapi.Int64s                `json:"parentStageIds,omitempty"`
	PeakExecutorMetrics          *ExecutorMetrics                `json:"peakExecutorMetrics,omitempty"`
	RddIds                       googleapi.Int64s                `json:"rddIds,omitempty"`
	ResourceProfileId            int64                           `json:"resourceProfileId,omitempty"`
	SchedulingPool               string                          `json:"schedulingPool,omitempty"`
	ShuffleMergersCount          int64                           `json:"shuffleMergersCount,omitempty"`
	SpeculationSummary           *SpeculationStageSummary        `json:"speculationSummary,omitempty"`
	StageAttemptId               int64                           `json:"stageAttemptId,omitempty"`
	StageId                      int64                           `json:"stageId,omitempty,string"`
	StageMetrics                 *StageMetrics                   `json:"stageMetrics,omitempty"`
	// Possible values:
	//   "STAGE_STATUS_UNSPECIFIED"
	//   "STAGE_STATUS_ACTIVE"
	//   "STAGE_STATUS_COMPLETE"
	//   "STAGE_STATUS_FAILED"
	//   "STAGE_STATUS_PENDING"
	//   "STAGE_STATUS_SKIPPED"
	Status         string `json:"status,omitempty"`
	SubmissionTime string `json:"submissionTime,omitempty"`
	// TaskQuantileMetrics: Summary metrics fields. These are included in response
	// only if present in summary_metrics_mask field in request
	TaskQuantileMetrics *TaskQuantileMetrics `json:"taskQuantileMetrics,omitempty"`
	Tasks               map[string]TaskData  `json:"tasks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccumulatorUpdates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccumulatorUpdates") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StageData) MarshalJSON() ([]byte, error) {
	type NoMethod StageData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StageInputMetrics: Metrics about the input read by the stage.
type StageInputMetrics struct {
	BytesRead   int64 `json:"bytesRead,omitempty,string"`
	RecordsRead int64 `json:"recordsRead,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BytesRead") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesRead") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StageInputMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod StageInputMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StageMetrics: Stage Level Aggregated Metrics
type StageMetrics struct {
	DiskBytesSpilled                int64                     `json:"diskBytesSpilled,omitempty,string"`
	ExecutorCpuTimeNanos            int64                     `json:"executorCpuTimeNanos,omitempty,string"`
	ExecutorDeserializeCpuTimeNanos int64                     `json:"executorDeserializeCpuTimeNanos,omitempty,string"`
	ExecutorDeserializeTimeMillis   int64                     `json:"executorDeserializeTimeMillis,omitempty,string"`
	ExecutorRunTimeMillis           int64                     `json:"executorRunTimeMillis,omitempty,string"`
	JvmGcTimeMillis                 int64                     `json:"jvmGcTimeMillis,omitempty,string"`
	MemoryBytesSpilled              int64                     `json:"memoryBytesSpilled,omitempty,string"`
	PeakExecutionMemoryBytes        int64                     `json:"peakExecutionMemoryBytes,omitempty,string"`
	ResultSerializationTimeMillis   int64                     `json:"resultSerializationTimeMillis,omitempty,string"`
	ResultSize                      int64                     `json:"resultSize,omitempty,string"`
	StageInputMetrics               *StageInputMetrics        `json:"stageInputMetrics,omitempty"`
	StageOutputMetrics              *StageOutputMetrics       `json:"stageOutputMetrics,omitempty"`
	StageShuffleReadMetrics         *StageShuffleReadMetrics  `json:"stageShuffleReadMetrics,omitempty"`
	StageShuffleWriteMetrics        *StageShuffleWriteMetrics `json:"stageShuffleWriteMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiskBytesSpilled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiskBytesSpilled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StageMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod StageMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StageOutputMetrics: Metrics about the output written by the stage.
type StageOutputMetrics struct {
	BytesWritten   int64 `json:"bytesWritten,omitempty,string"`
	RecordsWritten int64 `json:"recordsWritten,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BytesWritten") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesWritten") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StageOutputMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod StageOutputMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type StageShufflePushReadMetrics struct {
	CorruptMergedBlockChunks  int64 `json:"corruptMergedBlockChunks,omitempty,string"`
	LocalMergedBlocksFetched  int64 `json:"localMergedBlocksFetched,omitempty,string"`
	LocalMergedBytesRead      int64 `json:"localMergedBytesRead,omitempty,string"`
	LocalMergedChunksFetched  int64 `json:"localMergedChunksFetched,omitempty,string"`
	MergedFetchFallbackCount  int64 `json:"mergedFetchFallbackCount,omitempty,string"`
	RemoteMergedBlocksFetched int64 `json:"remoteMergedBlocksFetched,omitempty,string"`
	RemoteMergedBytesRead     int64 `json:"remoteMergedBytesRead,omitempty,string"`
	RemoteMergedChunksFetched int64 `json:"remoteMergedChunksFetched,omitempty,string"`
	RemoteMergedReqsDuration  int64 `json:"remoteMergedReqsDuration,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CorruptMergedBlockChunks")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CorruptMergedBlockChunks") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StageShufflePushReadMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod StageShufflePushReadMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StageShuffleReadMetrics: Shuffle data read for the stage.
type StageShuffleReadMetrics struct {
	BytesRead                   int64                        `json:"bytesRead,omitempty,string"`
	FetchWaitTimeMillis         int64                        `json:"fetchWaitTimeMillis,omitempty,string"`
	LocalBlocksFetched          int64                        `json:"localBlocksFetched,omitempty,string"`
	LocalBytesRead              int64                        `json:"localBytesRead,omitempty,string"`
	RecordsRead                 int64                        `json:"recordsRead,omitempty,string"`
	RemoteBlocksFetched         int64                        `json:"remoteBlocksFetched,omitempty,string"`
	RemoteBytesRead             int64                        `json:"remoteBytesRead,omitempty,string"`
	RemoteBytesReadToDisk       int64                        `json:"remoteBytesReadToDisk,omitempty,string"`
	RemoteReqsDuration          int64                        `json:"remoteReqsDuration,omitempty,string"`
	StageShufflePushReadMetrics *StageShufflePushReadMetrics `json:"stageShufflePushReadMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BytesRead") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesRead") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StageShuffleReadMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod StageShuffleReadMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StageShuffleWriteMetrics: Shuffle data written for the stage.
type StageShuffleWriteMetrics struct {
	BytesWritten   int64 `json:"bytesWritten,omitempty,string"`
	RecordsWritten int64 `json:"recordsWritten,omitempty,string"`
	WriteTimeNanos int64 `json:"writeTimeNanos,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "BytesWritten") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BytesWritten") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StageShuffleWriteMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod StageShuffleWriteMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StagesSummary: Data related to Stages page summary
type StagesSummary struct {
	ApplicationId      string `json:"applicationId,omitempty"`
	NumActiveStages    int64  `json:"numActiveStages,omitempty"`
	NumCompletedStages int64  `json:"numCompletedStages,omitempty"`
	NumFailedStages    int64  `json:"numFailedStages,omitempty"`
	NumPendingStages   int64  `json:"numPendingStages,omitempty"`
	NumSkippedStages   int64  `json:"numSkippedStages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StagesSummary) MarshalJSON() ([]byte, error) {
	type NoMethod StagesSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StartClusterRequest: A request to start a cluster.
type StartClusterRequest struct {
	// ClusterUuid: Optional. Specifying the cluster_uuid means the RPC will fail
	// (with error NOT_FOUND) if a cluster with the specified UUID does not exist.
	ClusterUuid string `json:"clusterUuid,omitempty"`
	// RequestId: Optional. A unique ID used to identify the request. If the server
	// receives two StartClusterRequest
	// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.StartClusterRequest)s
	// with the same id, then the second request will be ignored and the first
	// google.longrunning.Operation created and stored in the backend is
	// returned.Recommendation: Set this value to a UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
	// (-). The maximum length is 40 characters.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterUuid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterUuid") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StartClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod StartClusterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StartupConfig: Configuration to handle the startup of instances during
// cluster create and update process.
type StartupConfig struct {
	// RequiredRegistrationFraction: Optional. The config setting to enable cluster
	// creation/ updation to be successful only after
	// required_registration_fraction of instances are up and running. This
	// configuration is applicable to only secondary workers for now. The cluster
	// will fail if required_registration_fraction of instances are not available.
	// This will include instance creation, agent registration, and service
	// registration (if enabled).
	RequiredRegistrationFraction float64 `json:"requiredRegistrationFraction,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "RequiredRegistrationFraction") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequiredRegistrationFraction") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StartupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod StartupConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *StartupConfig) UnmarshalJSON(data []byte) error {
	type NoMethod StartupConfig
	var s1 struct {
		RequiredRegistrationFraction gensupport.JSONFloat64 `json:"requiredRegistrationFraction"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.RequiredRegistrationFraction = float64(s1.RequiredRegistrationFraction)
	return nil
}

// StateHistory: Historical state information.
type StateHistory struct {
	// State: Output only. The state of the batch at this point in history.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The batch state is unknown.
	//   "PENDING" - The batch is created before running.
	//   "RUNNING" - The batch is running.
	//   "CANCELLING" - The batch is cancelling.
	//   "CANCELLED" - The batch cancellation was successful.
	//   "SUCCEEDED" - The batch completed successfully.
	//   "FAILED" - The batch is no longer running due to an error.
	State string `json:"state,omitempty"`
	// StateMessage: Output only. Details about the state at this point in history.
	StateMessage string `json:"stateMessage,omitempty"`
	// StateStartTime: Output only. The time when the batch entered the historical
	// state.
	StateStartTime string `json:"stateStartTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "State") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StateHistory) MarshalJSON() ([]byte, error) {
	type NoMethod StateHistory
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type StateOperatorProgress struct {
	AllRemovalsTimeMs         int64             `json:"allRemovalsTimeMs,omitempty,string"`
	AllUpdatesTimeMs          int64             `json:"allUpdatesTimeMs,omitempty,string"`
	CommitTimeMs              int64             `json:"commitTimeMs,omitempty,string"`
	CustomMetrics             map[string]string `json:"customMetrics,omitempty"`
	MemoryUsedBytes           int64             `json:"memoryUsedBytes,omitempty,string"`
	NumRowsDroppedByWatermark int64             `json:"numRowsDroppedByWatermark,omitempty,string"`
	NumRowsRemoved            int64             `json:"numRowsRemoved,omitempty,string"`
	NumRowsTotal              int64             `json:"numRowsTotal,omitempty,string"`
	NumRowsUpdated            int64             `json:"numRowsUpdated,omitempty,string"`
	NumShufflePartitions      int64             `json:"numShufflePartitions,omitempty,string"`
	NumStateStoreInstances    int64             `json:"numStateStoreInstances,omitempty,string"`
	OperatorName              string            `json:"operatorName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllRemovalsTimeMs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllRemovalsTimeMs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StateOperatorProgress) MarshalJSON() ([]byte, error) {
	type NoMethod StateOperatorProgress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The Status type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each Status message contains three
// pieces of data: error code, error message, and error details.You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StopClusterRequest: A request to stop a cluster.
type StopClusterRequest struct {
	// ClusterUuid: Optional. Specifying the cluster_uuid means the RPC will fail
	// (with error NOT_FOUND) if a cluster with the specified UUID does not exist.
	ClusterUuid string `json:"clusterUuid,omitempty"`
	// RequestId: Optional. A unique ID used to identify the request. If the server
	// receives two StopClusterRequest
	// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.StopClusterRequest)s
	// with the same id, then the second request will be ignored and the first
	// google.longrunning.Operation created and stored in the backend is
	// returned.Recommendation: Set this value to a UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
	// (-). The maximum length is 40 characters.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterUuid") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterUuid") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StopClusterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod StopClusterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StreamBlockData: Stream Block Data.
type StreamBlockData struct {
	Deserialized bool   `json:"deserialized,omitempty"`
	DiskSize     int64  `json:"diskSize,omitempty,string"`
	ExecutorId   string `json:"executorId,omitempty"`
	HostPort     string `json:"hostPort,omitempty"`
	MemSize      int64  `json:"memSize,omitempty,string"`
	Name         string `json:"name,omitempty"`
	StorageLevel string `json:"storageLevel,omitempty"`
	UseDisk      bool   `json:"useDisk,omitempty"`
	UseMemory    bool   `json:"useMemory,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Deserialized") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Deserialized") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StreamBlockData) MarshalJSON() ([]byte, error) {
	type NoMethod StreamBlockData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StreamingQueryData: Streaming
type StreamingQueryData struct {
	EndTimestamp     int64  `json:"endTimestamp,omitempty,string"`
	Exception        string `json:"exception,omitempty"`
	IsActive         bool   `json:"isActive,omitempty"`
	Name             string `json:"name,omitempty"`
	RunId            string `json:"runId,omitempty"`
	StartTimestamp   int64  `json:"startTimestamp,omitempty,string"`
	StreamingQueryId string `json:"streamingQueryId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTimestamp") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTimestamp") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StreamingQueryData) MarshalJSON() ([]byte, error) {
	type NoMethod StreamingQueryData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type StreamingQueryProgress struct {
	BatchDuration            int64                    `json:"batchDuration,omitempty,string"`
	BatchId                  int64                    `json:"batchId,omitempty,string"`
	DurationMillis           map[string]string        `json:"durationMillis,omitempty"`
	EventTime                map[string]string        `json:"eventTime,omitempty"`
	Name                     string                   `json:"name,omitempty"`
	ObservedMetrics          map[string]string        `json:"observedMetrics,omitempty"`
	RunId                    string                   `json:"runId,omitempty"`
	Sink                     *SinkProgress            `json:"sink,omitempty"`
	Sources                  []*SourceProgress        `json:"sources,omitempty"`
	StateOperators           []*StateOperatorProgress `json:"stateOperators,omitempty"`
	StreamingQueryProgressId string                   `json:"streamingQueryProgressId,omitempty"`
	Timestamp                string                   `json:"timestamp,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BatchDuration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BatchDuration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StreamingQueryProgress) MarshalJSON() ([]byte, error) {
	type NoMethod StreamingQueryProgress
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SubmitJobRequest: A request to submit a job.
type SubmitJobRequest struct {
	// Job: Required. The job resource.
	Job *Job `json:"job,omitempty"`
	// RequestId: Optional. A unique id used to identify the request. If the server
	// receives two SubmitJobRequest
	// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.SubmitJobRequest)s
	// with the same id, then the second request will be ignored and the first Job
	// created and stored in the backend is returned.It is recommended to always
	// set this value to a UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The id must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
	// (-). The maximum length is 40 characters.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Job") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Job") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SubmitJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SubmitJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SummarizeSessionSparkApplicationExecutorsResponse: Consolidated summary of
// executors for a Spark Application.
type SummarizeSessionSparkApplicationExecutorsResponse struct {
	// ActiveExecutorSummary: Consolidated summary for active executors.
	ActiveExecutorSummary *ConsolidatedExecutorSummary `json:"activeExecutorSummary,omitempty"`
	// ApplicationId: Spark Application Id
	ApplicationId string `json:"applicationId,omitempty"`
	// DeadExecutorSummary: Consolidated summary for dead executors.
	DeadExecutorSummary *ConsolidatedExecutorSummary `json:"deadExecutorSummary,omitempty"`
	// TotalExecutorSummary: Overall consolidated summary for all executors.
	TotalExecutorSummary *ConsolidatedExecutorSummary `json:"totalExecutorSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveExecutorSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveExecutorSummary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SummarizeSessionSparkApplicationExecutorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SummarizeSessionSparkApplicationExecutorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SummarizeSessionSparkApplicationJobsResponse: Summary of a Spark Application
// jobs.
type SummarizeSessionSparkApplicationJobsResponse struct {
	// JobsSummary: Summary of a Spark Application Jobs
	JobsSummary *JobsSummary `json:"jobsSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "JobsSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobsSummary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SummarizeSessionSparkApplicationJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SummarizeSessionSparkApplicationJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SummarizeSessionSparkApplicationStageAttemptTasksResponse: Summary of tasks
// for a Spark Application stage attempt.
type SummarizeSessionSparkApplicationStageAttemptTasksResponse struct {
	// StageAttemptTasksSummary: Summary of tasks for a Spark Application Stage
	// Attempt
	StageAttemptTasksSummary *StageAttemptTasksSummary `json:"stageAttemptTasksSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "StageAttemptTasksSummary")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StageAttemptTasksSummary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SummarizeSessionSparkApplicationStageAttemptTasksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SummarizeSessionSparkApplicationStageAttemptTasksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SummarizeSessionSparkApplicationStagesResponse: Summary of a Spark
// Application stages.
type SummarizeSessionSparkApplicationStagesResponse struct {
	// StagesSummary: Summary of a Spark Application Stages
	StagesSummary *StagesSummary `json:"stagesSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "StagesSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StagesSummary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SummarizeSessionSparkApplicationStagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SummarizeSessionSparkApplicationStagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SummarizeSparkApplicationExecutorsResponse: Consolidated summary of
// executors for a Spark Application.
type SummarizeSparkApplicationExecutorsResponse struct {
	// ActiveExecutorSummary: Consolidated summary for active executors.
	ActiveExecutorSummary *ConsolidatedExecutorSummary `json:"activeExecutorSummary,omitempty"`
	// ApplicationId: Spark Application Id
	ApplicationId string `json:"applicationId,omitempty"`
	// DeadExecutorSummary: Consolidated summary for dead executors.
	DeadExecutorSummary *ConsolidatedExecutorSummary `json:"deadExecutorSummary,omitempty"`
	// TotalExecutorSummary: Overall consolidated summary for all executors.
	TotalExecutorSummary *ConsolidatedExecutorSummary `json:"totalExecutorSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveExecutorSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveExecutorSummary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SummarizeSparkApplicationExecutorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SummarizeSparkApplicationExecutorsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SummarizeSparkApplicationJobsResponse: Summary of a Spark Application jobs.
type SummarizeSparkApplicationJobsResponse struct {
	// JobsSummary: Summary of a Spark Application Jobs
	JobsSummary *JobsSummary `json:"jobsSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "JobsSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "JobsSummary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SummarizeSparkApplicationJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SummarizeSparkApplicationJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SummarizeSparkApplicationStageAttemptTasksResponse: Summary of tasks for a
// Spark Application stage attempt.
type SummarizeSparkApplicationStageAttemptTasksResponse struct {
	// StageAttemptTasksSummary: Summary of tasks for a Spark Application Stage
	// Attempt
	StageAttemptTasksSummary *StageAttemptTasksSummary `json:"stageAttemptTasksSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "StageAttemptTasksSummary")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StageAttemptTasksSummary") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SummarizeSparkApplicationStageAttemptTasksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SummarizeSparkApplicationStageAttemptTasksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SummarizeSparkApplicationStagesResponse: Summary of a Spark Application
// stages.
type SummarizeSparkApplicationStagesResponse struct {
	// StagesSummary: Summary of a Spark Application Stages
	StagesSummary *StagesSummary `json:"stagesSummary,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "StagesSummary") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StagesSummary") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SummarizeSparkApplicationStagesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SummarizeSparkApplicationStagesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TaskData: Data corresponding to tasks created by spark.
type TaskData struct {
	AccumulatorUpdates      []*AccumulableInfo `json:"accumulatorUpdates,omitempty"`
	Attempt                 int64              `json:"attempt,omitempty"`
	DurationMillis          int64              `json:"durationMillis,omitempty,string"`
	ErrorMessage            string             `json:"errorMessage,omitempty"`
	ExecutorId              string             `json:"executorId,omitempty"`
	ExecutorLogs            map[string]string  `json:"executorLogs,omitempty"`
	GettingResultTimeMillis int64              `json:"gettingResultTimeMillis,omitempty,string"`
	HasMetrics              bool               `json:"hasMetrics,omitempty"`
	Host                    string             `json:"host,omitempty"`
	Index                   int64              `json:"index,omitempty"`
	LaunchTime              string             `json:"launchTime,omitempty"`
	PartitionId             int64              `json:"partitionId,omitempty"`
	ResultFetchStart        string             `json:"resultFetchStart,omitempty"`
	SchedulerDelayMillis    int64              `json:"schedulerDelayMillis,omitempty,string"`
	Speculative             bool               `json:"speculative,omitempty"`
	StageAttemptId          int64              `json:"stageAttemptId,omitempty"`
	StageId                 int64              `json:"stageId,omitempty,string"`
	Status                  string             `json:"status,omitempty"`
	TaskId                  int64              `json:"taskId,omitempty,string"`
	TaskLocality            string             `json:"taskLocality,omitempty"`
	TaskMetrics             *TaskMetrics       `json:"taskMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccumulatorUpdates") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccumulatorUpdates") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TaskData) MarshalJSON() ([]byte, error) {
	type NoMethod TaskData
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TaskMetrics: Executor Task Metrics
type TaskMetrics struct {
	DiskBytesSpilled                int64                `json:"diskBytesSpilled,omitempty,string"`
	ExecutorCpuTimeNanos            int64                `json:"executorCpuTimeNanos,omitempty,string"`
	ExecutorDeserializeCpuTimeNanos int64                `json:"executorDeserializeCpuTimeNanos,omitempty,string"`
	ExecutorDeserializeTimeMillis   int64                `json:"executorDeserializeTimeMillis,omitempty,string"`
	ExecutorRunTimeMillis           int64                `json:"executorRunTimeMillis,omitempty,string"`
	InputMetrics                    *InputMetrics        `json:"inputMetrics,omitempty"`
	JvmGcTimeMillis                 int64                `json:"jvmGcTimeMillis,omitempty,string"`
	MemoryBytesSpilled              int64                `json:"memoryBytesSpilled,omitempty,string"`
	OutputMetrics                   *OutputMetrics       `json:"outputMetrics,omitempty"`
	PeakExecutionMemoryBytes        int64                `json:"peakExecutionMemoryBytes,omitempty,string"`
	ResultSerializationTimeMillis   int64                `json:"resultSerializationTimeMillis,omitempty,string"`
	ResultSize                      int64                `json:"resultSize,omitempty,string"`
	ShuffleReadMetrics              *ShuffleReadMetrics  `json:"shuffleReadMetrics,omitempty"`
	ShuffleWriteMetrics             *ShuffleWriteMetrics `json:"shuffleWriteMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiskBytesSpilled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiskBytesSpilled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TaskMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod TaskMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type TaskQuantileMetrics struct {
	DiskBytesSpilled                *Quantiles                   `json:"diskBytesSpilled,omitempty"`
	DurationMillis                  *Quantiles                   `json:"durationMillis,omitempty"`
	ExecutorCpuTimeNanos            *Quantiles                   `json:"executorCpuTimeNanos,omitempty"`
	ExecutorDeserializeCpuTimeNanos *Quantiles                   `json:"executorDeserializeCpuTimeNanos,omitempty"`
	ExecutorDeserializeTimeMillis   *Quantiles                   `json:"executorDeserializeTimeMillis,omitempty"`
	ExecutorRunTimeMillis           *Quantiles                   `json:"executorRunTimeMillis,omitempty"`
	GettingResultTimeMillis         *Quantiles                   `json:"gettingResultTimeMillis,omitempty"`
	InputMetrics                    *InputQuantileMetrics        `json:"inputMetrics,omitempty"`
	JvmGcTimeMillis                 *Quantiles                   `json:"jvmGcTimeMillis,omitempty"`
	MemoryBytesSpilled              *Quantiles                   `json:"memoryBytesSpilled,omitempty"`
	OutputMetrics                   *OutputQuantileMetrics       `json:"outputMetrics,omitempty"`
	PeakExecutionMemoryBytes        *Quantiles                   `json:"peakExecutionMemoryBytes,omitempty"`
	ResultSerializationTimeMillis   *Quantiles                   `json:"resultSerializationTimeMillis,omitempty"`
	ResultSize                      *Quantiles                   `json:"resultSize,omitempty"`
	SchedulerDelayMillis            *Quantiles                   `json:"schedulerDelayMillis,omitempty"`
	ShuffleReadMetrics              *ShuffleReadQuantileMetrics  `json:"shuffleReadMetrics,omitempty"`
	ShuffleWriteMetrics             *ShuffleWriteQuantileMetrics `json:"shuffleWriteMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiskBytesSpilled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiskBytesSpilled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TaskQuantileMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod TaskQuantileMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TaskResourceRequest: Resources used per task created by the application.
type TaskResourceRequest struct {
	Amount       float64 `json:"amount,omitempty"`
	ResourceName string  `json:"resourceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Amount") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Amount") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TaskResourceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TaskResourceRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *TaskResourceRequest) UnmarshalJSON(data []byte) error {
	type NoMethod TaskResourceRequest
	var s1 struct {
		Amount gensupport.JSONFloat64 `json:"amount"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Amount = float64(s1.Amount)
	return nil
}

// TemplateParameter: A configurable parameter that replaces one or more fields
// in the template. Parameterizable fields: - Labels - File uris - Job
// properties - Job arguments - Script variables - Main class (in HadoopJob and
// SparkJob) - Zone (in ClusterSelector)
type TemplateParameter struct {
	// Description: Optional. Brief description of the parameter. Must not exceed
	// 1024 characters.
	Description string `json:"description,omitempty"`
	// Fields: Required. Paths to all fields that the parameter replaces. A field
	// is allowed to appear in at most one parameter's list of field paths.A field
	// path is similar in syntax to a google.protobuf.FieldMask. For example, a
	// field path that references the zone field of a workflow template's cluster
	// selector would be specified as placement.clusterSelector.zone.Also, field
	// paths can reference fields using the following syntax: Values in maps can be
	// referenced by key: labels'key' placement.clusterSelector.clusterLabels'key'
	// placement.managedCluster.labels'key'
	// placement.clusterSelector.clusterLabels'key' jobs'step-id'.labels'key' Jobs
	// in the jobs list can be referenced by step-id:
	// jobs'step-id'.hadoopJob.mainJarFileUri jobs'step-id'.hiveJob.queryFileUri
	// jobs'step-id'.pySparkJob.mainPythonFileUri
	// jobs'step-id'.hadoopJob.jarFileUris0 jobs'step-id'.hadoopJob.archiveUris0
	// jobs'step-id'.hadoopJob.fileUris0 jobs'step-id'.pySparkJob.pythonFileUris0
	// Items in repeated fields can be referenced by a zero-based index:
	// jobs'step-id'.sparkJob.args0 Other examples:
	// jobs'step-id'.hadoopJob.properties'key' jobs'step-id'.hadoopJob.args0
	// jobs'step-id'.hiveJob.scriptVariables'key'
	// jobs'step-id'.hadoopJob.mainJarFileUri placement.clusterSelector.zoneIt may
	// not be possible to parameterize maps and repeated fields in their entirety
	// since only individual map values and individual items in repeated fields can
	// be referenced. For example, the following field paths are invalid:
	// placement.clusterSelector.clusterLabels jobs'step-id'.sparkJob.args
	Fields []string `json:"fields,omitempty"`
	// Name: Required. Parameter name. The parameter name is used as the key, and
	// paired with the parameter value, which are passed to the template when the
	// template is instantiated. The name must contain only capital letters (A-Z),
	// numbers (0-9), and underscores (_), and must not start with a number. The
	// maximum length is 40 characters.
	Name string `json:"name,omitempty"`
	// Validation: Optional. Validation rules to be applied to this parameter's
	// value.
	Validation *ParameterValidation `json:"validation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TemplateParameter) MarshalJSON() ([]byte, error) {
	type NoMethod TemplateParameter
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TerminateSessionRequest: A request to terminate an interactive session.
type TerminateSessionRequest struct {
	// RequestId: Optional. A unique ID used to identify the request. If the
	// service receives two TerminateSessionRequest
	// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.TerminateSessionRequest)s
	// with the same ID, the second request is ignored.Recommendation: Set this
	// value to a UUID
	// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The value must
	// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
	// (-). The maximum length is 40 characters.
	RequestId string `json:"requestId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RequestId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RequestId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TerminateSessionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TerminateSessionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for TestIamPermissions method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the resource. Permissions
	// with wildcards (such as * or storage.*) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for TestIamPermissions method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of TestPermissionsRequest.permissions that the caller
	// is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TrinoJob: A Dataproc job for running Trino (https://trino.io/) queries.
// IMPORTANT: The Dataproc Trino Optional Component
// (https://cloud.google.com/dataproc/docs/concepts/components/trino) must be
// enabled when the cluster is created to submit a Trino job to the cluster.
type TrinoJob struct {
	// ClientTags: Optional. Trino client tags to attach to this query
	ClientTags []string `json:"clientTags,omitempty"`
	// ContinueOnFailure: Optional. Whether to continue executing queries if a
	// query fails. The default value is false. Setting to true can be useful when
	// executing independent parallel queries.
	ContinueOnFailure bool `json:"continueOnFailure,omitempty"`
	// LoggingConfig: Optional. The runtime log config for job execution.
	LoggingConfig *LoggingConfig `json:"loggingConfig,omitempty"`
	// OutputFormat: Optional. The format in which query output will be displayed.
	// See the Trino documentation for supported output formats
	OutputFormat string `json:"outputFormat,omitempty"`
	// Properties: Optional. A mapping of property names to values. Used to set
	// Trino session properties
	// (https://trino.io/docs/current/sql/set-session.html) Equivalent to using the
	// --session flag in the Trino CLI
	Properties map[string]string `json:"properties,omitempty"`
	// QueryFileUri: The HCFS URI of the script that contains SQL queries.
	QueryFileUri string `json:"queryFileUri,omitempty"`
	// QueryList: A list of queries.
	QueryList *QueryList `json:"queryList,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClientTags") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientTags") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TrinoJob) MarshalJSON() ([]byte, error) {
	type NoMethod TrinoJob
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsageMetrics: Usage metrics represent approximate total resources consumed
// by a workload.
type UsageMetrics struct {
	// AcceleratorType: Optional. Accelerator type being used, if any
	AcceleratorType string `json:"acceleratorType,omitempty"`
	// MilliAcceleratorSeconds: Optional. Accelerator usage in (milliAccelerator x
	// seconds) (see Dataproc Serverless pricing
	// (https://cloud.google.com/dataproc-serverless/pricing)).
	MilliAcceleratorSeconds int64 `json:"milliAcceleratorSeconds,omitempty,string"`
	// MilliDcuSeconds: Optional. DCU (Dataproc Compute Units) usage in (milliDCU x
	// seconds) (see Dataproc Serverless pricing
	// (https://cloud.google.com/dataproc-serverless/pricing)).
	MilliDcuSeconds int64 `json:"milliDcuSeconds,omitempty,string"`
	// MilliSlotSeconds: Optional. Slot usage in (milliSlot x seconds).
	MilliSlotSeconds int64 `json:"milliSlotSeconds,omitempty,string"`
	// ShuffleStorageGbSeconds: Optional. Shuffle storage usage in (GB x seconds)
	// (see Dataproc Serverless pricing
	// (https://cloud.google.com/dataproc-serverless/pricing)).
	ShuffleStorageGbSeconds int64 `json:"shuffleStorageGbSeconds,omitempty,string"`
	// UpdateTime: Optional. The timestamp of the usage metrics.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceleratorType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceleratorType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageMetrics) MarshalJSON() ([]byte, error) {
	type NoMethod UsageMetrics
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsageSnapshot: The usage snapshot represents the resources consumed by a
// workload at a specified time.
type UsageSnapshot struct {
	// AcceleratorType: Optional. Accelerator type being used, if any
	AcceleratorType string `json:"acceleratorType,omitempty"`
	// MilliAccelerator: Optional. Milli (one-thousandth) accelerator. (see
	// Dataproc Serverless pricing
	// (https://cloud.google.com/dataproc-serverless/pricing))
	MilliAccelerator int64 `json:"milliAccelerator,omitempty,string"`
	// MilliDcu: Optional. Milli (one-thousandth) Dataproc Compute Units (DCUs)
	// (see Dataproc Serverless pricing
	// (https://cloud.google.com/dataproc-serverless/pricing)).
	MilliDcu int64 `json:"milliDcu,omitempty,string"`
	// MilliDcuPremium: Optional. Milli (one-thousandth) Dataproc Compute Units
	// (DCUs) charged at premium tier (see Dataproc Serverless pricing
	// (https://cloud.google.com/dataproc-serverless/pricing)).
	MilliDcuPremium int64 `json:"milliDcuPremium,omitempty,string"`
	// MilliSlot: Optional. Milli (one-thousandth) Slot usage of the workload.
	MilliSlot int64 `json:"milliSlot,omitempty,string"`
	// ShuffleStorageGb: Optional. Shuffle Storage in gigabytes (GB). (see Dataproc
	// Serverless pricing (https://cloud.google.com/dataproc-serverless/pricing))
	ShuffleStorageGb int64 `json:"shuffleStorageGb,omitempty,string"`
	// ShuffleStorageGbPremium: Optional. Shuffle Storage in gigabytes (GB) charged
	// at premium tier. (see Dataproc Serverless pricing
	// (https://cloud.google.com/dataproc-serverless/pricing))
	ShuffleStorageGbPremium int64 `json:"shuffleStorageGbPremium,omitempty,string"`
	// SnapshotTime: Optional. The timestamp of the usage snapshot.
	SnapshotTime string `json:"snapshotTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceleratorType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceleratorType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsageSnapshot) MarshalJSON() ([]byte, error) {
	type NoMethod UsageSnapshot
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValueInfo: Annotatated property value.
type ValueInfo struct {
	// Annotation: Annotation, comment or explanation why the property was set.
	Annotation string `json:"annotation,omitempty"`
	// OverriddenValue: Optional. Value which was replaced by the corresponding
	// component.
	OverriddenValue string `json:"overriddenValue,omitempty"`
	// Value: Property value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotation") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValueInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ValueInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ValueValidation: Validation based on a list of allowed values.
type ValueValidation struct {
	// Values: Required. List of allowed values for the parameter.
	Values []string `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ValueValidation) MarshalJSON() ([]byte, error) {
	type NoMethod ValueValidation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VirtualClusterConfig: The Dataproc cluster config for a cluster that does
// not directly control the underlying compute resources, such as a
// Dataproc-on-GKE cluster
// (https://cloud.google.com/dataproc/docs/guides/dpgke/dataproc-gke-overview).
type VirtualClusterConfig struct {
	// AuxiliaryServicesConfig: Optional. Configuration of auxiliary services used
	// by this cluster.
	AuxiliaryServicesConfig *AuxiliaryServicesConfig `json:"auxiliaryServicesConfig,omitempty"`
	// KubernetesClusterConfig: Required. The configuration for running the
	// Dataproc cluster on Kubernetes.
	KubernetesClusterConfig *KubernetesClusterConfig `json:"kubernetesClusterConfig,omitempty"`
	// StagingBucket: Optional. A Cloud Storage bucket used to stage job
	// dependencies, config files, and job driver console output. If you do not
	// specify a staging bucket, Cloud Dataproc will determine a Cloud Storage
	// location (US, ASIA, or EU) for your cluster's staging bucket according to
	// the Compute Engine zone where your cluster is deployed, and then create and
	// manage this project-level, per-location bucket (see Dataproc staging and
	// temp buckets
	// (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)).
	// This field requires a Cloud Storage bucket name, not a gs://... URI to a
	// Cloud Storage bucket.
	StagingBucket string `json:"stagingBucket,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuxiliaryServicesConfig") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuxiliaryServicesConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VirtualClusterConfig) MarshalJSON() ([]byte, error) {
	type NoMethod VirtualClusterConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkflowGraph: The workflow graph.
type WorkflowGraph struct {
	// Nodes: Output only. The workflow nodes.
	Nodes []*WorkflowNode `json:"nodes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Nodes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Nodes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkflowGraph) MarshalJSON() ([]byte, error) {
	type NoMethod WorkflowGraph
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkflowMetadata: A Dataproc workflow template resource.
type WorkflowMetadata struct {
	// ClusterName: Output only. The name of the target cluster.
	ClusterName string `json:"clusterName,omitempty"`
	// ClusterUuid: Output only. The UUID of target cluster.
	ClusterUuid string `json:"clusterUuid,omitempty"`
	// CreateCluster: Output only. The create cluster operation metadata.
	CreateCluster *ClusterOperation `json:"createCluster,omitempty"`
	// DagEndTime: Output only. DAG end time, only set for workflows with
	// dag_timeout when DAG ends.
	DagEndTime string `json:"dagEndTime,omitempty"`
	// DagStartTime: Output only. DAG start time, only set for workflows with
	// dag_timeout when DAG begins.
	DagStartTime string `json:"dagStartTime,omitempty"`
	// DagTimeout: Output only. The timeout duration for the DAG of jobs, expressed
	// in seconds (see JSON representation of duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)).
	DagTimeout string `json:"dagTimeout,omitempty"`
	// DeleteCluster: Output only. The delete cluster operation metadata.
	DeleteCluster *ClusterOperation `json:"deleteCluster,omitempty"`
	// EndTime: Output only. Workflow end time.
	EndTime string `json:"endTime,omitempty"`
	// Graph: Output only. The workflow graph.
	Graph *WorkflowGraph `json:"graph,omitempty"`
	// Parameters: Map from parameter names to values that were used for those
	// parameters.
	Parameters map[string]string `json:"parameters,omitempty"`
	// StartTime: Output only. Workflow start time.
	StartTime string `json:"startTime,omitempty"`
	// State: Output only. The workflow state.
	//
	// Possible values:
	//   "UNKNOWN" - Unused.
	//   "PENDING" - The operation has been created.
	//   "RUNNING" - The operation is running.
	//   "DONE" - The operation is done; either cancelled or completed.
	State string `json:"state,omitempty"`
	// Template: Output only. The resource name of the workflow template as
	// described in https://cloud.google.com/apis/design/resource_names. For
	// projects.regions.workflowTemplates, the resource name of the template has
	// the following format:
	// projects/{project_id}/regions/{region}/workflowTemplates/{template_id} For
	// projects.locations.workflowTemplates, the resource name of the template has
	// the following format:
	// projects/{project_id}/locations/{location}/workflowTemplates/{template_id}
	Template string `json:"template,omitempty"`
	// Version: Output only. The version of template at the time of workflow
	// instantiation.
	Version int64 `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkflowMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod WorkflowMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkflowNode: The workflow node.
type WorkflowNode struct {
	// Error: Output only. The error detail.
	Error string `json:"error,omitempty"`
	// JobId: Output only. The job id; populated after the node enters RUNNING
	// state.
	JobId string `json:"jobId,omitempty"`
	// PrerequisiteStepIds: Output only. Node's prerequisite nodes.
	PrerequisiteStepIds []string `json:"prerequisiteStepIds,omitempty"`
	// State: Output only. The node state.
	//
	// Possible values:
	//   "NODE_STATE_UNSPECIFIED" - State is unspecified.
	//   "BLOCKED" - The node is awaiting prerequisite node to finish.
	//   "RUNNABLE" - The node is runnable but not running.
	//   "RUNNING" - The node is running.
	//   "COMPLETED" - The node completed successfully.
	//   "FAILED" - The node failed. A node can be marked FAILED because its
	// ancestor or peer failed.
	State string `json:"state,omitempty"`
	// StepId: Output only. The name of the node.
	StepId string `json:"stepId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Error") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkflowNode) MarshalJSON() ([]byte, error) {
	type NoMethod WorkflowNode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkflowTemplate: A Dataproc workflow template resource.
type WorkflowTemplate struct {
	// CreateTime: Output only. The time template was created.
	CreateTime string `json:"createTime,omitempty"`
	// DagTimeout: Optional. Timeout duration for the DAG of jobs, expressed in
	// seconds (see JSON representation of duration
	// (https://developers.google.com/protocol-buffers/docs/proto3#json)). The
	// timeout duration must be from 10 minutes ("600s") to 24 hours ("86400s").
	// The timer begins when the first job is submitted. If the workflow is running
	// at the end of the timeout period, any remaining jobs are cancelled, the
	// workflow is ended, and if the workflow was running on a managed cluster, the
	// cluster is deleted.
	DagTimeout string `json:"dagTimeout,omitempty"`
	// EncryptionConfig: Optional. Encryption settings for encrypting workflow
	// template job arguments.
	EncryptionConfig *GoogleCloudDataprocV1WorkflowTemplateEncryptionConfig `json:"encryptionConfig,omitempty"`
	Id               string                                                 `json:"id,omitempty"`
	// Jobs: Required. The Directed Acyclic Graph of Jobs to submit.
	Jobs []*OrderedJob `json:"jobs,omitempty"`
	// Labels: Optional. The labels to associate with this template. These labels
	// will be propagated to all jobs and clusters created by the workflow
	// instance.Label keys must contain 1 to 63 characters, and must conform to RFC
	// 1035 (https://www.ietf.org/rfc/rfc1035.txt).Label values may be empty, but,
	// if present, must contain 1 to 63 characters, and must conform to RFC 1035
	// (https://www.ietf.org/rfc/rfc1035.txt).No more than 32 labels can be
	// associated with a template.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Output only. The resource name of the workflow template, as described
	// in https://cloud.google.com/apis/design/resource_names. For
	// projects.regions.workflowTemplates, the resource name of the template has
	// the following format:
	// projects/{project_id}/regions/{region}/workflowTemplates/{template_id} For
	// projects.locations.workflowTemplates, the resource name of the template has
	// the following format:
	// projects/{project_id}/locations/{location}/workflowTemplates/{template_id}
	Name string `json:"name,omitempty"`
	// Parameters: Optional. Template parameters whose values are substituted into
	// the template. Values for parameters must be provided when the template is
	// instantiated.
	Parameters []*TemplateParameter `json:"parameters,omitempty"`
	// Placement: Required. WorkflowTemplate scheduling information.
	Placement *WorkflowTemplatePlacement `json:"placement,omitempty"`
	// UpdateTime: Output only. The time template was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// Version: Optional. Used to perform a consistent read-modify-write.This field
	// should be left blank for a CreateWorkflowTemplate request. It is required
	// for an UpdateWorkflowTemplate request, and must match the current server
	// version. A typical update template flow would fetch the current template
	// with a GetWorkflowTemplate request, which will return the current template
	// with the version field filled in with the current server version. The user
	// updates other fields in the template, then returns it as part of the
	// UpdateWorkflowTemplate request.
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CreateTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkflowTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod WorkflowTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkflowTemplatePlacement: Specifies workflow execution target.Either
// managed_cluster or cluster_selector is required.
type WorkflowTemplatePlacement struct {
	// ClusterSelector: Optional. A selector that chooses target cluster for jobs
	// based on metadata.The selector is evaluated at the time each job is
	// submitted.
	ClusterSelector *ClusterSelector `json:"clusterSelector,omitempty"`
	// ManagedCluster: A cluster that is managed by the workflow.
	ManagedCluster *ManagedCluster `json:"managedCluster,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ClusterSelector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClusterSelector") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkflowTemplatePlacement) MarshalJSON() ([]byte, error) {
	type NoMethod WorkflowTemplatePlacement
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WriteSessionSparkApplicationContextRequest: Write Spark Application data to
// internal storage systems
type WriteSessionSparkApplicationContextRequest struct {
	// Parent: Required. Parent (Batch) resource reference.
	Parent string `json:"parent,omitempty"`
	// SparkWrapperObjects: Required. The batch of spark application context
	// objects sent for ingestion.
	SparkWrapperObjects []*SparkWrapperObject `json:"sparkWrapperObjects,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WriteSessionSparkApplicationContextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod WriteSessionSparkApplicationContextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WriteSessionSparkApplicationContextResponse: Response returned as an
// acknowledgement of receipt of data.
type WriteSessionSparkApplicationContextResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// WriteSparkApplicationContextRequest: Write Spark Application data to
// internal storage systems
type WriteSparkApplicationContextRequest struct {
	// Parent: Required. Parent (Batch) resource reference.
	Parent              string                `json:"parent,omitempty"`
	SparkWrapperObjects []*SparkWrapperObject `json:"sparkWrapperObjects,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WriteSparkApplicationContextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod WriteSparkApplicationContextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WriteSparkApplicationContextResponse: Response returned as an
// acknowledgement of receipt of data.
type WriteSparkApplicationContextResponse struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// YarnApplication: A YARN application created by a job. Application
// information is a subset of
// org.apache.hadoop.yarn.proto.YarnProtos.ApplicationReportProto.Beta Feature:
// This report is available for testing purposes only. It may be changed before
// final release.
type YarnApplication struct {
	// Name: Required. The application name.
	Name string `json:"name,omitempty"`
	// Progress: Required. The numerical progress of the application, from 1 to
	// 100.
	Progress float64 `json:"progress,omitempty"`
	// State: Required. The application state.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Status is unspecified.
	//   "NEW" - Status is NEW.
	//   "NEW_SAVING" - Status is NEW_SAVING.
	//   "SUBMITTED" - Status is SUBMITTED.
	//   "ACCEPTED" - Status is ACCEPTED.
	//   "RUNNING" - Status is RUNNING.
	//   "FINISHED" - Status is FINISHED.
	//   "FAILED" - Status is FAILED.
	//   "KILLED" - Status is KILLED.
	State string `json:"state,omitempty"`
	// TrackingUrl: Optional. The HTTP URL of the ApplicationMaster, HistoryServer,
	// or TimelineServer that provides application-specific information. The URL
	// uses the internal hostname, and requires a proxy server for resolution and,
	// possibly, access.
	TrackingUrl string `json:"trackingUrl,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s YarnApplication) MarshalJSON() ([]byte, error) {
	type NoMethod YarnApplication
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *YarnApplication) UnmarshalJSON(data []byte) error {
	type NoMethod YarnApplication
	var s1 struct {
		Progress gensupport.JSONFloat64 `json:"progress"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Progress = float64(s1.Progress)
	return nil
}

type ProjectsLocationsAutoscalingPoliciesCreateCall struct {
	s                 *Service
	parent            string
	autoscalingpolicy *AutoscalingPolicy
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates new autoscaling policy.
//
//   - parent: The "resource name" of the region or location, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies.create, the resource name of the
//     region has the following format: projects/{project_id}/regions/{region}
//     For projects.locations.autoscalingPolicies.create, the resource name of
//     the location has the following format:
//     projects/{project_id}/locations/{location}.
func (r *ProjectsLocationsAutoscalingPoliciesService) Create(parent string, autoscalingpolicy *AutoscalingPolicy) *ProjectsLocationsAutoscalingPoliciesCreateCall {
	c := &ProjectsLocationsAutoscalingPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.autoscalingpolicy = autoscalingpolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutoscalingPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutoscalingPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutoscalingPoliciesCreateCall) Context(ctx context.Context) *ProjectsLocationsAutoscalingPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutoscalingPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutoscalingPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.autoscalingpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/autoscalingPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.autoscalingPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AutoscalingPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAutoscalingPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*AutoscalingPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AutoscalingPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutoscalingPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an autoscaling policy. It is an error to delete an
// autoscaling policy that is in use by one or more clusters.
//
//   - name: The "resource name" of the autoscaling policy, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies.delete, the resource name of the
//     policy has the following format:
//     projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id} For
//     projects.locations.autoscalingPolicies.delete, the resource name of the
//     policy has the following format:
//     projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}.
func (r *ProjectsLocationsAutoscalingPoliciesService) Delete(name string) *ProjectsLocationsAutoscalingPoliciesDeleteCall {
	c := &ProjectsLocationsAutoscalingPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutoscalingPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutoscalingPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutoscalingPoliciesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAutoscalingPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutoscalingPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutoscalingPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.autoscalingPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutoscalingPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutoscalingPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves autoscaling policy.
//
//   - name: The "resource name" of the autoscaling policy, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies.get, the resource name of the policy
//     has the following format:
//     projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id} For
//     projects.locations.autoscalingPolicies.get, the resource name of the
//     policy has the following format:
//     projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}.
func (r *ProjectsLocationsAutoscalingPoliciesService) Get(name string) *ProjectsLocationsAutoscalingPoliciesGetCall {
	c := &ProjectsLocationsAutoscalingPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutoscalingPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutoscalingPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAutoscalingPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAutoscalingPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutoscalingPoliciesGetCall) Context(ctx context.Context) *ProjectsLocationsAutoscalingPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutoscalingPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutoscalingPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.autoscalingPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AutoscalingPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAutoscalingPoliciesGetCall) Do(opts ...googleapi.CallOption) (*AutoscalingPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AutoscalingPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAutoscalingPoliciesService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall {
	c := &ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.autoscalingPolicies.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutoscalingPoliciesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutoscalingPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists autoscaling policies in the project.
//
//   - parent: The "resource name" of the region or location, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies.list, the resource name of the region
//     has the following format: projects/{project_id}/regions/{region} For
//     projects.locations.autoscalingPolicies.list, the resource name of the
//     location has the following format:
//     projects/{project_id}/locations/{location}.
func (r *ProjectsLocationsAutoscalingPoliciesService) List(parent string) *ProjectsLocationsAutoscalingPoliciesListCall {
	c := &ProjectsLocationsAutoscalingPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in each response. Must be less than or equal to 1000.
// Defaults to 100.
func (c *ProjectsLocationsAutoscalingPoliciesListCall) PageSize(pageSize int64) *ProjectsLocationsAutoscalingPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token, returned
// by a previous call, to request the next page of results.
func (c *ProjectsLocationsAutoscalingPoliciesListCall) PageToken(pageToken string) *ProjectsLocationsAutoscalingPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutoscalingPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutoscalingPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAutoscalingPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAutoscalingPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutoscalingPoliciesListCall) Context(ctx context.Context) *ProjectsLocationsAutoscalingPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutoscalingPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutoscalingPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/autoscalingPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.autoscalingPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAutoscalingPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAutoscalingPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListAutoscalingPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAutoscalingPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAutoscalingPoliciesListCall) Pages(ctx context.Context, f func(*ListAutoscalingPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
// PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsAutoscalingPoliciesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall {
	c := &ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.autoscalingPolicies.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsAutoscalingPoliciesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsAutoscalingPoliciesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall {
	c := &ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.autoscalingPolicies.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAutoscalingPoliciesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsAutoscalingPoliciesUpdateCall struct {
	s                 *Service
	name              string
	autoscalingpolicy *AutoscalingPolicy
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Update: Updates (replaces) autoscaling policy.Disabled check for
// update_mask, because all updates will be full replacements.
//
//   - name: Output only. The "resource name" of the autoscaling policy, as
//     described in https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies, the resource name of the policy has
//     the following format:
//     projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id} For
//     projects.locations.autoscalingPolicies, the resource name of the policy
//     has the following format:
//     projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}.
func (r *ProjectsLocationsAutoscalingPoliciesService) Update(name string, autoscalingpolicy *AutoscalingPolicy) *ProjectsLocationsAutoscalingPoliciesUpdateCall {
	c := &ProjectsLocationsAutoscalingPoliciesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.autoscalingpolicy = autoscalingpolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAutoscalingPoliciesUpdateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAutoscalingPoliciesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAutoscalingPoliciesUpdateCall) Context(ctx context.Context) *ProjectsLocationsAutoscalingPoliciesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAutoscalingPoliciesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAutoscalingPoliciesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.autoscalingpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.autoscalingPolicies.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *AutoscalingPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAutoscalingPoliciesUpdateCall) Do(opts ...googleapi.CallOption) (*AutoscalingPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AutoscalingPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.autoscalingPolicies.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesAnalyzeCall struct {
	s                   *Service
	name                string
	analyzebatchrequest *AnalyzeBatchRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Analyze: Analyze a Batch for possible recommendations and insights.
//
//   - name: The fully qualified name of the batch to analyze in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID".
func (r *ProjectsLocationsBatchesService) Analyze(name string, analyzebatchrequest *AnalyzeBatchRequest) *ProjectsLocationsBatchesAnalyzeCall {
	c := &ProjectsLocationsBatchesAnalyzeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.analyzebatchrequest = analyzebatchrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesAnalyzeCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesAnalyzeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesAnalyzeCall) Context(ctx context.Context) *ProjectsLocationsBatchesAnalyzeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesAnalyzeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesAnalyzeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.analyzebatchrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:analyze")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.analyze", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.analyze" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesAnalyzeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.analyze", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesCreateCall struct {
	s          *Service
	parent     string
	batch      *Batch
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a batch workload that executes asynchronously.
//
// - parent: The parent resource where this batch will be created.
func (r *ProjectsLocationsBatchesService) Create(parent string, batch *Batch) *ProjectsLocationsBatchesCreateCall {
	c := &ProjectsLocationsBatchesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.batch = batch
	return c
}

// BatchId sets the optional parameter "batchId": The ID to use for the batch,
// which will become the final component of the batch's resource name.This
// value must be 4-63 characters. Valid characters are /[a-z][0-9]-/.
func (c *ProjectsLocationsBatchesCreateCall) BatchId(batchId string) *ProjectsLocationsBatchesCreateCall {
	c.urlParams_.Set("batchId", batchId)
	return c
}

// RequestId sets the optional parameter "requestId": A unique ID used to
// identify the request. If the service receives two CreateBatchRequest
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateBatchRequest)s
// with the same request_id, the second request is ignored and the Operation
// that corresponds to the first Batch created and stored in the backend is
// returned.Recommendation: Set this value to a UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The value must
// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
// (-). The maximum length is 40 characters.
func (c *ProjectsLocationsBatchesCreateCall) RequestId(requestId string) *ProjectsLocationsBatchesCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesCreateCall) Context(ctx context.Context) *ProjectsLocationsBatchesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.batch)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/batches")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the batch workload resource. If the batch is not in a
// CANCELLED, SUCCEEDED or FAILED State, the delete operation fails and the
// response returns FAILED_PRECONDITION.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID".
func (r *ProjectsLocationsBatchesService) Delete(name string) *ProjectsLocationsBatchesDeleteCall {
	c := &ProjectsLocationsBatchesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesDeleteCall) Context(ctx context.Context) *ProjectsLocationsBatchesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the batch workload resource representation.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID".
func (r *ProjectsLocationsBatchesService) Get(name string) *ProjectsLocationsBatchesGetCall {
	c := &ProjectsLocationsBatchesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesGetCall) Context(ctx context.Context) *ProjectsLocationsBatchesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Batch.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesGetCall) Do(opts ...googleapi.CallOption) (*Batch, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Batch{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists batch workloads.
//
// - parent: The parent, which owns this collection of batches.
func (r *ProjectsLocationsBatchesService) List(parent string) *ProjectsLocationsBatchesListCall {
	c := &ProjectsLocationsBatchesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter for the batches to
// return in the response.A filter is a logical expression constraining the
// values of various fields in each batch resource. Filters are case sensitive,
// and may contain multiple clauses combined with logical operators (AND/OR).
// Supported fields are batch_id, batch_uuid, state, create_time, and
// labels.e.g. state = RUNNING and create_time < "2023-01-01T00:00:00Z" filters
// for batches in state RUNNING that were created before 2023-01-01. state =
// RUNNING and labels.environment=production filters for batches in state in a
// RUNNING state that have a production environment label.See
// https://google.aip.dev/assets/misc/ebnf-filtering.txt for a detailed
// description of the filter syntax and a list of supported comparisons.
func (c *ProjectsLocationsBatchesListCall) Filter(filter string) *ProjectsLocationsBatchesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Field(s) on which to sort the
// list of batches.Currently the only supported sort orders are unspecified
// (empty) and create_time desc to sort by most recently created batches
// first.See https://google.aip.dev/132#ordering for more details.
func (c *ProjectsLocationsBatchesListCall) OrderBy(orderBy string) *ProjectsLocationsBatchesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// batches to return in each response. The service may return fewer than this
// value. The default page size is 20; the maximum page size is 1000.
func (c *ProjectsLocationsBatchesListCall) PageSize(pageSize int64) *ProjectsLocationsBatchesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous ListBatches call. Provide this token to retrieve the
// subsequent page.
func (c *ProjectsLocationsBatchesListCall) PageToken(pageToken string) *ProjectsLocationsBatchesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesListCall) Context(ctx context.Context) *ProjectsLocationsBatchesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/batches")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBatchesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsBatchesListCall) Do(opts ...googleapi.CallOption) (*ListBatchesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBatchesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBatchesListCall) Pages(ctx context.Context, f func(*ListBatchesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBatchesSparkApplicationsAccessCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Access: Obtain high level information corresponding to a single Spark
// Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) Access(name string) *ProjectsLocationsBatchesSparkApplicationsAccessCall {
	c := &ProjectsLocationsBatchesSparkApplicationsAccessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsAccessCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsAccessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsAccessCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsAccessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsAccessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:access")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.access", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.access" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSparkApplicationResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessCall) Do(opts ...googleapi.CallOption) (*AccessSparkApplicationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSparkApplicationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.access", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessEnvironmentInfo: Obtain environment details for a Spark Application
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) AccessEnvironmentInfo(name string) *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall {
	c := &ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessEnvironmentInfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessEnvironmentInfo", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.accessEnvironmentInfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSparkApplicationEnvironmentInfoResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessEnvironmentInfoCall) Do(opts ...googleapi.CallOption) (*AccessSparkApplicationEnvironmentInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSparkApplicationEnvironmentInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessEnvironmentInfo", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsAccessJobCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessJob: Obtain data corresponding to a spark job for a Spark Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) AccessJob(name string) *ProjectsLocationsBatchesSparkApplicationsAccessJobCall {
	c := &ProjectsLocationsBatchesSparkApplicationsAccessJobCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// JobId sets the optional parameter "jobId": Required. Job ID to fetch data
// for.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessJobCall) JobId(jobId int64) *ProjectsLocationsBatchesSparkApplicationsAccessJobCall {
	c.urlParams_.Set("jobId", fmt.Sprint(jobId))
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessJobCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsAccessJobCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessJobCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsAccessJobCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessJobCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsAccessJobCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessJobCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsAccessJobCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessJobCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsAccessJobCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessJob")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessJob", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.accessJob" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSparkApplicationJobResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessJobCall) Do(opts ...googleapi.CallOption) (*AccessSparkApplicationJobResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSparkApplicationJobResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessJob", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessSqlPlan: Obtain Spark Plan Graph for a Spark Application SQL
// execution. Limits the number of clusters returned as part of the graph to
// 10000.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) AccessSqlPlan(name string) *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall {
	c := &ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExecutionId sets the optional parameter "executionId": Required. Execution
// ID
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall) ExecutionId(executionId int64) *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall {
	c.urlParams_.Set("executionId", fmt.Sprint(executionId))
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessSqlPlan")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessSqlPlan", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.accessSqlPlan" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSparkApplicationSqlSparkPlanGraphResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlPlanCall) Do(opts ...googleapi.CallOption) (*AccessSparkApplicationSqlSparkPlanGraphResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSparkApplicationSqlSparkPlanGraphResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessSqlPlan", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessSqlQuery: Obtain data corresponding to a particular SQL Query for a
// Spark Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) AccessSqlQuery(name string) *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall {
	c := &ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Details sets the optional parameter "details": Lists/ hides details of Spark
// plan nodes. True is set to list and false to hide.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) Details(details bool) *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("details", fmt.Sprint(details))
	return c
}

// ExecutionId sets the optional parameter "executionId": Required. Execution
// ID
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) ExecutionId(executionId int64) *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("executionId", fmt.Sprint(executionId))
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// PlanDescription sets the optional parameter "planDescription": Enables/
// disables physical plan description on demand
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) PlanDescription(planDescription bool) *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("planDescription", fmt.Sprint(planDescription))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessSqlQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessSqlQuery", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.accessSqlQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSparkApplicationSqlQueryResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessSqlQueryCall) Do(opts ...googleapi.CallOption) (*AccessSparkApplicationSqlQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSparkApplicationSqlQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessSqlQuery", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessStageAttempt: Obtain data corresponding to a spark stage attempt for a
// Spark Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) AccessStageAttempt(name string) *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall {
	c := &ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageAttemptId sets the optional parameter "stageAttemptId": Required. Stage
// Attempt ID
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) StageAttemptId(stageAttemptId int64) *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("stageAttemptId", fmt.Sprint(stageAttemptId))
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) StageId(stageId int64) *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// SummaryMetricsMask sets the optional parameter "summaryMetricsMask": The
// list of summary metrics fields to include. Empty list will default to skip
// all summary metrics fields. Example, if the response should include
// TaskQuantileMetrics, the request should have task_quantile_metrics in
// summary_metrics_mask field
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) SummaryMetricsMask(summaryMetricsMask string) *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("summaryMetricsMask", summaryMetricsMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessStageAttempt")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessStageAttempt", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.accessStageAttempt" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSparkApplicationStageAttemptResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageAttemptCall) Do(opts ...googleapi.CallOption) (*AccessSparkApplicationStageAttemptResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSparkApplicationStageAttemptResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessStageAttempt", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessStageRddGraph: Obtain RDD operation graph for a Spark Application
// Stage. Limits the number of clusters returned as part of the graph to 10000.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) AccessStageRddGraph(name string) *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall {
	c := &ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall) StageId(stageId int64) *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessStageRddGraph")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessStageRddGraph", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.accessStageRddGraph" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSparkApplicationStageRddOperationGraphResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsAccessStageRddGraphCall) Do(opts ...googleapi.CallOption) (*AccessSparkApplicationStageRddOperationGraphResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSparkApplicationStageRddOperationGraphResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.accessStageRddGraph", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsSearchCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Obtain high level information and list of Spark Applications
// corresponding to a batch
//
//   - parent: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) Search(parent string) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// ApplicationStatus sets the optional parameter "applicationStatus": Search
// only applications in the chosen state.
//
// Possible values:
//
//	"APPLICATION_STATUS_UNSPECIFIED"
//	"APPLICATION_STATUS_RUNNING"
//	"APPLICATION_STATUS_COMPLETED"
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) ApplicationStatus(applicationStatus string) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.urlParams_.Set("applicationStatus", applicationStatus)
	return c
}

// MaxEndTime sets the optional parameter "maxEndTime": Latest end timestamp to
// list.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) MaxEndTime(maxEndTime string) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.urlParams_.Set("maxEndTime", maxEndTime)
	return c
}

// MaxTime sets the optional parameter "maxTime": Latest start timestamp to
// list.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) MaxTime(maxTime string) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.urlParams_.Set("maxTime", maxTime)
	return c
}

// MinEndTime sets the optional parameter "minEndTime": Earliest end timestamp
// to list.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) MinEndTime(minEndTime string) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.urlParams_.Set("minEndTime", minEndTime)
	return c
}

// MinTime sets the optional parameter "minTime": Earliest start timestamp to
// list.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) MinTime(minTime string) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.urlParams_.Set("minTime", minTime)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// applications to return in each response. The service may return fewer than
// this. The default page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) PageSize(pageSize int64) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSparkApplications call. Provide this token to retrieve
// the subsequent page.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) PageToken(pageToken string) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sparkApplications:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSparkApplicationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) Do(opts ...googleapi.CallOption) (*SearchSparkApplicationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSparkApplicationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchCall) Pages(ctx context.Context, f func(*SearchSparkApplicationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchExecutorStageSummary: Obtain executor summary with respect to a spark
// stage attempt.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SearchExecutorStageSummary(name string) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of executors
// to return in each response. The service may return fewer than this. The
// default page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) PageSize(pageSize int64) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous AccessSparkApplicationExecutorsList call. Provide this token
// to retrieve the subsequent page.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) PageToken(pageToken string) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageAttemptId sets the optional parameter "stageAttemptId": Required. Stage
// Attempt ID
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) StageAttemptId(stageAttemptId int64) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("stageAttemptId", fmt.Sprint(stageAttemptId))
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) StageId(stageId int64) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchExecutorStageSummary")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchExecutorStageSummary", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.searchExecutorStageSummary" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSparkApplicationExecutorStageSummaryResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) Do(opts ...googleapi.CallOption) (*SearchSparkApplicationExecutorStageSummaryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSparkApplicationExecutorStageSummaryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchExecutorStageSummary", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorStageSummaryCall) Pages(ctx context.Context, f func(*SearchSparkApplicationExecutorStageSummaryResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchExecutors: Obtain data corresponding to executors for a Spark
// Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SearchExecutors(name string) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExecutorStatus sets the optional parameter "executorStatus": Filter to
// select whether active/ dead or all executors should be selected.
//
// Possible values:
//
//	"EXECUTOR_STATUS_UNSPECIFIED"
//	"EXECUTOR_STATUS_ACTIVE"
//	"EXECUTOR_STATUS_DEAD"
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) ExecutorStatus(executorStatus string) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("executorStatus", executorStatus)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of executors
// to return in each response. The service may return fewer than this. The
// default page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) PageSize(pageSize int64) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous AccessSparkApplicationExecutorsList call. Provide this token
// to retrieve the subsequent page.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) PageToken(pageToken string) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchExecutors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchExecutors", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.searchExecutors" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSparkApplicationExecutorsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) Do(opts ...googleapi.CallOption) (*SearchSparkApplicationExecutorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSparkApplicationExecutorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchExecutors", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchExecutorsCall) Pages(ctx context.Context, f func(*SearchSparkApplicationExecutorsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBatchesSparkApplicationsSearchJobsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchJobs: Obtain list of spark jobs corresponding to a Spark Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SearchJobs(name string) *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSearchJobsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// JobStatus sets the optional parameter "jobStatus": List only jobs in the
// specific state.
//
// Possible values:
//
//	"JOB_EXECUTION_STATUS_UNSPECIFIED"
//	"JOB_EXECUTION_STATUS_RUNNING"
//	"JOB_EXECUTION_STATUS_SUCCEEDED"
//	"JOB_EXECUTION_STATUS_FAILED"
//	"JOB_EXECUTION_STATUS_UNKNOWN"
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) JobStatus(jobStatus string) *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("jobStatus", jobStatus)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of jobs to
// return in each response. The service may return fewer than this. The default
// page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) PageSize(pageSize int64) *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSparkApplicationJobs call. Provide this token to
// retrieve the subsequent page.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) PageToken(pageToken string) *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchJobs", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.searchJobs" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSparkApplicationJobsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) Do(opts ...googleapi.CallOption) (*SearchSparkApplicationJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSparkApplicationJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchJobs", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchJobsCall) Pages(ctx context.Context, f func(*SearchSparkApplicationJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchSqlQueries: Obtain data corresponding to SQL Queries for a Spark
// Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SearchSqlQueries(name string) *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Details sets the optional parameter "details": Lists/ hides details of Spark
// plan nodes. True is set to list and false to hide.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) Details(details bool) *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("details", fmt.Sprint(details))
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of queries
// to return in each response. The service may return fewer than this. The
// default page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) PageSize(pageSize int64) *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSparkApplicationSqlQueries call. Provide this token to
// retrieve the subsequent page.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) PageToken(pageToken string) *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// PlanDescription sets the optional parameter "planDescription": Enables/
// disables physical plan description on demand
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) PlanDescription(planDescription bool) *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("planDescription", fmt.Sprint(planDescription))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchSqlQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchSqlQueries", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.searchSqlQueries" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSparkApplicationSqlQueriesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) Do(opts ...googleapi.CallOption) (*SearchSparkApplicationSqlQueriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSparkApplicationSqlQueriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchSqlQueries", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchSqlQueriesCall) Pages(ctx context.Context, f func(*SearchSparkApplicationSqlQueriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchStageAttemptTasks: Obtain data corresponding to tasks for a spark
// stage attempt for a Spark Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SearchStageAttemptTasks(name string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of tasks to
// return in each response. The service may return fewer than this. The default
// page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) PageSize(pageSize int64) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous ListSparkApplicationStageAttemptTasks call. Provide this
// token to retrieve the subsequent page.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) PageToken(pageToken string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// SortRuntime sets the optional parameter "sortRuntime": Sort the tasks by
// runtime.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) SortRuntime(sortRuntime bool) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("sortRuntime", fmt.Sprint(sortRuntime))
	return c
}

// StageAttemptId sets the optional parameter "stageAttemptId": Stage Attempt
// ID
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) StageAttemptId(stageAttemptId int64) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("stageAttemptId", fmt.Sprint(stageAttemptId))
	return c
}

// StageId sets the optional parameter "stageId": Stage ID
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) StageId(stageId int64) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// TaskStatus sets the optional parameter "taskStatus": List only tasks in the
// state.
//
// Possible values:
//
//	"TASK_STATUS_UNSPECIFIED"
//	"TASK_STATUS_RUNNING"
//	"TASK_STATUS_SUCCESS"
//	"TASK_STATUS_FAILED"
//	"TASK_STATUS_KILLED"
//	"TASK_STATUS_PENDING"
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) TaskStatus(taskStatus string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("taskStatus", taskStatus)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchStageAttemptTasks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchStageAttemptTasks", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.searchStageAttemptTasks" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSparkApplicationStageAttemptTasksResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) Do(opts ...googleapi.CallOption) (*SearchSparkApplicationStageAttemptTasksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSparkApplicationStageAttemptTasksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchStageAttemptTasks", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptTasksCall) Pages(ctx context.Context, f func(*SearchSparkApplicationStageAttemptTasksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchStageAttempts: Obtain data corresponding to a spark stage attempts for
// a Spark Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SearchStageAttempts(name string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of stage
// attempts (paging based on stage_attempt_id) to return in each response. The
// service may return fewer than this. The default page size is 10; the maximum
// page size is 100.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) PageSize(pageSize int64) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSparkApplicationStageAttempts call. Provide this token
// to retrieve the subsequent page.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) PageToken(pageToken string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID for which
// attempts are to be fetched
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) StageId(stageId int64) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// SummaryMetricsMask sets the optional parameter "summaryMetricsMask": The
// list of summary metrics fields to include. Empty list will default to skip
// all summary metrics fields. Example, if the response should include
// TaskQuantileMetrics, the request should have task_quantile_metrics in
// summary_metrics_mask field
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) SummaryMetricsMask(summaryMetricsMask string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("summaryMetricsMask", summaryMetricsMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchStageAttempts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchStageAttempts", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.searchStageAttempts" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSparkApplicationStageAttemptsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) Do(opts ...googleapi.CallOption) (*SearchSparkApplicationStageAttemptsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSparkApplicationStageAttemptsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchStageAttempts", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStageAttemptsCall) Pages(ctx context.Context, f func(*SearchSparkApplicationStageAttemptsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBatchesSparkApplicationsSearchStagesCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchStages: Obtain data corresponding to stages for a Spark Application.
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SearchStages(name string) *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSearchStagesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of stages
// (paging based on stage_id) to return in each response. The service may
// return fewer than this. The default page size is 10; the maximum page size
// is 100.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) PageSize(pageSize int64) *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous FetchSparkApplicationStagesList call. Provide this token to
// retrieve the subsequent page.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) PageToken(pageToken string) *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageStatus sets the optional parameter "stageStatus": List only stages in
// the given state.
//
// Possible values:
//
//	"STAGE_STATUS_UNSPECIFIED"
//	"STAGE_STATUS_ACTIVE"
//	"STAGE_STATUS_COMPLETE"
//	"STAGE_STATUS_FAILED"
//	"STAGE_STATUS_PENDING"
//	"STAGE_STATUS_SKIPPED"
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) StageStatus(stageStatus string) *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("stageStatus", stageStatus)
	return c
}

// SummaryMetricsMask sets the optional parameter "summaryMetricsMask": The
// list of summary metrics fields to include. Empty list will default to skip
// all summary metrics fields. Example, if the response should include
// TaskQuantileMetrics, the request should have task_quantile_metrics in
// summary_metrics_mask field
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) SummaryMetricsMask(summaryMetricsMask string) *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("summaryMetricsMask", summaryMetricsMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchStages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchStages", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.searchStages" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSparkApplicationStagesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) Do(opts ...googleapi.CallOption) (*SearchSparkApplicationStagesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSparkApplicationStagesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.searchStages", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsBatchesSparkApplicationsSearchStagesCall) Pages(ctx context.Context, f func(*SearchSparkApplicationStagesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SummarizeExecutors: Obtain summary of Executor Summary for a Spark
// Application
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SummarizeExecutors(name string) *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:summarizeExecutors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.summarizeExecutors", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.summarizeExecutors" call.
// Any non-2xx status code is an error. Response headers are in either
// *SummarizeSparkApplicationExecutorsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeExecutorsCall) Do(opts ...googleapi.CallOption) (*SummarizeSparkApplicationExecutorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SummarizeSparkApplicationExecutorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.summarizeExecutors", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SummarizeJobs: Obtain summary of Jobs for a Spark Application
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SummarizeJobs(name string) *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:summarizeJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.summarizeJobs", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.summarizeJobs" call.
// Any non-2xx status code is an error. Response headers are in either
// *SummarizeSparkApplicationJobsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeJobsCall) Do(opts ...googleapi.CallOption) (*SummarizeSparkApplicationJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SummarizeSparkApplicationJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.summarizeJobs", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SummarizeStageAttemptTasks: Obtain summary of Tasks for a Spark Application
// Stage Attempt
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SummarizeStageAttemptTasks(name string) *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageAttemptId sets the optional parameter "stageAttemptId": Required. Stage
// Attempt ID
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall) StageAttemptId(stageAttemptId int64) *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall {
	c.urlParams_.Set("stageAttemptId", fmt.Sprint(stageAttemptId))
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall) StageId(stageId int64) *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:summarizeStageAttemptTasks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.summarizeStageAttemptTasks", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.summarizeStageAttemptTasks" call.
// Any non-2xx status code is an error. Response headers are in either
// *SummarizeSparkApplicationStageAttemptTasksResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStageAttemptTasksCall) Do(opts ...googleapi.CallOption) (*SummarizeSparkApplicationStageAttemptTasksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SummarizeSparkApplicationStageAttemptTasksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.summarizeStageAttemptTasks", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SummarizeStages: Obtain summary of Stages for a Spark Application
//
//   - name: The fully qualified name of the batch to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) SummarizeStages(name string) *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall {
	c := &ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Batch)
// resource reference.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall) Parent(parent string) *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall) IfNoneMatch(entityTag string) *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:summarizeStages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.summarizeStages", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.summarizeStages" call.
// Any non-2xx status code is an error. Response headers are in either
// *SummarizeSparkApplicationStagesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsSummarizeStagesCall) Do(opts ...googleapi.CallOption) (*SummarizeSparkApplicationStagesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SummarizeSparkApplicationStagesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.summarizeStages", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBatchesSparkApplicationsWriteCall struct {
	s                                   *Service
	name                                string
	writesparkapplicationcontextrequest *WriteSparkApplicationContextRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// Write: Write wrapper objects from dataplane to spanner
//
//   - name: The fully qualified name of the spark application to write data
//     about in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/batches/BATCH_ID/sparkApplic
//     ations/APPLICATION_ID".
func (r *ProjectsLocationsBatchesSparkApplicationsService) Write(name string, writesparkapplicationcontextrequest *WriteSparkApplicationContextRequest) *ProjectsLocationsBatchesSparkApplicationsWriteCall {
	c := &ProjectsLocationsBatchesSparkApplicationsWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.writesparkapplicationcontextrequest = writesparkapplicationcontextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBatchesSparkApplicationsWriteCall) Fields(s ...googleapi.Field) *ProjectsLocationsBatchesSparkApplicationsWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBatchesSparkApplicationsWriteCall) Context(ctx context.Context) *ProjectsLocationsBatchesSparkApplicationsWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBatchesSparkApplicationsWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBatchesSparkApplicationsWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.writesparkapplicationcontextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.write", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.batches.sparkApplications.write" call.
// Any non-2xx status code is an error. Response headers are in either
// *WriteSparkApplicationContextResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBatchesSparkApplicationsWriteCall) Do(opts ...googleapi.CallOption) (*WriteSparkApplicationContextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WriteSparkApplicationContextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.batches.sparkApplications.write", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsCancelCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Starts asynchronous cancellation on a long-running operation. The
// server makes a best effort to cancel the operation, but success is not
// guaranteed. If the server doesn't support this method, it returns
// google.rpc.Code.UNIMPLEMENTED. Clients can use Operations.GetOperation or
// other methods to check whether the cancellation succeeded or whether the
// operation completed despite cancellation. On successful cancellation, the
// operation is not deleted; instead, it becomes an operation with an
// Operation.error value with a google.rpc.Status.code of 1, corresponding to
// Code.CANCELLED.
//
// - name: The name of the operation resource to be cancelled.
func (r *ProjectsLocationsOperationsService) Cancel(name string) *ProjectsLocationsOperationsCancelCall {
	c := &ProjectsLocationsOperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsCancelCall) Context(ctx context.Context) *ProjectsLocationsOperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.operations.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// google.rpc.Code.UNIMPLEMENTED.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns UNIMPLEMENTED.
//
// - name: The name of the operation's parent resource.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": The standard list filter.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard list page
// size.
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard list page
// token.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListOperationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*ListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*ListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionTemplatesCreateCall struct {
	s               *Service
	parent          string
	sessiontemplate *SessionTemplate
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Create: Create a session template synchronously.
//
// - parent: The parent resource where this session template will be created.
func (r *ProjectsLocationsSessionTemplatesService) Create(parent string, sessiontemplate *SessionTemplate) *ProjectsLocationsSessionTemplatesCreateCall {
	c := &ProjectsLocationsSessionTemplatesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.sessiontemplate = sessiontemplate
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionTemplatesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionTemplatesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionTemplatesCreateCall) Context(ctx context.Context) *ProjectsLocationsSessionTemplatesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionTemplatesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionTemplatesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.sessiontemplate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sessionTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessionTemplates.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *SessionTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsSessionTemplatesCreateCall) Do(opts ...googleapi.CallOption) (*SessionTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SessionTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionTemplatesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a session template.
//
// - name: The name of the session template resource to delete.
func (r *ProjectsLocationsSessionTemplatesService) Delete(name string) *ProjectsLocationsSessionTemplatesDeleteCall {
	c := &ProjectsLocationsSessionTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionTemplatesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionTemplatesDeleteCall) Context(ctx context.Context) *ProjectsLocationsSessionTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessionTemplates.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the resource representation for a session template.
//
// - name: The name of the session template to retrieve.
func (r *ProjectsLocationsSessionTemplatesService) Get(name string) *ProjectsLocationsSessionTemplatesGetCall {
	c := &ProjectsLocationsSessionTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionTemplatesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionTemplatesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionTemplatesGetCall) Context(ctx context.Context) *ProjectsLocationsSessionTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessionTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *SessionTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsSessionTemplatesGetCall) Do(opts ...googleapi.CallOption) (*SessionTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SessionTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionTemplatesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists session templates.
//
// - parent: The parent that owns this collection of session templates.
func (r *ProjectsLocationsSessionTemplatesService) List(parent string) *ProjectsLocationsSessionTemplatesListCall {
	c := &ProjectsLocationsSessionTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter for the session
// templates to return in the response. Filters are case sensitive and have the
// following syntax:field = value AND field = value ...
func (c *ProjectsLocationsSessionTemplatesListCall) Filter(filter string) *ProjectsLocationsSessionTemplatesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// sessions to return in each response. The service may return fewer than this
// value.
func (c *ProjectsLocationsSessionTemplatesListCall) PageSize(pageSize int64) *ProjectsLocationsSessionTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous ListSessions call. Provide this token to retrieve the
// subsequent page.
func (c *ProjectsLocationsSessionTemplatesListCall) PageToken(pageToken string) *ProjectsLocationsSessionTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionTemplatesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionTemplatesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionTemplatesListCall) Context(ctx context.Context) *ProjectsLocationsSessionTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sessionTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessionTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSessionTemplatesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionTemplatesListCall) Do(opts ...googleapi.CallOption) (*ListSessionTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSessionTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionTemplatesListCall) Pages(ctx context.Context, f func(*ListSessionTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionTemplatesPatchCall struct {
	s               *Service
	name            string
	sessiontemplate *SessionTemplate
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Patch: Updates the session template synchronously.
//
// - name: Identifier. The resource name of the session template.
func (r *ProjectsLocationsSessionTemplatesService) Patch(name string, sessiontemplate *SessionTemplate) *ProjectsLocationsSessionTemplatesPatchCall {
	c := &ProjectsLocationsSessionTemplatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.sessiontemplate = sessiontemplate
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionTemplatesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionTemplatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionTemplatesPatchCall) Context(ctx context.Context) *ProjectsLocationsSessionTemplatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionTemplatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionTemplatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.sessiontemplate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessionTemplates.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *SessionTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsSessionTemplatesPatchCall) Do(opts ...googleapi.CallOption) (*SessionTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SessionTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessionTemplates.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsCreateCall struct {
	s          *Service
	parent     string
	session    *Session
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create an interactive session asynchronously.
//
// - parent: The parent resource where this session will be created.
func (r *ProjectsLocationsSessionsService) Create(parent string, session *Session) *ProjectsLocationsSessionsCreateCall {
	c := &ProjectsLocationsSessionsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.session = session
	return c
}

// RequestId sets the optional parameter "requestId": A unique ID used to
// identify the request. If the service receives two CreateSessionRequests
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateSessionRequest)s
// with the same ID, the second request is ignored, and the first Session is
// created and stored in the backend.Recommendation: Set this value to a UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The value must
// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
// (-). The maximum length is 40 characters.
func (c *ProjectsLocationsSessionsCreateCall) RequestId(requestId string) *ProjectsLocationsSessionsCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// SessionId sets the optional parameter "sessionId": Required. The ID to use
// for the session, which becomes the final component of the session's resource
// name.This value must be 4-63 characters. Valid characters are /a-z-/.
func (c *ProjectsLocationsSessionsCreateCall) SessionId(sessionId string) *ProjectsLocationsSessionsCreateCall {
	c.urlParams_.Set("sessionId", sessionId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsCreateCall) Context(ctx context.Context) *ProjectsLocationsSessionsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.session)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sessions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the interactive session resource. If the session is not in
// terminal state, it is terminated, and then deleted.
//
// - name: The name of the session resource to delete.
func (r *ProjectsLocationsSessionsService) Delete(name string) *ProjectsLocationsSessionsDeleteCall {
	c := &ProjectsLocationsSessionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// RequestId sets the optional parameter "requestId": A unique ID used to
// identify the request. If the service receives two DeleteSessionRequest
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.DeleteSessionRequest)s
// with the same ID, the second request is ignored.Recommendation: Set this
// value to a UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The value must
// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
// (-). The maximum length is 40 characters.
func (c *ProjectsLocationsSessionsDeleteCall) RequestId(requestId string) *ProjectsLocationsSessionsDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsSessionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the resource representation for an interactive session.
//
// - name: The name of the session to retrieve.
func (r *ProjectsLocationsSessionsService) Get(name string) *ProjectsLocationsSessionsGetCall {
	c := &ProjectsLocationsSessionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsGetCall) Context(ctx context.Context) *ProjectsLocationsSessionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Session.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsGetCall) Do(opts ...googleapi.CallOption) (*Session, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Session{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists interactive sessions.
//
// - parent: The parent, which owns this collection of sessions.
func (r *ProjectsLocationsSessionsService) List(parent string) *ProjectsLocationsSessionsListCall {
	c := &ProjectsLocationsSessionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter for the sessions to
// return in the response.A filter is a logical expression constraining the
// values of various fields in each session resource. Filters are case
// sensitive, and may contain multiple clauses combined with logical operators
// (AND, OR). Supported fields are session_id, session_uuid, state,
// create_time, and labels.Example: state = ACTIVE and create_time <
// "2023-01-01T00:00:00Z" is a filter for sessions in an ACTIVE state that were
// created before 2023-01-01. state = ACTIVE and labels.environment=production
// is a filter for sessions in an ACTIVE state that have a production
// environment label.See https://google.aip.dev/assets/misc/ebnf-filtering.txt
// for a detailed description of the filter syntax and a list of supported
// comparators.
func (c *ProjectsLocationsSessionsListCall) Filter(filter string) *ProjectsLocationsSessionsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// sessions to return in each response. The service may return fewer than this
// value.
func (c *ProjectsLocationsSessionsListCall) PageSize(pageSize int64) *ProjectsLocationsSessionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous ListSessions call. Provide this token to retrieve the
// subsequent page.
func (c *ProjectsLocationsSessionsListCall) PageToken(pageToken string) *ProjectsLocationsSessionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsListCall) Context(ctx context.Context) *ProjectsLocationsSessionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sessions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListSessionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsSessionsListCall) Do(opts ...googleapi.CallOption) (*ListSessionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListSessionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionsListCall) Pages(ctx context.Context, f func(*ListSessionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionsTerminateCall struct {
	s                       *Service
	name                    string
	terminatesessionrequest *TerminateSessionRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Terminate: Terminates the interactive session.
//
// - name: The name of the session resource to terminate.
func (r *ProjectsLocationsSessionsService) Terminate(name string, terminatesessionrequest *TerminateSessionRequest) *ProjectsLocationsSessionsTerminateCall {
	c := &ProjectsLocationsSessionsTerminateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.terminatesessionrequest = terminatesessionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsTerminateCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsTerminateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsTerminateCall) Context(ctx context.Context) *ProjectsLocationsSessionsTerminateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsTerminateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsTerminateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.terminatesessionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:terminate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.terminate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.terminate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsTerminateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.terminate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsAccessCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Access: Obtain high level information corresponding to a single Spark
// Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) Access(name string) *ProjectsLocationsSessionsSparkApplicationsAccessCall {
	c := &ProjectsLocationsSessionsSparkApplicationsAccessCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsAccessCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsAccessCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsAccessCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsAccessCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsAccessCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:access")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.access", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.access" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSessionSparkApplicationResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessCall) Do(opts ...googleapi.CallOption) (*AccessSessionSparkApplicationResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSessionSparkApplicationResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.access", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessEnvironmentInfo: Obtain environment details for a Spark Application
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) AccessEnvironmentInfo(name string) *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall {
	c := &ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessEnvironmentInfo")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessEnvironmentInfo", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.accessEnvironmentInfo" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSessionSparkApplicationEnvironmentInfoResponse.ServerResponse.Header
// or (if a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessEnvironmentInfoCall) Do(opts ...googleapi.CallOption) (*AccessSessionSparkApplicationEnvironmentInfoResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSessionSparkApplicationEnvironmentInfoResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessEnvironmentInfo", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsAccessJobCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessJob: Obtain data corresponding to a spark job for a Spark Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) AccessJob(name string) *ProjectsLocationsSessionsSparkApplicationsAccessJobCall {
	c := &ProjectsLocationsSessionsSparkApplicationsAccessJobCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// JobId sets the optional parameter "jobId": Required. Job ID to fetch data
// for.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessJobCall) JobId(jobId int64) *ProjectsLocationsSessionsSparkApplicationsAccessJobCall {
	c.urlParams_.Set("jobId", fmt.Sprint(jobId))
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessJobCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsAccessJobCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessJobCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsAccessJobCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessJobCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsAccessJobCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessJobCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsAccessJobCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessJobCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsAccessJobCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessJob")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessJob", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.accessJob" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSessionSparkApplicationJobResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessJobCall) Do(opts ...googleapi.CallOption) (*AccessSessionSparkApplicationJobResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSessionSparkApplicationJobResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessJob", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessSqlPlan: Obtain Spark Plan Graph for a Spark Application SQL
// execution. Limits the number of clusters returned as part of the graph to
// 10000.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) AccessSqlPlan(name string) *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall {
	c := &ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExecutionId sets the optional parameter "executionId": Required. Execution
// ID
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall) ExecutionId(executionId int64) *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall {
	c.urlParams_.Set("executionId", fmt.Sprint(executionId))
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessSqlPlan")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessSqlPlan", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.accessSqlPlan" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSessionSparkApplicationSqlSparkPlanGraphResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlPlanCall) Do(opts ...googleapi.CallOption) (*AccessSessionSparkApplicationSqlSparkPlanGraphResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSessionSparkApplicationSqlSparkPlanGraphResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessSqlPlan", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessSqlQuery: Obtain data corresponding to a particular SQL Query for a
// Spark Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) AccessSqlQuery(name string) *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall {
	c := &ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Details sets the optional parameter "details": Lists/ hides details of Spark
// plan nodes. True is set to list and false to hide.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) Details(details bool) *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("details", fmt.Sprint(details))
	return c
}

// ExecutionId sets the optional parameter "executionId": Required. Execution
// ID
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) ExecutionId(executionId int64) *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("executionId", fmt.Sprint(executionId))
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// PlanDescription sets the optional parameter "planDescription": Enables/
// disables physical plan description on demand
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) PlanDescription(planDescription bool) *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("planDescription", fmt.Sprint(planDescription))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessSqlQuery")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessSqlQuery", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.accessSqlQuery" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSessionSparkApplicationSqlQueryResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessSqlQueryCall) Do(opts ...googleapi.CallOption) (*AccessSessionSparkApplicationSqlQueryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSessionSparkApplicationSqlQueryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessSqlQuery", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessStageAttempt: Obtain data corresponding to a spark stage attempt for a
// Spark Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) AccessStageAttempt(name string) *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall {
	c := &ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageAttemptId sets the optional parameter "stageAttemptId": Required. Stage
// Attempt ID
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) StageAttemptId(stageAttemptId int64) *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("stageAttemptId", fmt.Sprint(stageAttemptId))
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) StageId(stageId int64) *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// SummaryMetricsMask sets the optional parameter "summaryMetricsMask": The
// list of summary metrics fields to include. Empty list will default to skip
// all summary metrics fields. Example, if the response should include
// TaskQuantileMetrics, the request should have task_quantile_metrics in
// summary_metrics_mask field
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) SummaryMetricsMask(summaryMetricsMask string) *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("summaryMetricsMask", summaryMetricsMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessStageAttempt")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessStageAttempt", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.accessStageAttempt" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSessionSparkApplicationStageAttemptResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageAttemptCall) Do(opts ...googleapi.CallOption) (*AccessSessionSparkApplicationStageAttemptResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSessionSparkApplicationStageAttemptResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessStageAttempt", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// AccessStageRddGraph: Obtain RDD operation graph for a Spark Application
// Stage. Limits the number of clusters returned as part of the graph to 10000.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) AccessStageRddGraph(name string) *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall {
	c := &ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall) StageId(stageId int64) *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:accessStageRddGraph")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessStageRddGraph", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.accessStageRddGraph" call.
// Any non-2xx status code is an error. Response headers are in either
// *AccessSessionSparkApplicationStageRddOperationGraphResponse.ServerResponse.H
// eader or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsAccessStageRddGraphCall) Do(opts ...googleapi.CallOption) (*AccessSessionSparkApplicationStageRddOperationGraphResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AccessSessionSparkApplicationStageRddOperationGraphResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.accessStageRddGraph", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsSearchCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Obtain high level information and list of Spark Applications
// corresponding to a batch
//
//   - parent: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) Search(parent string) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// ApplicationStatus sets the optional parameter "applicationStatus": Search
// only applications in the chosen state.
//
// Possible values:
//
//	"APPLICATION_STATUS_UNSPECIFIED"
//	"APPLICATION_STATUS_RUNNING"
//	"APPLICATION_STATUS_COMPLETED"
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) ApplicationStatus(applicationStatus string) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.urlParams_.Set("applicationStatus", applicationStatus)
	return c
}

// MaxEndTime sets the optional parameter "maxEndTime": Latest end timestamp to
// list.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) MaxEndTime(maxEndTime string) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.urlParams_.Set("maxEndTime", maxEndTime)
	return c
}

// MaxTime sets the optional parameter "maxTime": Latest start timestamp to
// list.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) MaxTime(maxTime string) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.urlParams_.Set("maxTime", maxTime)
	return c
}

// MinEndTime sets the optional parameter "minEndTime": Earliest end timestamp
// to list.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) MinEndTime(minEndTime string) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.urlParams_.Set("minEndTime", minEndTime)
	return c
}

// MinTime sets the optional parameter "minTime": Earliest start timestamp to
// list.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) MinTime(minTime string) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.urlParams_.Set("minTime", minTime)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// applications to return in each response. The service may return fewer than
// this. The default page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) PageSize(pageSize int64) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSessionSparkApplications call. Provide this token to
// retrieve the subsequent page.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) PageToken(pageToken string) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/sparkApplications:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.search", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.search" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSessionSparkApplicationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) Do(opts ...googleapi.CallOption) (*SearchSessionSparkApplicationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSessionSparkApplicationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.search", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchCall) Pages(ctx context.Context, f func(*SearchSessionSparkApplicationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchExecutorStageSummary: Obtain executor summary with respect to a spark
// stage attempt.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SearchExecutorStageSummary(name string) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of executors
// to return in each response. The service may return fewer than this. The
// default page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) PageSize(pageSize int64) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSessionSparkApplicationExecutorStageSummary call.
// Provide this token to retrieve the subsequent page.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) PageToken(pageToken string) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageAttemptId sets the optional parameter "stageAttemptId": Required. Stage
// Attempt ID
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) StageAttemptId(stageAttemptId int64) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("stageAttemptId", fmt.Sprint(stageAttemptId))
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) StageId(stageId int64) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchExecutorStageSummary")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchExecutorStageSummary", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.searchExecutorStageSummary" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSessionSparkApplicationExecutorStageSummaryResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) Do(opts ...googleapi.CallOption) (*SearchSessionSparkApplicationExecutorStageSummaryResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSessionSparkApplicationExecutorStageSummaryResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchExecutorStageSummary", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorStageSummaryCall) Pages(ctx context.Context, f func(*SearchSessionSparkApplicationExecutorStageSummaryResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchExecutors: Obtain data corresponding to executors for a Spark
// Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SearchExecutors(name string) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExecutorStatus sets the optional parameter "executorStatus": Filter to
// select whether active/ dead or all executors should be selected.
//
// Possible values:
//
//	"EXECUTOR_STATUS_UNSPECIFIED"
//	"EXECUTOR_STATUS_ACTIVE"
//	"EXECUTOR_STATUS_DEAD"
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) ExecutorStatus(executorStatus string) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("executorStatus", executorStatus)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of executors
// to return in each response. The service may return fewer than this. The
// default page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) PageSize(pageSize int64) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSessionSparkApplicationExecutors call. Provide this
// token to retrieve the subsequent page.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) PageToken(pageToken string) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchExecutors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchExecutors", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.searchExecutors" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSessionSparkApplicationExecutorsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) Do(opts ...googleapi.CallOption) (*SearchSessionSparkApplicationExecutorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSessionSparkApplicationExecutorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchExecutors", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchExecutorsCall) Pages(ctx context.Context, f func(*SearchSessionSparkApplicationExecutorsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionsSparkApplicationsSearchJobsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchJobs: Obtain list of spark jobs corresponding to a Spark Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SearchJobs(name string) *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSearchJobsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// JobIds sets the optional parameter "jobIds": List of Job IDs to filter by if
// provided.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) JobIds(jobIds ...int64) *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall {
	var jobIds_ []string
	for _, v := range jobIds {
		jobIds_ = append(jobIds_, fmt.Sprint(v))
	}
	c.urlParams_.SetMulti("jobIds", jobIds_)
	return c
}

// JobStatus sets the optional parameter "jobStatus": List only jobs in the
// specific state.
//
// Possible values:
//
//	"JOB_EXECUTION_STATUS_UNSPECIFIED"
//	"JOB_EXECUTION_STATUS_RUNNING"
//	"JOB_EXECUTION_STATUS_SUCCEEDED"
//	"JOB_EXECUTION_STATUS_FAILED"
//	"JOB_EXECUTION_STATUS_UNKNOWN"
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) JobStatus(jobStatus string) *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("jobStatus", jobStatus)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of jobs to
// return in each response. The service may return fewer than this. The default
// page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) PageSize(pageSize int64) *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSessionSparkApplicationJobs call. Provide this token
// to retrieve the subsequent page.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) PageToken(pageToken string) *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchJobs", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.searchJobs" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSessionSparkApplicationJobsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) Do(opts ...googleapi.CallOption) (*SearchSessionSparkApplicationJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSessionSparkApplicationJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchJobs", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchJobsCall) Pages(ctx context.Context, f func(*SearchSessionSparkApplicationJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchSqlQueries: Obtain data corresponding to SQL Queries for a Spark
// Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SearchSqlQueries(name string) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Details sets the optional parameter "details": Lists/ hides details of Spark
// plan nodes. True is set to list and false to hide.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) Details(details bool) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("details", fmt.Sprint(details))
	return c
}

// OperationIds sets the optional parameter "operationIds": List of Spark
// Connect operation IDs to filter by if provided.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) OperationIds(operationIds ...string) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.SetMulti("operationIds", append([]string{}, operationIds...))
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of queries
// to return in each response. The service may return fewer than this. The
// default page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) PageSize(pageSize int64) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSessionSparkApplicationSqlQueries call. Provide this
// token to retrieve the subsequent page.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) PageToken(pageToken string) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// PlanDescription sets the optional parameter "planDescription": Enables/
// disables physical plan description on demand
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) PlanDescription(planDescription bool) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("planDescription", fmt.Sprint(planDescription))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchSqlQueries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchSqlQueries", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.searchSqlQueries" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSessionSparkApplicationSqlQueriesResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) Do(opts ...googleapi.CallOption) (*SearchSessionSparkApplicationSqlQueriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSessionSparkApplicationSqlQueriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchSqlQueries", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchSqlQueriesCall) Pages(ctx context.Context, f func(*SearchSessionSparkApplicationSqlQueriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchStageAttemptTasks: Obtain data corresponding to tasks for a spark
// stage attempt for a Spark Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SearchStageAttemptTasks(name string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of tasks to
// return in each response. The service may return fewer than this. The default
// page size is 10; the maximum page size is 100.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) PageSize(pageSize int64) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSessionSparkApplicationStageAttemptTasks call. Provide
// this token to retrieve the subsequent page.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) PageToken(pageToken string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// SortRuntime sets the optional parameter "sortRuntime": Sort the tasks by
// runtime.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) SortRuntime(sortRuntime bool) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("sortRuntime", fmt.Sprint(sortRuntime))
	return c
}

// StageAttemptId sets the optional parameter "stageAttemptId": Stage Attempt
// ID
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) StageAttemptId(stageAttemptId int64) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("stageAttemptId", fmt.Sprint(stageAttemptId))
	return c
}

// StageId sets the optional parameter "stageId": Stage ID
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) StageId(stageId int64) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// TaskStatus sets the optional parameter "taskStatus": List only tasks in the
// state.
//
// Possible values:
//
//	"TASK_STATUS_UNSPECIFIED"
//	"TASK_STATUS_RUNNING"
//	"TASK_STATUS_SUCCESS"
//	"TASK_STATUS_FAILED"
//	"TASK_STATUS_KILLED"
//	"TASK_STATUS_PENDING"
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) TaskStatus(taskStatus string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("taskStatus", taskStatus)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchStageAttemptTasks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchStageAttemptTasks", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.searchStageAttemptTasks" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSessionSparkApplicationStageAttemptTasksResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in error.(*googleapi.Error).Header.
//
// Use googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) Do(opts ...googleapi.CallOption) (*SearchSessionSparkApplicationStageAttemptTasksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSessionSparkApplicationStageAttemptTasksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchStageAttemptTasks", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptTasksCall) Pages(ctx context.Context, f func(*SearchSessionSparkApplicationStageAttemptTasksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchStageAttempts: Obtain data corresponding to a spark stage attempts for
// a Spark Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SearchStageAttempts(name string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of stage
// attempts (paging based on stage_attempt_id) to return in each response. The
// service may return fewer than this. The default page size is 10; the maximum
// page size is 100.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) PageSize(pageSize int64) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSessionSparkApplicationStageAttempts call. Provide
// this token to retrieve the subsequent page.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) PageToken(pageToken string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID for which
// attempts are to be fetched
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) StageId(stageId int64) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// SummaryMetricsMask sets the optional parameter "summaryMetricsMask": The
// list of summary metrics fields to include. Empty list will default to skip
// all summary metrics fields. Example, if the response should include
// TaskQuantileMetrics, the request should have task_quantile_metrics in
// summary_metrics_mask field
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) SummaryMetricsMask(summaryMetricsMask string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("summaryMetricsMask", summaryMetricsMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchStageAttempts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchStageAttempts", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.searchStageAttempts" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSessionSparkApplicationStageAttemptsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) Do(opts ...googleapi.CallOption) (*SearchSessionSparkApplicationStageAttemptsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSessionSparkApplicationStageAttemptsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchStageAttempts", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStageAttemptsCall) Pages(ctx context.Context, f func(*SearchSessionSparkApplicationStageAttemptsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionsSparkApplicationsSearchStagesCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchStages: Obtain data corresponding to stages for a Spark Application.
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SearchStages(name string) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSearchStagesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of stages
// (paging based on stage_id) to return in each response. The service may
// return fewer than this. The default page size is 10; the maximum page size
// is 100.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) PageSize(pageSize int64) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous SearchSessionSparkApplicationStages call. Provide this token
// to retrieve the subsequent page.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) PageToken(pageToken string) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageIds sets the optional parameter "stageIds": List of Stage IDs to filter
// by if provided.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) StageIds(stageIds ...int64) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	var stageIds_ []string
	for _, v := range stageIds {
		stageIds_ = append(stageIds_, fmt.Sprint(v))
	}
	c.urlParams_.SetMulti("stageIds", stageIds_)
	return c
}

// StageStatus sets the optional parameter "stageStatus": List only stages in
// the given state.
//
// Possible values:
//
//	"STAGE_STATUS_UNSPECIFIED"
//	"STAGE_STATUS_ACTIVE"
//	"STAGE_STATUS_COMPLETE"
//	"STAGE_STATUS_FAILED"
//	"STAGE_STATUS_PENDING"
//	"STAGE_STATUS_SKIPPED"
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) StageStatus(stageStatus string) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("stageStatus", stageStatus)
	return c
}

// SummaryMetricsMask sets the optional parameter "summaryMetricsMask": The
// list of summary metrics fields to include. Empty list will default to skip
// all summary metrics fields. Example, if the response should include
// TaskQuantileMetrics, the request should have task_quantile_metrics in
// summary_metrics_mask field
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) SummaryMetricsMask(summaryMetricsMask string) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("summaryMetricsMask", summaryMetricsMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchStages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchStages", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.searchStages" call.
// Any non-2xx status code is an error. Response headers are in either
// *SearchSessionSparkApplicationStagesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) Do(opts ...googleapi.CallOption) (*SearchSessionSparkApplicationStagesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SearchSessionSparkApplicationStagesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.searchStages", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSessionsSparkApplicationsSearchStagesCall) Pages(ctx context.Context, f func(*SearchSessionSparkApplicationStagesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SummarizeExecutors: Obtain summary of Executor Summary for a Spark
// Application
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SummarizeExecutors(name string) *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:summarizeExecutors")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.summarizeExecutors", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.summarizeExecutors" call.
// Any non-2xx status code is an error. Response headers are in either
// *SummarizeSessionSparkApplicationExecutorsResponse.ServerResponse.Header or
// (if a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeExecutorsCall) Do(opts ...googleapi.CallOption) (*SummarizeSessionSparkApplicationExecutorsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SummarizeSessionSparkApplicationExecutorsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.summarizeExecutors", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SummarizeJobs: Obtain summary of Jobs for a Spark Application
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SummarizeJobs(name string) *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// JobIds sets the optional parameter "jobIds": List of Job IDs to filter by if
// provided.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall) JobIds(jobIds ...int64) *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall {
	var jobIds_ []string
	for _, v := range jobIds {
		jobIds_ = append(jobIds_, fmt.Sprint(v))
	}
	c.urlParams_.SetMulti("jobIds", jobIds_)
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:summarizeJobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.summarizeJobs", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.summarizeJobs" call.
// Any non-2xx status code is an error. Response headers are in either
// *SummarizeSessionSparkApplicationJobsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeJobsCall) Do(opts ...googleapi.CallOption) (*SummarizeSessionSparkApplicationJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SummarizeSessionSparkApplicationJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.summarizeJobs", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SummarizeStageAttemptTasks: Obtain summary of Tasks for a Spark Application
// Stage Attempt
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SummarizeStageAttemptTasks(name string) *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageAttemptId sets the optional parameter "stageAttemptId": Required. Stage
// Attempt ID
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall) StageAttemptId(stageAttemptId int64) *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall {
	c.urlParams_.Set("stageAttemptId", fmt.Sprint(stageAttemptId))
	return c
}

// StageId sets the optional parameter "stageId": Required. Stage ID
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall) StageId(stageId int64) *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall {
	c.urlParams_.Set("stageId", fmt.Sprint(stageId))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:summarizeStageAttemptTasks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.summarizeStageAttemptTasks", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.summarizeStageAttemptTasks" call.
// Any non-2xx status code is an error. Response headers are in either
// *SummarizeSessionSparkApplicationStageAttemptTasksResponse.ServerResponse.Hea
// der or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStageAttemptTasksCall) Do(opts ...googleapi.CallOption) (*SummarizeSessionSparkApplicationStageAttemptTasksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SummarizeSessionSparkApplicationStageAttemptTasksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.summarizeStageAttemptTasks", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SummarizeStages: Obtain summary of Stages for a Spark Application
//
//   - name: The fully qualified name of the session to retrieve in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) SummarizeStages(name string) *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall {
	c := &ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Parent sets the optional parameter "parent": Required. Parent (Session)
// resource reference.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall) Parent(parent string) *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// StageIds sets the optional parameter "stageIds": List of Stage IDs to filter
// by if provided.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall) StageIds(stageIds ...int64) *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall {
	var stageIds_ []string
	for _, v := range stageIds {
		stageIds_ = append(stageIds_, fmt.Sprint(v))
	}
	c.urlParams_.SetMulti("stageIds", stageIds_)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall) IfNoneMatch(entityTag string) *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:summarizeStages")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.summarizeStages", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.summarizeStages" call.
// Any non-2xx status code is an error. Response headers are in either
// *SummarizeSessionSparkApplicationStagesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsSummarizeStagesCall) Do(opts ...googleapi.CallOption) (*SummarizeSessionSparkApplicationStagesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SummarizeSessionSparkApplicationStagesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.summarizeStages", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsSessionsSparkApplicationsWriteCall struct {
	s                                          *Service
	name                                       string
	writesessionsparkapplicationcontextrequest *WriteSessionSparkApplicationContextRequest
	urlParams_                                 gensupport.URLParams
	ctx_                                       context.Context
	header_                                    http.Header
}

// Write: Write wrapper objects from dataplane to spanner
//
//   - name: The fully qualified name of the spark application to write data
//     about in the format
//     "projects/PROJECT_ID/locations/DATAPROC_REGION/sessions/SESSION_ID/sparkApp
//     lications/APPLICATION_ID".
func (r *ProjectsLocationsSessionsSparkApplicationsService) Write(name string, writesessionsparkapplicationcontextrequest *WriteSessionSparkApplicationContextRequest) *ProjectsLocationsSessionsSparkApplicationsWriteCall {
	c := &ProjectsLocationsSessionsSparkApplicationsWriteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.writesessionsparkapplicationcontextrequest = writesessionsparkapplicationcontextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsSessionsSparkApplicationsWriteCall) Fields(s ...googleapi.Field) *ProjectsLocationsSessionsSparkApplicationsWriteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsSessionsSparkApplicationsWriteCall) Context(ctx context.Context) *ProjectsLocationsSessionsSparkApplicationsWriteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsSessionsSparkApplicationsWriteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSessionsSparkApplicationsWriteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.writesessionsparkapplicationcontextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:write")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.write", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.sessions.sparkApplications.write" call.
// Any non-2xx status code is an error. Response headers are in either
// *WriteSessionSparkApplicationContextResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsSessionsSparkApplicationsWriteCall) Do(opts ...googleapi.CallOption) (*WriteSessionSparkApplicationContextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WriteSessionSparkApplicationContextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.sessions.sparkApplications.write", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkflowTemplatesCreateCall struct {
	s                *Service
	parent           string
	workflowtemplate *WorkflowTemplate
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Create: Creates new workflow template.
//
//   - parent: The resource name of the region or location, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.workflowTemplates.create, the resource name of the region
//     has the following format: projects/{project_id}/regions/{region} For
//     projects.locations.workflowTemplates.create, the resource name of the
//     location has the following format:
//     projects/{project_id}/locations/{location}.
func (r *ProjectsLocationsWorkflowTemplatesService) Create(parent string, workflowtemplate *WorkflowTemplate) *ProjectsLocationsWorkflowTemplatesCreateCall {
	c := &ProjectsLocationsWorkflowTemplatesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.workflowtemplate = workflowtemplate
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesCreateCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.workflowtemplate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/workflowTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *WorkflowTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsWorkflowTemplatesCreateCall) Do(opts ...googleapi.CallOption) (*WorkflowTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WorkflowTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkflowTemplatesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a workflow template. It does not cancel in-progress
// workflows.
//
//   - name: The resource name of the workflow template, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.workflowTemplates.delete, the resource name of the
//     template has the following format:
//     projects/{project_id}/regions/{region}/workflowTemplates/{template_id} For
//     projects.locations.workflowTemplates.instantiate, the resource name of the
//     template has the following format:
//     projects/{project_id}/locations/{location}/workflowTemplates/{template_id}.
func (r *ProjectsLocationsWorkflowTemplatesService) Delete(name string) *ProjectsLocationsWorkflowTemplatesDeleteCall {
	c := &ProjectsLocationsWorkflowTemplatesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Version sets the optional parameter "version": The version of workflow
// template to delete. If specified, will only delete the template if the
// current server version matches specified version.
func (c *ProjectsLocationsWorkflowTemplatesDeleteCall) Version(version int64) *ProjectsLocationsWorkflowTemplatesDeleteCall {
	c.urlParams_.Set("version", fmt.Sprint(version))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesDeleteCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowTemplatesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkflowTemplatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the latest workflow template.Can retrieve previously
// instantiated template by specifying optional version parameter.
//
//   - name: The resource name of the workflow template, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.workflowTemplates.get, the resource name of the template
//     has the following format:
//     projects/{project_id}/regions/{region}/workflowTemplates/{template_id} For
//     projects.locations.workflowTemplates.get, the resource name of the
//     template has the following format:
//     projects/{project_id}/locations/{location}/workflowTemplates/{template_id}.
func (r *ProjectsLocationsWorkflowTemplatesService) Get(name string) *ProjectsLocationsWorkflowTemplatesGetCall {
	c := &ProjectsLocationsWorkflowTemplatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Version sets the optional parameter "version": The version of workflow
// template to retrieve. Only previously instantiated versions can be
// retrieved.If unspecified, retrieves the current version.
func (c *ProjectsLocationsWorkflowTemplatesGetCall) Version(version int64) *ProjectsLocationsWorkflowTemplatesGetCall {
	c.urlParams_.Set("version", fmt.Sprint(version))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWorkflowTemplatesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkflowTemplatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesGetCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *WorkflowTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsWorkflowTemplatesGetCall) Do(opts ...googleapi.CallOption) (*WorkflowTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WorkflowTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkflowTemplatesGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsWorkflowTemplatesService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *ProjectsLocationsWorkflowTemplatesGetIamPolicyCall {
	c := &ProjectsLocationsWorkflowTemplatesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowTemplatesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkflowTemplatesInstantiateCall struct {
	s                                  *Service
	name                               string
	instantiateworkflowtemplaterequest *InstantiateWorkflowTemplateRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Instantiate: Instantiates a template and begins execution.The returned
// Operation can be used to track execution of workflow by polling
// operations.get. The Operation will complete when entire workflow is
// finished.The running workflow can be aborted via operations.cancel. This
// will cause any inflight jobs to be cancelled and workflow-owned clusters to
// be deleted.The Operation.metadata will be WorkflowMetadata
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#workflowmetadata).
// Also see Using WorkflowMetadata
// (https://cloud.google.com/dataproc/docs/concepts/workflows/debugging#using_workflowmetadata).On
// successful completion, Operation.response will be Empty.
//
//   - name: The resource name of the workflow template, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.workflowTemplates.instantiate, the resource name of the
//     template has the following format:
//     projects/{project_id}/regions/{region}/workflowTemplates/{template_id} For
//     projects.locations.workflowTemplates.instantiate, the resource name of the
//     template has the following format:
//     projects/{project_id}/locations/{location}/workflowTemplates/{template_id}.
func (r *ProjectsLocationsWorkflowTemplatesService) Instantiate(name string, instantiateworkflowtemplaterequest *InstantiateWorkflowTemplateRequest) *ProjectsLocationsWorkflowTemplatesInstantiateCall {
	c := &ProjectsLocationsWorkflowTemplatesInstantiateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.instantiateworkflowtemplaterequest = instantiateworkflowtemplaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesInstantiateCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesInstantiateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesInstantiateCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesInstantiateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesInstantiateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesInstantiateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instantiateworkflowtemplaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:instantiate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.instantiate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.instantiate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowTemplatesInstantiateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.instantiate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkflowTemplatesInstantiateInlineCall struct {
	s                *Service
	parent           string
	workflowtemplate *WorkflowTemplate
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// InstantiateInline: Instantiates a template and begins execution.This method
// is equivalent to executing the sequence CreateWorkflowTemplate,
// InstantiateWorkflowTemplate, DeleteWorkflowTemplate.The returned Operation
// can be used to track execution of workflow by polling operations.get. The
// Operation will complete when entire workflow is finished.The running
// workflow can be aborted via operations.cancel. This will cause any inflight
// jobs to be cancelled and workflow-owned clusters to be deleted.The
// Operation.metadata will be WorkflowMetadata
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#workflowmetadata).
// Also see Using WorkflowMetadata
// (https://cloud.google.com/dataproc/docs/concepts/workflows/debugging#using_workflowmetadata).On
// successful completion, Operation.response will be Empty.
//
//   - parent: The resource name of the region or location, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.workflowTemplates,instantiateinline, the resource name of
//     the region has the following format:
//     projects/{project_id}/regions/{region} For
//     projects.locations.workflowTemplates.instantiateinline, the resource name
//     of the location has the following format:
//     projects/{project_id}/locations/{location}.
func (r *ProjectsLocationsWorkflowTemplatesService) InstantiateInline(parent string, workflowtemplate *WorkflowTemplate) *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall {
	c := &ProjectsLocationsWorkflowTemplatesInstantiateInlineCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.workflowtemplate = workflowtemplate
	return c
}

// RequestId sets the optional parameter "requestId": A tag that prevents
// multiple concurrent workflow instances with the same tag from running. This
// mitigates risk of concurrent instances started due to retries.It is
// recommended to always set this value to a UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The tag must
// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
// (-). The maximum length is 40 characters.
func (c *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall) RequestId(requestId string) *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.workflowtemplate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/workflowTemplates:instantiateInline")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.instantiateInline", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.instantiateInline" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowTemplatesInstantiateInlineCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.instantiateInline", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkflowTemplatesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists workflows that match the specified filter in the request.
//
//   - parent: The resource name of the region or location, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.workflowTemplates,list, the resource name of the region
//     has the following format: projects/{project_id}/regions/{region} For
//     projects.locations.workflowTemplates.list, the resource name of the
//     location has the following format:
//     projects/{project_id}/locations/{location}.
func (r *ProjectsLocationsWorkflowTemplatesService) List(parent string) *ProjectsLocationsWorkflowTemplatesListCall {
	c := &ProjectsLocationsWorkflowTemplatesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in each response.
func (c *ProjectsLocationsWorkflowTemplatesListCall) PageSize(pageSize int64) *ProjectsLocationsWorkflowTemplatesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token, returned
// by a previous call, to request the next page of results.
func (c *ProjectsLocationsWorkflowTemplatesListCall) PageToken(pageToken string) *ProjectsLocationsWorkflowTemplatesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWorkflowTemplatesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkflowTemplatesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesListCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/workflowTemplates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListWorkflowTemplatesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowTemplatesListCall) Do(opts ...googleapi.CallOption) (*ListWorkflowTemplatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListWorkflowTemplatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsWorkflowTemplatesListCall) Pages(ctx context.Context, f func(*ListWorkflowTemplatesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsWorkflowTemplatesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
// PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsWorkflowTemplatesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsWorkflowTemplatesSetIamPolicyCall {
	c := &ProjectsLocationsWorkflowTemplatesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowTemplatesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsWorkflowTemplatesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall {
	c := &ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkflowTemplatesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkflowTemplatesUpdateCall struct {
	s                *Service
	name             string
	workflowtemplate *WorkflowTemplate
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Update: Updates (replaces) workflow template. The updated template must
// contain version that matches the current server version.
//
//   - name: Output only. The resource name of the workflow template, as
//     described in https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.workflowTemplates, the resource name of the template has
//     the following format:
//     projects/{project_id}/regions/{region}/workflowTemplates/{template_id} For
//     projects.locations.workflowTemplates, the resource name of the template
//     has the following format:
//     projects/{project_id}/locations/{location}/workflowTemplates/{template_id}.
func (r *ProjectsLocationsWorkflowTemplatesService) Update(name string, workflowtemplate *WorkflowTemplate) *ProjectsLocationsWorkflowTemplatesUpdateCall {
	c := &ProjectsLocationsWorkflowTemplatesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.workflowtemplate = workflowtemplate
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkflowTemplatesUpdateCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkflowTemplatesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkflowTemplatesUpdateCall) Context(ctx context.Context) *ProjectsLocationsWorkflowTemplatesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkflowTemplatesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkflowTemplatesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.workflowtemplate)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.locations.workflowTemplates.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *WorkflowTemplate.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsWorkflowTemplatesUpdateCall) Do(opts ...googleapi.CallOption) (*WorkflowTemplate, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WorkflowTemplate{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.locations.workflowTemplates.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsAutoscalingPoliciesCreateCall struct {
	s                 *Service
	parent            string
	autoscalingpolicy *AutoscalingPolicy
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates new autoscaling policy.
//
//   - parent: The "resource name" of the region or location, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies.create, the resource name of the
//     region has the following format: projects/{project_id}/regions/{region}
//     For projects.locations.autoscalingPolicies.create, the resource name of
//     the location has the following format:
//     projects/{project_id}/locations/{location}.
func (r *ProjectsRegionsAutoscalingPoliciesService) Create(parent string, autoscalingpolicy *AutoscalingPolicy) *ProjectsRegionsAutoscalingPoliciesCreateCall {
	c := &ProjectsRegionsAutoscalingPoliciesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.autoscalingpolicy = autoscalingpolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsAutoscalingPoliciesCreateCall) Fields(s ...googleapi.Field) *ProjectsRegionsAutoscalingPoliciesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsAutoscalingPoliciesCreateCall) Context(ctx context.Context) *ProjectsRegionsAutoscalingPoliciesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsAutoscalingPoliciesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsAutoscalingPoliciesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.autoscalingpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/autoscalingPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.autoscalingPolicies.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *AutoscalingPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsRegionsAutoscalingPoliciesCreateCall) Do(opts ...googleapi.CallOption) (*AutoscalingPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AutoscalingPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsAutoscalingPoliciesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an autoscaling policy. It is an error to delete an
// autoscaling policy that is in use by one or more clusters.
//
//   - name: The "resource name" of the autoscaling policy, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies.delete, the resource name of the
//     policy has the following format:
//     projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id} For
//     projects.locations.autoscalingPolicies.delete, the resource name of the
//     policy has the following format:
//     projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}.
func (r *ProjectsRegionsAutoscalingPoliciesService) Delete(name string) *ProjectsRegionsAutoscalingPoliciesDeleteCall {
	c := &ProjectsRegionsAutoscalingPoliciesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsAutoscalingPoliciesDeleteCall) Fields(s ...googleapi.Field) *ProjectsRegionsAutoscalingPoliciesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsAutoscalingPoliciesDeleteCall) Context(ctx context.Context) *ProjectsRegionsAutoscalingPoliciesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsAutoscalingPoliciesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsAutoscalingPoliciesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.autoscalingPolicies.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsAutoscalingPoliciesDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsAutoscalingPoliciesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves autoscaling policy.
//
//   - name: The "resource name" of the autoscaling policy, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies.get, the resource name of the policy
//     has the following format:
//     projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id} For
//     projects.locations.autoscalingPolicies.get, the resource name of the
//     policy has the following format:
//     projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}.
func (r *ProjectsRegionsAutoscalingPoliciesService) Get(name string) *ProjectsRegionsAutoscalingPoliciesGetCall {
	c := &ProjectsRegionsAutoscalingPoliciesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsAutoscalingPoliciesGetCall) Fields(s ...googleapi.Field) *ProjectsRegionsAutoscalingPoliciesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsRegionsAutoscalingPoliciesGetCall) IfNoneMatch(entityTag string) *ProjectsRegionsAutoscalingPoliciesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsAutoscalingPoliciesGetCall) Context(ctx context.Context) *ProjectsRegionsAutoscalingPoliciesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsAutoscalingPoliciesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsAutoscalingPoliciesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.autoscalingPolicies.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *AutoscalingPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsRegionsAutoscalingPoliciesGetCall) Do(opts ...googleapi.CallOption) (*AutoscalingPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AutoscalingPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsRegionsAutoscalingPoliciesService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall {
	c := &ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall) Context(ctx context.Context) *ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.autoscalingPolicies.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsAutoscalingPoliciesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsAutoscalingPoliciesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists autoscaling policies in the project.
//
//   - parent: The "resource name" of the region or location, as described in
//     https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies.list, the resource name of the region
//     has the following format: projects/{project_id}/regions/{region} For
//     projects.locations.autoscalingPolicies.list, the resource name of the
//     location has the following format:
//     projects/{project_id}/locations/{location}.
func (r *ProjectsRegionsAutoscalingPoliciesService) List(parent string) *ProjectsRegionsAutoscalingPoliciesListCall {
	c := &ProjectsRegionsAutoscalingPoliciesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return in each response. Must be less than or equal to 1000.
// Defaults to 100.
func (c *ProjectsRegionsAutoscalingPoliciesListCall) PageSize(pageSize int64) *ProjectsRegionsAutoscalingPoliciesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The page token, returned
// by a previous call, to request the next page of results.
func (c *ProjectsRegionsAutoscalingPoliciesListCall) PageToken(pageToken string) *ProjectsRegionsAutoscalingPoliciesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsAutoscalingPoliciesListCall) Fields(s ...googleapi.Field) *ProjectsRegionsAutoscalingPoliciesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsRegionsAutoscalingPoliciesListCall) IfNoneMatch(entityTag string) *ProjectsRegionsAutoscalingPoliciesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsAutoscalingPoliciesListCall) Context(ctx context.Context) *ProjectsRegionsAutoscalingPoliciesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsAutoscalingPoliciesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsAutoscalingPoliciesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/autoscalingPolicies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.autoscalingPolicies.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAutoscalingPoliciesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsRegionsAutoscalingPoliciesListCall) Do(opts ...googleapi.CallOption) (*ListAutoscalingPoliciesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAutoscalingPoliciesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsRegionsAutoscalingPoliciesListCall) Pages(ctx context.Context, f func(*ListAutoscalingPoliciesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
// PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsRegionsAutoscalingPoliciesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall {
	c := &ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall) Context(ctx context.Context) *ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.autoscalingPolicies.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsAutoscalingPoliciesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall struct {
	s                         *Service
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// resource. If the resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.Note: This operation is designed to be
// used for building permission-aware UIs and command-line tools, not for
// authorization checking. This operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsRegionsAutoscalingPoliciesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall {
	c := &ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.autoscalingPolicies.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsRegionsAutoscalingPoliciesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsAutoscalingPoliciesUpdateCall struct {
	s                 *Service
	name              string
	autoscalingpolicy *AutoscalingPolicy
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Update: Updates (replaces) autoscaling policy.Disabled check for
// update_mask, because all updates will be full replacements.
//
//   - name: Output only. The "resource name" of the autoscaling policy, as
//     described in https://cloud.google.com/apis/design/resource_names. For
//     projects.regions.autoscalingPolicies, the resource name of the policy has
//     the following format:
//     projects/{project_id}/regions/{region}/autoscalingPolicies/{policy_id} For
//     projects.locations.autoscalingPolicies, the resource name of the policy
//     has the following format:
//     projects/{project_id}/locations/{location}/autoscalingPolicies/{policy_id}.
func (r *ProjectsRegionsAutoscalingPoliciesService) Update(name string, autoscalingpolicy *AutoscalingPolicy) *ProjectsRegionsAutoscalingPoliciesUpdateCall {
	c := &ProjectsRegionsAutoscalingPoliciesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.autoscalingpolicy = autoscalingpolicy
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsAutoscalingPoliciesUpdateCall) Fields(s ...googleapi.Field) *ProjectsRegionsAutoscalingPoliciesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsAutoscalingPoliciesUpdateCall) Context(ctx context.Context) *ProjectsRegionsAutoscalingPoliciesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsAutoscalingPoliciesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsAutoscalingPoliciesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.autoscalingpolicy)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.autoscalingPolicies.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *AutoscalingPolicy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsRegionsAutoscalingPoliciesUpdateCall) Do(opts ...googleapi.CallOption) (*AutoscalingPolicy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &AutoscalingPolicy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.autoscalingPolicies.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersCreateCall struct {
	s          *Service
	projectId  string
	region     string
	cluster    *Cluster
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a cluster in a project. The returned Operation.metadata will
// be ClusterOperationMetadata
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
//
//   - projectId: The ID of the Google Cloud Platform project that the cluster
//     belongs to.
//   - region: The Dataproc region in which to handle the request.
func (r *ProjectsRegionsClustersService) Create(projectId string, region string, cluster *Cluster) *ProjectsRegionsClustersCreateCall {
	c := &ProjectsRegionsClustersCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.region = region
	c.cluster = cluster
	return c
}

// ActionOnFailedPrimaryWorkers sets the optional parameter
// "actionOnFailedPrimaryWorkers": Failure action when primary worker creation
// fails.
//
// Possible values:
//
//	"FAILURE_ACTION_UNSPECIFIED" - When FailureAction is unspecified, failure
//
// action defaults to NO_ACTION.
//
//	"NO_ACTION" - Take no action on failure to create a cluster resource.
//
// NO_ACTION is the default.
//
//	"DELETE" - Delete the failed cluster resource.
func (c *ProjectsRegionsClustersCreateCall) ActionOnFailedPrimaryWorkers(actionOnFailedPrimaryWorkers string) *ProjectsRegionsClustersCreateCall {
	c.urlParams_.Set("actionOnFailedPrimaryWorkers", actionOnFailedPrimaryWorkers)
	return c
}

// RequestId sets the optional parameter "requestId": A unique ID used to
// identify the request. If the server receives two CreateClusterRequest
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.CreateClusterRequest)s
// with the same id, then the second request will be ignored and the first
// google.longrunning.Operation created and stored in the backend is
// returned.It is recommended to always set this value to a UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
// (-). The maximum length is 40 characters.
func (c *ProjectsRegionsClustersCreateCall) RequestId(requestId string) *ProjectsRegionsClustersCreateCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersCreateCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersCreateCall) Context(ctx context.Context) *ProjectsRegionsClustersCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cluster)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{projectId}/regions/{region}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"region":    c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersDeleteCall struct {
	s           *Service
	projectId   string
	region      string
	clusterName string
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Delete: Deletes a cluster in a project. The returned Operation.metadata will
// be ClusterOperationMetadata
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
//
//   - clusterName: The cluster name.
//   - projectId: The ID of the Google Cloud Platform project that the cluster
//     belongs to.
//   - region: The Dataproc region in which to handle the request.
func (r *ProjectsRegionsClustersService) Delete(projectId string, region string, clusterName string) *ProjectsRegionsClustersDeleteCall {
	c := &ProjectsRegionsClustersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.region = region
	c.clusterName = clusterName
	return c
}

// ClusterUuid sets the optional parameter "clusterUuid": Specifying the
// cluster_uuid means the RPC should fail (with error NOT_FOUND) if cluster
// with specified UUID does not exist.
func (c *ProjectsRegionsClustersDeleteCall) ClusterUuid(clusterUuid string) *ProjectsRegionsClustersDeleteCall {
	c.urlParams_.Set("clusterUuid", clusterUuid)
	return c
}

// GracefulTerminationTimeout sets the optional parameter
// "gracefulTerminationTimeout": The graceful termination timeout for the
// deletion of the cluster. Indicate the time the request will wait to complete
// the running jobs on the cluster before its forceful deletion. Default value
// is 0 indicating that the user has not enabled the graceful termination.
// Value can be between 60 second and 6 Hours, in case the graceful termination
// is enabled. (There is no separate flag to check the enabling or disabling of
// graceful termination, it can be checked by the values in the field).
func (c *ProjectsRegionsClustersDeleteCall) GracefulTerminationTimeout(gracefulTerminationTimeout string) *ProjectsRegionsClustersDeleteCall {
	c.urlParams_.Set("gracefulTerminationTimeout", gracefulTerminationTimeout)
	return c
}

// RequestId sets the optional parameter "requestId": A unique ID used to
// identify the request. If the server receives two DeleteClusterRequest
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.DeleteClusterRequest)s
// with the same id, then the second request will be ignored and the first
// google.longrunning.Operation created and stored in the backend is
// returned.It is recommended to always set this value to a UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
// (-). The maximum length is 40 characters.
func (c *ProjectsRegionsClustersDeleteCall) RequestId(requestId string) *ProjectsRegionsClustersDeleteCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersDeleteCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersDeleteCall) Context(ctx context.Context) *ProjectsRegionsClustersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":   c.projectId,
		"region":      c.region,
		"clusterName": c.clusterName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersDiagnoseCall struct {
	s                      *Service
	projectId              string
	region                 string
	clusterName            string
	diagnoseclusterrequest *DiagnoseClusterRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Diagnose: Gets cluster diagnostic information. The returned
// Operation.metadata will be ClusterOperationMetadata
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
// After the operation completes, Operation.response contains
// DiagnoseClusterResults
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#diagnoseclusterresults).
//
//   - clusterName: The cluster name.
//   - projectId: The ID of the Google Cloud Platform project that the cluster
//     belongs to.
//   - region: The Dataproc region in which to handle the request.
func (r *ProjectsRegionsClustersService) Diagnose(projectId string, region string, clusterName string, diagnoseclusterrequest *DiagnoseClusterRequest) *ProjectsRegionsClustersDiagnoseCall {
	c := &ProjectsRegionsClustersDiagnoseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.region = region
	c.clusterName = clusterName
	c.diagnoseclusterrequest = diagnoseclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersDiagnoseCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersDiagnoseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersDiagnoseCall) Context(ctx context.Context) *ProjectsRegionsClustersDiagnoseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersDiagnoseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersDiagnoseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.diagnoseclusterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:diagnose")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":   c.projectId,
		"region":      c.region,
		"clusterName": c.clusterName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.diagnose", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.diagnose" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersDiagnoseCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.diagnose", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersGetCall struct {
	s            *Service
	projectId    string
	region       string
	clusterName  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the resource representation for a cluster in a project.
//
//   - clusterName: The cluster name.
//   - projectId: The ID of the Google Cloud Platform project that the cluster
//     belongs to.
//   - region: The Dataproc region in which to handle the request.
func (r *ProjectsRegionsClustersService) Get(projectId string, region string, clusterName string) *ProjectsRegionsClustersGetCall {
	c := &ProjectsRegionsClustersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.region = region
	c.clusterName = clusterName
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersGetCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsRegionsClustersGetCall) IfNoneMatch(entityTag string) *ProjectsRegionsClustersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersGetCall) Context(ctx context.Context) *ProjectsRegionsClustersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":   c.projectId,
		"region":      c.region,
		"clusterName": c.clusterName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Cluster.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersGetCall) Do(opts ...googleapi.CallOption) (*Cluster, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Cluster{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersGetIamPolicyCall struct {
	s                   *Service
	resource            string
	getiampolicyrequest *GetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns an
// empty policy if the resource exists and does not have a policy set.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsRegionsClustersService) GetIamPolicy(resource string, getiampolicyrequest *GetIamPolicyRequest) *ProjectsRegionsClustersGetIamPolicyCall {
	c := &ProjectsRegionsClustersGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.getiampolicyrequest = getiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersGetIamPolicyCall) Context(ctx context.Context) *ProjectsRegionsClustersGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.getiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.getIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersInjectCredentialsCall struct {
	s                        *Service
	project                  string
	region                   string
	cluster                  string
	injectcredentialsrequest *InjectCredentialsRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// InjectCredentials: Inject encrypted credentials into all of the VMs in a
// cluster.The target cluster must be a personal auth cluster assigned to the
// user who is issuing the RPC.
//
//   - cluster: The cluster, in the form clusters/.
//   - project: The ID of the Google Cloud Platform project the cluster belongs
//     to, of the form projects/.
//   - region: The region containing the cluster, of the form regions/.
func (r *ProjectsRegionsClustersService) InjectCredentials(project string, region string, cluster string, injectcredentialsrequest *InjectCredentialsRequest) *ProjectsRegionsClustersInjectCredentialsCall {
	c := &ProjectsRegionsClustersInjectCredentialsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.region = region
	c.cluster = cluster
	c.injectcredentialsrequest = injectcredentialsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersInjectCredentialsCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersInjectCredentialsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersInjectCredentialsCall) Context(ctx context.Context) *ProjectsRegionsClustersInjectCredentialsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersInjectCredentialsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersInjectCredentialsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.injectcredentialsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+project}/{+region}/{+cluster}:injectCredentials")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
		"region":  c.region,
		"cluster": c.cluster,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.injectCredentials", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.injectCredentials" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersInjectCredentialsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.injectCredentials", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersListCall struct {
	s            *Service
	projectId    string
	region       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all regions/{region}/clusters in a project alphabetically.
//
//   - projectId: The ID of the Google Cloud Platform project that the cluster
//     belongs to.
//   - region: The Dataproc region in which to handle the request.
func (r *ProjectsRegionsClustersService) List(projectId string, region string) *ProjectsRegionsClustersListCall {
	c := &ProjectsRegionsClustersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.region = region
	return c
}

// Filter sets the optional parameter "filter": A filter constraining the
// clusters to list. Filters are case-sensitive and have the following
// syntax:field = value AND field = value ...where field is one of
// status.state, clusterName, or labels.[KEY], and [KEY] is a label key. value
// can be * to match all values. status.state can be one of the following:
// ACTIVE, INACTIVE, CREATING, RUNNING, ERROR, DELETING, UPDATING, STOPPING, or
// STOPPED. ACTIVE contains the CREATING, UPDATING, and RUNNING states.
// INACTIVE contains the DELETING, ERROR, STOPPING, and STOPPED states.
// clusterName is the name of the cluster provided at creation time. Only the
// logical AND operator is supported; space-separated items are treated as
// having an implicit AND operator.Example filter:status.state = ACTIVE AND
// clusterName = mycluster AND labels.env = staging AND labels.starred = *
func (c *ProjectsRegionsClustersListCall) Filter(filter string) *ProjectsRegionsClustersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The standard List page
// size.
func (c *ProjectsRegionsClustersListCall) PageSize(pageSize int64) *ProjectsRegionsClustersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The standard List page
// token.
func (c *ProjectsRegionsClustersListCall) PageToken(pageToken string) *ProjectsRegionsClustersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersListCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsRegionsClustersListCall) IfNoneMatch(entityTag string) *ProjectsRegionsClustersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersListCall) Context(ctx context.Context) *ProjectsRegionsClustersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{projectId}/regions/{region}/clusters")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId": c.projectId,
		"region":    c.region,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListClustersResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsRegionsClustersListCall) Do(opts ...googleapi.CallOption) (*ListClustersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListClustersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsRegionsClustersListCall) Pages(ctx context.Context, f func(*ListClustersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsRegionsClustersPatchCall struct {
	s           *Service
	projectId   string
	region      string
	clusterName string
	cluster     *Cluster
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates a cluster in a project. The returned Operation.metadata will
// be ClusterOperationMetadata
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#clusteroperationmetadata).
// The cluster must be in a RUNNING state or an error is returned.
//
//   - clusterName: The cluster name.
//   - projectId: The ID of the Google Cloud Platform project the cluster belongs
//     to.
//   - region: The Dataproc region in which to handle the request.
func (r *ProjectsRegionsClustersService) Patch(projectId string, region string, clusterName string, cluster *Cluster) *ProjectsRegionsClustersPatchCall {
	c := &ProjectsRegionsClustersPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.region = region
	c.clusterName = clusterName
	c.cluster = cluster
	return c
}

// GracefulDecommissionTimeout sets the optional parameter
// "gracefulDecommissionTimeout": Timeout for graceful YARN decommissioning.
// Graceful decommissioning allows removing nodes from the cluster without
// interrupting jobs in progress. Timeout specifies how long to wait for jobs
// in progress to finish before forcefully removing nodes (and potentially
// interrupting jobs). Default timeout is 0 (for forceful decommission), and
// the maximum allowed timeout is 1 day. (see JSON representation of Duration
// (https://developers.google.com/protocol-buffers/docs/proto3#json)).Only
// supported on Dataproc image versions 1.2 and higher.
func (c *ProjectsRegionsClustersPatchCall) GracefulDecommissionTimeout(gracefulDecommissionTimeout string) *ProjectsRegionsClustersPatchCall {
	c.urlParams_.Set("gracefulDecommissionTimeout", gracefulDecommissionTimeout)
	return c
}

// RequestId sets the optional parameter "requestId": A unique ID used to
// identify the request. If the server receives two UpdateClusterRequest
// (https://cloud.google.com/dataproc/docs/reference/rpc/google.cloud.dataproc.v1#google.cloud.dataproc.v1.UpdateClusterRequest)s
// with the same id, then the second request will be ignored and the first
// google.longrunning.Operation created and stored in the backend is
// returned.It is recommended to always set this value to a UUID
// (https://en.wikipedia.org/wiki/Universally_unique_identifier).The ID must
// contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens
// (-). The maximum length is 40 characters.
func (c *ProjectsRegionsClustersPatchCall) RequestId(requestId string) *ProjectsRegionsClustersPatchCall {
	c.urlParams_.Set("requestId", requestId)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Specifies the
// path, relative to Cluster, of the field to update. For example, to change
// the number of workers in a cluster to 5, the update_mask parameter would be
// specified as config.worker_config.num_instances, and the PATCH request body
// would specify the new value, as follows: { "config":{ "workerConfig":{
// "numInstances":"5" } } } Similarly, to change the number of preemptible
// workers in a cluster to 5, the update_mask parameter would be
// config.secondary_worker_config.num_instances, and the PATCH request body
// would be set as follows: { "config":{ "secondaryWorkerConfig":{
// "numInstances":"5" } } } *Note:* Currently, only the following fields can be
// updated: *Mask* *Purpose* *labels* Update labels
// *config.worker_config.num_instances* Resize primary worker group
// *config.secondary_worker_config.num_instances* Resize secondary worker group
// config.autoscaling_config.policy_uri Use, stop using, or change autoscaling
// policies
func (c *ProjectsRegionsClustersPatchCall) UpdateMask(updateMask string) *ProjectsRegionsClustersPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersPatchCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersPatchCall) Context(ctx context.Context) *ProjectsRegionsClustersPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cluster)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":   c.projectId,
		"region":      c.region,
		"clusterName": c.clusterName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersRepairCall struct {
	s                    *Service
	projectId            string
	region               string
	clusterName          string
	repairclusterrequest *RepairClusterRequest
	urlParams_           gensupport.URLParams
	ctx_                 context.Context
	header_              http.Header
}

// Repair: Repairs a cluster.
//
//   - clusterName: The cluster name.
//   - projectId: The ID of the Google Cloud Platform project the cluster belongs
//     to.
//   - region: The Dataproc region in which to handle the request.
func (r *ProjectsRegionsClustersService) Repair(projectId string, region string, clusterName string, repairclusterrequest *RepairClusterRequest) *ProjectsRegionsClustersRepairCall {
	c := &ProjectsRegionsClustersRepairCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.region = region
	c.clusterName = clusterName
	c.repairclusterrequest = repairclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersRepairCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersRepairCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersRepairCall) Context(ctx context.Context) *ProjectsRegionsClustersRepairCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersRepairCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersRepairCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.repairclusterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:repair")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":   c.projectId,
		"region":      c.region,
		"clusterName": c.clusterName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.repair", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.repair" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersRepairCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.repair", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersSetIamPolicyCall struct {
	s                   *Service
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the access control policy on the specified resource.
// Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and
// PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsRegionsClustersService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsRegionsClustersSetIamPolicyCall {
	c := &ProjectsRegionsClustersSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersSetIamPolicyCall) Context(ctx context.Context) *ProjectsRegionsClustersSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersStartCall struct {
	s                   *Service
	projectId           string
	region              string
	clusterName         string
	startclusterrequest *StartClusterRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Start: Starts a cluster in a project.
//
//   - clusterName: The cluster name.
//   - projectId: The ID of the Google Cloud Platform project the cluster belongs
//     to.
//   - region: The Dataproc region in which to handle the request.
func (r *ProjectsRegionsClustersService) Start(projectId string, region string, clusterName string, startclusterrequest *StartClusterRequest) *ProjectsRegionsClustersStartCall {
	c := &ProjectsRegionsClustersStartCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.region = region
	c.clusterName = clusterName
	c.startclusterrequest = startclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersStartCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersStartCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersStartCall) Context(ctx context.Context) *ProjectsRegionsClustersStartCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersStartCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersStartCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.startclusterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:start")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":   c.projectId,
		"region":      c.region,
		"clusterName": c.clusterName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.start", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.start" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersStartCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.start", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsRegionsClustersStopCall struct {
	s                  *Service
	projectId          string
	region             string
	clusterName        string
	stopclusterrequest *StopClusterRequest
	urlParams_         gensupport.URLParams
	ctx_               context.Context
	header_            http.Header
}

// Stop: Stops a cluster in a project.
//
//   - clusterName: The cluster name.
//   - projectId: The ID of the Google Cloud Platform project the cluster belongs
//     to.
//   - region: The Dataproc region in which to handle the request.
func (r *ProjectsRegionsClustersService) Stop(projectId string, region string, clusterName string, stopclusterrequest *StopClusterRequest) *ProjectsRegionsClustersStopCall {
	c := &ProjectsRegionsClustersStopCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.projectId = projectId
	c.region = region
	c.clusterName = clusterName
	c.stopclusterrequest = stopclusterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsRegionsClustersStopCall) Fields(s ...googleapi.Field) *ProjectsRegionsClustersStopCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsRegionsClustersStopCall) Context(ctx context.Context) *ProjectsRegionsClustersStopCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsRegionsClustersStopCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsRegionsClustersStopCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.stopclusterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/projects/{projectId}/regions/{region}/clusters/{clusterName}:stop")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"projectId":   c.projectId,
		"region":      c.region,
		"clusterName": c.clusterName,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "dataproc.projects.regions.clusters.stop", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataproc.projects.regions.clusters.stop" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsRegionsClustersStopCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
	