// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyGauge(t *testing.T) {
	for name, src := range genTestEncodingValuesGauge() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewGauge()
				CopyGauge(dest, src)
				assert.Equal(t, src, dest)
				CopyGauge(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyGaugeSlice(t *testing.T) {
	src := []Gauge{}
	dest := []Gauge{}
	// Test CopyTo empty
	dest = CopyGaugeSlice(dest, src)
	assert.Equal(t, []Gauge{}, dest)

	// Test CopyTo larger slice
	src = GenTestGaugeSlice()
	dest = CopyGaugeSlice(dest, src)
	assert.Equal(t, GenTestGaugeSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyGaugeSlice(dest, src)
	assert.Equal(t, GenTestGaugeSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyGaugeSlice(dest, []Gauge{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyGaugeSlice(dest, src)
	assert.Equal(t, GenTestGaugeSlice(), dest)
}

func TestCopyGaugePtrSlice(t *testing.T) {
	src := []*Gauge{}
	dest := []*Gauge{}
	// Test CopyTo empty
	dest = CopyGaugePtrSlice(dest, src)
	assert.Equal(t, []*Gauge{}, dest)

	// Test CopyTo larger slice
	src = GenTestGaugePtrSlice()
	dest = CopyGaugePtrSlice(dest, src)
	assert.Equal(t, GenTestGaugePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyGaugePtrSlice(dest, src)
	assert.Equal(t, GenTestGaugePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyGaugePtrSlice(dest, []*Gauge{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyGaugePtrSlice(dest, src)
	assert.Equal(t, GenTestGaugePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONGaugeUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewGauge()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewGauge(), dest)
}

func TestMarshalAndUnmarshalJSONGauge(t *testing.T) {
	for name, src := range genTestEncodingValuesGauge() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewGauge()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteGauge(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoGaugeFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesGauge() {
		t.Run(name, func(t *testing.T) {
			dest := NewGauge()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoGaugeUnknown(t *testing.T) {
	dest := NewGauge()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewGauge(), dest)
}

func TestMarshalAndUnmarshalProtoGauge(t *testing.T) {
	for name, src := range genTestEncodingValuesGauge() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewGauge()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteGauge(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufGauge(t *testing.T) {
	for name, src := range genTestEncodingValuesGauge() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.Gauge{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewGauge()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesGauge() map[string][]byte {
	return map[string][]byte{
		"invalid_field":              {0x02},
		"DataPoints/wrong_wire_type": {0xc},
		"DataPoints/missing_value":   {0xa},
	}
}

func genTestEncodingValuesGauge() map[string]*Gauge {
	return map[string]*Gauge{
		"empty":           NewGauge(),
		"DataPoints/test": {DataPoints: []*NumberDataPoint{{}, GenTestNumberDataPoint()}},
	}
}
