/*
Object Storage

REST API OpenAPI documentation for the Object Storage

API version: 1.0.0 (v1)
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package storage

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the ResponseBucket type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ResponseBucket{}

// ResponseBucket struct for ResponseBucket
type ResponseBucket struct {
	State StateEnum `json:"state"`
	Data Bucket `json:"data"`
}

type _ResponseBucket ResponseBucket

// NewResponseBucket instantiates a new ResponseBucket object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewResponseBucket(state StateEnum, data Bucket) *ResponseBucket {
	this := ResponseBucket{}
	this.State = state
	this.Data = data
	return &this
}

// NewResponseBucketWithDefaults instantiates a new ResponseBucket object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewResponseBucketWithDefaults() *ResponseBucket {
	this := ResponseBucket{}
	return &this
}

// GetState returns the State field value
func (o *ResponseBucket) GetState() StateEnum {
	if o == nil {
		var ret StateEnum
		return ret
	}

	return o.State
}

// GetStateOk returns a tuple with the State field value
// and a boolean to check if the value has been set.
func (o *ResponseBucket) GetStateOk() (*StateEnum, bool) {
	if o == nil {
		return nil, false
	}
	return &o.State, true
}

// SetState sets field value
func (o *ResponseBucket) SetState(v StateEnum) {
	o.State = v
}

// GetData returns the Data field value
func (o *ResponseBucket) GetData() Bucket {
	if o == nil {
		var ret Bucket
		return ret
	}

	return o.Data
}

// GetDataOk returns a tuple with the Data field value
// and a boolean to check if the value has been set.
func (o *ResponseBucket) GetDataOk() (*Bucket, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Data, true
}

// SetData sets field value
func (o *ResponseBucket) SetData(v Bucket) {
	o.Data = v
}

func (o ResponseBucket) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ResponseBucket) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["state"] = o.State
	toSerialize["data"] = o.Data
	return toSerialize, nil
}

func (o *ResponseBucket) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"state",
		"data",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varResponseBucket := _ResponseBucket{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varResponseBucket)

	if err != nil {
		return err
	}

	*o = ResponseBucket(varResponseBucket)

	return err
}

type NullableResponseBucket struct {
	value *ResponseBucket
	isSet bool
}

func (v NullableResponseBucket) Get() *ResponseBucket {
	return v.value
}

func (v *NullableResponseBucket) Set(val *ResponseBucket) {
	v.value = val
	v.isSet = true
}

func (v NullableResponseBucket) IsSet() bool {
	return v.isSet
}

func (v *NullableResponseBucket) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableResponseBucket(val *ResponseBucket) *NullableResponseBucket {
	return &NullableResponseBucket{value: val, isSet: true}
}

func (v NullableResponseBucket) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableResponseBucket) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


